//
//   COMPONENT_NAME: somx
//
//   ORIGINS: 27
//
//
//   10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
//   All Rights Reserved
//   Licensed Materials - Property of IBM
//   US Government Users Restricted Rights - Use, duplication or
//   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
//

/* %Z% %I% %W% %G% %U% [%H% %T%] */

/*
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */

/*----------------------------------------
   ANISAMP.C -- SOM Sample Program
  ----------------------------------------*/

#include <windows.h>
#include <somd.xh>	
#include "danimal.xh"
#include "dldog.xh"
#include "dbdog.xh"
#include "dloc.xh"
#include "nlsutil.h"
#include "anitest.h"

/***************************************************
Messages for NLS support
****************************************************/
static char *nlsmsgs[ENDNLSID-STARTNLSID+1];
#define GetNlsMessage(id) nlsmsgs[id-STARTNLSID]
#define SetNlsMessage(id, str) nlsmsgs[id-STARTNLSID] = (str);

struct
     {
     long style ;
     char *text ;
     }
     button[] =
     {
     BS_PUSHBUTTON,      GetNlsMessage(PoohId),
     BS_PUSHBUTTON,      GetNlsMessage(SnoopyId),
     BS_PUSHBUTTON,      GetNlsMessage(LassieId),
     } ;


/**********************************************************
18953: NLS support
This procedure must be called first to initialize all the messages
to be used by irdump. These messages are obtained from the resource file.
****************************************************************/
static void InitNlsMsgs(){

SetNlsMessage(IamId, NlsMsgAlloc(IamId));
SetNlsMessage(PoohId ,NlsMsgAlloc(PoohId));
SetNlsMessage(SnoopyId ,NlsMsgAlloc(SnoopyId));
SetNlsMessage(LassieId, NlsMsgAlloc(LassieId));
SetNlsMessage(TitleId, NlsMsgAlloc(TitleId));
SetNlsMessage(PressButtonId, NlsMsgAlloc(PressButtonId));
SetNlsMessage(WinniePoohId, NlsMsgAlloc(WinniePoohId));
SetNlsMessage(StorybookBearId, NlsMsgAlloc(StorybookBearId));
SetNlsMessage(HoneyId, NlsMsgAlloc(HoneyId));
SetNlsMessage(AustinId, NlsMsgAlloc(AustinId));
SetNlsMessage(TexasId, NlsMsgAlloc(TexasId));
SetNlsMessage(CartoonBeagleId, NlsMsgAlloc(CartoonBeagleId));
SetNlsMessage(CookiesId, NlsMsgAlloc(CookiesId));
SetNlsMessage(DublinId, NlsMsgAlloc(DublinId));
SetNlsMessage(OhioId, NlsMsgAlloc(OhioId));
SetNlsMessage(DancingId, NlsMsgAlloc(DancingId));
SetNlsMessage(TVCollieId, NlsMsgAlloc(TVCollieId));
SetNlsMessage(SteakId, NlsMsgAlloc(SteakId));
SetNlsMessage(HollywoodId, NlsMsgAlloc(HollywoodId));
SetNlsMessage(CaliforniaId, NlsMsgAlloc(CaliforniaId));
SetNlsMessage(SavingLivesId, NlsMsgAlloc(SavingLivesId));
SetNlsMessage(MynameId, NlsMsgAlloc(MynameId));
SetNlsMessage(ILikeToEatId, NlsMsgAlloc(ILikeToEatId));
SetNlsMessage(ILiveInId, NlsMsgAlloc(ILiveInId));
SetNlsMessage(IWeighStrId, NlsMsgAlloc(IWeighStrId));
SetNlsMessage(IWeighFloatId, NlsMsgAlloc(IWeighFloatId));
/*SetNlsMessage(MyTrickId, NlsMsgAlloc(MyTrickId));*/
SetNlsMessage(ErrorId, NlsMsgAlloc(ErrorId));
SetNlsMessage(MinorErrorId, NlsMsgAlloc(MinorErrorId));
SetNlsMessage(CompletionErrorId, NlsMsgAlloc(CompletionErrorId));
button[0].text =  GetNlsMessage(PoohId);
button[1].text =  GetNlsMessage(SnoopyId);
button[2].text =  GetNlsMessage(LassieId);
}

#define NUM (sizeof button / sizeof button [0])
#define checkEv(ev) ((ev)->_major != NO_EXCEPTION)


void printEv(Environment *ev);

long APIENTRY WndProc (HWND, UINT, UINT, LONG);

int APIENTRY WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                      LPSTR lpszCmdLine, int nCmdShow)
     {
     static char szAppName[] = "DAnisamp" ;
     HWND        hwnd ;
     MSG         msg ;
     WNDCLASS    wndclass ;

     InitNlsMsgs();

     somEnvironmentNew(); 

     if (!hPrevInstance)
          {
          wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = NULL ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
          }

     hwnd = CreateWindow (szAppName, GetNlsMessage(TitleId),
                          WS_OVERLAPPEDWINDOW,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          NULL, NULL, hInstance, NULL) ;

     ShowWindow (hwnd, nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg, NULL, 0, 0))
          {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
          }
     return msg.wParam ;
     }

long APIENTRY WndProc (HWND hwnd, UINT message, UINT wParam,
                       LONG lParam)
     {
     static char  *szTop= NULL; /* d18953 */
     static HWND  hwndButton [NUM] ;
     static int   buttonx [NUM] = {  5, 20, 35 };
     static int   buttony [NUM] = {  8, 8, 8};
     static RECT  NEAR  rect ;
     static int   cxChar, cyChar ;
     HDC          hdc ;
     HCURSOR      hCursor;
     PAINTSTRUCT  ps ;
     int          i ;
     TEXTMETRIC   tm ;
     static dAnimal     *Pooh = (dAnimal *) NULL;
     static dLittleDog  *Snoopy = (dLittleDog *) NULL;
     static dBigDog     *Lassie = (dBigDog *) NULL;
     static dLocation   *locPooh = (dLocation *) NULL;
     static dLocation   *locSnoopy = (dLocation*) NULL;
     static dLocation   *locLassie = (dLocation *) NULL;
     static Environment *ev;
     string buffer;

     /* d18953 */
     if (szTop == NULL)
	/* initialize szTop */
	szTop = GetNlsMessage(PressButtonId); 

     switch (message)
          {
          case WM_CREATE:

                /* local and DSOM initialization */
                ev = SOM_CreateLocalEnvironment();
                SOMD_Init(ev);
                Pooh = (dAnimal *) NULL;
                Snoopy = (dLittleDog *) NULL;
                Lassie = (dBigDog *) NULL;
                locPooh = (dLocation *) NULL;
                locSnoopy = (dLocation *) NULL;
                locLassie = (dLocation *) NULL;

                /* Make sure classes are registered with SOMClassMgr: */
                dAnimalNewClass(0,0);
                dLittleDogNewClass(0,0);
                dBigDogNewClass(0,0);
                dLocationNewClass(0,0);

               /* create remote animal object */
               Pooh = (dAnimal *) SOMD_ObjectMgr->somdNewObject(ev,
                                                        "dAnimal", NULL);
               if (checkEv(ev)) goto error;

               /* save pointers to dLocation object */
               locPooh = Pooh->_get_loc(ev);
               if (checkEv(ev)) goto error;

               Snoopy = (dLittleDog *) SOMD_ObjectMgr->somdNewObject(ev,
                                                        "dLittleDog", NULL);
               if (checkEv(ev)) goto error;

               locSnoopy = Snoopy->_get_loc(ev);
               if (checkEv(ev)) goto error;

               Lassie = (dBigDog *)SOMD_ObjectMgr->somdNewObject(ev,
                                                        "dBigDog", NULL);
               if (checkEv(ev)) goto error;

               locLassie = Lassie->_get_loc(ev);
               if (checkEv(ev)) goto error;

                /* set instance data for animal objects */
                Pooh->_set_name(ev, GetNlsMessage(WinniePoohId));
                if (checkEv(ev)) goto error;
                Pooh->_set_type(ev, GetNlsMessage(StorybookBearId));
                if (checkEv(ev)) goto error;
                Pooh->_set_food(ev, GetNlsMessage(HoneyId));
                if (checkEv(ev)) goto error;
                locPooh->_set_city(ev, GetNlsMessage(AustinId));
                if (checkEv(ev)) goto error;
                locPooh->_set_state(ev, GetNlsMessage(TexasId));
                if (checkEv(ev)) goto error;

                Snoopy->_set_name(ev, GetNlsMessage(SnoopyId));
                if (checkEv(ev)) goto error;
                Snoopy->_set_type(ev, GetNlsMessage(CartoonBeagleId));
                if (checkEv(ev)) goto error;
                Snoopy->_set_food(ev, GetNlsMessage(CookiesId));
                if (checkEv(ev)) goto error;
                locSnoopy->_set_city(ev, GetNlsMessage(DublinId));
                if (checkEv(ev)) goto error;
                locSnoopy->_set_state(ev, GetNlsMessage(OhioId));
                if (checkEv(ev)) goto error;
                Snoopy->_set_trick(ev, GetNlsMessage(DancingId));
                if (checkEv(ev)) goto error;
                Snoopy->_set_LDweight(ev, 320.47);
                if (checkEv(ev)) goto error;

                Lassie->_set_name(ev, GetNlsMessage(LassieId));
                if (checkEv(ev)) goto error;
                Lassie->_set_type(ev, GetNlsMessage(TVCollieId));
                if (checkEv(ev)) goto error;
                Lassie->_set_food(ev, GetNlsMessage(SteakId));
                if (checkEv(ev)) goto error;
                locLassie->_set_city(ev, GetNlsMessage(HollywoodId));
                if (checkEv(ev)) goto error;
                locLassie->_set_state(ev, GetNlsMessage(CaliforniaId));
                if (checkEv(ev)) goto error;
                Lassie->_set_trick(ev, GetNlsMessage(SavingLivesId));
                if (checkEv(ev)) goto error;
                Lassie->_set_BDweight(ev, 42.38);
                if (checkEv(ev)) goto error;

               /* Display one button per animal: */
               hdc = GetDC (hwnd) ;
               GetTextMetrics (hdc, &tm) ;
               cxChar = tm.tmAveCharWidth ;
               cyChar = tm.tmHeight + tm.tmExternalLeading ;
               ReleaseDC (hwnd, hdc) ;
               for (i = 0 ; i < NUM ; i++)
                 hwndButton [i] =
                     CreateWindow ("button",
                                   button[i].text,
                                   WS_CHILD | WS_VISIBLE | button[i].style,
                                   buttonx[i] * cxChar,
                                   cyChar * buttony[i],
                                   10 * cxChar,
                                   7 * cyChar / 4,
                                   hwnd,
                                   (HMENU)i,
                                   (HINSTANCE)((LPCREATESTRUCT)lParam)->hInstance,
                                   0);
               return 0 ;

                error:
                   printEv(ev);
                   SendMessage(hwnd, WM_CLOSE, 0, 0L);
                   return 0;

          case WM_SIZE:
               rect.left   =  5 * cxChar ;
               rect.top    =  2 * cyChar ;
               rect.right  = LOWORD (lParam) ;
               rect.bottom = HIWORD (lParam) ;
               return 0 ;

          case WM_PAINT:
               InvalidateRect (hwnd, &rect, TRUE) ;
               hdc = BeginPaint (hwnd, &ps) ;
     /*static char  szTop[] = GetNlsMessage(PressButtonId); */
               TextOut (hdc, 6 * cxChar, 3 * cyChar, szTop, strlen(szTop)/*38*/);
               EndPaint (hwnd, &ps) ;
               return 0 ;

          case WM_COMMAND:
          case WM_DRAWITEM:
               hCursor = SetCursor (LoadCursor (NULL, IDC_WAIT));
               ShowCursor (TRUE);

               /* Produce a pop-up window for the animal: */
                switch (wParam)
                        {
                        case 0:
                          buffer = Pooh->display (ev);
                          break;
                        case 1:
                          buffer = Snoopy->display (ev);
                          break;
                        case 2:
                          buffer = Lassie->display (ev);
                          break;
                        }
              ShowCursor (FALSE);
              SetCursor (hCursor);
              if (ev->_major == NO_EXCEPTION) {
                  MessageBox (hwnd, buffer, button[wParam].text, MB_OK);
               }
	       InvalidateRect(hwnd,NULL,TRUE);
               return 0 ;

          case WM_DESTROY:
                /* destroy local proxy objects and remote animal objects */
                if (locPooh)
                   ((SOMDClientProxy *)locPooh)->somdProxyFree(ev);
                if (Pooh)
                   SOMD_ObjectMgr->somdDestroyObject(ev, Pooh);
                if (locSnoopy)
                   ((SOMDClientProxy *)locSnoopy)->somdProxyFree(ev);
                if (Snoopy)
                   SOMD_ObjectMgr->somdDestroyObject(ev, Snoopy);
                if (locLassie)
                   ((SOMDClientProxy *)locLassie)->somdProxyFree(ev);
                if (Lassie)
                   SOMD_ObjectMgr->somdDestroyObject(ev, Lassie);
                SOMD_Uninit(ev);
                SOM_DestroyLocalEnvironment(ev);
                PostQuitMessage (0) ;
                return 0 ;
          }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }

/*
 *  Prints exception information.
 */

void printEv(Environment *ev)
{
  char *exId, *bp;
  char buffer[200];
  StExcep *params;

  exId = somExceptionId(ev);
  if (!exId) exId = "None";
  params = (StExcep *) somExceptionValue(ev);
  bp = buffer;

  wsprintf(bp, GetNlsMessage(ErrorId), (LPSTR) exId);
  bp += strlen(bp);
  wsprintf(bp, GetNlsMessage(MinorErrorId), (params ? params->minor : 0));
  bp += strlen(bp);
  wsprintf(bp, GetNlsMessage(CompletionErrorId) ,
                (LPSTR) (params ? (params->completed == YES ? "YES" :
                params->completed == NO ? "NO": "MAYBE") : "YES"));
  MessageBox ((HWND)NULL, buffer, (LPSTR) "Exception",
                                MB_ICONEXCLAMATION | MB_OK);
  somdExceptionFree(ev);
  return;
}
