//
//   COMPONENT_NAME: somx
//
//   ORIGINS: 27
//
//
//   10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
//   All Rights Reserved
//   Licensed Materials - Property of IBM
//   US Government Users Restricted Rights - Use, duplication or
//   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
//

/* %Z% %I% %W% %G% %U% [%H% %T%] */
/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using: 
 *      SOM Emitter emitxtm: 2.37
 */



#ifndef SOM_Module_danimal_Source
#define SOM_Module_danimal_Source
#endif
#define dAnimal_Class_Source

#include <stdio.h>
#include <string.h>
#include <windows.h>
#include "dloc.xh"
#include "danimal.xih"
#include "nlsutil.h"   /* 18953 */
#include "animal.h"   /* 18953 */

/*
 * Name of animal.
 */

SOM_Scope void  SOMLINK _set_name(dAnimal *somSelf,  Environment *ev, 
                                  string name)
{
    dAnimalData *somThis = dAnimalGetData(somSelf);
    dAnimalMethodDebug("dAnimal","_set_name");
    if (somThis->name) SOMFree(somThis->name);
    somThis->name = (string) SOMMalloc(strlen(name) + 1);
    strcpy(somThis->name, name);

}

/*
 * Type of animal.
 */

SOM_Scope void  SOMLINK _set_type(dAnimal *somSelf,  Environment *ev, 
                                  string type)
{
    dAnimalData *somThis = dAnimalGetData(somSelf);
    dAnimalMethodDebug("dAnimal","_set_type");
    if (somThis->type) SOMFree(somThis->type);
    somThis->type = (string) SOMMalloc(strlen(type) + 1);
    strcpy(somThis->type, type);

}

/*
 * Food animal likes to eat.
 */

SOM_Scope void  SOMLINK _set_food(dAnimal *somSelf,  Environment *ev, 
                                  string food)
{
    dAnimalData *somThis = dAnimalGetData(somSelf);
    dAnimalMethodDebug("dAnimal","_set_food");
    if (somThis->food) SOMFree(somThis->food);
    somThis->food = (string) SOMMalloc(strlen(food) + 1);
    strcpy(somThis->food, food);

}

/*
 * Work area for display method.
 */

SOM_Scope void  SOMLINK _set_buff(dAnimal *somSelf,  Environment *ev, 
                                  string buff)
{
    dAnimalData *somThis = dAnimalGetData(somSelf);
    dAnimalMethodDebug("dAnimal","_set_buff");
    if (somThis->buff) SOMFree(somThis->buff);
    somThis->buff = (string) SOMMalloc(strlen(buff) + 1);
    strcpy(somThis->buff, buff);

}

/*
 * Returns description of animal.
 */

SOM_Scope string  SOMLINK display(dAnimal *somSelf,  Environment *ev)
{
    string bp;

    dAnimalData *somThis = dAnimalGetData(somSelf);
    dAnimalMethodDebug("dAnimal","display");

    /* Return statement to be customized: */
 
    bp = somThis->buff;
    wsprintf(bp, NlsMsgGet(IamId), somThis->type);

    bp += strlen(bp);
    wsprintf(bp, NlsMsgGet(MynameId), somThis->name);

    bp += strlen(bp);
    wsprintf(bp, NlsMsgGet(ILikeToEatId), somThis->food);

    bp += strlen(bp);
    wsprintf(bp, NlsMsgGet(ILiveInId),
            somThis->loc->_get_city(ev),
	    somThis->loc->_get_state(ev));

    return somThis->buff;

}
SOM_Scope void SOMLINK somDefaultInit(dAnimal *somSelf, somInitCtrl* ctrl)
{
    dAnimalData *somThis; /* set in BeginInitializer */
    Environment *ev;
    somInitCtrl globalCtrl;
    somBooleanVector myMask;
    dAnimalMethodDebug("dAnimal","somDefaultInit");
    dAnimal_BeginInitializer_somDefaultInit;
    dAnimal_Init_SOMObject_somDefaultInit(somSelf,ctrl);

    ev = somGetGlobalEnvironment();

    somSelf->_set_name(ev, "unknown name");
    somSelf->_set_type(ev, "unknown type");
    somSelf->_set_food(ev, "unknown food");
    somThis->loc = new dLocation;
    somThis->buff = (string) SOMMalloc(2048);
}
SOM_Scope void SOMLINK somDestruct(dAnimal *somSelf, octet doFree, somDestructCtrl* ctrl)
{
    dAnimalData *somThis; /* set in BeginDestructor */
    somDestructCtrl globalCtrl;
    somBooleanVector myMask;
    dAnimalMethodDebug("dAnimal","somDestruct");
    dAnimal_BeginDestructor;


    if (somThis->name) SOMFree(somThis->name);
    if (somThis->type) SOMFree(somThis->type);
    if (somThis->food) SOMFree(somThis->food);
    if (somThis->buff) SOMFree(somThis->buff);
    somThis->loc->somFree();
    dAnimal_EndDestructor;
}

