#
#   COMPONENT_NAME: somx
#
#   ORIGINS: 27
#
#
#   10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
#   All Rights Reserved
#   Licensed Materials - Property of IBM
#   US Government Users Restricted Rights - Use, duplication or
#   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.




# DISCLAIMER OF WARRANTIES.
# The following [enclosed] code is sample code created by IBM
# Corporation. This sample code is not part of any standard or IBM
# product and is provided to you solely for the purpose of assisting
# you in the development of your applications.  The code is provided
# "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
# NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
# FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
# THIS CODE.  IBM shall not be liable for any damages arising out of
# your use of the sample code, even if they have been advised of the
# possibility of such damages.
#
# DISTRIBUTION.
# This sample code can be freely distributed, copied, altered, and
# incorporated into other software, provided that it bears the above
# Copyright notice and DISCLAIMER intact.
!include  ..\..\..\mscmake.hd

INCLS = danimal.xh ddog.xh dldog.xh dbdog.xh dloc.xh
IDLFILES = danimal.idl dbdog.idl ddog.idl dldog.idl dloc.idl

PRIVCPPFLAGSDLL=/DSOM_DONT_IMPORT_CLASS_dDog \
 	   /DSOM_DONT_IMPORT_CLASS_dLittleDog \
	   /DSOM_DONT_IMPORT_CLASS_dLocation \
	   /DSOM_DONT_IMPORT_CLASS_Animal \
	   /DSOM_DONT_IMPORT_CLASS_dBigDog \
	   /DSOM_DONT_IMPORT_CLASS_dAnimal

PRIVCPPFLAGS=

DLLOBJS = danimal.od dloc.od ddog.od dldog.od dbdog.od daniinit.od nlsutil.od
PRIVLDFLAGSDLL=$(ENTRYFLAG) $(SOMINITOBJ)

CLEANFILES=som_ir som.ir

all: $(SOMXH_DEPEND) danimal.dll anitest.exe testsvr.exe som_ir somdimpl

danimal.dll: danimal.def $(DLLOBJS) danimal.lib
danimal.lib: danimal.def $(DLLOBJS)

danimal.od: danimal.xih danimal.xh dloc.xh danimal.cpp
ddog.od: ddog.xih ddog.xh ddog.cpp
dldog.od: dldog.xih dldog.xh dldog.cpp
dbdog.od: dbdog.xih dbdog.xh dbdog.cpp
dloc.od: dloc.xih dloc.xh dloc.cpp
daniinit.od: daniinit.cpp

testsvr.exe: testsvr.obj nlsutil.obj testsvr.res
testsvr.res: testsvr.rc testsvr.h som.ico
testsvr.obj: $(INCLS) testsvr.cpp

anitest.exe: anitest.obj nlsutil.obj anitest.res danimal.lib
	$(LD) $(LDFLAGS) /OUT:$@ anitest.obj nlsutil.obj anitest.res danimal.lib somtk.lib user32.lib gdi32.lib

anitest.obj: $(INCLS) anitest.cpp
anitest.res: anitest.rc

clnimpl:
	-regimpl -D -i aniServer2
	-del somdimpl

### -- Put the IDL descriptions into the Interface Repository.
som_ir: $(IDLFILES)
	-$(SC) -I. -sir -u -mnolock $(INCS) *.idl
	-@echo "x" > som_ir

### -- Build the DSOM Implementation Repository.
somdimpl:
	-regimpl -A -i aniServer2 -p testsvr.exe
	-regimpl -a -i aniServer2 -c dAnimal -c dDog -c dBigDog -c dLittleDog -c dLocation
	-regimpl -L -i aniServer2
	@echo x > somdimpl

clean: clnimpl
	del som_ir
	del som.ir

!include ..\..\..\mscmake.tl
