//
//   COMPONENT_NAME: somx
//
//   ORIGINS: 27
//
//
//   10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
//   All Rights Reserved
//   Licensed Materials - Property of IBM
//   US Government Users Restricted Rights - Use, duplication or
//   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
//

/* %Z% %I% %W% %G% %U% [%H% %T%] */
/*
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */

/*----------------------------------------
   CONSUMER.C -- DSOM Sample Program
  ----------------------------------------*/

#include <windows.h>
#include <string.h>
#include <malloc.h>
#include <stdio.h>
#include <errno.h>

#include <somd.xh>
#include <orb.xh>

#define WIN32_USE_CLASS_RESOLVE_MACROS
#include "eventcom.xh"
#include "eventch.xh"
#undef WIN32_USE_CLASS_RESOLVE_MACROS

/************************************************************
19982
Given file name, return a file name with the prefix for
the temporary directory . Return NULL if insufficient buffer space.
Note: This implementation returns pointer to a static variable.
*************************************************************/
#define TEMP_FILE_NAME_SIZE 256
static char tempFileName[TEMP_FILE_NAME_SIZE];
char *TmpFileName(char *fname){
int len;
    len = GetEnvironmentVariable("TEMP", tempFileName, TEMP_FILE_NAME_SIZE);
    if ( len == 0 || (len+strlen(fname)+1 > TEMP_FILE_NAME_SIZE) )
        return NULL;
    strcat(tempFileName,"\\");
    strcat(tempFileName, fname);
    return tempFileName;
}

long APIENTRY WndProc (HWND, UINT, UINT, LONG) ;
void WinSleep(unsigned long);
void printEv(Environment *ev);

#define checkEv(ev) ((ev)->_major != NO_EXCEPTION)

struct {
     long style ;
     char *text ;
}
button[] = {
     BS_PUSHBUTTON, "Poll the event channel", /* 18953:NLS in InitNlsMsgs()*/
     BS_PUSHBUTTON, "Terminate the consumer",
} ;

/**********************************************************
18953: NLS support
***********************************************************/
#include "consumer.h"
#include "nlsutil.h"
/***************************************************
Messages for NLS support
****************************************************/
static char *nlsmsgs[ENDNLSID-STARTNLSID+1];
#define GetNlsMessage(id) nlsmsgs[id-STARTNLSID]
#define SetNlsMessage(id, str) nlsmsgs[id-STARTNLSID] = (str);

/**********************************************************
18953: NLS support
This procedure must be called first to initialize all the messages
to be used by the sample. These messages are obtained from the resource file.
****************************************************************/
static void InitNlsMsgs(){
SetNlsMessage(ObjrefErrorId , NlsMsgAlloc(ObjrefErrorId ));
SetNlsMessage(CreateErrorId, NlsMsgAlloc(CreateErrorId ));
SetNlsMessage(CurrentValueId, NlsMsgAlloc(CurrentValueId ));
SetNlsMessage(ErrorOccurId , NlsMsgAlloc(ErrorOccurId ));
SetNlsMessage(MinorCodeId , NlsMsgAlloc(MinorCodeId ));
SetNlsMessage(CompletionCodeId, NlsMsgAlloc(CompletionCodeId ));
SetNlsMessage(ExceptionId, NlsMsgAlloc(ExceptionId));
SetNlsMessage(DisconnectId, NlsMsgAlloc(DisconnectId));
SetNlsMessage(YesId, NlsMsgAlloc(YesId ));
SetNlsMessage(NoId, NlsMsgAlloc(NoId));
SetNlsMessage(MaybeId, NlsMsgAlloc(MaybeId ));
SetNlsMessage(PollId, NlsMsgAlloc(PollId));
SetNlsMessage(TerminateId, NlsMsgAlloc(TerminateId));

button[0].text = GetNlsMessage(PollId);
button[1].text = GetNlsMessage(TerminateId);
}

#define NUM (sizeof button / sizeof button [0])

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
     {
     static char szAppName[] = "consumer" ;
     HWND        hwnd ;
     MSG         msg ;
     WNDCLASS    wndclass ;

     InitNlsMsgs();

     somEnvironmentNew();

     if (!hPrevInstance)
          {
          wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = NULL ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
          }

     hwnd = CreateWindow (szAppName, "DSOM Event Sample -- Consumer",
                          WS_OVERLAPPEDWINDOW,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          NULL, NULL, hInstance, NULL) ;

     ShowWindow (hwnd, nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg, NULL, 0, 0))
          {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
          }
     return msg.wParam ;
     }

long APIENTRY WndProc (HWND hwnd, UINT message, UINT wParam,
                       LONG lParam)
     {
     static HWND  hwndButton [NUM] ;
     static int   buttonx [NUM] = { 10, 10 };
     static int   buttony [NUM] = { 9, 12};
     static int   cxChar, cyChar ;
     int i;
     HDC          hdc ;
     TEXTMETRIC   tm ;
     static HCURSOR hCursor ;
     PAINTSTRUCT  ps ;
     char buffer[100];

     static Environment  NEAR                    ev;
     static EventChannelAdmin_EventChannel       *evchObj;
     static EventComm_Supplier                   *supp_if;
     static EventChannelAdmin_ConsumerAdmin      *cons_admin;
     static EventComm_EventConnection            *evcon_if;
     static boolean                              has_event;
     static any     NEAR                         notify;
     FILE                                       *fileref;
     string                                      *stringref;
     char *fname; /* 19982 */

     switch (message)
          {
          case WM_CREATE:

                /* local and DSOM initialization */
                SOM_InitEnvironment(&ev);
                SOMD_Init(&ev);
                EventComm_EventConnectionNewClass(0,0);
                EventComm_ConsumerNewClass(0,0);
                EventComm_SupplierNewClass(0,0);
                EventChannelAdmin_ConsumerAdminNewClass(0,0);
                EventChannelAdmin_SupplierAdminNewClass(0,0);
                EventChannelAdmin_EventChannelNewClass(0,0);
                evchObj = NULL;

                fname = TmpFileName("event.rep"); /* 19982 */
                if (/* 19982*/ fname == NULL ||
                   !(fileref = fopen(fname /* 19982 "event.rep" */,"r"))) {
                        MessageBox ((HWND)NULL,
                        "Unable to find object reference string in event.rep.",
                               "File Open Error", MB_ICONEXCLAMATION | MB_OK);
                        SendMessage(hwnd, WM_CLOSE, 0, 0L);
			SOMD_Uninit(&ev);
                        return 0 ;
                }
                stringref = (string *)SOMMalloc(512);
                fscanf(fileref,"%s",stringref);
                fclose(fileref);
                evchObj = (EventChannelAdmin_EventChannel *)(SOMD_ORBObject->string_to_object(&ev,(char *)stringref));
                if (!evchObj) {
                        wsprintf(buffer, GetNlsMessage(ObjrefErrorId),
                                    stringref);
                        MessageBox ((HWND)NULL,  buffer, GetNlsMessage(CreateErrorId),
                                    MB_ICONEXCLAMATION | MB_OK);
                        SendMessage(hwnd, WM_CLOSE, 0, 0L);
			SOMD_Uninit(&ev);
                        return 0 ;
                }
                SOMFree(stringref);

                cons_admin = evchObj->for_consumers(&ev);
                evcon_if = (EventComm_EventConnection *)(SOMD_ObjectMgr->somdNewObject(&ev,"EventComm::EventConnection", NULL));
                if (checkEv(&ev))  {
                                printEv(&ev);
                                SendMessage(hwnd, WM_CLOSE, 0, 0L);
			        SOMD_Uninit(&ev);
                                return 0;
                        }
                supp_if = cons_admin->add_pull_consumer(&ev, evcon_if);
                has_event = FALSE;

               /* Display button selections: */
               hdc = GetDC (hwnd) ;
               GetTextMetrics (hdc, &tm) ;
               cxChar = tm.tmAveCharWidth ;
               cyChar = tm.tmHeight + tm.tmExternalLeading ;
               ReleaseDC (hwnd, hdc) ;
               for (i = 0 ; i < NUM ; i++)
                    hwndButton [i] =
                        CreateWindow ("button",
                                      button[i].text,
                                      WS_CHILD | WS_VISIBLE | button[i].style,
                                      buttonx[i] * cxChar,
                                      cyChar * buttony[i],
                                      40 * cxChar,
                                      7 * cyChar / 4,
                                      hwnd,
                                      (HMENU)i,
                                      ((LPCREATESTRUCT)lParam)->hInstance,
                                      NULL);
               return 0 ;

          case WM_PAINT:

                hdc = BeginPaint (hwnd, &ps) ;
                GetTextMetrics (hdc, &tm) ;
                cyChar = tm.tmHeight + tm.tmExternalLeading;
                cxChar = tm.tmAveCharWidth;

                if (has_event) {
                        wsprintf(buffer, GetNlsMessage(CurrentValueId),
                                *((long *)notify._value));
                        TextOut (hdc, cxChar*10, 4*cyChar,
                                (LPSTR)buffer, strlen(buffer));
                }

                EndPaint (hwnd, &ps) ;
                return 0 ;

          case WM_COMMAND:
          case WM_DRAWITEM:

                ValidateRect (hwnd, NULL) ;
                switch (wParam)
                        {
                        case 0: /* poll event channel */

                                hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
                                ShowCursor(TRUE);

                                if (has_event) {
                                    TypeCode_free(notify._type, &ev);
                                    has_event = FALSE;
                                }
                                while(!has_event) {
                                        has_event= supp_if->try_pull(&ev, &notify);
                                        if (checkEv(&ev))  {
                                           printEv(&ev);
                                           SendMessage(hwnd, WM_CLOSE, 0, 0L);
			                   SOMD_Uninit(&ev);
                                           return 0;
                                        }
                                        if (!has_event)
                                           WinSleep((unsigned long)1000);
                                }

                                ShowCursor(FALSE);
                                SetCursor(hCursor);
                                InvalidateRect(hwnd, NULL, TRUE);
                                break;

                        case 1: /* quit */

                                SendMessage(hwnd, WM_CLOSE, 0, 0L);
			        SOMD_Uninit(&ev);
                                break;
                }
                return 0;

          case WM_DESTROY:

                if (evchObj)
                  SOMD_ObjectMgr->somdReleaseObject(&ev, evchObj);
                /* DSOM uninitialization: */
                SOMD_Uninit(&ev);
                SOM_UninitEnvironment(&ev);

                PostQuitMessage (0) ;
                return 0 ;
          }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }


/*
 *  Prints exception information.
 */

void printEv(Environment *ev)
{
  char *exId, *bp;
  char buffer[200];
  StExcep *params;
  Disconnected *discon;

  exId = somExceptionId(ev);
  if (!exId) exId = "None";
  bp = buffer;
  wsprintf(bp, GetNlsMessage(ErrorOccurId), (LPSTR) exId);
  bp += strlen(bp);

  switch(ev->_major)
    {
    case SYSTEM_EXCEPTION:
        params = (StExcep *)somExceptionValue(ev);
        wsprintf(bp, GetNlsMessage(MinorCodeId), (params ? params->minor : 0));
        bp += strlen(bp);
        wsprintf(bp, GetNlsMessage(CompletionCodeId),
                (LPSTR) (params ? (params->completed == YES ? GetNlsMessage(YesId) :
                params->completed == NO ? GetNlsMessage(NoId): GetNlsMessage(MaybeId)) : GetNlsMessage(YesId)));
        break;

    case USER_EXCEPTION:
        if (strcmp(exId, ex_Disconnected) == 0)
            discon = (Disconnected *) somExceptionValue(ev);
            wsprintf(bp, GetNlsMessage(DisconnectId), (LPSTR) discon->Reason);
        break;
  }
  MessageBox ((HWND)NULL, buffer, (LPSTR) GetNlsMessage(ExceptionId),
                                MB_ICONEXCLAMATION | MB_OK);
  somdExceptionFree(ev);
  return;
}

void WinSleep(unsigned long msec)
{

   DWORD dwStartTime = GetCurrentTime();
   MSG   msg;

   do
   {
      while ( PeekMessage( (MSG FAR*)&msg, (HWND)NULL, 0, 0, PM_REMOVE) )
      {
         TranslateMessage( &msg );
         DispatchMessage( &msg );
      }
   } while ( (GetCurrentTime() - dwStartTime) < msec );

   return;
}
