//
//   COMPONENT_NAME: somx
//
//   ORIGINS: 27
//
//
//   10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
//   All Rights Reserved
//   Licensed Materials - Property of IBM
//   US Government Users Restricted Rights - Use, duplication or
//   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
//

/* %Z% %I% %W% %G% %U% [%H% %T%] */

/*
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */

/*----------------------------------------
   EVENTCLI.C -- DSOM Sample Program
  ----------------------------------------*/

#include <windows.h>
#include <string.h>
#include <malloc.h>
#include <stdio.h>
#include <errno.h>

#include <somd.xh>
#include <orb.xh>
#include "cell.xh"

/************************************************************
19982
Given file name, return a file name with the prefix for
the temporary directory . Return NULL if insufficient buffer space.
Note: This implementation returns pointer to a static variable.
*************************************************************/
#define TEMP_FILE_NAME_SIZE 256
static char tempFileName[TEMP_FILE_NAME_SIZE];
char *TmpFileName(char *fname){
int len;
    len = GetEnvironmentVariable("TEMP", tempFileName, TEMP_FILE_NAME_SIZE);
    if ( len == 0 || (len+strlen(fname)+1 > TEMP_FILE_NAME_SIZE) )
        return NULL;
    strcat(tempFileName,"\\");
    strcat(tempFileName, fname);
    return tempFileName;
}

long APIENTRY WndProc (HWND, UINT, UINT, LONG) ;

struct {
     long style ;
     char *text ;
}
button[] = {
     BS_PUSHBUTTON, "Increment cell value", /* 18953: will be translated in InitNlsMsgs */
     BS_PUSHBUTTON, "Terminate the supplier",
} ;

/***************************************************
Messages for NLS support
****************************************************/
#include "eventcli.h"
#include "nlsutil.h"
static char *nlsmsgs[ENDNLSID-STARTNLSID+1];
#define GetNlsMessage(id) nlsmsgs[id-STARTNLSID]
#define SetNlsMessage(id, str) nlsmsgs[id-STARTNLSID] = (str);

/**********************************************************
18953: NLS support
This procedure must be called first to initialize all the messages
to be used by irdump. These messages are obtained from the resource file.
****************************************************************/
static void InitNlsMsgs(){
SetNlsMessage(ObjRefErrorId, NlsMsgAlloc(ObjRefErrorId));
SetNlsMessage(CreationErrorId, NlsMsgAlloc(CreationErrorId));
SetNlsMessage(IinitialValueId, NlsMsgAlloc(IinitialValueId));
SetNlsMessage(CurrentValueId, NlsMsgAlloc(CurrentValueId));
SetNlsMessage(IncrementCellId, NlsMsgAlloc(IncrementCellId));
SetNlsMessage(TerminateSupplierId, NlsMsgAlloc(TerminateSupplierId));
SetNlsMessage(SampleNameId	, NlsMsgAlloc(SampleNameId	));
SetNlsMessage(ObjRefCellErrorId , NlsMsgAlloc(ObjRefCellErrorId ));
SetNlsMessage(FileOpenErrorId , NlsMsgAlloc(FileOpenErrorId ));

/* Set up string for button */
button[0].text = GetNlsMessage(IncrementCellId);
button[1].text = GetNlsMessage(TerminateSupplierId);
}

#define NUM (sizeof button / sizeof button [0])

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
     {
     static char szAppName[] = "eventcli" ;
     HWND        hwnd ;
     MSG         msg ;
     WNDCLASS    wndclass ;

     InitNlsMsgs();

     somEnvironmentNew();

     if (!hPrevInstance)
          {
          wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = NULL ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
          }

     hwnd = CreateWindow (szAppName, "DSOM Event Sample -- Supplier",
                          WS_OVERLAPPEDWINDOW,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          NULL, NULL, hInstance, NULL) ;

     ShowWindow (hwnd, nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg, NULL, 0, 0))
          {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
          }
     return msg.wParam ;
     }

long APIENTRY WndProc (HWND hwnd, UINT message, UINT wParam,
                       LONG lParam)
     {
     static HWND  hwndButton [NUM] ;
     static int   buttonx [NUM] = { 10, 10 };
     static int   buttony [NUM] = { 9, 12};
     static int   cxChar, cyChar ;
     int i;
     HDC          hdc ;
     TEXTMETRIC   tm ;
     static HCURSOR hCursor ;
     PAINTSTRUCT  ps ;
     char buffer[100];

     static Environment NEAR ev;
     static Cell *cellObj;
     static long  init_val;
     FILE *fileref;
     string stringref;
     char *fname; /* 19982 */

     switch (message)
          {
          case WM_CREATE:

                /* local and DSOM initialization */
                SOM_InitEnvironment(&ev);
                SOMD_Init(&ev);
                CellNewClass(0,0);
                cellObj = (Cell *)NULL;

                fname= TmpFileName("cell.rep");
                if (fname == NULL || !(fileref = fopen(fname 
                        /* 19982 "cell.rep" */,"r"))) {
                        MessageBox ((HWND)NULL,
			GetNlsMessage(ObjRefCellErrorId),
                               GetNlsMessage(FileOpenErrorId), MB_ICONEXCLAMATION | MB_OK);
                        SendMessage(hwnd, WM_CLOSE, 0, 0L);
                        return 0 ;
                }
                stringref = (string)SOMMalloc(512);
                fscanf(fileref,"%s",stringref);
                fclose(fileref);
                cellObj = (Cell *)(SOMD_ORBObject->string_to_object(&ev,stringref));
                if (!cellObj) {
                        wsprintf(buffer, GetNlsMessage(ObjRefErrorId),
                                    stringref);
                        MessageBox ((HWND)NULL,  buffer, GetNlsMessage(CreationErrorId),
                                    MB_ICONEXCLAMATION | MB_OK);
                        SendMessage(hwnd, WM_CLOSE, 0, 0L);
                        return 0 ;
                }
                SOMFree(stringref);
                /* initialize the cell to 10: */
                init_val = 10;
                cellObj->_set_val(&ev, init_val);

               /* Display button selections: */
               hdc = GetDC (hwnd) ;
               GetTextMetrics (hdc, &tm) ;
               cxChar = tm.tmAveCharWidth ;
               cyChar = tm.tmHeight + tm.tmExternalLeading ;
               ReleaseDC (hwnd, hdc) ;
               for (i = 0 ; i < NUM ; i++)
                    hwndButton [i] =
                       CreateWindow ("button",
                                     button[i].text,
                                     WS_CHILD | WS_VISIBLE | button[i].style,
                                     buttonx[i] * cxChar, cyChar * buttony[i],
                                     40 * cxChar,
                                     7 * cyChar / 4,
                                     hwnd,
                                     (HMENU)i,
                                     ((LPCREATESTRUCT)lParam)->hInstance,
                                     NULL) ;
               return 0 ;

          case WM_PAINT:

                hdc = BeginPaint (hwnd, &ps) ;
                GetTextMetrics (hdc, &tm) ;
                cyChar = tm.tmHeight + tm.tmExternalLeading;
                cxChar = tm.tmAveCharWidth;

                wsprintf(buffer, GetNlsMessage(IinitialValueId), init_val);
                TextOut (hdc, cxChar*10, 4*cyChar,
                        (LPSTR)buffer, strlen(buffer));

                wsprintf(buffer, GetNlsMessage(CurrentValueId),
                                cellObj->_get_val(&ev));
                TextOut (hdc, cxChar*10, 6*cyChar,
                        (LPSTR)buffer, strlen(buffer));

                EndPaint (hwnd, &ps) ;
                return 0 ;

          case WM_COMMAND:
          case WM_DRAWITEM:

                ValidateRect (hwnd, NULL) ;
                switch (wParam)
                        {
                        case 0: /* increment cell */

                                SetCapture(hwnd);
                                hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
                                ShowCursor(TRUE);

                                cellObj->_set_val(&ev,
                                      (cellObj->_get_val(&ev) + 1) );

                                ReleaseCapture();
                                ShowCursor(FALSE);
                                SetCursor(hCursor);
                                InvalidateRect(hwnd, NULL, TRUE);
                                break;

                        case 1: /* quit */

                                SendMessage(hwnd, WM_CLOSE, 0, 0L);
                                break;
                }
                return 0;

          case WM_DESTROY:

                if (cellObj)
                   SOMD_ObjectMgr->somdReleaseObject(&ev, cellObj);
                /* DSOM uninitialization: */
                SOMD_Uninit(&ev);
                SOM_UninitEnvironment(&ev);

                PostQuitMessage (0) ;
                return 0 ;
          }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }
