#
#   COMPONENT_NAME: somx
#
#   ORIGINS: 27
#
#
#   10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
#   All Rights Reserved
#   Licensed Materials - Property of IBM
#   US Government Users Restricted Rights - Use, duplication or
#   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
#

# DISCLAIMER OF WARRANTIES.
# The following [enclosed] code is sample code created by IBM
# Corporation. This sample code is not part of any standard or IBM
# product and is provided to you solely for the purpose of assisting
# you in the development of your applications.  The code is provided
# "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
# NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
# FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
# THIS CODE.  IBM shall not be liable for any damages arising out of
# your use of the sample code, even if they have been advised of the
# possibility of such damages.
#
# DISTRIBUTION.
# This sample code can be freely distributed, copied, altered, and
# incorporated into other software, provided that it bears the above
# Copyright notice and DISCLAIMER intact.

#  Makefile for DSOM C++ "event" sample

!include ..\..\..\vacmake.hd

#SCINCFLAGS = -I$(SOMBASE)\include
IDLS = eventcom.idl eventch.idl cell.idl
INCLS	= eventcom.xh eventch.xh cell.xh

PRIVCPPFLAGSDLL	= /Ms

PRIVCPPFLAGS=/Ms

#PRIVLDFLAGS=/SUBSYSTEM:WINDOWS

DLLOBJS = eventcom.od eventch.od cell.od eventint.od nlsutild.od

# this will actually use eventv.def at present
DEFSPEC=/DEF:$(*:.def=)v.def


all: $(SOMXH_DEPEND) event.lib event.dll eventsvr.exe eventcli.exe consumer.exe som.ir somdimpl

# dll objects
cell.od:  cell.cpp cell.xh cell.xih
cell.xih:  cell.idl
eventcom.od: eventcom.cpp eventcom.xh eventcom.xih
eventcom.xih: eventcom.idl
eventch.od: eventch.cpp eventch.xh eventch.xih eventcom.xih
eventch.xih: eventch.idl
eventint.od: eventint.cpp

event.lib: eventv.def $(DLLOBJS)
	ilib  /out:event /geni $(DLLOBJS:.od=.obj)

event.dll: eventv.def $(DLLOBJS)
	ilink /DLL /DE /NOE /MAP /NOLog /OUT:event.dll $(DLLOBJS:.od=.obj) event.exp somtk.lib user32.lib kernel32.lib

##Build the executables
eventcli.obj: eventcli.cpp cell.xh
eventcli.exe: eventcli.obj event.lib nlsutil.obj eventcli.res
eventcli.res: eventcli.h eventcli.rc
consumer.obj: consumer.cpp eventcom.xh eventch.xh
consumer.exe: consumer.obj event.lib nlsutil.obj consumer.res 
#consumer.exe: consumer.obj event.lib consumer.def nlsutil.obj consumer.res 
consumer.res: consumer.h consumer.rc
eventsvr.obj: eventsvr.cpp cell.xh eventcom.xh eventch.xh
eventsvr.res: eventsvr.rc som.ico
eventsvr.exe: eventsvr.obj event.lib nlsutil.obj eventsvr.res

## Add IDL descriptions into interface repository
som.ir : som_ir

som_ir: *.idl
	-$(SC) -I. -sir -u -mnolock $(SCINCFLAGS) *.idl
	-@echo x > som_ir
	
##Build DSOM inplementation repository
somdimpl:
	regimpl -A -i cellServer2 -p eventsvr.exe
	regimpl -a -i cellServer2 -c Cell -c EventChannelAdmin::ConsumerAdmin
	regimpl -a -i cellServer2 -c EventChannelAdmin::EventChannel -c EventChannelAdmin::SupplierAdmin
	regimpl -a -i cellServer2 -c EventComm::Consumer -c EventComm::Supplier -c EventComm::EventConnection
	echo x >somdimpl

clnimpl:
	-regimpl -D -i cellServer2
	-del somdimpl

clean: clnimpl
	del som.ir
	del som_ir
	del eventcom.xh 
	del eventch.xh 
	del cell.xh
	del msg.log

!include ..\..\..\vacmake.tl
