//
//   COMPONENT_NAME: somx
//
//   ORIGINS: 27
//
//
//   10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
//   All Rights Reserved
//   Licensed Materials - Property of IBM
//   US Government Users Restricted Rights - Use, duplication or
//   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
//
/* %Z% %I% %W% %G% %U% [%H% %T%] */

/*
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */

/*----------------------------------------
   SOMSTACK.CPP -- SOM Sample Program
  ----------------------------------------*/
#include <windows.h>

#include <somd.xh>
#include "stack.xh"
#include "somstack.h"
#include "nlsutil.h"
//#include <bccstruc.h>

/***************************************************
Messages for NLS support
****************************************************/
static char *nlsmsgs[ENDNLSID-STARTNLSID+1];
#define GetNlsMessage(id) nlsmsgs[id-STARTNLSID]
#define SetNlsMessage(id, str) nlsmsgs[id-STARTNLSID] = (str);

/**********************************************************
18953: NLS support
This procedure must be called first to initialize all the messages
to be used by irdump. These messages are obtained from the resource file.
****************************************************************/
static void InitNlsMsgs(){

SetNlsMessage(EmptyStackId, NlsMsgAlloc(EmptyStackId));
SetNlsMessage(StackTopId ,NlsMsgAlloc(StackTopId));
SetNlsMessage(StackAboutId, NlsMsgAlloc(StackAboutId));
SetNlsMessage(PushId	, NlsMsgAlloc(PushId	));
SetNlsMessage(ValueId, NlsMsgAlloc(ValueId));
SetNlsMessage(ErrorId, NlsMsgAlloc(ErrorId));
SetNlsMessage(ErrorMinorCodeId, NlsMsgAlloc(ErrorMinorCodeId));
SetNlsMessage(ErrorCompletionId, NlsMsgAlloc(ErrorCompletionId));
SetNlsMessage(YesId 	, NlsMsgAlloc(YesId 	));
SetNlsMessage(NoId, NlsMsgAlloc(NoId));
SetNlsMessage(MaybeId, NlsMsgAlloc(MaybeId));
SetNlsMessage(ExceptionId, NlsMsgAlloc(ExceptionId));
SetNlsMessage(PushAcceptedId, NlsMsgAlloc(PushAcceptedId));
}

//long FAR PASCAL _export WndProc (HWND, UINT, UINT, LONG) ;
long FAR PASCAL WndProc (HWND, UINT, UINT, LONG) ;
int RegisterWindowClasses(void);
HWND CreateMainAppWindow(HANDLE);
void printEv(Environment *ev);

Stack *stk;
Environment NEAR ev;

char szMainWindowClass[32];
char szMessage[64];
int pushValue;
HANDLE hCurrent;

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
                        LPSTR lpszCmdParam, int nCmdShow)
{
        HWND hwnd;
        MSG msg;
        static char szAppName[] = "DSOM Stack sample" ;
        WNDCLASS    wndclass ;

	InitNlsMsgs();

//        SOM_MainProgram();

        hCurrent = hInstance;
        LoadString(hInstance, IDS_APPNAME, szMainWindowClass,
                                sizeof(szMainWindowClass));

        if (!hPrevInstance)
          {
          wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = "StackMenu";
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
          }

        hwnd = CreateWindow (szAppName, "Distributed Stack Sample",
                          WS_OVERLAPPEDWINDOW,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          NULL, NULL, hInstance, NULL) ;

        ShowWindow (hwnd, nCmdShow) ;
        UpdateWindow (hwnd) ;


        while (GetMessage(&msg, NULL, 0, 0))
        {
                TranslateMessage(&msg);
                DispatchMessage(&msg);
        }

        return msg.wParam;
}


BOOL FAR PASCAL AboutDlgProc(HWND hdlg, WORD message, WORD wParam, LONG lParam)
{
        switch (message)
        {
                case WM_INITDIALOG:
                        return TRUE;
                case WM_COMMAND:
                        switch (wParam)
                        {
                                case ID_OK:
                                        EndDialog(hdlg, TRUE);
                                        return TRUE;
                        }
                        break;
        }
        return FALSE;
}

BOOL FAR PASCAL PushDlgProc(HWND hdlg, WORD message, WORD wParam, LONG lParam)
{
        static HWND hEdit;
        static char valstr[64];

        switch (message)
        {
                case WM_INITDIALOG:
                        pushValue = 100;
                        hEdit = GetDlgItem(hdlg, ID_TEXT);
                        SetFocus(hEdit);
                        return TRUE;
                case WM_COMMAND:
                        switch (wParam)
                        {
                                case ID_OK:
                                        GetDlgItemText(hdlg, ID_TEXT, valstr, 63);
                                        pushValue = atoi(valstr);
                                        EndDialog(hdlg, TRUE);
                                        return TRUE;
                                case ID_CANCEL:
                                        EndDialog(hdlg, FALSE);
                                        return TRUE;
                                case ID_TEXT:
                                        if (HIWORD(lParam) == EN_CHANGE)
                                        {
                                                GetDlgItemText(hdlg, ID_TEXT, valstr, 63);
                                                pushValue = atoi(valstr);
                                        }
                                        return TRUE;
                        }
                        break;
        }
        return FALSE;
}


long FAR PASCAL WndProc (HWND hwnd, UINT message, UINT wParam,
                         LONG lParam)
{
        HDC hDevContext;
        PAINTSTRUCT ps;
        RECT rect;
        static FARPROC lpfnAboutDlgProc;
        static FARPROC lpfnPushDlgProc;

        switch(message)
        {
                case WM_CREATE:
                        lpfnAboutDlgProc = MakeProcInstance((FARPROC)AboutDlgProc, hCurrent);
                        lpfnPushDlgProc = MakeProcInstance((FARPROC)PushDlgProc, hCurrent);
                        SOM_InitEnvironment(&ev);
                        SOMD_Init(&ev);
                        StackNewClass(Stack_MajorVersion,Stack_MinorVersion);
			stk = (Stack *)(SOMD_ObjectMgr->somdNewObject(&ev, "Stack", NULL));
                        if (ev._major != NO_EXCEPTION) {
                                printEv(&ev);
                                SendMessage(hwnd, WM_CLOSE, 0, 0L);
                        }
                        return 0;

                case WM_PAINT:
                        hDevContext = BeginPaint(hwnd, &ps);
                        GetClientRect(hwnd, &rect);
                        if (stk->empty(&ev))
                           wsprintf((LPSTR)szMessage, GetNlsMessage(EmptyStackId));
                        else
                           wsprintf((LPSTR)szMessage, GetNlsMessage(StackTopId), (int *)stk->top(&ev));
                        DrawText(hDevContext, szMessage, -1, &rect,
                                        DT_SINGLELINE | DT_CENTER | DT_VCENTER);
                        EndPaint(hwnd, &ps);
                        return 0;

                case WM_DESTROY:
                        if (stk)
			    SOMD_ObjectMgr->somdDestroyObject(&ev, stk);
                        SOMD_Uninit(&ev);
                        SOM_UninitEnvironment(&ev);
                        PostQuitMessage(0);
                        return 0;

                case WM_COMMAND:
                        switch(wParam)
                        {
                        case IDM_ABOUT:
                                DialogBox(hCurrent, GetNlsMessage(StackAboutId), hwnd, lpfnAboutDlgProc);
                                return 0;
                        case IDM_EXIT:
                                SendMessage(hwnd, WM_CLOSE, 0, 0L);
                                return 0;
                        case IDM_PUSH:
                                if (DialogBox(hCurrent, GetNlsMessage(PushId), hwnd, lpfnPushDlgProc))
                                {
                                        wsprintf(szMessage, GetNlsMessage(ValueId), pushValue);
                                        MessageBox(hwnd, szMessage, GetNlsMessage(PushAcceptedId),
                                                MB_OK | MB_DEFBUTTON1 | MB_ICONINFORMATION);
                                        stk->push(&ev,(long)pushValue);
					somdExceptionFree(&ev);
                                        InvalidateRect(hwnd, NULL, TRUE);
                                }
                                return 0;
                        case IDM_POP:
                                stk->pop(&ev);
				somdExceptionFree(&ev);
                                InvalidateRect(hwnd, NULL, TRUE);
                                return 0;
                        }
        }

        return DefWindowProc(hwnd, message, wParam, lParam);
}

/*
 *  Prints exception information.
 */

void printEv(Environment *ev)
{
  char *exId, *bp;
  char buffer[200];
  StExcep *params;

  exId = somExceptionId(ev);
  if (!exId) exId = "None";
  params = (StExcep *)(somExceptionValue(ev));
  bp = buffer;

  wsprintf(bp, GetNlsMessage(ErrorId), (LPSTR) exId);
  bp += strlen(bp);
  wsprintf(bp, GetNlsMessage(ErrorMinorCodeId), (params ? params->minor : 0));
  bp += strlen(bp);
  wsprintf(bp, GetNlsMessage(ErrorCompletionId),
                (LPSTR) (params ? (params->completed == YES ? 
		GetNlsMessage(YesId) :
                params->completed == NO ? GetNlsMessage(NoId): GetNlsMessage(MaybeId)) : GetNlsMessage(YesId)));
  MessageBox ((HWND)NULL, buffer, GetNlsMessage(ExceptionId),
                MB_ICONEXCLAMATION | MB_OK);
  somdExceptionFree(ev);
  return;
}

