/*
 *   COMPONENT_NAME: somx
 *
 *   ORIGINS: 27
 *
 *
 *   10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
 *   All Rights Reserved
 *   Licensed Materials - Property of IBM
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */
#ifndef lint
static char *sccsid = "%Z% %I% %W% %G% %U% [%H% %T%]";
#endif

/*
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */

/* Interface Repository Viewer Program Sample */

#include <windows.h>
#include <string.h>
#include <direct.h>
#include <som.h>
#include <stdlib.h>
#include <repostry.h>
#include <containr.h>
#include <containd.h>
#include <intfacdf.h>
#include <moduledf.h>
#include <typedef.h>
#include <constdef.h>
#include <irdump.h>
#include "nlsutil.h"
/* #include <bccstruc.h>
*/
#define  MAXID        80
#define  MAXTMP     2048
#define  MAXOUT     8192
#define  WM_BLDTEXT (WM_USER+0)

long WINAPI WndProc(HWND, UINT, UINT, LONG);
LRESULT APIENTRY ListProc(HWND, UINT, UINT, LONG);
LRESULT APIENTRY TextProc(HWND, UINT, UINT, LONG);
static void irdumpHelp(HWND);
static string getErrorType(irOpenErrorCodes ec);
static int SOMLINK irOutChar(char c);
static void expandComma(char *);

char szAppName[] = "IRdump";
char szAppDesc[] = "SOM Interface Repository Viewer Sample";
char szTxtName[] = "TextWin";
char tmpbuf[MAXTMP] = "";
char buf[MAXOUT] = "";
Repository *repo = NULL;
SOMObject *cSel = NULL;
LPSTR parentid = NULL;
SOMClass *containerClass = NULL;
sequence(Contained) sc = {0, 0, NULL};
Environment *ev = NULL;
irOpenError *oep = NULL;
string exname = NULL;
HWND hwndCurr = NULL, hwndList = NULL, hwndText = NULL;
WNDPROC lpfnOldList= NULL, lpfnOldText = NULL;
HANDLE gHInstance = NULL;

/* Define standard video sizes */
float hRes = 0, vRes = 0, hFact = 0, vFact = 0, htFact = 0, wtFact = 0;
#define STDHRES    1024.0
#define STDVRES    768.0
#define STDHEIGHT  20.0
#define STDWIDTH   9.0

/* Messages for NLS Support */
static char *nlsmsgs[ENDNLSID-STARTNLSID+1];
#define GetNlsMessage(id) nlsmsgs[id-STARTNLSID]
#define SetNlsMessage(id, str) nlsmsgs[id-STARTNLSID] = (str);

/**********************************************************
18953: NLS support
This procedure must be called first to initialize all the messages
to be used by irdump. These messages are obtained from the resource file.
****************************************************************/
static void InitNlsMsgs(){
int i;
	SetNlsMessage(IRFileErrorId, NlsMsgAlloc(IRFileErrorId));
	SetNlsMessage(ModuleSelectId, NlsMsgAlloc(ModuleSelectId));
	SetNlsMessage(InterfaceInheritId, NlsMsgAlloc(InterfaceInheritId));
	SetNlsMessage(AttrOperationId, NlsMsgAlloc(AttrOperationId));
	SetNlsMessage(OperationTypecodeId, NlsMsgAlloc(OperationTypecodeId));
	SetNlsMessage(ParametersId, NlsMsgAlloc(ParametersId));
	SetNlsMessage(ExceptionId, NlsMsgAlloc(ExceptionId	));
	SetNlsMessage(ParameterOperationId	, NlsMsgAlloc(ParameterOperationId));
	SetNlsMessage(TypeDefinedId, NlsMsgAlloc(TypeDefinedId));
	SetNlsMessage(ExceptionDefinedId, NlsMsgAlloc(ExceptionDefinedId));
	SetNlsMessage(AttributeDefinedId, NlsMsgAlloc(AttributeDefinedId));
	SetNlsMessage(ConstantDefinedId, NlsMsgAlloc(ConstantDefinedId));
	SetNlsMessage(UnknownDescriptorId, NlsMsgAlloc(UnknownDescriptorId));
	SetNlsMessage(SOMModifiersId, NlsMsgAlloc(SOMModifiersId));
	SetNlsMessage(IRAccessId, NlsMsgAlloc(IRAccessId));
	SetNlsMessage(StaticId, NlsMsgAlloc(StaticId));
	SetNlsMessage(SelectedEntryId, NlsMsgAlloc(SelectedEntryId));
	SetNlsMessage(RepositoryIdListId, NlsMsgAlloc(RepositoryIdListId));
	SetNlsMessage(SelectedEntryDescriptionId, NlsMsgAlloc(SelectedEntryDescriptionId));
	SetNlsMessage(NothingId, NlsMsgAlloc(NothingId));
	SetNlsMessage(OperationsIntroducedId, NlsMsgAlloc(OperationsIntroducedId));
	SetNlsMessage(NoParameterId, NlsMsgAlloc(NoParameterId));
	SetNlsMessage(UnknownDescriptionId, NlsMsgAlloc(UnknownDescriptionId));
	SetNlsMessage(CantFindSelectionId, NlsMsgAlloc(CantFindSelectionId));
	SetNlsMessage(IRMessageId, NlsMsgAlloc(IRMessageId));
	SetNlsMessage(AttrIntroducedId, NlsMsgAlloc(AttrIntroducedId));
	SetNlsMessage(ModeId, NlsMsgAlloc(ModeId));

}

int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
{
    HWND hwnd;
    MSG msg;
    WNDCLASS wndclass;

	InitNlsMsgs();
/*    SOM_MainProgram();
*/
    gHInstance = hInstance;

    if (!hPrevInstance) {
        wndclass.style = CS_HREDRAW | CS_VREDRAW;
        wndclass.lpfnWndProc = WndProc;
        wndclass.cbClsExtra = 0;
        wndclass.cbWndExtra = 0;
        wndclass.hInstance = hInstance;
        wndclass.hIcon = LoadIcon(hInstance, szAppName);
        wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
        wndclass.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
        wndclass.lpszMenuName  = szAppName;
        wndclass.lpszClassName = szAppName;

        RegisterClass(&wndclass);

        wndclass.style = CS_HREDRAW | CS_VREDRAW;
        wndclass.lpfnWndProc = TextProc;
        wndclass.cbClsExtra = 0;
        wndclass.cbWndExtra = 0;
        wndclass.hInstance = hInstance;
        wndclass.hIcon = NULL;
        wndclass.hCursor = NULL;
        wndclass.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
        wndclass.lpszMenuName = NULL;
        wndclass.lpszClassName = szTxtName;

        RegisterClass(&wndclass);
    }

    /* Figure video sizing factors */
    hRes  = GetSystemMetrics(SM_CXSCREEN);
    vRes  = GetSystemMetrics(SM_CYSCREEN);
    hFact = hRes / STDHRES;
    vFact = vRes / STDVRES;

    hwnd = CreateWindow(szAppName, szAppDesc,
                        WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
                        20, 10, (int)(960 * hFact), (int)(690 * vFact),
                        NULL, NULL, hInstance, 0);


    ShowWindow(hwnd, nCmdShow);
    UpdateWindow(hwnd);

    while (GetMessage(&msg, NULL, 0, 0)) {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }
    return msg.wParam;
}

long WINAPI WndProc(HWND hwnd, UINT message, UINT wParam,
                                 LONG lParam)
{
    char szBuffer[MAXTMP + 1];
    HDC hdc;
    int i;
    unsigned int ui;
    TEXTMETRIC tm;
    LRESULT rc;
    HCURSOR hCursor;
    HMENU hMenu;

    switch (message) {
        case WM_CREATE:
            hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
            ShowCursor(TRUE);
            hMenu = GetMenu(hwnd);

            ev = somGetGlobalEnvironment();
            somEnvironmentNew();
            containerClass = ContainerNewClass(0, 0);
            somSetOutChar((somTD_SOMOutCharRoutine *) irOutChar);

            /* Try to open up the IR and quit if we can't */
            if (!(repo = RepositoryNew())) {
                exname = somExceptionId(ev);
                oep = (irOpenError *) somExceptionValue(ev);
                if ((ev->_major == USER_EXCEPTION) && exname && oep &&
                    (strcmp(ex_irOpenError, exname) == 0)) {
                    wsprintf(buf, GetNlsMessage(IRFileErrorId),
                             (LPSTR) oep->fileName,
                             (LPSTR) getErrorType(oep->errorCode));
                    MessageBox(hwnd, buf, szAppDesc,
                               MB_ICONEXCLAMATION | MB_OK);
                    somExceptionFree(ev);
                }
                else
                    MessageBox(hwnd, GetNlsMessage(IRAccessId), szAppDesc,
                               MB_ICONEXCLAMATION | MB_OK);
                SendMessage(hwnd, WM_CLOSE, 0, 0L);
                return 0;
            }
                                        
            hdc = GetDC(hwnd);
            GetTextMetrics(hdc, &tm);
            ReleaseDC(hwnd, hdc);

            htFact = STDHEIGHT / tm.tmHeight;
            wtFact = STDWIDTH  / tm.tmAveCharWidth;

            CreateWindow("static", GetNlsMessage(SelectedEntryId),
                         WS_CHILDWINDOW | WS_VISIBLE | SS_LEFT,
                         (int)(tm.tmAveCharWidth * 7 * hFact * wtFact),
                         (int)(tm.tmHeight * vFact * htFact),
                         tm.tmAveCharWidth * 15,
                         tm.tmHeight,
                         hwnd, (HANDLE)2,
                         (HINSTANCE)GetWindowLong(hwnd, GWL_HINSTANCE), 0);

            hwndCurr = CreateWindow("static", "::",
                                    WS_CHILDWINDOW | WS_VISIBLE | SS_LEFT,
                                    (int)(tm.tmAveCharWidth * 4 * hFact * wtFact),
                                    (int)(tm.tmHeight * 3 * vFact * htFact),
                                    (int)(tm.tmAveCharWidth * MAXID * hFact * wtFact),
                                    tm.tmHeight,
                                    hwnd, (HANDLE)2,
                                    (HINSTANCE)GetWindowLong(hwnd, GWL_HINSTANCE), 0);

            CreateWindow("static", GetNlsMessage(RepositoryIdListId),
                         WS_CHILDWINDOW | WS_VISIBLE | SS_LEFT,
                         (int)(tm.tmAveCharWidth * 9 * hFact * wtFact),
                         (int)(tm.tmHeight * 5 * vFact * htFact),
                         tm.tmAveCharWidth * 19,
                         tm.tmHeight,
                         hwnd, (HANDLE)2,
                         (HINSTANCE)GetWindowLong(hwnd, GWL_HINSTANCE), 0);


            hwndList = CreateWindow("listbox", NULL,
                                    WS_CHILDWINDOW | WS_VISIBLE | LBS_STANDARD,
                                    (int)(tm.tmAveCharWidth * 4 * hFact * wtFact),
                                    (int)(tm.tmHeight * 7 * vFact * htFact),
                                    (int)(tm.tmAveCharWidth * 30 * hFact * wtFact +
                                    GetSystemMetrics(SM_CXVSCROLL)),
                                    (int)(tm.tmHeight * 22 * vFact * htFact),
                                    hwnd, (HANDLE)1,
                                    (HINSTANCE)GetWindowLong(hwnd, GWL_HINSTANCE), 0);

            CreateWindow("static", GetNlsMessage(SelectedEntryDescriptionId),
                         WS_CHILDWINDOW | WS_VISIBLE | SS_LEFT,
                         (int)(tm.tmAveCharWidth * 56 * hFact * wtFact),
                         (int)(tm.tmHeight * 5 * vFact * htFact),
                         tm.tmAveCharWidth * 26,
                         tm.tmHeight,
                         hwnd, (HANDLE)2,
                         (HINSTANCE)GetWindowLong(hwnd, GWL_HINSTANCE), 0);

            hwndText = CreateWindow(szTxtName, NULL,
                                    WS_CHILDWINDOW | WS_VISIBLE | WS_BORDER |
                                    WS_HSCROLL | WS_VSCROLL | WS_TABSTOP,
                                    (int)(tm.tmAveCharWidth * 40 * hFact * wtFact),
                                    (int)(tm.tmHeight * 7 * vFact * htFact),
                                    (int)(tm.tmAveCharWidth * 60 * hFact * wtFact +
                                    GetSystemMetrics(SM_CXVSCROLL)),
                                    (int)(tm.tmHeight * 22 * vFact * htFact),
                                    hwnd, (HANDLE)1,
                                    (HINSTANCE)GetWindowLong(hwnd, GWL_HINSTANCE), 0);

            lpfnOldList = (WNDPROC) SetWindowLong(hwndList, GWL_WNDPROC, (LONG)ListProc);
            
            /* Set the IR to be the current selection */
            cSel = repo;

            /* Fill up list box with toplevel contents of IR */

            /* Get the contents of the Repository */
            sc = Container_contents(cSel, ev, "all", FALSE);

            /* Clear current contents of our ListBox */
            SendMessage(hwndList, LB_RESETCONTENT, 0, 0L);

            /* Don't display the ListBox while we are filling it */
            SendMessage(hwndList, WM_SETREDRAW, FALSE, 0L);

            /*
             * Fill the ListBox with the names of the entries in the current
             * container
             */
            if (sc._length) {
                for (ui = 0; ui < sc._length; ui++) {
                    SendMessage(hwndList, LB_ADDSTRING, 0,
                                (LONG) (LPSTR) __get_id(sc._buffer[ui], ev));
                    _somFree(sc._buffer[ui]);
                }                      /* endfor */
                SOMFree(sc._buffer);
                sc._length = 0L;
            }                          /* endif */

            /* OK, now we can display ListBox */
            SendMessage(hwndList, WM_SETREDRAW, TRUE, 0L);

            ShowCursor(FALSE);
            SetCursor(hCursor);
            return 0;

        case WM_COMMAND:
             switch (wParam)
             {
             case IDM_EXIT:
                  SendMessage(hwnd, WM_CLOSE, 0, 0L);
                  return 0;

             case IDM_HELP:
                  irdumpHelp(hwnd);
                  return 0L;
             }

            if (LOWORD(wParam) == 1 && HIWORD(wParam) == LBN_DBLCLK) {
                if (LB_ERR == (i = (WORD) SendMessage(hwndList, LB_GETCURSEL, 0, 0L)))
                    break;
                SendMessage(hwndList, LB_GETTEXT, i, (LONG) (char far *) szBuffer);

                cSel = (strcmp(szBuffer, "::") == 0) ? repo
                    : Repository_lookup_id(repo, ev, (string) szBuffer);

                if (cSel) {
                    SetWindowText(hwndCurr, szBuffer);
                    if (_somIsA(cSel, containerClass)) {
                        HCURSOR hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
                        ShowCursor(TRUE);
                        /* Clear current contents of our ListBox */
                        SendMessage(hwndList, LB_RESETCONTENT, 0, 0L);

                        /*
                         * Add the object in which the selection in defined to
                         * the List Box -- so the user can "pop back up" later
                         */
                        if (cSel != repo) {
                            rc = SendMessage(hwndList, LB_ADDSTRING, 0,
                                   (LONG) (LPSTR) __get_defined_in(cSel, ev));
                        }              /* endfor */

                        /* Determine contents of current selection */
                        sc = Container_contents(cSel, ev, "all", FALSE);

                        /*
                         * Fill the ListBox with the names of the entries in
                         * the current container
                         */
                        if (sc._length) {
                            for (ui = 0; ui < sc._length; ui++) {
                                rc = SendMessage(hwndList, LB_ADDSTRING, 0,
                                 (LONG) (LPSTR) __get_id(sc._buffer[ui], ev));
                                _somFree(sc._buffer[ui]);
                            }          /* endfor */
                            SOMFree(sc._buffer);
                            sc._length = 0L;
                        }              /* endif */
                        ShowCursor(FALSE);
                        SetCursor(hCursor);
                    }
                    else {             /* cSel is a contained object */
                        parentid = __get_defined_in(cSel, ev);
                        /* if parent not already in List Box, Add it */
                        if (LB_ERR == SendMessage(hwndList,
                                                  LB_FINDSTRINGEXACT,
                                                  (WPARAM) - 1,
                                              (LPARAM) ((LPCSTR) parentid))) {
                            SendMessage(hwndList, LB_ADDSTRING, 0, (LONG) (LPSTR) parentid);
                        }              /* endif */
                    }                  /* endif */
                }
                else {                 /* cSel is NULL */
                    MessageBox(hwnd, GetNlsMessage(CantFindSelectionId), szAppDesc,
                               MB_ICONEXCLAMATION | MB_OK);
                }                      /* endif */

                SendMessage(hwndText, WM_BLDTEXT, 0, 0L);
            }                          /* end if */
            return 0;

        case WM_DESTROY:
            PostQuitMessage(0);
            return 0;
    }
    return DefWindowProc(hwnd, message, wParam, lParam);
}


LRESULT APIENTRY ListProc(HWND hwnd, UINT message, UINT wParam,
                                  LONG lParam)
{
    if (message == WM_KEYDOWN && wParam == VK_RETURN)
         SendMessage(GetParent(hwnd), WM_COMMAND, (UINT)(MAKELONG(1, LBN_DBLCLK)), (LONG)hwnd);

    return CallWindowProc(lpfnOldList, hwnd, message, wParam, lParam);
}


LRESULT APIENTRY TextProc(HWND hwnd, UINT message, UINT wParam,
                                 LONG lParam)
{
    HDC          hdc;
    unsigned int ui, cnt;
    PAINTSTRUCT  ps;
    Description  cdesc;
    HCURSOR      hCursor;
    static BOOL  first = TRUE;
    static RECT  rect = {0, 0, 0, 0};
    static short vPos = 0, hPos = 0, numlines = 0, maxline = 0;
    static TEXTMETRIC tm = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};


    switch (message) {
        case WM_CREATE:
            hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
            ShowCursor(TRUE);

            hdc = GetDC(hwnd);
            SelectObject(hdc, GetStockObject(SYSTEM_FIXED_FONT));
            GetTextMetrics(hdc, &tm);
            ReleaseDC(hwnd, hdc);
            first = TRUE;
            return 0;

        case WM_SIZE:
            rect.right = LOWORD(lParam);
            rect.bottom = HIWORD(lParam);
            return 0;

        case WM_VSCROLL:

            switch (wParam) {
                case SB_LINEUP:
                    vPos -= 1;
                    break;

                case SB_LINEDOWN:
                    vPos += 1;
                    break;

                case SB_PAGEUP:
                    vPos -= rect.bottom / tm.tmHeight;
                    break;

                case SB_PAGEDOWN:
                    vPos += rect.bottom / tm.tmHeight;
                    break;

                case SB_THUMBPOSITION:
                    vPos = LOWORD(lParam);
                    break;

            }
            /* Must double the scroll range because of possibility of wrap */
            vPos = max(0, min(vPos, numlines*2));

            if (vPos != GetScrollPos(hwnd, SB_VERT)) {
                SetScrollPos(hwnd, SB_VERT, vPos, TRUE);
                InvalidateRect(hwnd, NULL, TRUE);
            }

            return 0;

        case WM_HSCROLL:

            switch (wParam) {
                case SB_LINEUP:
                    hPos -= 1;
                    break;

                case SB_LINEDOWN:
                    hPos += 1;
                    break;

                case SB_PAGEUP:
                    hPos -= rect.right / tm.tmAveCharWidth;
                    break;

                case SB_PAGEDOWN:
                    hPos += rect.right / tm.tmAveCharWidth;
                    break;

                case SB_THUMBPOSITION:
                    hPos = LOWORD(lParam);
                    break;

            }
            hPos = max(0, min(hPos, maxline));

            if (hPos != GetScrollPos(hwnd, SB_HORZ)) {
                SetScrollPos(hwnd, SB_HORZ, hPos, TRUE);
                InvalidateRect(hwnd, NULL, TRUE);
            }

            return 0;

        case WM_PAINT:
            if (first) {
               SendMessage(hwnd, WM_BLDTEXT, 0, 0L);
               first = FALSE;
            }

            rect.left = (1 * tm.tmAveCharWidth) - (hPos * tm.tmAveCharWidth);
            rect.top  = (1 * tm.tmHeight) - (vPos * tm.tmHeight);

            hdc = BeginPaint(hwnd, &ps);
            SelectObject(hdc, GetStockObject(SYSTEM_FIXED_FONT));
            SetTextColor(hdc, GetSysColor(COLOR_WINDOWTEXT));
            SetBkColor(hdc, GetSysColor(COLOR_WINDOW));

            /* Must double the scroll range because of possibility of wrap */
            SetScrollRange(hwnd, SB_VERT, 0, numlines*2, FALSE);
            SetScrollPos(hwnd, SB_VERT, vPos, TRUE);
            SetScrollRange(hwnd, SB_HORZ, 0, maxline, FALSE);
            SetScrollPos(hwnd, SB_HORZ, hPos, TRUE);

            DrawText(hdc, (LPSTR) buf, -1, &rect, DT_WORDBREAK |
                     DT_EXPANDTABS | DT_NOCLIP | DT_NOPREFIX);

            EndPaint(hwnd, &ps);
            return 0;

        case WM_BLDTEXT:
            /*
             * if there is a current object, get its description and "draw" it
             */

            if (cSel == repo) {
                strcpy(buf, GetNlsMessage(IRMessageId));
            }
            else {
                sequence(somModifier) sm;
                cdesc = Contained_describe(cSel, ev);
                if (strcmp(cdesc.name, "ModuleDescription") == 0) {
                    sequence(Contained) seq;
                    ModuleDescription *md;
                    seq = Container_contents(cSel, ev, "all", FALSE);
                    md = (ModuleDescription *) cdesc.value._value;
                    wsprintf(buf,
                    		GetNlsMessage(ModuleSelectId),
                             (LPSTR) (md->name),
                             seq._length,
                             (LPSTR) (seq._length == 1 ? "" : "s"));
                }
                else if (strcmp(cdesc.name, "InterfaceDescription") == 0) {
                    FullInterfaceDescription fifdesc;
                    sequence(RepositoryId) srid;
                    fifdesc = InterfaceDef_describe_interface(cSel, ev);
                    wsprintf(buf, GetNlsMessage(InterfaceInheritId), (LPSTR) fifdesc.name);
                    srid = __get_base_interfaces(cSel, ev);
                    strcpy(tmpbuf, "");
                    if (srid._length) {
                        for (ui = 0; ui < srid._length; ui++) {
                            strcat(tmpbuf, srid._buffer[ui]);
                            if (ui + 1 < srid._length)
                                strcat(tmpbuf, ", ");
                        }              /* endfor */
                    }
                    else {
                        strcat(tmpbuf, GetNlsMessage(NothingId));
                    }                  /* endif */
                    strcat(tmpbuf, ".\n\n");
                    strcat(buf, tmpbuf);
                    wsprintf(tmpbuf, GetNlsMessage(AttrOperationId),
                             (LPSTR) fifdesc.name,
                             fifdesc.attributes._length,
                         (LPSTR) (fifdesc.attributes._length == 1 ? "" : "s"),
                             fifdesc.operation._length,
                         (LPSTR) (fifdesc.operation._length == 1 ? "" : "s"));
                    strcat(buf, tmpbuf);
                    if (fifdesc.attributes._length) {
                        strcat(buf, GetNlsMessage(AttrIntroducedId));
                        for (ui = 0; ui < fifdesc.attributes._length; ui++) {
                            strcat(buf, fifdesc.attributes._buffer[ui].name);
                            if (ui + 1 < fifdesc.attributes._length)
                                strcat(buf, ", ");
                        }              /* endfor */
                        strcat(buf, "\n\n");
                    }                  /* endif */
                    if (fifdesc.operation._length) {
                        strcat(buf, GetNlsMessage(OperationsIntroducedId));
                        for (ui = 0; ui < fifdesc.operation._length; ui++) {
                            strcat(buf, fifdesc.operation._buffer[ui].name);
                            if (ui + 1 < fifdesc.operation._length)
                                strcat(buf, ", ");
                        }              /* endfor */
                        strcat(buf, "\n\n");
                    }                  /* endif */
                }
                else if (strcmp(cdesc.name, "OperationDescription") == 0) {
                    OperationDescription *opd = cdesc.value._value;
                    sequence(ParameterDescription) params;
                    sequence(ExceptionDescription) excepts;

                    wsprintf(buf, GetNlsMessage(OperationTypecodeId),
                             (LPSTR) opd->name);
                    TypeCode_print(opd->result, ev);
                    strcat(buf, GetNlsMessage(ModeId));
                    strcat(buf, (opd->mode == OperationDef_ONEWAY) ? "ONEWAY" : "NORMAL");
                    params = opd->parameter;
                    if (params._length) {
                        wsprintf(tmpbuf, GetNlsMessage(ParametersId),
                                 (LPSTR) (params._length == 1 ? "" : "s"));
                        strcat(buf, tmpbuf);
                        for (ui = 0; ui < params._length; ui++) {
                            wsprintf(tmpbuf, "[%d] %s (%s):\n  ",
                                     ui + 1,
                                     (LPSTR) params._buffer[ui].name,
                                     (LPSTR) (params._buffer[ui].mode == ParameterDef_IN) ?
                                     "IN" : (params._buffer[ui].mode == ParameterDef_OUT) ?
                                     "OUT" : "INOUT");
                            strcat(buf, tmpbuf);
                            TypeCode_print(params._buffer[ui].type, ev);
                        }              /* endfor */
                    }
                    else {
                        strcat(buf, GetNlsMessage(NoParameterId));
                    }                  /* endif */
                    excepts = opd->exceptions;
                    if (excepts._length) {
                        wsprintf(tmpbuf, GetNlsMessage(ExceptionId),
                                 (LPSTR) (excepts._length == 1 ? "" : "s"));
                        strcat(buf, tmpbuf);
                        for (ui = 0; ui < excepts._length; ui++) {
                            strcat(buf, excepts._buffer[ui].name);
                            strcat(buf, ":\n  ");
                            TypeCode_print(excepts._buffer[ui].type, ev);
                        }              /* endfor */
                    }                  /* endif */
                }
                else if (strcmp(cdesc.name, "ParameterDescription") == 0) {
                    ParameterDescription *pd = cdesc.value._value;
                    wsprintf(buf, GetNlsMessage(ParameterOperationId),
                             (LPSTR) pd->name,
                             (LPSTR) pd->defined_in,
                             (LPSTR) (pd->mode == ParameterDef_IN) ?
                             "IN" : (pd->mode == ParameterDef_OUT) ?
                             "OUT" : "INOUT");
                    TypeCode_print(pd->type, ev);
                }
                else if (strcmp(cdesc.name, "TypeDescription") == 0) {
                    TypeDescription *td = cdesc.value._value;
                    wsprintf(buf,GetNlsMessage(TypeDefinedId),
                             (LPSTR) td->name,
                             (LPSTR) td->defined_in);
                    TypeCode_print(td->type, ev);
                }
                else if (strcmp(cdesc.name, "ExceptionDescription") == 0) {
                    ExceptionDescription *xd = cdesc.value._value;
                    wsprintf(buf,GetNlsMessage(ExceptionDefinedId),
                             (LPSTR) xd->name,
                             (LPSTR) xd->defined_in);
                    TypeCode_print(xd->type, ev);
                }
                else if (strcmp(cdesc.name, "AttributeDescription") == 0) {
                    AttributeDescription *ad = cdesc.value._value;
                    wsprintf(buf,GetNlsMessage(AttributeDefinedId),
                             (LPSTR) ad->name,
                             (LPSTR) ad->defined_in,
                             (LPSTR) (ad->mode == AttributeDef_READONLY) ?
                             "READONLY" : "NORMAL");
                    TypeCode_print(ad->type, ev);
                }
                else if (strcmp(cdesc.name, "ConstantDescription") == 0) {
                    ConstantDescription *cd = cdesc.value._value;
                    wsprintf(buf,GetNlsMessage(ConstantDefinedId),
                             (LPSTR) cd->name,
                             (LPSTR) cd->defined_in,
                             (LPSTR) cd->value._value);
                    TypeCode_print(cd->type, ev);
                }
                else {
                    MessageBox(hwnd, GetNlsMessage(UnknownDescriptionId), szAppDesc,
                               MB_ICONEXCLAMATION | MB_OK);
                    SendMessage(hwnd, WM_CLOSE, 0, 0L);
                }                      /* endif */
                sm = __get_somModifiers(cSel, ev);
                if (sm._length) {
                    strcat(buf, GetNlsMessage(SOMModifiersId));
                    for (ui = 0; ui < sm._length; ui++) {
                        if (sm._buffer[ui].name && sm._buffer[ui].value) {
                            wsprintf(tmpbuf, "  %s = %s\n",
                                   sm._buffer[ui].name, sm._buffer[ui].value);
                            strcat(buf, tmpbuf);
                        }
                        else {
                            strcat(buf, sm._buffer[ui].name ? sm._buffer[ui].name : "\"\"");
                        }              /* endif */
                    }                  /* endfor */
                }                      /* endif */
            }                          /* endif */

            /* Make sure each ',' followed by ' ' */
            expandComma(buf);

            /* Count the number of lines and figure the longest line */
            numlines = maxline = cnt = 1;
            for (ui = 0; buf[ui] != 0; ui++) {
                if (buf[ui] == '\n') {
                    numlines++;
                    maxline = max(cnt, maxline);
                    cnt = 1;
                }
                else
                    cnt++;
            }

            vPos = hPos = 0;
            InvalidateRect(hwnd, NULL, TRUE);
            return 0;
    }

    return DefWindowProc(hwnd, message, wParam, lParam);
}


static void irdumpHelp(HWND hwnd)
{
    int i;
    static char *helpbuf = NULL;
    char buf[80];

    if (helpbuf == NULL) {
       helpbuf = SOMMalloc(1024);
       *helpbuf = 0;
       for (i = HELP01; i < HELP01+HELPCOUNT; i++) {
           LoadString(gHInstance, i, buf, sizeof(buf));
           strcat(helpbuf, buf);
       }
    }

    MessageBox(hwnd, helpbuf, szAppDesc, MB_ICONINFORMATION  | MB_OK);
}


static string getErrorType(irOpenErrorCodes ec)
{
    switch (ec) {
            case Repository_NOACCESS:
             return "NOACCESS";
        case Repository_BADMAGICNUMBER:
            return "BADMAGICNUMBER";
        case Repository_MISSINGVERSIONINFO:
            return "MISSINGVERSIONINFO";
        case Repository_IOERROR:
            return "IOERROR";
        case Repository_VERSIONMISMATCH:
            return "VERSIONMISMATCH";
    }
    return "UNKNOWN";
}


/* included so that we can dump typecodes using existing routines
   that make use of somPrintf */
static int SOMLINK irOutChar(char c)
{
    int n = strlen(buf);
    if (n < MAXOUT) {
        buf[n] = c;
        buf[n + 1] = (char) 0;
        return 1;
    }
    else
        return 0;
}



/* Added to maximize DrawText line wrapping */
static void expandComma(char *pbuf)
{
    char tbuf[MAXOUT];
    char *p1, *p2;

    p1 = pbuf;
    p2 = tbuf;

    do {
       *p2 = *p1;
       if (*p1 == ',' && *(p1+1) != ' ') {
          p2++;
          *p2 = ' ';
       }
       p1++;
       p2++;

    }
    while (*(p1-1) != 0);

    strcpy(pbuf, tbuf);
}
