#ifndef lint
static char *sccsid = "%Z% %I% %W% %G% %U% [%H% %T%] (c)IBM Corp. 1993";
#endif

#include "animals.h"
#include "nlsutil.h"
#include "msgid.h"
#include <stdio.h>
#define BIG_DOG_MAX 4

int main(int argc, char *argv[])
{
    Environment *ev = somGetGlobalEnvironment ();
    string bigDogNames[6] = {
        "Lassie", "Guffy", "Waldo", "Pluto", "Elvis", "Spike"
        };
    sequence(Animals_Animal) allCreatures;
    int i;

   /* Use translated messages, instead of English */
   bigDogNames[0] = NlsMsgAlloc(LassieId);
   bigDogNames[1] = NlsMsgAlloc(GuffyId);
   bigDogNames[2] = NlsMsgAlloc(WaldoId);
   bigDogNames[3] = NlsMsgAlloc(PlutoId);
   bigDogNames[4] = NlsMsgAlloc(ElvisId);
   bigDogNames[5] = NlsMsgAlloc(SpikeId);

    /*
     * Create classes. 
     */
    Animals_AnimalNewClass (Animals_Animal_MajorVersion, 
        Animals_Animal_MinorVersion);
    Animals_DogNewClass (Animals_Dog_MajorVersion, Animals_Dog_MinorVersion);
    Animals_LittleDogNewClass (Animals_LittleDog_MajorVersion, 
        Animals_LittleDog_MinorVersion);
    Animals_BigDogNewClass (Animals_BigDog_MajorVersion,
        Animals_BigDog_MinorVersion);

    SOM_TraceLevel = (argc > 1 ? 1 : 0);

    /*
     * Create objects using constructors 
     */
    _newAnimal (_Animals_Animal, ev, NlsMsgAlloc(ScaryId), NlsMsgAlloc(RoarId));
    _newDog (_Animals_Dog, ev, NlsMsgAlloc(RoverId), NlsMsgAlloc(GrrId),
		NlsMsgAlloc(RetrieverId), NlsMsgAlloc(YellowId));
    _newDog (_Animals_LittleDog, ev, NlsMsgAlloc(PierreId), 
		NlsMsgAlloc(YapId), NlsMsgAlloc(FrenchPoodleId),
	        NlsMsgAlloc(BlackId));
    for (i=0; i<(sizeof(bigDogNames)/sizeof(string)); i++)
        _newDog (_Animals_BigDog, ev, bigDogNames[i], (string) NULL, 
            NlsMsgAlloc(GermanShepherdId), NlsMsgAlloc(BrownId));

    /*
     * Display objects. 
     */
    somPrintf (NlsMsgAlloc(SeparatorId));
    allCreatures = __get_instances (_Animals_Animal, ev);
   
    for (i=0; i<allCreatures._length; i++) {
        _display (allCreatures._buffer[i], ev);
    }


    somPrintf (NlsMsgAlloc(PopulationId), allCreatures._length);

    /*
     * Free objects. 
     */
    for (i=0; i<allCreatures._length; i++)
        _somFree (allCreatures._buffer[i]);

    somPrintf ("\n");

    return(0);
}
