
/*
 *  This file was generated by the SOM Compiler.
 *  Generated using:
 *     SOM incremental update: 10.9
 */


#ifndef lint
static char *sccsid = "%Z% %I% %W% %G% %U% [%H% %T%] (c)IBM Corp. 1992";
#endif

/*
 * This class is adapted from the book
 *   Class Construction in C and C++, Object Oriented Fundamentals
 *   by Roger Sessions, Copyright (c) 1992 Prentice Hall.
 * Reprinted with permission.
 */
#include "msgid.h"
#include "nlsutil.h"

#define fileMgr_Class_Source
#if defined(_WIN32)
#include "statcls.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include "fm.ih"

/* ************************************************************ */
/*
 *  Initialize and open a new file.
 */

SOM_Scope void  SOMLINK fmInit(fileMgr *somSelf,
		string newFile)
{
    fileMgrData *somThis = fileMgrGetData(somSelf);
    fileMgrMethodDebug("fileMgr", "fileMgrInit");
    if (!(_funit = fopen(newFile, "r"))) {
	printf(NlsMsgGet(FileOpenErrorId), newFile);
	exit(3);
    }
}

/* ************************************************************ */
/*
 *  Get the next character in the file.
 */

SOM_Scope long  SOMLINK fmGetChar(fileMgr *somSelf)
{
    fileMgrData *somThis = fileMgrGetData(somSelf);
    int newChar;
    fileMgrMethodDebug("fileMgr", "fmGetChar");

    if (_fmSize(somSelf)) {
	newChar = _buffer[_getSide];
	_getSide = _fmIncr(somSelf, _getSide);
    }
    else {
	newChar = getc(_funit);
    }
    return newChar;
}

/* ************************************************************ */
/*
 *  Peek ahead in the file.
 */

SOM_Scope long  SOMLINK fmPeekChar(fileMgr *somSelf,
		long offset)
{
    fileMgrData *somThis = fileMgrGetData(somSelf);
    int newChar;
    char cChar;
    int n;
    fileMgrMethodDebug("fileMgr", "fmPeekChar");

    for (;;) {
	n = _fmSize(somSelf);
	if (n > offset)
	    break;
	newChar = getc(_funit);
	cChar = (char) newChar;
	_buffer[_putSide] = newChar;
	_putSide = _fmIncr(somSelf, _putSide);
    }
    offset = _fmAdd(somSelf, _getSide, offset);
    newChar = _buffer[offset];
    return newChar;
}

/* ************************************************************ */
SOM_Scope void SOMLINK somInit(fileMgr * somSelf)
{
    fileMgrData *somThis = fileMgrGetData(somSelf);
    fileMgrMethodDebug("fileMgr", "somInit");
    parent_somInit(somSelf);

    _funit = 0;
    _putSide = 0;
    _getSide = 0;
}

/* ************************************************************ */
SOM_Scope void SOMLINK somUninit(fileMgr * somSelf)
{
    fileMgrData *somThis = fileMgrGetData(somSelf);
    fileMgrMethodDebug("fileMgr", "somUninit");

    if (_funit)
	fclose(_funit);

    parent_somUninit(somSelf);
}

/* ************************************************************ */

/*
 * SOM_Scope void SOMLINK somDumpSelfInt(fileMgr * somSelf,
 * 				       int level)
 */

/*
 * The prototype for somDumpSelfInt was replaced by the following prototype:
 */
SOM_Scope void  SOMLINK somDumpSelfInt(fileMgr *somSelf,
		long level)
{
    fileMgrData *somThis = fileMgrGetData(somSelf);
    fileMgrMethodDebug("fileMgr", "somDumpSelfInt");
    parent_somDumpSelfInt(somSelf, level);
}

/* ************************************************************ */
SOM_Scope long SOMLINK fmSize(fileMgr * somSelf)
{
    fileMgrData *somThis = fileMgrGetData(somSelf);
    int result;
    fileMgrMethodDebug("fileMgr", "size");

    if (_getSide == _putSide)
	result = 0;
    else if (_getSide < _putSide)
	result = _putSide - _getSide;
    else
	result = (BUFF_SIZE - _getSide - 1) + (_putSide + 1);
    return result;
}

/* ************************************************************ */
SOM_Scope long SOMLINK fmIncr(fileMgr * somSelf,
			      long oldNum)
{
    fileMgrData *somThis = fileMgrGetData(somSelf);
    fileMgrMethodDebug("fileMgr", "incr");

    if (oldNum == (BUFF_SIZE - 1))
	return 0;
    else
	return (oldNum + 1);
}

/* ************************************************************ */
SOM_Scope long SOMLINK fmAdd(fileMgr * somSelf,
			     long oldNum,
			     long addNum)
{
    fileMgrData *somThis = fileMgrGetData(somSelf);
    fileMgrMethodDebug("fileMgr", "add");
    return ((oldNum + addNum) % BUFF_SIZE);
}
