/*
#
#   COMPONENT_NAME: somx
#
#   ORIGINS: 27
#
#
#   10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
#   All Rights Reserved
#   Licensed Materials - Property of IBM
#   US Government Users Restricted Rights - Use, duplication or
#   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.




# DISCLAIMER OF WARRANTIES.
# The following [enclosed] code is sample code created by IBM
# Corporation. This sample code is not part of any standard or IBM
# product and is provided to you solely for the purpose of assisting
# you in the development of your applications.  The code is provided
# "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
# NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
# FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
# THIS CODE.  IBM shall not be liable for any damages arising out of
# your use of the sample code, even if they have been advised of the
# possibility of such damages.
#
# DISTRIBUTION.
# This sample code can be freely distributed, copied, altered, and
# incorporated into other software, provided that it bears the above
# Copyright notice and DISCLAIMER intact.
*/
#ifdef __cplusplus
extern "C" {
#endif

#include <windows.h>
#include <stdio.h>
#include <som.h>

#define BUFSIZE 256
char buf[BUFSIZE];


static HINSTANCE hinst = NULL;

/*************************************************************
Load a message from the resource, based on the msgId.
A temp buffer is returned.
**************************************************************/
char * __stdcall NlsMsgGet(int msgId){

	if (hinst == NULL)
	{
		hinst = GetModuleHandle(NULL);
		if (hinst == NULL)
		{
			/* note: can't translate this error message */
			fprintf(stderr,"can't get module handle\n");
			exit(1);
		}
	}

	if (LoadString(hinst, msgId, buf, BUFSIZE) == 0)
		return "unknown nls message";
	else return buf;
}

/**********************************************************************
Load a nls message from the rc.
New memory is allocated. The new memory should be freed with somFree
***********************************************************************/
char * __stdcall NlsMsgAlloc(int msgId){
char *msg, *finalMsg;

	msg = NlsMsgGet(msgId);
	finalMsg=(char *)SOMMalloc(strlen(msg)+1);
	if (finalMsg == NULL){
		fprintf(stderr,"out of memory\n");
		exit(1);
	}
	strcpy(finalMsg, msg);
	return finalMsg;
}

#ifdef __cplusplus
}
#endif
