BASENAME=cppwv13
#*******************************************************************************
#* SAMPLE PROJECT: Calculator Makefile - builds the DLL and Import LIB         *
#*                 for the nonvisual parts                                     *
#*                                                                             *
#* COPYRIGHT:                                                                  *
#* ----------                                                                  *
#* Copyright (C) International Business Machines Corp., 1992,1996.             *
#*                                                                             *
#* DISCLAIMER OF WARRANTIES:                                                   *
#* -------------------------                                                   *
#* The following [enclosed] code is sample code created by IBM                 *
#* Corporation. This sample code is not part of any standard IBM product       *
#* and is provided to you solely for the purpose of assisting you in the       *
#* development of your applications.  The code is provided "AS IS",            *
#* without warranty of any kind.  IBM shall not be liable for any damages      *
#* arising out of your use of the sample code, even if they have been          *
#* advised of the possibility of such damages.                                 *
#*                                                                             *
#*******************************************************************************

##########################################################
# Define variables for makefile
##########################################################
GCPPFLAGS=/c /Ge- /Gd+ /Gm+ /Ft$(BASENAME) /Tdp /Q /DIVBSAMP_IMPORT=
LINKFLAGS=/Ge- /Gd+ /Gm+ /Ft$(BASENAME) /Tdp /Q /DIVBSAMP_IMPORT=

##########################################################
# Definitions for GCPPFLAGS (compile options):
##########################################################
# /c   = perform compile only
# /Ge- = create a DLL (/Ge+ to create an EXE)
# /Ti+ = generate debugger information
# /Gd- = statically link runtime functions (why??)
# /Gm+ = multi-thread capability
# /Gn+ = not providing linker info about default libraries
#        (in object).  All libraries must be explicitly
#        specified at link time
# /Ft  = generate files for template resolution and put
#        them in the specified directory
# /Tdp = consider all files to be C++ files
# /I   = control which paths are searched when the
#        compiler looks for user #include files.  These
#        paths are searched before those given in the
#        INCLUDE environment variable.  The format is:
#             I  path[;path][;path]...
##########################################################
OBJS=icalcpu.obj \
                icalcop.obj \
                icalcfnc.obj \
                ikeypad.obj \
                icalcac.obj \
                icalcsc.obj \
                icalcmc.obj \
                icalcdc.obj \
                icalcclr.obj \
                icalceql.obj \
                icalctly.obj \
                iclrdsp.obj \
                imykybrd.obj

.cpp.obj:
    @echo Compiling... $(*F)... >con
    icc.exe $(GCPPFLAGS) %s

all:          main

main:         $(BASENAME).dll

##########################################################
# List of dependency files for the DLL.
# NOTE:  the compilation ordering is determined by the
#        dependency ordering.
##########################################################
$(BASENAME).dll:    $(BASENAME).def \
                    $(BASENAME).lib \
                    $(OBJS)
##########################################################
# When any of the DLL dependency files change, invoke the
# linker to rebuild the DLL.
##########################################################
# /Tdp = consider all files to be C++ files
# /Gm+ = multi-thread capability
# /Gn+ = not providing linker info about default libraries
#        (in object).  All libraries must be explicitly
#        specified at link time
# /Ft  = generate files for template resolution in the
#        specified directory under the current directory
# /B   = indicates passing linker options
# /NOE =
# /NOI =
# /MAP =
#
# NOTE:  the template code doesn't get compiled until
#        the link, so need to include the /Gm+ and /Gn+ options on the
#        link as well as the compile (otherwise, got link errors).
##########################################################
                @echo Creating DLL>con
                icc $(LINKFLAGS) /B"/DLL /NOE /MAP" \
##########################################################
# Name of the DLL being built and the MAP file to be
# created by the linker.
##########################################################
                /Fe$(*F) $(BASENAME).exp $(OBJS)

##########################################################
# Generate an import library (.LIB) to allow DLL to be
# linked with applications.  The DEF file is created
# and used as input.
##########################################################
$(BASENAME).def: $(OBJS)
        @echo creating DEF file $(*F) ...>con
        copy << $(BASENAME).def
                LIBRARY $(BASENAME)
                DESCRIPTION  'Visual Builder CALCULATOR DLL'
EXPORTS
;       _DLL_InitTerm@12  @1 NONAME
<<
        cppfilt -b -p -O:1000 -n $** >> $(BASENAME).def

$(BASENAME).lib: $(OBJS) $(BASENAME).def
              @echo Creating import library $(*F)...>con
              ilib /Freeform /Q /GENI:$(BASENAME).lib $(BASENAME).def

##########################################################
# Statements to compile each non-visual C++ file for the Calc
##########################################################
icalcpu.obj:     icalcpu.cpp  icalcpu.hpp


icalcop.obj:     icalcop.cpp  icalcop.hpp


icalcac.obj:     icalcac.cpp  icalcac.hpp icalcop.hpp


icalcsc.obj:     icalcsc.cpp  icalcsc.hpp icalcop.hpp


icalcmc.obj:     icalcmc.cpp  icalcmc.hpp icalcop.hpp


icalcdc.obj:     icalcdc.cpp  icalcdc.hpp icalcop.hpp


icalcfnc.obj:    icalcfnc.cpp  icalcfnc.hpp


icalcclr.obj:    icalcclr.cpp  icalcclr.hpp icalcfnc.hpp icalcpu.hpp


icalceql.obj:    icalceql.cpp  icalceql.hpp icalcfnc.hpp icalcpu.hpp


icalctly.obj:    icalctly.cpp  icalctly.hpp


ikeypad.obj:     ikeypad.cpp  ikeypad.hpp


iclrdsp.obj:     iclrdsp.cpp iclrdsp.hpp


imykybrd.obj:    imykybrd.cpp imykybrd.hpp


