BASENAME=cppwv23
#*******************************************************************************
#* SAMPLE PROJECT: Police Rap Sheet Makefile - builds the DLL and Import LIB   *
#*                 for the nonvisual parts                                     *
#*                                                                             *
#* COPYRIGHT:                                                                  *
#* ----------                                                                  *
#* Copyright (C) International Business Machines Corp., 1992,1996.             *
#*                                                                             *
#* DISCLAIMER OF WARRANTIES:                                                   *
#* -------------------------                                                   *
#* The following [enclosed] code is sample code created by IBM                 *
#* Corporation. This sample code is not part of any standard IBM product       *
#* and is provided to you solely for the purpose of assisting you in the       *
#* development of your applications.  The code is provided "AS IS",            *
#* without warranty of any kind.  IBM shall not be liable for any damages      *
#* arising out of your use of the sample code, even if they have been          *
#* advised of the possibility of such damages.                                 *
#*                                                                             *
#*******************************************************************************

##########################################################
# Define variables for makefile
##########################################################
GCPPFLAGS=/c /Ge- /Gd+ /Gm+ /Ft$(BASENAME) /Tdp /Q /DIVBSAMP_IMPORT=
LINKFLAGS=/Ge- /Gd+ /Gm+ /Ft$(BASENAME) /Tdp /Q /DIVBSAMP_IMPORT=

##########################################################
# Definitions for GCPPFLAGS (compile options):
##########################################################
# /c   = perform compile only
# /Ge- = create a DLL (/Ge+ to create an EXE)
# /Ti+ = generate debugger information
# /Gd+ = dynamically link runtime functions
# /Gm+ = multi-thread capability
# /Ft  = generate files for template resolution and put
#        them in the specified directory
# /Tdp = consider all files to be C++ files
##########################################################

##########################################################
# Definitions for LINKFLAGS (link options):
##########################################################
# See the definitions for the compile options
##########################################################

##########################################################
# List of the .OBJ files
##########################################################
OBJS=querydb.obj \
     irsltrec.obj \
     iaddrrec.obj \
     ialsrec.obj \
     iarstrec.obj \
     isusrec.obj \
     ialias.obj \
     iarrest.obj \
     iperson.obj \
     isuspect.obj \
     ialsrmgr.obj \
     iarsrmgr.obj \
     iadrrmgr.obj \
     isusrmgr.obj

##########################################################
# When any of the OBJ dependency files change, invoke the
# compiler to recompile them.
##########################################################
.cpp.obj:
    @echo Compiling... $(*F)... >con
    icc.exe $(GCPPFLAGS) %s


all:          main

main:         $(BASENAME).dll

##########################################################
# List of dependency files for the DLL.
##########################################################
$(BASENAME).dll:    $(BASENAME).def \
                    $(BASENAME).lib \
                    $(OBJS)
##########################################################
# When any of the DLL dependency files change, invoke the
# linker to rebuild the DLL.
##########################################################
                @echo Creating DLL>con
                icc $(LINKFLAGS) /B"/DLL /NOE /MAP /DEBUG" \
                /Fe$(*F) $(BASENAME).exp $(OBJS)

##########################################################
# Generate a .DEF file
##########################################################
$(BASENAME).def: $(OBJS)
        @echo creating DEF file $(*F) ...>con
        copy << $(BASENAME).def
                LIBRARY $(BASENAME)
                DESCRIPTION  'Visual Builder Rap Sheet DLL'
EXPORTS
;       _DLL_InitTerm@12  @1 NONAME
<<
        cppfilt -b -p -O:1000 -n $** >> $(BASENAME).def

##########################################################
# Generate an import library (.LIB) to allow DLLs to be
# linked with applications.  The DEF file is used as input.
##########################################################
$(BASENAME).lib: $(OBJS) $(BASENAME).def
              @echo Creating import library $(*F)...>con
              ilib /Freeform /Q /GENI:$(BASENAME).lib $(BASENAME).def

##########################################################
# Statements to compile each C/C++ file for the non-visual
# parts in the sample Rap Sheet application.
##########################################################
querydb.obj:  querydb.cpp  {$(INCLUDE)}querydb.hpp {$(INCLUDE)}irsltrec.hpp \
              {$(INCLUDE)}isusrec.hpp {$(INCLUDE)}rap.h

irsltrec.obj: irsltrec.cpp  {$(INCLUDE)}irsltrec.hpp

isusrec.obj:  isusrec.cpp  {$(INCLUDE)}isusrec.hpp

iaddrrec.obj: iaddrrec.cpp  {$(INCLUDE)}iaddrrec.hpp

ialsrec.obj:  ialsrec.cpp  {$(INCLUDE)}ialsrec.hpp

iarstrec.obj: iarstrec.cpp  {$(INCLUDE)}iarstrec.hpp

ialias.obj:   ialias.cpp {$(INCLUDE)}ialias.hpp

iarrest.obj:  iarrest.cpp {$(INCLUDE)}iarrest.hpp {$(INCLUDE)}rap.h

iperson.obj:  iperson.cpp {$(INCLUDE)}iperson.hpp {$(INCLUDE)}iadd.hpp \
              {$(INCLUDE)}ialias.hpp {$(INCLUDE)}rap.h

isuspect.obj: isuspect.cpp {$(INCLUDE)}isuspect.hpp {$(INCLUDE)}iarrest.hpp

ialsrmgr.obj: ialsrmgr.cpp {$(INCLUDE)}ialsrmgr.hpp {$(INCLUDE)}irsltrec.hpp \
              {$(INCLUDE)}ialsrec.hpp {$(INCLUDE)}ialias.hpp {$(INCLUDE)}querydb.hpp

iarsrmgr.obj: iarsrmgr.cpp {$(INCLUDE)}iarsrmgr.hpp {$(INCLUDE)}irsltrec.hpp \
              {$(INCLUDE)}iarstrec.hpp {$(INCLUDE)}iarrest.hpp {$(INCLUDE)}querydb.hpp

iadrrmgr.obj: iadrrmgr.cpp {$(INCLUDE)}iadrrmgr.hpp {$(INCLUDE)}irsltrec.hpp \
              {$(INCLUDE)}iaddrrec.hpp {$(INCLUDE)}iadd.hpp {$(INCLUDE)}querydb.hpp

isusrmgr.obj: isusrmgr.cpp  {$(INCLUDE)}isusrmgr.hpp {$(INCLUDE)}irsltrec.hpp \
              {$(INCLUDE)}isusrec.hpp {$(INCLUDE)}isuspect.hpp {$(INCLUDE)}querydb.hpp \
              {$(INCLUDE)}iadd.hpp
