BASENAME=cppwv03
# C++ cppov03 DLL - Makefile ($(BASENAME).mak)
#
# COPYRIGHT:
#   IBM(R) VisualAge(TM) for C++                                               *
#   (C) Copyright International Business Machines Corporation 1991, 1996       *
#   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
#   US Government Users Restricted Rights - Use, duplication, or disclosure
#   restricted by GSA ADP Schedule Contract with IBM Corp.
#
#   This program will not run in DOS mode.
#
# DISCLAIMER OF WARRANTIES:
#   The following [enclosed] code is sample code created by IBM
#   Corporation.  This sample code is not part of any standard IBM product
#   and is provided to you solely for the purpose of assisting you in the
#   development of your applications.  The code is provided "AS IS",
#   without warranty of any kind.  IBM shall not be liable for any damages
#   arising out of your use of the sample code, even if they have been
#   advised of the possibility of such damages.
#
# Define variables for makefile
#

#  These are the compile stmts normally used. They would normally be in your TOOLS.INI
GCPPFLAGS=/Ge- /Gd+ /Gm+ /Tdp /I. /Q /O+ /DIVB_IMPORT=
#GCPPFLAGS=/Ge- /Gd+ /Gm+ /Tdp /I. /Q /Ti /DIC_TRACE_DEVELOP /DIVB_IMPORT=
STATICFLAGS=/c /Ge- /O+ /Gm+ /Tdp /I. /Ft- /Q
DEBUGFLAGS=/Ge- /Gd+ /Gm+ /Tdp /I. /Q /Ti /Tm+ /DIC_TRACE_DEVELOP /DIVB_IMPORT=
DLLDIR=.
LIBDIR=.
OBJDIR=.
SOBJDIR=static
DOBJDIR=debug
GLINK=icc

OBJS=ivbdtype.obj \
     ivbbool.obj \
     ivblong.obj \
     ivbulong.obj \
     ivbshort.obj \
     ivbushrt.obj \
     ivbdbl.obj \
     ivbstrng.obj \
     iordrrec.obj \
     irecord.obj \
     iadd.obj \
     icust.obj \
     icompany.obj \
     ivbland.obj \
     ivblor.obj


.cpp.obj:
    @echo Compiling... $(*F)... >con
    icc.exe $(GCPPFLAGS) /C %s
    icc.exe $(STATICFLAGS) /Fo"static\%|dpfF.obj" /C %s
    icc.exe $(DEBUGFLAGS) /Ftdebug\tempinc /Fo"debug\%|dpfF.obj" /C %s

# This allowed us to update the lib and include paths.
LIB=$(LIB)$(AVLLIB);
INCLUDE=$(INCLUDE)$(AVLINC);

all: lib dll slib debug

dll: $(DLLDIR)\$(BASENAME).dll

lib: $(LIBDIR)\$(BASENAME)i.lib

slib: $(LIBDIR)\$(BASENAME).lib $(LIBDIR)\$(BASENAME)o.lib

debug: debug\$(BASENAME).dll

$(BASENAME).def: $(OBJS)
        @echo Creating def file $(*F) ...>con
        copy << $(BASENAME).def
        LIBRARY $(BASENAME)
        DESCRIPTION ' Visual Builder Win Sample DLL'
EXPORTS
;       _DLL_InitTerm@12  @1 NONAME
<<
        cppfilt -b -p -O:1000 -n $** >> $(BASENAME).def

$(LIBDIR)\$(BASENAME)i.lib: $(OBJS) $(BASENAME).def
        @echo Creating import library $(*F)...>con
        ilib /Freeform /Q /GENI:$(BASENAME).lib $(BASENAME).def
        copy $(BASENAME).lib $(BASENAME)i.lib
        erase $(BASENAME).lib

$(DLLDIR)\$(BASENAME).dll:  \
#               ..\ibmdll\copyr3v0.exe \
                $(BASENAME).def \
                $(LIBDIR)\$(BASENAME)i.lib
        @echo Linking $(*F)...>con
        icc /B"/STUB:COPYV3R5.EXE /DLL /NOE" $(GCPPFLAGS) /Fe$@ $(BASENAME).exp $(OBJS)

debug\$(BASENAME).dll:  \
#               ..\ibmdll\copyr3v0.exe \
                $(BASENAME).def \
                $(LIBDIR)\$(BASENAME)i.lib
        @echo Linking debug dll $(*F)...>con
        cd debug
        copy ..\$(BASENAME)i.lib
        icc /B"/STUB:COPYV3R5.EXE /DLL /NOE" $(GCPPFLAGS) /Fe$(*F) ..\$(BASENAME).exp $(OBJS)
        cd ..

$(LIBDIR)\$(BASENAME).lib: $(OBJS)
        @echo Creating Static Library $(*F) ...>con
        erase $@
        cd static
        ILIB /NOFREEFORM /Q ..\$(BASENAME).lib $(OBJS) , $(@B).lst
        cd ..

$(LIBDIR)\$(BASENAME)o.lib: $(OBJS)
        @echo Creating dll Library $(*F)...>con
        erase $@
        ILIB /NOFREEFORM /Q $@ $(OBJS) , $(@B).lst
#
#       Statements to compile iadd
#
$(OBJDIR)\iadd.obj: iadd.cpp ..\shipibm\iadd.hpp

#
#       Statements to compile icust
#
$(OBJDIR)\icust.obj: icust.cpp ..\shipibm\icust.hpp

#
#       Statements to compile icompany
#
$(OBJDIR)\icompany.obj: icompany.cpp ..\shipibm\icompany.hpp

#
#       Statements to compile iordrrec
#
$(OBJDIR)\iordrrec.obj: iordrrec.cpp ..\shipibm\iordrrec.hpp

#
#       Statements to compile irecord
#
$(OBJDIR)\irecord.obj: irecord.cpp ..\shipibm\irecord.hpp

#
#       Statements to compile ivbdtype
#
$(OBJDIR)\ivbdtype.obj: ivbdtype.cpp ..\shipibm\ivbdtype.hpp

#
#       Statements to compile ivbbool
#
$(OBJDIR)\ivbbool.obj: ivbbool.cpp ..\shipibm\ivbbool.hpp

#
#       Statements to compile ivblong
#
$(OBJDIR)\ivblong.obj: ivblong.cpp ..\shipibm\ivblong.hpp

#
#       Statements to compile ivbdbl
#
$(OBJDIR)\ivbdbl.obj: ivbdbl.cpp ..\shipibm\ivbdbl.hpp

#
#       Statements to compile ivbulong
#
$(OBJDIR)\ivbulong.obj: ivbulong.cpp ..\shipibm\ivbulong.hpp

#
#       Statements to compile ivbshort
#
$(OBJDIR)\ivbshort.obj: ivbshort.cpp ..\shipibm\ivbshort.hpp

#
#       Statements to compile ivbushrt
#
$(OBJDIR)\ivbushrt.obj: ivbushrt.cpp ..\shipibm\ivbushrt.hpp

#
#       Statements to compile ivbland
#
$(OBJDIR)\ivbland.obj: ivbland.cpp ..\shipibm\ivbland.hpp

#
#       Statements to compile ivblor
#
$(OBJDIR)\ivblor.obj:  ivblor.cpp ..\shipibm\ivblor.hpp

#
#       Statements to compile ivbstrng
#
$(OBJDIR)\ivbstrng.obj: ivbstrng.cpp ..\shipibm\ivbstrng.hpp

clean:
        $(ERASE) $(DLLDIR)\$(BASENAME).dll
        $(ERASE) $(LIBDIR)\$(BASENAME).lib
        $(ERASE) $(LIBDIR)\$(BASENAME)I.lib
        erase $(OBJS)
        $(ERASE) $(TEMPINCOBJDIR)\* /N
