/*******************************************************************************
* FILE NAME: iadd.cpp                                                          *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class(es):                                     *
*    IAddress - IBM sample address part.                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
* DISCLAIMER OF WARRANTIES:                                                    *
*   The following [enclosed] code is sample code created by IBM                *
*   Corporation.  This sample code is not part of any standard IBM product     *
*   and is provided to you solely for the purpose of assisting you in the      *
*   development of your applications.  The code is provided "AS IS",           *
*   without warranty of any kind.  IBM shall not be liable for any damages     *
*   arising out of your use of the sample code, even if they have been         *
*   advised of the possibility of such damages.                                *
*******************************************************************************/

#ifndef _IADD_
  #include <iadd.hpp>
#endif

#ifndef _INOTIFEV_
  #include <inotifev.hpp>
#endif


#pragma export (IAddress::streetId,, 1100)
const INotificationId IAddress::streetId =
                     "IAddress::street";
#pragma export (IAddress::cityId,, 1101)
const INotificationId IAddress::cityId =
                     "IAddress::city";
#pragma export (IAddress::stateId,, 1102)
const INotificationId IAddress::stateId =
                     "IAddress::state";
#pragma export (IAddress::zipId,, 1103)
const INotificationId IAddress::zipId =
                     "IAddress::zip";

/*------------------------------------------------------------------------------
| IAddress::IAddress                                                           |
|                                                                              |
| Standard constructor.                                                        |
------------------------------------------------------------------------------*/
#pragma export (IAddress::IAddress(),, 1104)
IAddress::IAddress() : IStandardNotifier ()
    ,iStreet ("101 Main Street")
    ,iCity ("Hometown")
    ,iState ("NC")
    ,iZip ("27511")
{
  enableNotification ();
}

/*------------------------------------------------------------------------------
| IAddress::IAddress                                                           |
|                                                                              |
| Standard copy constructor.                                                   |
------------------------------------------------------------------------------*/
#pragma export (IAddress::IAddress(const IAddress&),, 1105)
IAddress::IAddress (const IAddress& partCopy)
  : IStandardNotifier (partCopy)
    ,iStreet (partCopy.street ())
    ,iCity (partCopy.city ())
    ,iState (partCopy.state ())
    ,iZip (partCopy.zip ())
{
  enableNotification ();
}

/*------------------------------------------------------------------------------
| IAddress::IAddress                                                           |
|                                                                              |
| Standard operator=                                                           |
------------------------------------------------------------------------------*/
#pragma export (IAddress::operator= (const IAddress&),, 1106)
IAddress& IAddress::operator= (const IAddress& aIAddress)
{
  if (this == &aIAddress) {
    return *this;
  } /* endif */
  Inherited::operator=(aIAddress);
  setStreet(aIAddress.street());
  setCity(aIAddress.city());
  setState(aIAddress.state());
  setZip(aIAddress.zip());
  return *this;
}

/*------------------------------------------------------------------------------
| IAddress::~IAddress                                                          |
|                                                                              |
| IAddress destructor.                                                         |
------------------------------------------------------------------------------*/
#pragma export (IAddress::~IAddress(),, 1107)
IAddress::~IAddress()
{
}

/*------------------------------------------------------------------------------
| IAddress::street                                                             |
|                                                                              |
| Return the street attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IAddress::street() const,, 1108)
IString IAddress::street () const
{
  return iStreet;
}

/*------------------------------------------------------------------------------
| IAddress::setStreet                                                          |
|                                                                              |
| Set the street attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IAddress::setStreet(const IString&),, 1109)
IAddress& IAddress::setStreet (const IString& aStreet)
{
  if (iStreet != aStreet) {
    iStreet = aStreet;
    IString eventData(iStreet);
    notifyObservers(INotificationEvent(streetId, *this,
                      true, (void*)&eventData));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IAddress::city                                                               |
|                                                                              |
| Return the city attribute.                                                   |
------------------------------------------------------------------------------*/
#pragma export (IAddress::city() const,, 1110)
IString IAddress::city () const
{
  return iCity;
}

/*------------------------------------------------------------------------------
| IAddress::setCity                                                            |
|                                                                              |
| Set the city attribute.                                                      |
------------------------------------------------------------------------------*/
#pragma export (IAddress::setCity(const IString&),, 1111)
IAddress& IAddress::setCity (const IString& aCity)
{
  if (iCity != aCity) {
    iCity = aCity;
    IString eventData(iCity);
    notifyObservers(INotificationEvent(cityId, *this,
                      true, (void*)&eventData));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IAddress::state                                                              |
|                                                                              |
| Return the state attribute.                                                  |
------------------------------------------------------------------------------*/
#pragma export (IAddress::state() const,, 1112)
IString IAddress::state () const
{
  return iState;
}

/*------------------------------------------------------------------------------
| IAddress::setState                                                           |
|                                                                              |
| Set the state attribute.                                                     |
------------------------------------------------------------------------------*/
#pragma export (IAddress::setState(const IString&),, 1113)
IAddress& IAddress::setState (const IString& aState)
{
  if (iState != aState) {
    iState = aState;
    IString eventData(iState);
    notifyObservers(INotificationEvent(stateId, *this,
                      true, (void*)&eventData));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IAddress::zip                                                                |
|                                                                              |
| Return the zip attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IAddress::zip() const,, 1114)
IString IAddress::zip () const
{
  return iZip;
}

/*------------------------------------------------------------------------------
| IAddress::setZip                                                             |
|                                                                              |
| Set the zip attribute.                                                       |
------------------------------------------------------------------------------*/
#pragma export (IAddress::setZip(const IString&),, 1115)
IAddress& IAddress::setZip (const IString& aZip)
{
  if (iZip != aZip) {
    iZip = aZip;
    IString eventData(iZip);
    notifyObservers(INotificationEvent(zipId, *this,
                      true, (void*)&eventData));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IAddress::setStreetToDefault                                                 |
|                                                                              |
| Perform the setStreetToDefault action.                                       |
------------------------------------------------------------------------------*/
#pragma export (IAddress::setStreetToDefault(),, 1116)
IAddress& IAddress::setStreetToDefault ()
{
  return setStreet("101 Main Street");
}

/*------------------------------------------------------------------------------
| IAddress::setCityToDefault                                                   |
|                                                                              |
| Perform the setCityToDefault action.                                         |
------------------------------------------------------------------------------*/
#pragma export (IAddress::setCityToDefault(),, 1117)
IAddress& IAddress::setCityToDefault ()
{
  return setCity("Hometown");
}

/*------------------------------------------------------------------------------
| IAddress::setStateToDefault                                                  |
|                                                                              |
| Perform the setStateToDefault action.                                        |
------------------------------------------------------------------------------*/
#pragma export (IAddress::setStateToDefault(),, 1118)
IAddress& IAddress::setStateToDefault ()
{
  return setState("NC");
}

/*------------------------------------------------------------------------------
| IAddress::setZipToDefault                                                    |
|                                                                              |
| Perform the setZipToDefault action.                                          |
------------------------------------------------------------------------------*/
#pragma export (IAddress::setZipToDefault(),, 1119)
IAddress& IAddress::setZipToDefault ()
{
  return setZip("27511");
}

/*------------------------------------------------------------------------------
| IAddress::setToDefault                                                       |
|                                                                              |
| Perform the setToDefault action.                                             |
------------------------------------------------------------------------------*/
#pragma export (IAddress::setToDefault(),, 1120)
IAddress& IAddress::setToDefault ()
{
  setStreetToDefault();
  setCityToDefault();
  setStateToDefault();
  setZipToDefault();
  return *this;
}

/*------------------------------------------------------------------------------
| IAddress::operator == (const IAddress & aValue)                              |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IAddress::operator == (const IAddress&) const,, 1121)
Boolean IAddress::
  operator == (const IAddress& aValue) const
{
  if (street() != aValue.street()) {
    return false;
  } /* endif */
  if (city() != aValue.city()) {
    return false;
  } /* endif */
  if (state() != aValue.state()) {
    return false;
  } /* endif */
  if (zip() != aValue.zip()) {
    return false;
  } /* endif */
  return true;
}

/*------------------------------------------------------------------------------
| IAddress::operator != (const IAddress & aValue)                              |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IAddress::operator != (const IAddress&) const,, 1122)
Boolean IAddress::
  operator != (const IAddress& aValue) const
{
  if (street() != aValue.street()) {
    return true;
  } /* endif */
  if (city() != aValue.city()) {
    return true;
  } /* endif */
  if (state() != aValue.state()) {
    return true;
  } /* endif */
  if (zip() != aValue.zip()) {
    return true;
  } /* endif */
  return false;
}

/*------------------------------------------------------------------------------
| IAddress::operator == (const IAddress * aValue)                              |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IAddress::operator == (const IAddress*) const,, 1123)
Boolean IAddress::
  operator == (const IAddress* aValue) const
{
  if (street() != aValue->street()) {
    return false;
  } /* endif */
  if (city() != aValue->city()) {
    return false;
  } /* endif */
  if (state() != aValue->state()) {
    return false;
  } /* endif */
  if (zip() != aValue->zip()) {
    return false;
  } /* endif */
  return true;
}

/*------------------------------------------------------------------------------
| IAddress::operator != (const IAddress * aValue)                              |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IAddress::operator != (const IAddress*) const,, 1124)
Boolean IAddress::
  operator != (const IAddress* aValue) const
{
  if (street() != aValue->street()) {
    return true;
  } /* endif */
  if (city() != aValue->city()) {
    return true;
  } /* endif */
  if (state() != aValue->state()) {
    return true;
  } /* endif */
  if (zip() != aValue->zip()) {
    return true;
  } /* endif */
  return false;
}
