/*******************************************************************************
* FILE NAME: icompany.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class(es):                                     *
*    ICompany - IBM sample company part.                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
* DISCLAIMER OF WARRANTIES:                                                    *
*   The following [enclosed] code is sample code created by IBM                *
*   Corporation.  This sample code is not part of any standard IBM product     *
*   and is provided to you solely for the purpose of assisting you in the      *
*   development of your applications.  The code is provided "AS IS",           *
*   without warranty of any kind.  IBM shall not be liable for any damages     *
*   arising out of your use of the sample code, even if they have been         *
*   advised of the possibility of such damages.                                *
*******************************************************************************/

#ifndef _ICOMPANY_
  #include <icompany.hpp>
#endif

#ifndef _INOTIFEV_
  #include <inotifev.hpp>
#endif

#include <iadd.hpp>
#include <icust.hpp>

#pragma export (ICompany::nameId,, 1300)
const INotificationId ICompany::nameId =
                     "ICompany::name";
#pragma export (ICompany::addressId,, 1301)
const INotificationId ICompany::addressId =
                     "ICompany::address";
#pragma export (ICompany::customerListId,, 1302)
const INotificationId ICompany::customerListId =
                     "ICompany::customerList";
#pragma export (ICompany::phoneId,, 1303)
const INotificationId ICompany::phoneId =
                     "ICompany::phone";
#pragma export (ICompany::customerAddedId,, 1304)
const INotificationId ICompany::customerAddedId =
                     "ICompany::customerAdded";

/*------------------------------------------------------------------------------
| ICompany::ICompany                                                           |
|                                                                              |
| Standard constructor.                                                        |
------------------------------------------------------------------------------*/
#pragma export (ICompany::ICompany(),, 1305)
ICompany::ICompany() : IStandardNotifier ()
    ,iName ("XYZ")
    ,iAddress (new IAddress())
    ,iCustomerList (new IVSequence<ICustomer*> ())
    ,iPhone ("555-1212")
{
  iCustomerList->addAsLast (new ICustomer("Al"));
  iCustomerList->addAsLast (new ICustomer("Bob"));
  iCustomerList->addAsLast (new ICustomer("Bruce"));
  iCustomerList->addAsLast (new ICustomer("Dave"));
  iCustomerList->addAsLast (new ICustomer("Delores"));
  iCustomerList->addAsLast (new ICustomer("Diann"));
  iCustomerList->addAsLast (new ICustomer("Don"));
  iCustomerList->addAsLast (new ICustomer("Ed"));
  iCustomerList->addAsLast (new ICustomer("Flora"));
  iCustomerList->addAsLast (new ICustomer("Fred"));
  iCustomerList->addAsLast (new ICustomer("George"));
  iCustomerList->addAsLast (new ICustomer("Jim"));
  iCustomerList->addAsLast (new ICustomer("Kat"));
  iCustomerList->addAsLast (new ICustomer("Kathy"));
  iCustomerList->addAsLast (new ICustomer("Ken"));
  iCustomerList->addAsLast (new ICustomer("Lou"));
  iCustomerList->addAsLast (new ICustomer("Mark"));
  iCustomerList->addAsLast (new ICustomer("Michael"));
  iCustomerList->addAsLast (new ICustomer("Morris"));
  iCustomerList->addAsLast (new ICustomer("Peter"));
  iCustomerList->addAsLast (new ICustomer("Rich"));
  iCustomerList->addAsLast (new ICustomer("Ricky"));
  iCustomerList->addAsLast (new ICustomer("Robert"));
  iCustomerList->addAsLast (new ICustomer("Ron"));
  iCustomerList->addAsLast (new ICustomer("Sherry"));
  iCustomerList->addAsLast (new ICustomer("Steve"));
  iCustomerList->addAsLast (new ICustomer("Susan"));
  iCustomerList->addAsLast (new ICustomer("Terry"));
  enableNotification ();
  iCustomerList->enableNotification ();
}

/*------------------------------------------------------------------------------
| ICompany::ICompany                                                           |
|                                                                              |
| Constructor with name parameter.                                             |
------------------------------------------------------------------------------*/
#pragma export (ICompany::ICompany(const IString& aName),, 1306)
ICompany::ICompany(const IString& aName) :
  IStandardNotifier (),
  iName ("XYZ"),
  iAddress (new IAddress()),
  iCustomerList (new IVSequence<ICustomer*> ()),
  iPhone ("555-1212")
{
  setName(aName);
  enableNotification ();
  iCustomerList->enableNotification ();
}

/*------------------------------------------------------------------------------
| ICompany::ICompany                                                           |
|                                                                              |
| Standard copy constructor.                                                   |
------------------------------------------------------------------------------*/
#pragma export (ICompany::ICompany(const ICompany&),, 1307)
ICompany::ICompany (const ICompany& partCopy)
  : IStandardNotifier (partCopy)
    ,iName (partCopy.name ())
    ,iAddress (partCopy.address ())
    ,iCustomerList (partCopy.customerList ())
    ,iPhone (partCopy.phone ())
{
  enableNotification ();
  iCustomerList->enableNotification ();
}

/*------------------------------------------------------------------------------
| ICompany::ICompany                                                           |
|                                                                              |
| Standard operator=                                                           |
------------------------------------------------------------------------------*/
#pragma export (ICompany::operator= (const ICompany&),, 1308)
ICompany& ICompany::operator= (const ICompany& aICompany)
{
  if (this == &aICompany) {
    return *this;
  } /* endif */
  Inherited::operator=(aICompany);
  setName(aICompany.name());
  setAddress(new IAddress(*aICompany.address()));
  setCustomerList(aICompany.customerList());
  setPhone(aICompany.phone());
  return *this;
}

/*------------------------------------------------------------------------------
| ICompany::~ICompany                                                          |
|                                                                              |
| ICompany destructor.                                                         |
------------------------------------------------------------------------------*/
#pragma export (ICompany::~ICompany(),, 1309)
ICompany::~ICompany()
{
  ISequence<ICustomer *> tempList;
  ICustomer *            customer;

  if ( iAddress )
    delete iAddress;

  if ( iCustomerList )
  {
    IVSequence <ICustomer*>::Cursor cursor(*iCustomerList);
    forCursor( cursor )
      tempList.addAsFirst( iCustomerList->elementAt( cursor ) );

    iCustomerList->removeAll( );

    ISequence<ICustomer *>::Cursor tempCursor( tempList );
    forCursor( tempCursor )
    {
      customer = tempList.elementAt ( tempCursor );
      delete customer;
    }
    tempList.removeAll( );

    delete iCustomerList;

  }
}

/*------------------------------------------------------------------------------
| ICompany::asString                                                           |
|                                                                              |
| Perform asString.                                                            |
------------------------------------------------------------------------------*/
#pragma export (ICompany::asString() const,, 1310)
IString ICompany::asString () const
{
  return name();
}

/*------------------------------------------------------------------------------
| ICompany::name                                                               |
|                                                                              |
| Return the name attribute.                                                   |
------------------------------------------------------------------------------*/
#pragma export (ICompany::name() const,, 1311)
IString ICompany::name () const
{
  return iName;
}

/*------------------------------------------------------------------------------
| ICompany::setName                                                            |
|                                                                              |
| Set the name attribute.                                                      |
------------------------------------------------------------------------------*/
#pragma export (ICompany::setName(const IString&),, 1312)
ICompany& ICompany::setName (const IString& aName)
{
  if (iName != aName) {
    iName = aName;
    IString eventData(iName);
    notifyObservers(INotificationEvent(nameId, *this,
                      true, (void*)&eventData));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| ICompany::address                                                            |
|                                                                              |
| Return the address attribute.                                                |
------------------------------------------------------------------------------*/
#pragma export (ICompany::address() const,, 1313)
IAddress* ICompany::address () const
{
  return iAddress;
}

/*------------------------------------------------------------------------------
| ICompany::setAddress                                                         |
|                                                                              |
| Set the address attribute.                                                   |
------------------------------------------------------------------------------*/
#pragma export (ICompany::setAddress(const IAddress*),, 1314)
ICompany& ICompany::setAddress (IAddress* aAddress)
{
  if (iAddress != aAddress) {
    if (iAddress)
      delete iAddress;
    iAddress = aAddress;
    notifyObservers(INotificationEvent(addressId, *this,
                      true, (void*)iAddress));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| ICompany::setAddress                                                         |
|                                                                              |
| Set the address attribute.                                                   |
------------------------------------------------------------------------------*/
#pragma export (ICompany::setAddress(const IAddress&),, 1315)
ICompany& ICompany::setAddress (const IAddress& aAddress)
{
  return setAddress(new IAddress(aAddress));
}

/*------------------------------------------------------------------------------
| ICompany::customerList                                                       |
|                                                                              |
| Return the customerList attribute.                                           |
------------------------------------------------------------------------------*/
#pragma export (ICompany::customerList() const,, 1316)
IVSequence <ICustomer*> * ICompany::customerList () const
{
  return iCustomerList;
}

/*------------------------------------------------------------------------------
| ICompany::setCustomerList                                                    |
|                                                                              |
| Set the customerList attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (ICompany::setCustomerList(const IVSequence <ICustomer*>*),, 1317)
ICompany& ICompany::setCustomerList (IVSequence <ICustomer*>* aCustomerList)
{
  if (iCustomerList != aCustomerList) {
    if (iCustomerList) {
//
//  Need to add additional code to handle deleting the objects.
//
//  Call removeall to make sure listbox or other collection viewer controls
//  are not looking at old objects.
//
      iCustomerList->removeAll();
      delete iCustomerList;
    } /* end */
    iCustomerList = aCustomerList;
    iCustomerList->enableNotification ();
    notifyObservers(INotificationEvent(customerListId, *this,
                      true, (void*)iCustomerList));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| ICompany::setCustomerList                                                    |
|                                                                              |
| Set the customerList attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (ICompany::setCustomerList(const IVSequence <ICustomer*>&),, 1318)
ICompany& ICompany::setCustomerList (const IVSequence <ICustomer*>& aCustomerList)
{
  return setCustomerList(new IVSequence <ICustomer*>(aCustomerList));
}

/*------------------------------------------------------------------------------
| ICompany::addCustomer                                                        |
|                                                                              |
| Perform the addCustomer action.                                              |
------------------------------------------------------------------------------*/
#pragma export (ICompany::addCustomer (ICustomer* customer),, 1319)
ICompany& ICompany::
  addCustomer (ICustomer* customer)
{
  if (customerList ()) {
    if (customer) {
      customerList()->add (customer);
      customer->enableNotification ();
      notifyObservers(INotificationEvent(customerAddedId, *this,
                      true, (void*)customer));
    } ; /* endif */
  } ; /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| ICompany::addCustomer                                                        |
|                                                                              |
| Perform the addCustomer action.                                              |
------------------------------------------------------------------------------*/
#pragma export (ICompany::addCustomer (const IString& aName),, 1320)
ICompany& ICompany::
  addCustomer (const IString& aName)
{
  addCustomer (new ICustomer (aName));
  return *this;
}

/*------------------------------------------------------------------------------
| ICompany::phone                                                              |
|                                                                              |
| Return the phone attribute.                                                  |
------------------------------------------------------------------------------*/
#pragma export (ICompany::phone() const,, 1321)
IString ICompany::phone () const
{
  return iPhone;
}

/*------------------------------------------------------------------------------
| ICompany::setPhone                                                           |
|                                                                              |
| Set the phone attribute.                                                     |
------------------------------------------------------------------------------*/
#pragma export (ICompany::setPhone(const IString&),, 1322)
ICompany& ICompany::setPhone (const IString& aPhone)
{
  if (iPhone != aPhone) {
    iPhone = aPhone;
    IString eventData(iPhone);
    notifyObservers(INotificationEvent(phoneId, *this,
                      true, (void*)&eventData));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| ICompany::setNameToDefault                                                   |
|                                                                              |
| Perform the setNameToDefault action.                                         |
------------------------------------------------------------------------------*/
#pragma export (ICompany::setNameToDefault(),, 1323)
ICompany& ICompany::setNameToDefault ()
{
  return setName("IBM");
}

/*------------------------------------------------------------------------------
| ICompany::setAddressToDefault                                                |
|                                                                              |
| Perform the setAddressToDefault action.                                      |
------------------------------------------------------------------------------*/
#pragma export (ICompany::setAddressToDefault(),, 1324)
ICompany& ICompany::setAddressToDefault ()
{
  if (address())
    address()->setToDefault();
  return *this;
}

/*------------------------------------------------------------------------------
| ICompany::setPhoneToDefault                                                  |
|                                                                              |
| Perform the setPhoneToDefault action.                                        |
------------------------------------------------------------------------------*/
#pragma export (ICompany::setPhoneToDefault(),, 1325)
ICompany& ICompany::setPhoneToDefault ()
{
  return setPhone("555-1212");
}

/*------------------------------------------------------------------------------
| ICompany::setCustomerListToDefault                                           |
|                                                                              |
| Perform the setCustomerListToDefault action.                                 |
------------------------------------------------------------------------------*/
#pragma export (ICompany::setCustomerListToDefault(),, 1326)
ICompany& ICompany::setCustomerListToDefault ()
{
  iCustomerList->removeAll ();
  iCustomerList->addAsLast (new ICustomer("Al"));
  iCustomerList->addAsLast (new ICustomer("Bob"));
  iCustomerList->addAsLast (new ICustomer("Bruce"));
  iCustomerList->addAsLast (new ICustomer("Dave"));
  iCustomerList->addAsLast (new ICustomer("Delores"));
  iCustomerList->addAsLast (new ICustomer("Diann"));
  iCustomerList->addAsLast (new ICustomer("Don"));
  iCustomerList->addAsLast (new ICustomer("Ed"));
  iCustomerList->addAsLast (new ICustomer("Flora"));
  iCustomerList->addAsLast (new ICustomer("Fred"));
  iCustomerList->addAsLast (new ICustomer("George"));
  iCustomerList->addAsLast (new ICustomer("Jim"));
  iCustomerList->addAsLast (new ICustomer("Kat"));
  iCustomerList->addAsLast (new ICustomer("Kathy"));
  iCustomerList->addAsLast (new ICustomer("Ken"));
  iCustomerList->addAsLast (new ICustomer("Lou"));
  iCustomerList->addAsLast (new ICustomer("Mark"));
  iCustomerList->addAsLast (new ICustomer("Michael"));
  iCustomerList->addAsLast (new ICustomer("Morris"));
  iCustomerList->addAsLast (new ICustomer("Peter"));
  iCustomerList->addAsLast (new ICustomer("Rich"));
  iCustomerList->addAsLast (new ICustomer("Ricky"));
  iCustomerList->addAsLast (new ICustomer("Robert"));
  iCustomerList->addAsLast (new ICustomer("Ron"));
  iCustomerList->addAsLast (new ICustomer("Sherry"));
  iCustomerList->addAsLast (new ICustomer("Steve"));
  iCustomerList->addAsLast (new ICustomer("Susan"));
  iCustomerList->addAsLast (new ICustomer("Terry"));
  return *this;
}

/*------------------------------------------------------------------------------
| ICompany::operator == (const ICompany & aValue)                              |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (ICompany::operator == (const ICompany&) const,, 1327)
Boolean ICompany::
  operator == (const ICompany& aValue) const
{
  if (name() != aValue.name()) {
    return false;
  } /* endif */
  if (address() != aValue.address()) {
    return false;
  } /* endif */
  if (customerList() != aValue.customerList()) {
    return false;
  } /* endif */
  if (phone() != aValue.phone()) {
    return false;
  } /* endif */
  return true;
}

/*------------------------------------------------------------------------------
| ICompany::operator != (const ICompany & aValue)                              |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (ICompany::operator != (const ICompany&) const,, 1328)
Boolean ICompany::
  operator != (const ICompany& aValue) const
{
  if (name() != aValue.name()) {
    return true;
  } /* endif */
  if (address() != aValue.address()) {
    return true;
  } /* endif */
  if (customerList() != aValue.customerList()) {
    return true;
  } /* endif */
  if (phone() != aValue.phone()) {
    return true;
  } /* endif */
  return false;
}

/*------------------------------------------------------------------------------
| ICompany::operator == (const ICompany * aValue)                              |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (ICompany::operator == (const ICompany*) const,, 1329)
Boolean ICompany::
  operator == (const ICompany* aValue) const
{
  if (name() != aValue->name()) {
    return false;
  } /* endif */
  if (address() != aValue->address()) {
    return false;
  } /* endif */
  if (customerList() != aValue->customerList()) {
    return false;
  } /* endif */
  if (phone() != aValue->phone()) {
    return false;
  } /* endif */
  return true;
}

/*------------------------------------------------------------------------------
| ICompany::operator != (const ICompany * aValue)                              |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (ICompany::operator != (const ICompany*) const,, 1330)
Boolean ICompany::
  operator != (const ICompany* aValue) const
{
  if (name() != aValue->name()) {
    return true;
  } /* endif */
  if (address() != aValue->address()) {
    return true;
  } /* endif */
  if (customerList() != aValue->customerList()) {
    return true;
  } /* endif */
  if (phone() != aValue->phone()) {
    return true;
  } /* endif */
  return false;
}

/*------------------------------------------------------------------------------
| ICompany::operator < (const ICompany * aValue)                               |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (ICompany::operator < (const ICompany*) const,, 1331)
Boolean ICompany::
  operator < (const ICompany* aValue) const
{
  return (name() < (aValue->name()));
}

/*------------------------------------------------------------------------------
| ICompany::operator < (const ICompany & aValue)                               |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (ICompany::operator < (const ICompany&) const,, 1332)
Boolean ICompany::
  operator < (const ICompany& aValue) const
{
  return (name() < (aValue.name()));
}

/*------------------------------------------------------------------------------
| ICompany::operator < (ICompany* const & aValue)                              |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (ICompany::operator < (ICompany* const&) const,, 1333)
Boolean ICompany::
  operator < (ICompany* const& aValue) const
{
  return (name() < (aValue->name()));
}

/*------------------------------------------------------------------------------
| ICompany::operator < (ICompanyElemPtr const & aValue)                        |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (ICompany::operator < (ICompanyElemPtr const&) const,, 1334)
Boolean ICompany::
  operator < (ICompanyElemPtr const& aValue) const
{
  return (name() < (aValue->name()));
}

/*------------------------------------------------------------------------------
| ICompany::operator < (ICompanyMngPtr const & aValue)                         |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (ICompany::operator < (ICompanyMngPtr const&) const,, 1335)
Boolean ICompany::
  operator < (ICompanyMngPtr const& aValue) const
{
  return (name() < (aValue->name()));
}
