/*******************************************************************************
* FILE NAME: icust.cpp                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class(es):                                     *
*    ICustomer - IBM sample customer part.                                     *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
* DISCLAIMER OF WARRANTIES:                                                    *
*   The following [enclosed] code is sample code created by IBM                *
*   Corporation.  This sample code is not part of any standard IBM product     *
*   and is provided to you solely for the purpose of assisting you in the      *
*   development of your applications.  The code is provided "AS IS",           *
*   without warranty of any kind.  IBM shall not be liable for any damages     *
*   arising out of your use of the sample code, even if they have been         *
*   advised of the possibility of such damages.                                *
*******************************************************************************/

#ifndef _ICUST_
  #include <icust.hpp>
#endif

#ifndef _INOTIFEV_
  #include <inotifev.hpp>
#endif

#include <iadd.hpp>

#pragma export (ICustomer::nameId,, 1200)
const INotificationId ICustomer::nameId =
                     "ICustomer::name";
#pragma export (ICustomer::addressId,, 1201)
const INotificationId ICustomer::addressId =
                     "ICustomer::address";
#pragma export (ICustomer::homePhoneId,, 1202)
const INotificationId ICustomer::homePhoneId =
                     "ICustomer::homePhone";
#pragma export (ICustomer::workPhoneId,, 1203)
const INotificationId ICustomer::workPhoneId =
                     "ICustomer::workPhone";
#pragma export (ICustomer::dateId,, 1204)
const INotificationId ICustomer::dateId =
                     "ICustomer::date";
#pragma export (ICustomer::timeId,, 1205)
const INotificationId ICustomer::timeId =
                     "ICustomer::time";

/*------------------------------------------------------------------------------
| ICustomer::ICustomer                                                         |
|                                                                              |
| Standard constructor.                                                        |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::ICustomer(),, 1206)
ICustomer::ICustomer() : IStandardNotifier ()
    ,iName ("Ken")
    ,iAddress (new IAddress())
    ,iHomePhone ("555-1212")
    ,iWorkPhone ("555-1212")
    ,iDate ()
    ,iTime ()
{
  enableNotification ();
}

/*------------------------------------------------------------------------------
| ICustomer::ICustomer                                                         |
|                                                                              |
| Constructor with name parameter.                                             |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::ICustomer(const IString& aName),, 1207)
ICustomer::ICustomer(const IString& aName) :
  IStandardNotifier (),
  iName ("Ken"),
  iAddress (new IAddress()),
  iHomePhone ("555-1212"),
  iWorkPhone ("555-1212"),
  iDate (),
  iTime ()
{
  setName(aName);
  enableNotification ();
}

/*------------------------------------------------------------------------------
| ICustomer::ICustomer                                                         |
|                                                                              |
| Standard copy constructor.                                                   |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::ICustomer(const ICustomer&),, 1208)
ICustomer::ICustomer (const ICustomer& partCopy)
  : IStandardNotifier (partCopy)
    ,iName (partCopy.name ())
    ,iAddress (partCopy.address ())
    ,iHomePhone (partCopy.homePhone ())
    ,iWorkPhone (partCopy.workPhone ())
    ,iDate (partCopy.date ())
    ,iTime (partCopy.time ())
{
  enableNotification ();
}

/*------------------------------------------------------------------------------
| ICustomer::ICustomer                                                         |
|                                                                              |
| Standard operator=                                                           |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::operator= (const ICustomer&),, 1209)
ICustomer& ICustomer::operator= (const ICustomer& aICustomer)
{
  if (this == &aICustomer) {
    return *this;
  } /* endif */
  Inherited::operator=(aICustomer);
  setName(aICustomer.name());
  setAddress(new IAddress(*aICustomer.address()));
  setHomePhone(aICustomer.homePhone());
  setWorkPhone(aICustomer.workPhone());
  setDate(aICustomer.date());
  setTime(aICustomer.time());
  return *this;
}

/*------------------------------------------------------------------------------
| ICustomer::~ICustomer                                                        |
|                                                                              |
| ICustomer destructor.                                                        |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::~ICustomer(),, 1210)
ICustomer::~ICustomer()
{
  if (iAddress)
    delete iAddress;
}

/*------------------------------------------------------------------------------
| ICustomer::asString                                                          |
|                                                                              |
| Perform asString.                                                            |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::asString() const,, 1211)
IString ICustomer::asString () const
{
  return name();
}

/*------------------------------------------------------------------------------
| ICustomer::name                                                              |
|                                                                              |
| Return the name attribute.                                                   |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::name() const,, 1212)
IString ICustomer::name () const
{
  return iName;
}

/*------------------------------------------------------------------------------
| ICustomer::setName                                                           |
|                                                                              |
| Set the name attribute.                                                      |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::setName(const IString&),, 1213)
ICustomer& ICustomer::setName (const IString& aName)
{
  if (iName != aName) {
    iName = aName;
    IString eventData(iName);
    notifyObservers(INotificationEvent(nameId, *this,
                      true, (void*)&eventData));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| ICustomer::address                                                           |
|                                                                              |
| Return the address attribute.                                                |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::address() const,, 1214)
IAddress* ICustomer::address () const
{
  return iAddress;
}

/*------------------------------------------------------------------------------
| ICustomer::setAddress                                                        |
|                                                                              |
| Set the address attribute.                                                   |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::setAddress(const IAddress*),, 1215)
ICustomer& ICustomer::setAddress (IAddress* aAddress)
{
  if (iAddress != aAddress) {
    if (iAddress)
      delete iAddress;
    iAddress = aAddress;
    notifyObservers(INotificationEvent(addressId, *this,
                      true, (void*)iAddress));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| ICustomer::setAddress                                                        |
|                                                                              |
| Set the address attribute.                                                   |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::setAddress(const IAddress&),, 1216)
ICustomer& ICustomer::setAddress (const IAddress& aAddress)
{
  return setAddress(new IAddress(aAddress));
}

/*------------------------------------------------------------------------------
| ICustomer::homePhone                                                         |
|                                                                              |
| Return the homePhone attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::homePhone() const,, 1217)
IString ICustomer::homePhone () const
{
  return iHomePhone;
}

/*------------------------------------------------------------------------------
| ICustomer::setHomePhone                                                      |
|                                                                              |
| Set the homePhone attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::setHomePhone(const IString&),, 1218)
ICustomer& ICustomer::setHomePhone (const IString& aHomePhone)
{
  if (iHomePhone != aHomePhone) {
    iHomePhone = aHomePhone;
    IString eventData(iHomePhone);
    notifyObservers(INotificationEvent(homePhoneId, *this,
                      true, (void*)&eventData));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| ICustomer::workPhone                                                         |
|                                                                              |
| Return the workPhone attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::workPhone() const,, 1219)
IString ICustomer::workPhone () const
{
  return iWorkPhone;
}

/*------------------------------------------------------------------------------
| ICustomer::setWorkPhone                                                      |
|                                                                              |
| Set the workPhone attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::setWorkPhone(const IString&),, 1220)
ICustomer& ICustomer::setWorkPhone (const IString& aWorkPhone)
{
  if (iWorkPhone != aWorkPhone) {
    iWorkPhone = aWorkPhone;
    IString eventData(iWorkPhone);
    notifyObservers(INotificationEvent(workPhoneId, *this,
                      true, (void*)&eventData));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| ICustomer::date                                                              |
|                                                                              |
| Return the date attribute.                                                   |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::date() const,, 1221)
IDate ICustomer::date () const
{
  return iDate;
}

/*------------------------------------------------------------------------------
| ICustomer::setDate                                                           |
|                                                                              |
| Set the date attribute.                                                      |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::setDate(const IDate&),, 1222)
ICustomer& ICustomer::setDate (const IDate& aDate)
{
  if (iDate != aDate) {
    iDate = aDate;
    IDate eventData(iDate);
    notifyObservers(INotificationEvent(dateId, *this,
                      true, (void*)&eventData));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| ICustomer::time                                                              |
|                                                                              |
| Return the time attribute.                                                   |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::time() const,, 1223)
ITime ICustomer::time () const
{
  return iTime;
}

/*------------------------------------------------------------------------------
| ICustomer::setTime                                                           |
|                                                                              |
| Set the time attribute.                                                      |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::setTime(const ITime&),, 1224)
ICustomer& ICustomer::setTime (const ITime& aTime)
{
  if (iTime != aTime)
  {
    iTime = aTime;
    ITime eventData(iTime);
    notifyObservers(INotificationEvent(timeId, *this,
                      true, (void*)&eventData));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| ICustomer::setNameToDefault                                                  |
|                                                                              |
| Perform the setNameToDefault action.                                         |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::setNameToDefault(),, 1225)
ICustomer& ICustomer::setNameToDefault ()
{
  return setName("Ken");
}

/*------------------------------------------------------------------------------
| ICustomer::setAddressToDefault                                               |
|                                                                              |
| Perform the setAddressToDefault action.                                      |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::setAddressToDefault(),, 1226)
ICustomer& ICustomer::setAddressToDefault ()
{
  if (address())
    address()->setToDefault();
  return *this;
}

/*------------------------------------------------------------------------------
| ICustomer::setHomePhoneToDefault                                             |
|                                                                              |
| Perform the setHomePhoneToDefault action.                                    |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::setHomePhoneToDefault(),, 1227)
ICustomer& ICustomer::setHomePhoneToDefault ()
{
  return setHomePhone("555-1212");
}

/*------------------------------------------------------------------------------
| ICustomer::setWorkPhoneToDefault                                             |
|                                                                              |
| Perform the setWorkPhoneToDefault action.                                    |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::setWorkPhoneToDefault(),, 1228)
ICustomer& ICustomer::setWorkPhoneToDefault ()
{
  return setWorkPhone("555-1212");
}

/*------------------------------------------------------------------------------
| ICustomer::operator == (const ICustomer & aValue)                            |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::operator == (const ICustomer&) const,, 1229)
Boolean ICustomer::
  operator == (const ICustomer& aValue) const
{
  if (name() != aValue.name()) {
    return false;
  } /* endif */
  if (address() != aValue.address()) {
    return false;
  } /* endif */
  if (homePhone() != aValue.homePhone()) {
    return false;
  } /* endif */
  if (workPhone() != aValue.workPhone()) {
    return false;
  } /* endif */
  if (date() != aValue.date()) {
    return false;
  } /* endif */
  if (time() != aValue.time()) {
    return false;
  } /* endif */
  return true;
}

/*------------------------------------------------------------------------------
| ICustomer::operator != (const ICustomer & aValue)                            |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::operator != (const ICustomer&) const,, 1230)
Boolean ICustomer::
  operator != (const ICustomer& aValue) const
{
  if (name() != aValue.name()) {
    return true;
  } /* endif */
  if (address() != aValue.address()) {
    return true;
  } /* endif */
  if (homePhone() != aValue.homePhone()) {
    return true;
  } /* endif */
  if (workPhone() != aValue.workPhone()) {
    return true;
  } /* endif */
  if (date() != aValue.date()) {
    return true;
  } /* endif */
  if (time() != aValue.time()) {
    return true;
  } /* endif */
  return false;
}

/*------------------------------------------------------------------------------
| ICustomer::operator == (const ICustomer * aValue)                            |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::operator == (const ICustomer*) const,, 1231)
Boolean ICustomer::
  operator == (const ICustomer* aValue) const
{
  if (name() != aValue->name()) {
    return false;
  } /* endif */
  if (address() != aValue->address()) {
    return false;
  } /* endif */
  if (homePhone() != aValue->homePhone()) {
    return false;
  } /* endif */
  if (workPhone() != aValue->workPhone()) {
    return false;
  } /* endif */
  if (date() != aValue->date()) {
    return false;
  } /* endif */
  if (time() != aValue->time()) {
    return false;
  } /* endif */
  return true;
}

/*------------------------------------------------------------------------------
| ICustomer::operator != (const ICustomer * aValue)                            |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::operator != (const ICustomer*) const,, 1232)
Boolean ICustomer::
  operator != (const ICustomer* aValue) const
{
  if (name() != aValue->name()) {
    return true;
  } /* endif */
  if (address() != aValue->address()) {
    return true;
  } /* endif */
  if (homePhone() != aValue->homePhone()) {
    return true;
  } /* endif */
  if (workPhone() != aValue->workPhone()) {
    return true;
  } /* endif */
  if (date() != aValue->date()) {
    return true;
  } /* endif */
  if (time() != aValue->time()) {
    return true;
  } /* endif */
  return false;
}

/*------------------------------------------------------------------------------
| ICustomer::operator < (const ICustomer * aValue)                             |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::operator < (const ICustomer*) const,, 1233)
Boolean ICustomer::
  operator < (const ICustomer* aValue) const
{
  return (name() < (aValue->name()));
}

/*------------------------------------------------------------------------------
| ICustomer::operator < (const ICustomer & aValue)                             |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::operator < (const ICustomer&) const,, 1234)
Boolean ICustomer::
  operator < (const ICustomer& aValue) const
{
  return (name() < (aValue.name()));
}

/*------------------------------------------------------------------------------
| ICustomer::operator < (ICustomer* const & aValue)                            |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::operator < (ICustomer* const&) const,, 1235)
Boolean ICustomer::
  operator < (ICustomer* const& aValue) const
{
  return (name() < (aValue->name()));
}

/*------------------------------------------------------------------------------
| ICustomer::operator < (ICustomerElemPtr const & aValue)                      |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::operator < (ICustomerElemPtr const&) const,, 1236)
Boolean ICustomer::
  operator < (ICustomerElemPtr const& aValue) const
{
  return (name() < (aValue->name()));
}

/*------------------------------------------------------------------------------
| ICustomer::operator < (ICustomerMngPtr const & aValue)                       |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (ICustomer::operator < (ICustomerMngPtr const&) const,, 1237)
Boolean ICustomer::
  operator < (ICustomerMngPtr const& aValue) const
{
  return (name() < (aValue->name()));
}
