/*******************************************************************************
* FILE NAME: iordrrec.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Functions to implement the class(es):                                      *
*     IOrderedRecord - Base class for classes that represent records           *
*                      that have an ordering relationship.                     *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
* DISCLAIMER OF WARRANTIES:                                                    *
*   The following [enclosed] code is sample code created by IBM                *
*   Corporation.  This sample code is not part of any standard IBM product     *
*   and is provided to you solely for the purpose of assisting you in the      *
*   development of your applications.  The code is provided "AS IS",           *
*   without warranty of any kind.  IBM shall not be liable for any damages     *
*   arising out of your use of the sample code, even if they have been         *
*   advised of the possibility of such damages.                                *
*******************************************************************************/
#include <iordrrec.hpp>

// Define the functions and static data members to be exported.
// Ordinals 200 through 249 are reserved for use by IOrderedRecord.
#pragma export(IOrderedRecord::IOrderedRecord(),, 200)
#pragma export(IOrderedRecord::IOrderedRecord(const IString&),, 201)
#pragma export(IOrderedRecord::IOrderedRecord(const IOrderedRecord&),, 202)
#pragma export(IOrderedRecord::isOrdered() const,, 203)
#pragma export(IOrderedRecord::operator!=(const IOrderedRecord&) const,, 204)
#pragma export(IOrderedRecord::operator<(const IOrderedRecord&) const,, 205)
#pragma export(IOrderedRecord::operator<=(const IOrderedRecord&) const,, 206)
#pragma export(IOrderedRecord::operator=(const IOrderedRecord&),, 207)
#pragma export(IOrderedRecord::operator=(const IString&),, 208)
#pragma export(IOrderedRecord::operator==(const IOrderedRecord&) const,, 209)
#pragma export(IOrderedRecord::operator>(const IOrderedRecord&) const,, 210)
#pragma export(IOrderedRecord::operator>=(const IOrderedRecord&) const,, 211)
#pragma export(IOrderedRecord::~IOrderedRecord(),, 212)
#pragma export(operator!=(const IOrderedRecord&,const IString&),, 213)
#pragma export(operator!=(const IString&,const IOrderedRecord&),, 214)
#pragma export(operator<(const IOrderedRecord&,const IString&),, 215)
#pragma export(operator<(const IString&,const IOrderedRecord&),, 216)
#pragma export(operator<=(const IOrderedRecord&,const IString&),, 217)
#pragma export(operator<=(const IString&,const IOrderedRecord&),, 218)
#pragma export(operator==(const IOrderedRecord&,const IString&),, 219)
#pragma export(operator==(const IString&,const IOrderedRecord&),, 220)
#pragma export(operator>(const IOrderedRecord&,const IString&),, 221)
#pragma export(operator>(const IString&,const IOrderedRecord&),, 222)
#pragma export(operator>=(const IOrderedRecord&,const IString&),, 223)
#pragma export(operator>=(const IString&,const IOrderedRecord&),, 224)

// It's possible for the caller of the external entry points to have a
// different C library environment.  Make sure the exception handler for
// our library environment is registered on entry and deregistered on exit.
#ifdef __OS2__
#pragma handler(IOrderedRecord::IOrderedRecord())
#pragma handler(IOrderedRecord::IOrderedRecord(const IString&))
#pragma handler(IOrderedRecord::IOrderedRecord(const IOrderedRecord&))
#pragma handler(IOrderedRecord::isOrdered())
#pragma handler(IOrderedRecord::operator!=(const IOrderedRecord&))
#pragma handler(IOrderedRecord::operator<(const IOrderedRecord&))
#pragma handler(IOrderedRecord::operator<=(const IOrderedRecord&))
#pragma handler(IOrderedRecord::operator=(const IOrderedRecord&))
#pragma handler(IOrderedRecord::operator=(const IString&))
#pragma handler(IOrderedRecord::operator==(const IOrderedRecord&))
#pragma handler(IOrderedRecord::operator>(const IOrderedRecord&))
#pragma handler(IOrderedRecord::operator>=(const IOrderedRecord&))
#pragma handler(IOrderedRecord::~IOrderedRecord())
#pragma handler(operator!=(const IOrderedRecord&,const IString&))
#pragma handler(operator!=(const IString&,const IOrderedRecord&))
#pragma handler(operator<(const IOrderedRecord&,const IString&))
#pragma handler(operator<(const IString&,const IOrderedRecord&))
#pragma handler(operator<=(const IOrderedRecord&,const IString&))
#pragma handler(operator<=(const IString&,const IOrderedRecord&))
#pragma handler(operator==(const IOrderedRecord&,const IString&))
#pragma handler(operator==(const IString&,const IOrderedRecord&))
#pragma handler(operator>(const IOrderedRecord&,const IString&))
#pragma handler(operator>(const IString&,const IOrderedRecord&))
#pragma handler(operator>=(const IOrderedRecord&,const IString&))
#pragma handler(operator>=(const IString&,const IOrderedRecord&))
#endif

/*------------------------------------------------------------------------------
| Function Name: IOrderedRecord :: IOrderedRecord
|
| Implementation:
|   Default initialization of the base class is okay.
|-----------------------------------------------------------------------------*/
IOrderedRecord :: IOrderedRecord()
{
  ;
}

/*------------------------------------------------------------------------------
| Function Name: IOrderedRecord :: IOrderedRecord
|
| Implementation:
|   Initialize with the similar base class constructor.
|-----------------------------------------------------------------------------*/
IOrderedRecord :: IOrderedRecord ( const IString & recordData ) :
                   IRecord( recordData )
{
  ;
}

/*------------------------------------------------------------------------------
| Function Name: IOrderedRecord :: IOrderedRecord
|
| Implementation:
|   Initialize with the similar base class constructor.
|-----------------------------------------------------------------------------*/
IOrderedRecord :: IOrderedRecord ( const IOrderedRecord & aRecord ) :
                   IRecord( aRecord )
{
  ;
}

/*------------------------------------------------------------------------------
| Function Name: IOrderedRecord :: ~IOrderedRecord
|
| Implementation:
|   Default destruction is okay.
|-----------------------------------------------------------------------------*/
IOrderedRecord :: ~IOrderedRecord()
{
  ;
}

/*------------------------------------------------------------------------------
| Function Name: IOrderedRecord :: isOrdered
|
| Implementation:
|   Of course, IOrderedRecord objects are ordered.
------------------------------------------------------------------------------*/
IBoolean IOrderedRecord :: isOrdered ( ) const
{
  return( true );
}

/*------------------------------------------------------------------------------
| Function Name: IOrderedRecord :: operator ==
|
| Implementation:
|   Invoke the similar IString operator.
------------------------------------------------------------------------------*/
IBoolean IOrderedRecord :: operator == ( const IOrderedRecord & aRecord ) const
{
  return( sRecordData == aRecord.sRecordData );
}

/*------------------------------------------------------------------------------
| Function Name: operator ==
|
| Implementation:
|   Invoke the similar IOrderedRecord virtual operator.
------------------------------------------------------------------------------*/
IBoolean operator == ( const IOrderedRecord & record1,
                       const IString & record2 )
{
  IOrderedRecord sRecord2( record2 );
  return( record1 == sRecord2 );
}

/*------------------------------------------------------------------------------
| Function Name: operator ==
|
| Implementation:
|   Invoke the similar IOrderedRecord virtual operator.
------------------------------------------------------------------------------*/
IBoolean operator == ( const IString & record1,
                       const IOrderedRecord & record2 )
{
  IOrderedRecord sRecord1( record1 );
  return( sRecord1 == record2 );
}

/*------------------------------------------------------------------------------
| Function Name: IOrderedRecord :: operator !=
|
| Implementation:
|   Invoke the similar IString operator.
------------------------------------------------------------------------------*/
IBoolean IOrderedRecord :: operator != ( const IOrderedRecord & aRecord ) const
{
  return( sRecordData != aRecord.sRecordData );
}

/*------------------------------------------------------------------------------
| Function Name: operator !=
|
| Implementation:
|   Invoke the similar IOrderedRecord virtual operator.
------------------------------------------------------------------------------*/
IBoolean operator != ( const IOrderedRecord & record1,
                       const IString & record2 )
{
  IOrderedRecord sRecord2( record2 );
  return( record1 != sRecord2 );
}

/*------------------------------------------------------------------------------
| Function Name: operator !=
|
| Implementation:
|   Invoke the similar IOrderedRecord virtual operator.
------------------------------------------------------------------------------*/
IBoolean operator != ( const IString & record1,
                       const IOrderedRecord & record2 )
{
  IOrderedRecord sRecord1( record1 );
  return( sRecord1 != record2 );
}

/*------------------------------------------------------------------------------
| Function Name: IOrderedRecord :: operator <
|
| Implementation:
|   Invoke the similar IString operator.
------------------------------------------------------------------------------*/
IBoolean IOrderedRecord :: operator < ( const IOrderedRecord & aRecord ) const
{
  return( sRecordData < aRecord.sRecordData );
}

/*------------------------------------------------------------------------------
| Function Name: operator <
|
| Implementation:
|   Invoke the similar IOrderedRecord virtual operator.
------------------------------------------------------------------------------*/
IBoolean operator < ( const IOrderedRecord & record1,
                      const IString & record2 )
{
  IOrderedRecord sRecord2( record2 );
  return( record1 < sRecord2 );
}

/*------------------------------------------------------------------------------
| Function Name: operator <
|
| Implementation:
|   Invoke the similar IOrderedRecord virtual operator.
------------------------------------------------------------------------------*/
IBoolean operator < ( const IString & record1,
                      const IOrderedRecord & record2 )
{
  IOrderedRecord sRecord1( record1 );
  return( sRecord1 < record2 );
}

/*------------------------------------------------------------------------------
| Function Name: IOrderedRecord :: operator >
|
| Implementation:
|   Invoke the similar IString operator.
------------------------------------------------------------------------------*/
IBoolean IOrderedRecord :: operator > ( const IOrderedRecord & aRecord ) const
{
  return( sRecordData > aRecord.sRecordData );
}

/*------------------------------------------------------------------------------
| Function Name: operator >
|
| Implementation:
|   Invoke the similar IOrderedRecord virtual operator.
------------------------------------------------------------------------------*/
IBoolean operator > ( const IOrderedRecord & record1,
                      const IString & record2 )
{
  IOrderedRecord sRecord2( record2 );
  return( record1 > sRecord2 );
}

/*------------------------------------------------------------------------------
| Function Name: operator >
|
| Implementation:
|   Invoke the similar IOrderedRecord virtual operator.
------------------------------------------------------------------------------*/
IBoolean operator > ( const IString & record1,
                      const IOrderedRecord & record2 )
{
  IOrderedRecord sRecord1( record1 );
  return( sRecord1 > record2 );
}

/*------------------------------------------------------------------------------
| Function Name: IOrderedRecord :: operator <=
|
| Implementation:
|   Invoke the similar IString operator.
------------------------------------------------------------------------------*/
IBoolean IOrderedRecord :: operator <= ( const IOrderedRecord & aRecord ) const
{
  return( sRecordData <= aRecord.sRecordData );
}

/*------------------------------------------------------------------------------
| Function Name: operator <=
|
| Implementation:
|   Invoke the similar IOrderedRecord virtual operator.
------------------------------------------------------------------------------*/
IBoolean operator <= ( const IOrderedRecord & record1,
                       const IString & record2 )
{
  IOrderedRecord sRecord2( record2 );
  return( record1 <= sRecord2 );
}

/*------------------------------------------------------------------------------
| Function Name: operator <=
|
| Implementation:
|   Invoke the similar IOrderedRecord virtual operator.
------------------------------------------------------------------------------*/
IBoolean operator <= ( const IString & record1,
                       const IOrderedRecord & record2 )
{
  IOrderedRecord sRecord1( record1 );
  return( sRecord1 <= record2 );
}

/*------------------------------------------------------------------------------
| Function Name: IOrderedRecord :: operator >=
|
| Implementation:
|   Invoke the similar IString operator.
------------------------------------------------------------------------------*/
IBoolean IOrderedRecord :: operator >= ( const IOrderedRecord & aRecord ) const
{
  return( sRecordData >= aRecord.sRecordData );
}

/*------------------------------------------------------------------------------
| Function Name: operator >=
|
| Implementation:
|   Invoke the similar IOrderedRecord virtual operator.
------------------------------------------------------------------------------*/
IBoolean operator >= ( const IOrderedRecord & record1,
                       const IString & record2 )
{
  IOrderedRecord sRecord2( record2 );
  return( record1 >= sRecord2 );
}

/*------------------------------------------------------------------------------
| Function Name: operator >=
|
| Implementation:
|   Invoke the similar IOrderedRecord virtual operator.
------------------------------------------------------------------------------*/
IBoolean operator >= ( const IString & record1,
                       const IOrderedRecord & record2 )
{
  IOrderedRecord sRecord1( record1 );
  return( sRecord1 >= record2 );
}

/*------------------------------------------------------------------------------
| Function Name: IOrderedRecord :: operator =
|
| Implementation:
|   Invoke the similar superclass assignment operator.
------------------------------------------------------------------------------*/
IOrderedRecord & IOrderedRecord :: operator = ( const IOrderedRecord & aRecord )
{
  this->IRecord::operator=( aRecord );
  return( *this );
}

/*------------------------------------------------------------------------------
| Function Name: IOrderedRecord :: operator =
|
| Implementation:
|   Invoke the similar superclass assignment operator.
------------------------------------------------------------------------------*/
IOrderedRecord & IOrderedRecord :: operator = ( const IString & aRecord )
{
  this->IRecord::operator=( aRecord );
  return( *this );
}
