/*******************************************************************************
* FILE NAME: ivbbool.cpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class(es):                                     *
*    IVBBooleanPart - VB Boolean Part.                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
* DISCLAIMER OF WARRANTIES:                                                    *
*   The following [enclosed] code is sample code created by IBM                *
*   Corporation.  This sample code is not part of any standard IBM product     *
*   and is provided to you solely for the purpose of assisting you in the      *
*   development of your applications.  The code is provided "AS IS",           *
*   without warranty of any kind.  IBM shall not be liable for any damages     *
*   arising out of your use of the sample code, even if they have been         *
*   advised of the possibility of such damages.                                *
*******************************************************************************/

#ifndef _IVBBOOL_
  #include <ivbbool.hpp>
#endif

#ifndef _INOTIFEV_
  #include <inotifev.hpp>
#endif



/*------------------------------------------------------------------------------
| IVBBooleanPart::IVBBooleanPart                                               |
|                                                                              |
| Standard constructor.                                                        |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::IVBBooleanPart(Boolean aValue),, 2100)
IVBBooleanPart::IVBBooleanPart(Boolean aValue) : IVBDataTypePart ()
    ,iValue (aValue)
    ,iDefaultValue (false)
    ,iValueEqualDefault (false)
    ,iValueNotEqualDefault (false)
{
  enableNotification ();
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::IVBBooleanPart                                               |
|                                                                              |
| Standard copy constructor.                                                   |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::IVBBooleanPart(const IVBBooleanPart&),, 2101)
IVBBooleanPart::IVBBooleanPart (const IVBBooleanPart& partCopy)
  : IVBDataTypePart (partCopy)
    ,iValue (partCopy.value ())
    ,iDefaultValue (partCopy.defaultValue ())
{
  enableNotification ();
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::IVBBooleanPart                                               |
|                                                                              |
| Standard operator=                                                           |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::operator= (const IVBBooleanPart&),, 2102)
IVBBooleanPart& IVBBooleanPart::operator= (const IVBBooleanPart& aIVBBooleanPart)
{
  if (this == &aIVBBooleanPart) {
    return *this;
  } /* endif */
  Inherited::operator=(aIVBBooleanPart);
  setValue(aIVBBooleanPart.value());
  setDefaultValue(aIVBBooleanPart.defaultValue());
  return *this;
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::~IVBBooleanPart                                              |
|                                                                              |
| IVBBooleanPart destructor.                                                   |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::~IVBBooleanPart(),, 2103)
IVBBooleanPart::~IVBBooleanPart()
{
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::asString                                                     |
|                                                                              |
| Perform asString.                                                            |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::asString() const,, 2104)
IString IVBBooleanPart::asString () const
{
  return valueAsText();
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::value                                                        |
|                                                                              |
| Return the value attribute.                                                  |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::value() const,, 2105)
Boolean IVBBooleanPart::value () const
{
  return iValue;
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::setValue                                                     |
|                                                                              |
| Set the value attribute.                                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::setValue(const Boolean),, 2106)
IVBBooleanPart& IVBBooleanPart::setValue (Boolean aValue)
{
  if (iValue != aValue) {
    iValue = aValue;
    notifyObservers(INotificationEvent(valueId, *this,
                    true, (void*)iValue));
    if (isValueEqualDefault ()) {
      notifyObservers(INotificationEvent(valueEqualDefaultId, *this,
                      true, (void*)iValue));
    }
    else {
      notifyObservers(INotificationEvent(valueNotEqualDefaultId, *this,
                      true, (void*)iValue));
    } ; /* endif */
  } ; /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::setValue                                                     |
|                                                                              |
| Set the value attribute.                                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::setValue(),, 2107)
IVBBooleanPart& IVBBooleanPart::setValue ()
{
  return setValue (defaultValue());
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::notValue                                                     |
|                                                                              |
| Return the notValue attribute.                                               |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::notValue() const,, 2108)
Boolean IVBBooleanPart::notValue () const
{
  return !value();
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::setNotValue                                                  |
|                                                                              |
| Set the notValue attribute.                                                  |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::setNotValue(const Boolean),, 2109)
IVBBooleanPart& IVBBooleanPart::setNotValue (Boolean aNotValue)
{
  return setValue(!aNotValue);
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::setNotValue                                                  |
|                                                                              |
| Set the notValue attribute.                                                  |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::setNotValue(),, 2110)
IVBBooleanPart& IVBBooleanPart::setNotValue ()
{
  return setNotValue (defaultValue());
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::valueAsText                                                  |
|                                                                              |
| Return the valueAsText attribute.                                            |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::valueAsText() const,, 2111)
IString IVBBooleanPart::valueAsText () const
{
  if (value()) {
    return IString("1");
  } ; /* endif */
  return IString("0");
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::setValueAsText                                               |
|                                                                              |
| Set the valueAsText attribute.                                               |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::setValueAsText(const IString&),, 2112)
IVBBooleanPart& IVBBooleanPart::setValueAsText (const IString& aValueAsText)
{
  if (aValueAsText == "0") {
    return setValue (false);
  }
  return setValue (true);
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::setValueAsText                                               |
|                                                                              |
| Set the valueAsText attribute.                                               |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::setValueAsText(const IString*),, 2113)
IVBBooleanPart& IVBBooleanPart::setValueAsText (const IString* aValueAsText)
{
  return setValueAsText (*aValueAsText);
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::notValueAsText                                               |
|                                                                              |
| Return the notValueAsText attribute.                                         |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::notValueAsText() const,, 2114)
IString IVBBooleanPart::notValueAsText () const
{
  if (notValue()) {
    return IString("1");
  } ; /* endif */
  return IString("0");
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::setNotValueAsText                                            |
|                                                                              |
| Set the notValueAsText attribute.                                            |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::setNotValueAsText(const IString&),, 2115)
IVBBooleanPart& IVBBooleanPart::setNotValueAsText (const IString& aNotValueAsText)
{
  if (aNotValueAsText == "0") {
    return setValue (true);
  }
  return setValue (false);
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::setNotValueAsText                                            |
|                                                                              |
| Set the notValueAsText attribute.                                            |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::setNotValueAsText(const IString*),, 2116)
IVBBooleanPart& IVBBooleanPart::setNotValueAsText (const IString* aNotValueAsText)
{
  return setNotValueAsText (*aNotValueAsText);
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::defaultValue                                                 |
|                                                                              |
| Return the defaultValue attribute.                                           |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::defaultValue() const,, 2117)
Boolean IVBBooleanPart::defaultValue () const
{
  return iDefaultValue;
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::setDefaultValue                                              |
|                                                                              |
| Set the defaultValue attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::setDefaultValue(const Boolean),, 2118)
IVBBooleanPart& IVBBooleanPart::setDefaultValue (Boolean aDefaultValue)
{
  if (iDefaultValue != aDefaultValue) {
    iDefaultValue = aDefaultValue;
    if (isValueEqualDefault ()) {
      notifyObservers(INotificationEvent(valueEqualDefaultId, *this,
                      true, (void*)iValue));
    }
    else {
      notifyObservers(INotificationEvent(valueNotEqualDefaultId, *this,
                      true, (void*)iValue));
    } /* endif */
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::isValueEqualDefault                                          |
|                                                                              |
| Return the valueEqualDefault attribute.                                      |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::isValueEqualDefault() const,, 2119)
Boolean IVBBooleanPart::isValueEqualDefault () const
{
  return (value() == defaultValue ()) ;
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::isValueNotEqualDefault                                       |
|                                                                              |
| Return the valueNotEqualDefault attribute.                                   |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::isValueNotEqualDefault() const,, 2120)
Boolean IVBBooleanPart::isValueNotEqualDefault () const
{
  return (value() != defaultValue ()) ;
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::assignValueToTrue                                            |
|                                                                              |
| Assign the value attribute to true.                                          |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::assignValueToTrue(),, 2121)
IVBBooleanPart& IVBBooleanPart::assignValueToTrue ()
{
  return setValue (true) ;
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::assignValueToFalse                                           |
|                                                                              |
| Assign the value attribute to false.                                         |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::assignValueToFalse(),, 2122)
IVBBooleanPart& IVBBooleanPart::assignValueToFalse ()
{
  return setValue (false) ;
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::assignValueToDefault                                         |
|                                                                              |
| Assign the value attribute to default.                                       |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::assignValueToDefault(),, 2123)
IVBBooleanPart& IVBBooleanPart::assignValueToDefault ()
{
  return setValue (defaultValue ()) ;
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::copyValueToDefault                                           |
|                                                                              |
| Copy the value attribute to default.                                         |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::copyValueToDefault(),, 2124)
IVBBooleanPart& IVBBooleanPart::copyValueToDefault ()
{
  return setDefaultValue (value()) ;
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::logicalNotValue                                              |
|                                                                              |
| Perform the logical not operator to the value attribute.                     |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::logicalNotValue(),, 2125)
IVBBooleanPart& IVBBooleanPart::logicalNotValue()
{
  return setValue (!value()) ;
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::logicalAndValue                                               |
|                                                                              |
| Perform the logical And operator to the value attribute.                      |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::logicalAndValue (Boolean),, 2126)
IVBBooleanPart& IVBBooleanPart::logicalAndValue (Boolean anAndValue)
{
  return setValue (value() && anAndValue) ;
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::logicalOrValue                                               |
|                                                                              |
| Perform the logical Or operator to the value attribute.                      |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::logicalOrValue (Boolean),, 2127)
IVBBooleanPart& IVBBooleanPart::logicalOrValue (Boolean anOrValue)
{
  return setValue (value() || anOrValue) ;
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::operator == (const IVBBooleanPart & aValue)                  |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::operator == (const IVBBooleanPart&) const,, 2128)
Boolean IVBBooleanPart::
  operator == (const IVBBooleanPart& aValue) const
{
  if (value() != aValue.value()) {
    return false;
  } /* endif */
  if (defaultValue() != aValue.defaultValue()) {
    return false;
  } /* endif */
  if (isValueEqualDefault() != aValue.isValueEqualDefault()) {
    return false;
  } /* endif */
  if (isValueNotEqualDefault() != aValue.isValueNotEqualDefault()) {
    return false;
  } /* endif */
  return true;
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::operator != (const IVBBooleanPart & aValue)                  |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::operator != (const IVBBooleanPart&) const,, 2129)
Boolean IVBBooleanPart::
  operator != (const IVBBooleanPart& aValue) const
{
  if (value() != aValue.value()) {
    return true;
  } /* endif */
  if (defaultValue() != aValue.defaultValue()) {
    return true;
  } /* endif */
  if (isValueEqualDefault() != aValue.isValueEqualDefault()) {
    return true;
  } /* endif */
  if (isValueNotEqualDefault() != aValue.isValueNotEqualDefault()) {
    return true;
  } /* endif */
  return false;
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::operator == (const IVBBooleanPart * aValue)                  |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::operator == (const IVBBooleanPart*) const,, 2130)
Boolean IVBBooleanPart::
  operator == (const IVBBooleanPart* aValue) const
{
  if (value() != aValue->value()) {
    return false;
  } /* endif */
  if (defaultValue() != aValue->defaultValue()) {
    return false;
  } /* endif */
  if (isValueEqualDefault() != aValue->isValueEqualDefault()) {
    return false;
  } /* endif */
  if (isValueNotEqualDefault() != aValue->isValueNotEqualDefault()) {
    return false;
  } /* endif */
  return true;
}

/*------------------------------------------------------------------------------
| IVBBooleanPart::operator != (const IVBBooleanPart * aValue)                  |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBBooleanPart::operator != (const IVBBooleanPart*) const,, 2131)
Boolean IVBBooleanPart::
  operator != (const IVBBooleanPart* aValue) const
{
  if (value() != aValue->value()) {
    return true;
  } /* endif */
  if (defaultValue() != aValue->defaultValue()) {
    return true;
  } /* endif */
  if (isValueEqualDefault() != aValue->isValueEqualDefault()) {
    return true;
  } /* endif */
  if (isValueNotEqualDefault() != aValue->isValueNotEqualDefault()) {
    return true;
  } /* endif */
  return false;
}
