/*******************************************************************************
* FILE NAME: ivbdbl.cpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class(es):                                     *
*    IVBDoublePart - IBM VB sample Double part.                                *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
* DISCLAIMER OF WARRANTIES:                                                    *
*   The following [enclosed] code is sample code created by IBM                *
*   Corporation.  This sample code is not part of any standard IBM product     *
*   and is provided to you solely for the purpose of assisting you in the      *
*   development of your applications.  The code is provided "AS IS",           *
*   without warranty of any kind.  IBM shall not be liable for any damages     *
*   arising out of your use of the sample code, even if they have been         *
*   advised of the possibility of such damages.                                *
*******************************************************************************/

#ifndef _IVBDBL_
  #include <ivbdbl.hpp>
#endif

#ifndef _INOTIFEV_
  #include <inotifev.hpp>
#endif

  #include <complex.h>

  #include <math.h>



/*------------------------------------------------------------------------------
| IVBDoublePart::IVBDoublePart                                                 |
|                                                                              |
| Standard constructor.                                                        |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::IVBDoublePart(double aValue),, 2700)
IVBDoublePart::IVBDoublePart(double aValue) : IVBDataTypePart ()
    ,iValue (aValue)
    ,iDefaultValue (0)
    ,iLowLimit (DBL_MIN)
    ,iHighLimit (DBL_MAX)
{
  enableNotification ();
}

/*------------------------------------------------------------------------------
| IVBDoublePart::IVBDoublePart                                                 |
|                                                                              |
| Standard copy constructor.                                                   |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::IVBDoublePart(const IVBDoublePart&),, 2701)
IVBDoublePart::IVBDoublePart (const IVBDoublePart& partCopy)
  : IVBDataTypePart (partCopy)
    ,iValue (partCopy.value ())
    ,iDefaultValue (partCopy.defaultValue ())
    ,iLowLimit (partCopy.lowLimit ())
    ,iHighLimit (partCopy.highLimit ())
{
  enableNotification ();
}

/*------------------------------------------------------------------------------
| IVBDoublePart::IVBDoublePart                                                 |
|                                                                              |
| Standard operator=                                                           |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::operator= (const IVBDoublePart&),, 2702)
IVBDoublePart& IVBDoublePart::operator= (const IVBDoublePart& aIVBDoublePart)
{
  if (this == &aIVBDoublePart) {
    return *this;
  } /* endif */
  Inherited::operator=(aIVBDoublePart);
  setValue(aIVBDoublePart.value());
  setDefaultValue(aIVBDoublePart.defaultValue());
  setLowLimit(aIVBDoublePart.lowLimit());
  setHighLimit(aIVBDoublePart.highLimit());
  return *this;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::~IVBDoublePart                                                |
|                                                                              |
| IVBDoublePart destructor.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::~IVBDoublePart(),, 2703)
IVBDoublePart::~IVBDoublePart()
{
}

/*------------------------------------------------------------------------------
| IVBDoublePart::asString                                                      |
|                                                                              |
| Perform asString.                                                            |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::asString() const,, 2704)
IString IVBDoublePart::asString () const
{
  return valueAsText();
}

/*------------------------------------------------------------------------------
| IVBDoublePart::value                                                         |
|                                                                              |
| Return the value attribute.                                                  |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::value() const,, 2705)
double IVBDoublePart::value () const
{
  return iValue;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::setValue                                                      |
|                                                                              |
| Set the value attribute.                                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::setValue(const double),, 2706)
IVBDoublePart& IVBDoublePart::setValue (double aValue)
{
  if (iValue != aValue) {
    double oldValue = iValue;
    iValue = aValue;
    notifyObservers(INotificationEvent(valueId, *this,
                      true, (void*)&iValue));
    if (iValue < 0) {
      if (!(oldValue < 0)) {
        notifyObservers(INotificationEvent(valueNegativeId, *this,
                        true, (void*)&iValue));
      } ; /* endif */
    } ;
    if (iValue > 0) {
      if (!(oldValue > 0)) {
        notifyObservers(INotificationEvent(valuePositiveId, *this,
                        true, (void*)&iValue));
      } ; /* endif */
    } ; /* endif */
    if (iValue == 0) {
      notifyObservers(INotificationEvent(valueZeroId, *this,
                      true, (void*)&iValue));
    }
    else {
      if (oldValue == 0) {
        notifyObservers(INotificationEvent(valueNotZeroId, *this,
                        true, (void*)&iValue));
      } ; /* endif */
    } ; /* endif */
    if (iDefaultValue == iValue) {
      notifyObservers(INotificationEvent(valueEqualDefaultId, *this,
                      true, (void*)&iValue));
    }
    else {
      if (iDefaultValue == oldValue) {
        notifyObservers(INotificationEvent(valueNotEqualDefaultId, *this,
                        true, (void*)&iValue));
      } /* endif */
    } /* endif */
    if (iValue == iLowLimit) {
      notifyObservers(INotificationEvent(valueEqualLowLimitId, *this,
                      true, (void*)&iValue));
    } ; /* endif */
    if (iLowLimit != DBL_MIN) {
      if (iValue < iLowLimit) {
        if (!(oldValue < iLowLimit)) {
          notifyObservers(INotificationEvent(valueBelowLowLimitId, *this,
                          true, (void*)&iValue));
        } ; /* endif */
      } ; /* endif */
    } ; /* endif */
    if (iValue == iHighLimit) {
      notifyObservers(INotificationEvent(valueEqualHighLimitId, *this,
                      true, (void*)&iValue));
    } ; /* endif */
    if (iHighLimit != DBL_MAX) {
      if (iValue > iHighLimit) {
        if (!(oldValue > iHighLimit)) {
          notifyObservers(INotificationEvent(valueAboveHighLimitId, *this,
                          true, (void*)&iValue));
        } ; /* endif */
      } ; /* endif */
    } ; /* endif */
    if ((iValue >= iLowLimit) && (iValue <= iHighLimit)) {
      if (!((oldValue >= iLowLimit) && (oldValue <= iHighLimit))) {
        notifyObservers(INotificationEvent(valueWithinLimitsId, *this,
                        true, (void*)&iValue));
      } ; /* endif */
    }
    else {
      if (((oldValue >= iLowLimit) && (oldValue <= iHighLimit))) {
        notifyObservers(INotificationEvent(valueOutsideLimitsId, *this,
                        true, (void*)&iValue));
      } ; /* endif */
    } ; /* endif */
  } ; /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::setValue                                                      |
|                                                                              |
| Set the value attribute.                                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::setValue(),, 2707)
IVBDoublePart& IVBDoublePart::setValue ()
{
  return setValue(defaultValue());
}

/*------------------------------------------------------------------------------
| IVBDoublePart::valueAsText                                                   |
|                                                                              |
| Return the valueAsText attribute.                                            |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::valueAsText() const,, 2708)
IString IVBDoublePart::valueAsText () const
{
  return IString (value());
}

/*------------------------------------------------------------------------------
| IVBDoublePart::setValueAsText                                                |
|                                                                              |
| Set the valueAsText attribute.                                               |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::setValueAsText(const IString&),, 2709)
IVBDoublePart& IVBDoublePart::setValueAsText (const IString& aValueAsText)
{
#ifdef IC_PM
  IString tempValueString(aValueAsText);
  setValue (aValueAsText.asDouble());
  tempValueString = tempValueString.strip();
  Boolean   inValidDbl=0;
  int iExponent;


  IString firstCharOfString(tempValueString.subString(1,1));   //Gets 1st char of string
  Boolean testFirstChar=firstCharOfString.indexOfAnyOf("+-");  //Checks 2C if 1st char is + or -

  if (testFirstChar)
    tempValueString=tempValueString.subString(2);              //Uses rest of string after sign

  tempValueString = tempValueString.strip();

  int numDecimalPoints =tempValueString.occurrencesOf(".");

  if (numDecimalPoints>1)
    inValidDbl=1;
  else {
    int numExponents =(tempValueString.occurrencesOf("E")+tempValueString.occurrencesOf("e"));
    iExponent =tempValueString.indexOfAnyOf("Ee");
    if (numExponents>1)
      inValidDbl=1;
    else if (numExponents==1){

   /*  *****Verifies real part of Double ********  */
      IString realPartStr=tempValueString.subString(1,iExponent-1);
      Boolean isItNotReal=realPartStr.indexOfAnyBut(".0123456789");
      if (isItNotReal)
        inValidDbl=1;

   /*  *****Verifies exponential part of Double ********  */
      IString exponStr=tempValueString.subString(iExponent);
      Boolean exponStrNotGood=exponStr.indexOfAnyBut("Ee+-0123456789");
      if (exponStrNotGood)
        inValidDbl=1;
    }  /*else if*/

      else {/* if numExponents ==0 */
      Boolean isItNotReal=tempValueString.indexOfAnyBut(".0123456789");
      if (isItNotReal)
        inValidDbl=1;

    } /*else*/
  }/*else  */

  IString eventData(aValueAsText);
  if (inValidDbl) {
    notifyObservers(INotificationEvent(inputStringNotValidId, *this,
                      true, (void*)&eventData));
  } else {
    notifyObservers(INotificationEvent(inputStringIsValidId, *this,
                      true, (void*)&eventData));
  } /* endif */
#endif
#ifdef IC_WIN
  setValue (aValueAsText.asDouble());
  Boolean iValid = aValueAsText.indexOfAnyBut("+-0123456789. ");
  if (iValid) {
    IString eventData(aValueAsText);
    notifyObservers(INotificationEvent(inputStringNotValidId, *this,
                      true, (void*)&eventData));
  } else {
    IString eventData(aValueAsText);
    notifyObservers(INotificationEvent(inputStringIsValidId, *this,
                      true, (void*)&eventData));
  } /* endif */
#endif
  return *this;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::setValueAsText                                                |
|                                                                              |
| Set the valueAsText attribute.                                               |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::setValueAsText(const IString*),, 2710)
IVBDoublePart& IVBDoublePart::setValueAsText (const IString* aValueAsText)
{
  return setValueAsText (*aValueAsText);
}

/*------------------------------------------------------------------------------
| IVBDoublePart::valueAs1Based                                                 |
|                                                                              |
| Return the valueAs1Based attribute.                                          |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::valueAs1Based() const,, 2711)
double IVBDoublePart::valueAs1Based () const
{
  return (value() + 1) ;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::setValueAs1Based                                              |
|                                                                              |
| Set the valueAs1Based attribute.                                             |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::setValueAs1Based(double),, 2712)
IVBDoublePart& IVBDoublePart::setValueAs1Based (double aValueAs1Based)
{
  return setValue (aValueAs1Based - 1);
}

/*------------------------------------------------------------------------------
| IVBDoublePart::defaultValue                                                  |
|                                                                              |
| Return the defaultValue attribute.                                           |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::defaultValue() const,, 2713)
double IVBDoublePart::defaultValue () const
{
  return iDefaultValue;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::setDefaultValue                                               |
|                                                                              |
| Set the defaultValue attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::setDefaultValue(const double),, 2714)
IVBDoublePart& IVBDoublePart::setDefaultValue (double aDefaultValue)
{
  if (iDefaultValue != aDefaultValue) {
    double oldValue = iDefaultValue;
    iDefaultValue = aDefaultValue;
    notifyObservers(INotificationEvent(defaultValueId, *this,
                      true, (void*)&iDefaultValue));
    if (iDefaultValue == iValue) {
      notifyObservers(INotificationEvent(valueEqualDefaultId, *this,
                      true, (void*)&iValue));
    }
    else {
      if (oldValue == iValue) {
        notifyObservers(INotificationEvent(valueNotEqualDefaultId, *this,
                        true, (void*)&iValue));
      } /* endif */
    } /* endif */
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::isValueEqualDefault                                           |
|                                                                              |
| Return the valueEqualDefault attribute.                                      |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::isValueEqualDefault() const,, 2715)
Boolean IVBDoublePart::isValueEqualDefault () const
{
  return (value() == defaultValue ()) ;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::isValueNotEqualDefault                                        |
|                                                                              |
| Return the valueNotEqualDefault attribute.                                   |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::isValueNotEqualDefault() const,, 2716)
Boolean IVBDoublePart::isValueNotEqualDefault () const
{
  return (value() != defaultValue ()) ;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::lowLimit                                                      |
|                                                                              |
| Return the lowLimit attribute.                                               |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::lowLimit() const,, 2717)
double IVBDoublePart::lowLimit () const
{
  return iLowLimit;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::setLowLimit                                                   |
|                                                                              |
| Set the lowLimit attribute.                                                  |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::setLowLimit(const double),, 2718)
IVBDoublePart& IVBDoublePart::setLowLimit (double aLowLimit)
{
  if (iLowLimit != aLowLimit) {
    double oldValue = iLowLimit;
    iLowLimit = aLowLimit;
    notifyObservers(INotificationEvent(lowLimitId, *this,
                      true, (void*)&iLowLimit));
    if (iValue == lowLimit()) {
      notifyObservers(INotificationEvent(valueEqualLowLimitId, *this,
                      true, (void*)&iValue));
    } ; /* endif */
    if (lowLimit() != DBL_MIN) {
      if (iValue < iLowLimit) {
        if (!(iValue < oldValue)) {
          notifyObservers(INotificationEvent(valueBelowLowLimitId, *this,
                          true, (void*)&iValue));
        } ; /* endif */
      } ; /* endif */
    } ; /* endif */
    if ((iValue >= lowLimit()) && (iValue <= highLimit())) {
      if (!((iValue >= oldValue) && (iValue <= highLimit()))) {
        notifyObservers(INotificationEvent(valueWithinLimitsId, *this,
                        true, (void*)&iLowLimit));
      } ; /* endif */
    }
    else {
      if ((iValue >= oldValue) && (iValue <= highLimit())) {
        notifyObservers(INotificationEvent(valueOutsideLimitsId, *this,
                        true, (void*)&iLowLimit));
      } ; /* endif */
    } ; /* endif */
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::highLimit                                                     |
|                                                                              |
| Return the highLimit attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::highLimit() const,, 2719)
double IVBDoublePart::highLimit () const
{
  return iHighLimit;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::setHighLimit                                                  |
|                                                                              |
| Set the highLimit attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::setHighLimit(const double),, 2720)
IVBDoublePart& IVBDoublePart::setHighLimit (double aHighLimit)
{
  if (iHighLimit != aHighLimit) {
    double oldValue = iHighLimit;
    iHighLimit = aHighLimit;
    notifyObservers(INotificationEvent(highLimitId, *this,
                      true, (void*)&iHighLimit));
    if (iValue == highLimit()) {
      notifyObservers(INotificationEvent(valueEqualHighLimitId, *this,
                      true, (void*)&iValue));
    } ; /* endif */
    if (highLimit() != DBL_MAX) {
      if (iValue > iHighLimit) {
        if (!(iValue > oldValue)) {
          notifyObservers(INotificationEvent(valueAboveHighLimitId, *this,
                          true, (void*)&iValue));
        } ; /* endif */
      } ; /* endif */
    } ; /* endif */
    if ((iValue >= lowLimit()) && (iValue <= highLimit())) {
      if (!((iValue >= lowLimit()) && (iValue <= oldValue))) {
        notifyObservers(INotificationEvent(valueWithinLimitsId, *this,
                        true, (void*)&iHighLimit));
      } ; /* endif */
    }
    else {
      if ((iValue >= lowLimit()) && (iValue <= oldValue)) {
        notifyObservers(INotificationEvent(valueOutsideLimitsId, *this,
                        true, (void*)&iHighLimit));
      } ; /* endif */
    } ; /* endif */
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::isValueEqualLowLimit                                          |
|                                                                              |
| Return the valueEqualLowLimit attribute.                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::isValueEqualLowLimit() const,, 2721)
Boolean IVBDoublePart::isValueEqualLowLimit () const
{
  return (value() == lowLimit ()) ;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::isValueEqualHighLimit                                         |
|                                                                              |
| Return the valueEqualHighLimit attribute.                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::isValueEqualHighLimit() const,, 2722)
Boolean IVBDoublePart::isValueEqualHighLimit () const
{
  return (value() == highLimit ()) ;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::isValueBelowLowLimit                                          |
|                                                                              |
| Return the valueBelowLowLimit attribute.                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::isValueBelowLowLimit() const,, 2723)
Boolean IVBDoublePart::isValueBelowLowLimit () const
{
  return (value() < lowLimit ()) ;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::isValueAboveHighLimit                                         |
|                                                                              |
| Return the valueAboveHighLimit attribute.                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::isValueAboveHighLimit() const,, 2724)
Boolean IVBDoublePart::isValueAboveHighLimit () const
{
  return (value() > highLimit ()) ;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::isValueOutsideLimits                                          |
|                                                                              |
| Return the valueOutsideLimits attribute.                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::isValueOutsideLimits() const,, 2725)
Boolean IVBDoublePart::isValueOutsideLimits () const
{
  return ((value() < lowLimit()) || (value() > highLimit())) ;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::isValueWithinLimits                                           |
|                                                                              |
| Return the valueWithinLimits attribute.                                      |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::isValueWithinLimits() const,, 2726)
Boolean IVBDoublePart::isValueWithinLimits () const
{
  return !isValueOutsideLimits ();
}

/*------------------------------------------------------------------------------
| IVBDoublePart::isValueNotZero                                                |
|                                                                              |
| Return the valueNotZero attribute.                                           |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::isValueNotZero() const,, 2727)
Boolean IVBDoublePart::isValueNotZero () const
{
  return (value() != 0) ;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::isValueZero                                                   |
|                                                                              |
| Return the valueZero attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::isValueZero() const,, 2728)
Boolean IVBDoublePart::isValueZero () const
{
  return (value() == 0) ;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::isValuePositive                                               |
|                                                                              |
| Return the valuePositive attribute.                                          |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::isValuePositive() const,, 2729)
Boolean IVBDoublePart::isValuePositive () const
{
  return (value() > 0) ;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::isValueNegative                                               |
|                                                                              |
| Return the valueNegative attribute.                                          |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::isValueNegative() const,, 2730)
Boolean IVBDoublePart::isValueNegative () const
{
  return (value() < 0) ;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::assignValueToZero                                             |
|                                                                              |
| Assign the value attribute to 0.                                             |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::assignValueToZero(),, 2731)
IVBDoublePart& IVBDoublePart::assignValueToZero ()
{
  return setValue (0) ;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::assignValueToOne                                              |
|                                                                              |
| Assign the value attribute to 1.                                             |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::assignValueToOne(),, 2732)
IVBDoublePart& IVBDoublePart::assignValueToOne ()
{
  return setValue (1) ;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::assignValueToLowLimit                                         |
|                                                                              |
| Assign the value attribute to low limit attribute.                           |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::assignValueToLowLimit(),, 2733)
IVBDoublePart& IVBDoublePart::assignValueToLowLimit ()
{
  return setValue (lowLimit()) ;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::assignValueToHighLimit                                        |
|                                                                              |
| Assign the value attribute to high limit attribute.                          |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::assignValueToHighLimit(),, 2734)
IVBDoublePart& IVBDoublePart::assignValueToHighLimit ()
{
  return setValue (highLimit()) ;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::assignValueToDefault                                          |
|                                                                              |
| Assign the value attribute to default.                                       |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::assignValueToDefault(),, 2735)
IVBDoublePart& IVBDoublePart::assignValueToDefault ()
{
  return setValue (defaultValue ()) ;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::assignValueToRandom                                           |
|                                                                              |
| Assign the value attribute to a pseudo-random number.                        |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::assignValueToRandom(),, 2736)
IVBDoublePart& IVBDoublePart::assignValueToRandom ()
{
  return setValue (rand ()) ;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::copyValueToDefault                                            |
|                                                                              |
| Copy the value attribute to default.                                         |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::copyValueToDefault(),, 2737)
IVBDoublePart& IVBDoublePart::copyValueToDefault ()
{
  return setDefaultValue (value()) ;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::squareValue                                                   |
|                                                                              |
| Square the value attribute.                                                  |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::squareValue(),, 2738)
IVBDoublePart& IVBDoublePart::squareValue()
{
  return setValue (value() * value()) ;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::addValue                                                      |
|                                                                              |
| Perform the add operator to the value attribute.                             |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::addValue (double),, 2739)
IVBDoublePart& IVBDoublePart::addValue (double addValue)
{
  return setValue (value() + addValue) ;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::subtractValue                                                 |
|                                                                              |
| Perform the subtract operator to the value attribute.                        |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::subtractValue (double),, 2740)
IVBDoublePart& IVBDoublePart::subtractValue (double subtractValue)
{
  return setValue (value() - subtractValue) ;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::multiplyValue                                                 |
|                                                                              |
| Perform the multiply operator to the value attribute.                        |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::multiplyValue (double),, 2741)
IVBDoublePart& IVBDoublePart::multiplyValue (double multiplyValue)
{
  return setValue (value() * multiplyValue) ;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::divideValue                                                  |
|                                                                             |
| Perform the divide operator to the value attribute.                         |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::divideValue (double),, 2742)
IVBDoublePart& IVBDoublePart::divideValue (double divideValue)
{
  if (divideValue)
    return setValue (value() / divideValue) ;
  return *this;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::ceilValue                                                     |
|                                                                              |
| Perform the ceil function to the value attribute.                            |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::ceilValue (),, 2743)
IVBDoublePart& IVBDoublePart::ceilValue ()
{
  return setValue (ceil(value())) ;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::floorValue                                                    |
|                                                                              |
| Perform the floor function to the value attribute.                           |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::floorValue (),, 2744)
IVBDoublePart& IVBDoublePart::floorValue ()
{
  return setValue (floor(value())) ;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::assignValueToPI                                               |
|                                                                              |
| Assign the value attribute to PI.                                            |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::assignValueToPI(),, 2745)
IVBDoublePart& IVBDoublePart::assignValueToPI ()
{
  return setValue (M_PI) ;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::assignValueToE                                                |
|                                                                              |
| Assign the value attribute to e.                                             |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::assignValueToE(),, 2746)
IVBDoublePart& IVBDoublePart::assignValueToE ()
{
  return setValue (M_E) ;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::operator == (const IVBDoublePart & aValue)                    |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::operator == (const IVBDoublePart&) const,, 2747)
Boolean IVBDoublePart::
  operator == (const IVBDoublePart& aValue) const
{
  if (value() != aValue.value()) {
    return false;
  } /* endif */
  if (defaultValue() != aValue.defaultValue()) {
    return false;
  } /* endif */
  if (lowLimit() != aValue.lowLimit()) {
    return false;
  } /* endif */
  if (highLimit() != aValue.highLimit()) {
    return false;
  } /* endif */
  return true;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::operator != (const IVBDoublePart & aValue)                    |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::operator != (const IVBDoublePart&) const,, 2748)
Boolean IVBDoublePart::
  operator != (const IVBDoublePart& aValue) const
{
  if (value() != aValue.value()) {
    return true;
  } /* endif */
  if (defaultValue() != aValue.defaultValue()) {
    return true;
  } /* endif */
  if (lowLimit() != aValue.lowLimit()) {
    return true;
  } /* endif */
  if (highLimit() != aValue.highLimit()) {
    return true;
  } /* endif */
  return false;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::operator == (const IVBDoublePart * aValue)                    |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::operator == (const IVBDoublePart*) const,, 2749)
Boolean IVBDoublePart::
  operator == (const IVBDoublePart* aValue) const
{
  if (value() != aValue->value()) {
    return false;
  } /* endif */
  if (defaultValue() != aValue->defaultValue()) {
    return false;
  } /* endif */
  if (lowLimit() != aValue->lowLimit()) {
    return false;
  } /* endif */
  if (highLimit() != aValue->highLimit()) {
    return false;
  } /* endif */
  return true;
}

/*------------------------------------------------------------------------------
| IVBDoublePart::operator != (const IVBDoublePart * aValue)                    |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBDoublePart::operator != (const IVBDoublePart*) const,, 2750)
Boolean IVBDoublePart::
  operator != (const IVBDoublePart* aValue) const
{
  if (value() != aValue->value()) {
    return true;
  } /* endif */
  if (defaultValue() != aValue->defaultValue()) {
    return true;
  } /* endif */
  if (lowLimit() != aValue->lowLimit()) {
    return true;
  } /* endif */
  if (highLimit() != aValue->highLimit()) {
    return true;
  } /* endif */
  return false;
}
