/*******************************************************************************
* FILE NAME: ivbdtype.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class(es):                                     *
*    IVBDataTypePart - IBM VB sample base data type part.                      *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
* DISCLAIMER OF WARRANTIES:                                                    *
*   The following [enclosed] code is sample code created by IBM                *
*   Corporation.  This sample code is not part of any standard IBM product     *
*   and is provided to you solely for the purpose of assisting you in the      *
*   development of your applications.  The code is provided "AS IS",           *
*   without warranty of any kind.  IBM shall not be liable for any damages     *
*   arising out of your use of the sample code, even if they have been         *
*   advised of the possibility of such damages.                                *
*******************************************************************************/

#ifndef _IVBDTYPE_
  #include <ivbdtype.hpp>
#endif

#ifndef _INOTIFEV_
  #include <inotifev.hpp>
#endif


#pragma export (IVBDataTypePart::valueId,, 2900)
const INotificationId IVBDataTypePart::valueId =
                     "IVBDataTypePart::value";
#pragma export (IVBDataTypePart::defaultValueId,, 2901)
const INotificationId IVBDataTypePart::defaultValueId =
                     "IVBDataTypePart::defaultValue";
#pragma export (IVBDataTypePart::valueEqualDefaultId,, 2902)
const INotificationId IVBDataTypePart::valueEqualDefaultId =
                     "IVBDataTypePart::valueEqualDefault";
#pragma export (IVBDataTypePart::valueNotEqualDefaultId,, 2903)
const INotificationId IVBDataTypePart::valueNotEqualDefaultId =
                     "IVBDataTypePart::valueNotEqualDefault";
#pragma export (IVBDataTypePart::lowLimitId,, 2904)
const INotificationId IVBDataTypePart::lowLimitId =
                     "IVBDataTypePart::lowLimit";
#pragma export (IVBDataTypePart::highLimitId,, 2905)
const INotificationId IVBDataTypePart::highLimitId =
                     "IVBDataTypePart::highLimit";
#pragma export (IVBDataTypePart::valueEqualLowLimitId,, 2906)
const INotificationId IVBDataTypePart::valueEqualLowLimitId =
                     "IVBDataTypePart::valueEqualLowLimit";
#pragma export (IVBDataTypePart::valueEqualHighLimitId,, 2907)
const INotificationId IVBDataTypePart::valueEqualHighLimitId =
                     "IVBDataTypePart::valueEqualHighLimit";
#pragma export (IVBDataTypePart::valueBelowLowLimitId,, 2908)
const INotificationId IVBDataTypePart::valueBelowLowLimitId =
                     "IVBDataTypePart::valueBelowLowLimit";
#pragma export (IVBDataTypePart::valueAboveHighLimitId,, 2909)
const INotificationId IVBDataTypePart::valueAboveHighLimitId =
                     "IVBDataTypePart::valueAboveHighLimit";
#pragma export (IVBDataTypePart::valueOutsideLimitsId,, 2910)
const INotificationId IVBDataTypePart::valueOutsideLimitsId =
                     "IVBDataTypePart::valueOutsideLimits";
#pragma export (IVBDataTypePart::valueWithinLimitsId,, 2911)
const INotificationId IVBDataTypePart::valueWithinLimitsId =
                     "IVBDataTypePart::valueWithinLimits";
#pragma export (IVBDataTypePart::valueNotZeroId,, 2912)
const INotificationId IVBDataTypePart::valueNotZeroId =
                     "IVBDataTypePart::valueNotZero";
#pragma export (IVBDataTypePart::valueZeroId,, 2913)
const INotificationId IVBDataTypePart::valueZeroId =
                     "IVBDataTypePart::valueZero";
#pragma export (IVBDataTypePart::valuePositiveId,, 2914)
const INotificationId IVBDataTypePart::valuePositiveId =
                     "IVBDataTypePart::valuePositive";
#pragma export (IVBDataTypePart::valueNegativeId,, 2915)
const INotificationId IVBDataTypePart::valueNegativeId =
                     "IVBDataTypePart::valueNegative";
#pragma export (IVBDataTypePart::textId,, 2916)
const INotificationId IVBDataTypePart::textId =
                     "IVBDataTypePart::text";
#pragma export (IVBDataTypePart::defaultTextId,, 2917)
const INotificationId IVBDataTypePart::defaultTextId =
                     "IVBDataTypePart::defaultText";
#pragma export (IVBDataTypePart::textEqualDefaultId,, 2918)
const INotificationId IVBDataTypePart::textEqualDefaultId =
                     "IVBDataTypePart::textEqualDefault";
#pragma export (IVBDataTypePart::textNotEqualDefaultId,, 2919)
const INotificationId IVBDataTypePart::textNotEqualDefaultId =
                     "IVBDataTypePart::textNotEqualDefault";
#pragma export (IVBDataTypePart::textLengthId,, 2920)
const INotificationId IVBDataTypePart::textLengthId =
                     "IVBDataTypePart::textLength";
#pragma export (IVBDataTypePart::lowerCaseId,, 2921)
const INotificationId IVBDataTypePart::lowerCaseId =
                     "IVBDataTypePart::lowerCase";
#pragma export (IVBDataTypePart::upperCaseId,, 2922)
const INotificationId IVBDataTypePart::upperCaseId =
                     "IVBDataTypePart::upperCase";
#pragma export (IVBDataTypePart::digitsId,, 2923)
const INotificationId IVBDataTypePart::digitsId =
                     "IVBDataTypePart::digits";
#pragma export (IVBDataTypePart::inputStringNotValidId,, 2924)
const INotificationId IVBDataTypePart::inputStringNotValidId =
                     "IVBDataTypePart::inputStringNotValid";
#pragma export (IVBDataTypePart::inputStringIsValidId,, 2925)
const INotificationId IVBDataTypePart::inputStringIsValidId =
                     "IVBDataTypePart::inputStringIsValid";

/*------------------------------------------------------------------------------
| IVBDataTypePart::IVBDataTypePart                                             |
|                                                                              |
| Standard constructor.                                                        |
------------------------------------------------------------------------------*/
#pragma export (IVBDataTypePart::IVBDataTypePart(),, 2926)
IVBDataTypePart::IVBDataTypePart() : IStandardNotifier ()
{
  enableNotification ();
}

/*------------------------------------------------------------------------------
| IVBDataTypePart::~IVBDataTypePart                                            |
|                                                                              |
| IVBDataTypePart destructor.                                                  |
------------------------------------------------------------------------------*/
#pragma export (IVBDataTypePart::~IVBDataTypePart(),, 2927)
IVBDataTypePart::~IVBDataTypePart()
{
}

/*------------------------------------------------------------------------------
| IVBDataTypePart::operator=                                                   |
|                                                                              |
| IVBDataTypePart operator=.                                                   |
------------------------------------------------------------------------------*/
#pragma export (IVBDataTypePart::operator=(const IVBDataTypePart&),, 2928)
IVBDataTypePart& IVBDataTypePart::operator= (const IVBDataTypePart& aIVBDataTypePart)
{
  Inherited::operator=(aIVBDataTypePart);
  return *this;
}

/*------------------------------------------------------------------------------
| IVBDataTypePart::operator == (const IVBDataTypePart & aValue)                |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBDataTypePart::operator == (const IVBDataTypePart&) const,, 2929)
Boolean IVBDataTypePart::
  operator == (const IVBDataTypePart& aValue) const
{
  if (asString() != aValue.asString()) {
    return false;
  } /* endif */
  return true;
}

/*------------------------------------------------------------------------------
| IVBDataTypePart::operator != (const IVBDataTypePart & aValue)                |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBDataTypePart::operator != (const IVBDataTypePart&) const,, 2930)
Boolean IVBDataTypePart::
  operator != (const IVBDataTypePart& aValue) const
{
  if (asString() != aValue.asString()) {
    return true;
  } /* endif */
  return false;
}

/*------------------------------------------------------------------------------
| IVBDataTypePart::operator == (const IVBDataTypePart * aValue)                |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBDataTypePart::operator == (const IVBDataTypePart*) const,, 2931)
Boolean IVBDataTypePart::
  operator == (const IVBDataTypePart* aValue) const
{
  if (asString() != aValue->asString()) {
    return false;
  } /* endif */
  return true;
}

/*------------------------------------------------------------------------------
| IVBDataTypePart::operator != (const IVBDataTypePart * aValue)                |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBDataTypePart::operator != (const IVBDataTypePart*) const,, 2932)
Boolean IVBDataTypePart::
  operator != (const IVBDataTypePart* aValue) const
{
  if (asString() != aValue->asString()) {
    return true;
  } /* endif */
  return false;
}

/*------------------------------------------------------------------------------
| IVBDataTypePart::operator < (const IVBDataTypePart * aValue)                 |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBDataTypePart::operator < (const IVBDataTypePart*) const,, 2933)
Boolean IVBDataTypePart::
  operator < (const IVBDataTypePart* aValue) const
{
  return (asString() < (aValue->asString()));
}

/*------------------------------------------------------------------------------
| IVBDataTypePart::operator < (const IVBDataTypePart & aValue)                 |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBDataTypePart::operator < (const IVBDataTypePart&) const,, 2934)
Boolean IVBDataTypePart::
  operator < (const IVBDataTypePart& aValue) const
{
  return (asString() < (aValue.asString()));
}

/*------------------------------------------------------------------------------
| IVBDataTypePart::operator < (IVBDataTypePart* const & aValue)                |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBDataTypePart::operator < (IVBDataTypePart* const&) const,, 2935)
Boolean IVBDataTypePart::
  operator < (IVBDataTypePart* const& aValue) const
{
  return (asString() < (aValue->asString()));
}
