/*******************************************************************************
* FILE NAME: ivbland.cpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class(es):                                     *
*    IVBLogicalAndPart - VB Logical And Part.                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
* DISCLAIMER OF WARRANTIES:                                                    *
*   The following [enclosed] code is sample code created by IBM                *
*   Corporation.  This sample code is not part of any standard IBM product     *
*   and is provided to you solely for the purpose of assisting you in the      *
*   development of your applications.  The code is provided "AS IS",           *
*   without warranty of any kind.  IBM shall not be liable for any damages     *
*   arising out of your use of the sample code, even if they have been         *
*   advised of the possibility of such damages.                                *
*******************************************************************************/

#ifndef _IVBLAND_
  #include <ivbland.hpp>
#endif

#ifndef _INOTIFEV_
  #include <inotifev.hpp>
#endif


#pragma export (IVBLogicalAndPart::valueId,, 3100)
const INotificationId IVBLogicalAndPart::valueId =
                     "IVBLogicalAndPart::value";
#pragma export (IVBLogicalAndPart::input1Id,, 3101)
const INotificationId IVBLogicalAndPart::input1Id =
                     "IVBLogicalAndPart::input1";
#pragma export (IVBLogicalAndPart::input2Id,, 3102)
const INotificationId IVBLogicalAndPart::input2Id =
                     "IVBLogicalAndPart::input2";
#pragma export (IVBLogicalAndPart::input3Id,, 3103)
const INotificationId IVBLogicalAndPart::input3Id =
                     "IVBLogicalAndPart::input3";
#pragma export (IVBLogicalAndPart::input4Id,, 3104)
const INotificationId IVBLogicalAndPart::input4Id =
                     "IVBLogicalAndPart::input4";
#pragma export (IVBLogicalAndPart::input5Id,, 3105)
const INotificationId IVBLogicalAndPart::input5Id =
                     "IVBLogicalAndPart::input5";
#pragma export (IVBLogicalAndPart::input6Id,, 3106)
const INotificationId IVBLogicalAndPart::input6Id =
                     "IVBLogicalAndPart::input6";
#pragma export (IVBLogicalAndPart::input7Id,, 3107)
const INotificationId IVBLogicalAndPart::input7Id =
                     "IVBLogicalAndPart::input7";
#pragma export (IVBLogicalAndPart::input8Id,, 3108)
const INotificationId IVBLogicalAndPart::input8Id =
                     "IVBLogicalAndPart::input8";
#pragma export (IVBLogicalAndPart::input9Id,, 3109)
const INotificationId IVBLogicalAndPart::input9Id =
                     "IVBLogicalAndPart::input9";
#pragma export (IVBLogicalAndPart::input10Id,, 3110)
const INotificationId IVBLogicalAndPart::input10Id =
                     "IVBLogicalAndPart::input10";

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::IVBLogicalAndPart                                         |
|                                                                              |
| Standard constructor.                                                        |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::IVBLogicalAndPart(),, 3111)
IVBLogicalAndPart::IVBLogicalAndPart() : IVBDataTypePart ()
    ,iValue (defaultInput())
    ,iInput1 (defaultInput())
    ,iInput2 (defaultInput())
    ,iInput3 (defaultInput())
    ,iInput4 (defaultInput())
    ,iInput5 (defaultInput())
    ,iInput6 (defaultInput())
    ,iInput7 (defaultInput())
    ,iInput8 (defaultInput())
    ,iInput9 (defaultInput())
    ,iInput10 (defaultInput())
{
  enableNotification ();
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::IVBLogicalAndPart                                         |
|                                                                              |
| Standard copy constructor.                                                   |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::IVBLogicalAndPart(const IVBLogicalAndPart&),, 3112)
IVBLogicalAndPart::IVBLogicalAndPart (const IVBLogicalAndPart& partCopy)
  : IVBDataTypePart (partCopy)
    ,iInput1 (partCopy.input1 ())
    ,iInput2 (partCopy.input2 ())
    ,iInput3 (partCopy.input3 ())
    ,iInput4 (partCopy.input4 ())
    ,iInput5 (partCopy.input5 ())
    ,iInput6 (partCopy.input6 ())
    ,iInput7 (partCopy.input7 ())
    ,iInput8 (partCopy.input8 ())
    ,iInput9 (partCopy.input9 ())
    ,iInput10 (partCopy.input10 ())
{
  enableNotification ();
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::IVBLogicalAndPart                                         |
|                                                                              |
| Standard operator=                                                           |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::operator= (const IVBLogicalAndPart&),, 3113)
IVBLogicalAndPart& IVBLogicalAndPart::operator= (const IVBLogicalAndPart& aIVBLogicalAndPart)
{
  if (this == &aIVBLogicalAndPart) {
    return *this;
  } /* endif */
  Inherited::operator=(aIVBLogicalAndPart);
  setInput1(aIVBLogicalAndPart.input1());
  setInput2(aIVBLogicalAndPart.input2());
  setInput3(aIVBLogicalAndPart.input3());
  setInput4(aIVBLogicalAndPart.input4());
  setInput5(aIVBLogicalAndPart.input5());
  setInput6(aIVBLogicalAndPart.input6());
  setInput7(aIVBLogicalAndPart.input7());
  setInput8(aIVBLogicalAndPart.input8());
  setInput9(aIVBLogicalAndPart.input9());
  setInput10(aIVBLogicalAndPart.input10());
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::~IVBLogicalAndPart                                        |
|                                                                              |
| IVBLogicalAndPart destructor.                                                |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::~IVBLogicalAndPart(),, 3114)
IVBLogicalAndPart::~IVBLogicalAndPart()
{
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::asString                                                  |
|                                                                              |
| Perform asString.                                                            |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::asString() const,, 3115)
IString IVBLogicalAndPart::asString () const
{
  return valueAsText();
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::value                                                     |
|                                                                              |
| Return the value attribute.                                                  |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::value() const,, 3116)
Boolean IVBLogicalAndPart::value () const
{
  return iValue;
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::notValue                                                  |
|                                                                              |
| Return the notValue attribute.                                               |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::notValue() const,, 3117)
Boolean IVBLogicalAndPart::notValue () const
{
  return !value();
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::valueAsText                                               |
|                                                                              |
| Return the valueAsText attribute.                                            |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::valueAsText() const,, 3118)
IString IVBLogicalAndPart::valueAsText () const
{
  if (value()) {
    return IString("1");
  } ; /* endif */
  return IString("0");
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::input1                                                    |
|                                                                              |
| Return the input1 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::input1() const,, 3119)
Boolean IVBLogicalAndPart::input1 () const
{
  return iInput1;
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setInput1                                                 |
|                                                                              |
| Set the input1 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setInput1(const Boolean))
IVBLogicalAndPart& IVBLogicalAndPart::setInput1 (Boolean aInput1)
{
  if (iInput1 != aInput1) {
    iInput1 = aInput1;
    compute ();
    notifyObservers(INotificationEvent(input1Id, *this,
                    true, (void*)iInput1));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setInput1                                                 |
|                                                                              |
| Set the input1 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setInput1(),, 3121)
IVBLogicalAndPart& IVBLogicalAndPart::setInput1 ()
{
  return setInput1 (defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::input2                                                    |
|                                                                              |
| Return the input2 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::input2() const,, 3122)
Boolean IVBLogicalAndPart::input2 () const
{
  return iInput2;
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setInput2                                                 |
|                                                                              |
| Set the input2 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setInput2(const Boolean))
IVBLogicalAndPart& IVBLogicalAndPart::setInput2 (Boolean aInput2)
{
  if (iInput2 != aInput2) {
    iInput2 = aInput2;
    compute ();
    notifyObservers(INotificationEvent(input2Id, *this,
                    true, (void*)iInput2));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setInput2                                                 |
|                                                                              |
| Set the input2 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setInput2(),, 3124)
IVBLogicalAndPart& IVBLogicalAndPart::setInput2 ()
{
  return setInput2 (defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::input3                                                    |
|                                                                              |
| Return the input3 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::input3() const,, 3125)
Boolean IVBLogicalAndPart::input3 () const
{
  return iInput3;
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setInput3                                                 |
|                                                                              |
| Set the input3 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setInput3(const Boolean))
IVBLogicalAndPart& IVBLogicalAndPart::setInput3 (Boolean aInput3)
{
  if (iInput3 != aInput3) {
    iInput3 = aInput3;
    compute ();
    notifyObservers(INotificationEvent(input3Id, *this,
                    true, (void*)iInput3));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setInput3                                                 |
|                                                                              |
| Set the input3 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setInput3(),, 3127)
IVBLogicalAndPart& IVBLogicalAndPart::setInput3 ()
{
  return setInput3 (defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::input4                                                    |
|                                                                              |
| Return the input4 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::input4() const,, 3128)
Boolean IVBLogicalAndPart::input4 () const
{
  return iInput4;
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setInput4                                                 |
|                                                                              |
| Set the input4 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setInput4(const Boolean))
IVBLogicalAndPart& IVBLogicalAndPart::setInput4 (Boolean aInput4)
{
  if (iInput4 != aInput4) {
    iInput4 = aInput4;
    compute ();
    notifyObservers(INotificationEvent(input4Id, *this,
                    true, (void*)iInput4));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setInput4                                                 |
|                                                                              |
| Set the input4 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setInput4(),, 3130)
IVBLogicalAndPart& IVBLogicalAndPart::setInput4 ()
{
  return setInput4 (defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::input5                                                    |
|                                                                              |
| Return the input5 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::input5() const,, 3131)
Boolean IVBLogicalAndPart::input5 () const
{
  return iInput5;
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setInput5                                                 |
|                                                                              |
| Set the input5 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setInput5(const Boolean))
IVBLogicalAndPart& IVBLogicalAndPart::setInput5 (Boolean aInput5)
{
  if (iInput5 != aInput5) {
    iInput5 = aInput5;
    compute ();
    notifyObservers(INotificationEvent(input5Id, *this,
                    true, (void*)iInput5));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setInput5                                                 |
|                                                                              |
| Set the input5 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setInput5(),, 3133)
IVBLogicalAndPart& IVBLogicalAndPart::setInput5 ()
{
  return setInput5 (defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::input6                                                    |
|                                                                              |
| Return the input6 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::input6() const,, 3134)
Boolean IVBLogicalAndPart::input6 () const
{
  return iInput6;
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setInput6                                                 |
|                                                                              |
| Set the input6 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setInput6(const Boolean))
IVBLogicalAndPart& IVBLogicalAndPart::setInput6 (Boolean aInput6)
{
  if (iInput6 != aInput6) {
    iInput6 = aInput6;
    compute ();
    notifyObservers(INotificationEvent(input6Id, *this,
                    true, (void*)iInput6));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setInput6                                                 |
|                                                                              |
| Set the input6 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setInput6(),, 3136)
IVBLogicalAndPart& IVBLogicalAndPart::setInput6 ()
{
  return setInput6 (defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::input7                                                    |
|                                                                              |
| Return the input7 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::input7() const,, 3137)
Boolean IVBLogicalAndPart::input7 () const
{
  return iInput7;
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setInput7                                                 |
|                                                                              |
| Set the input7 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setInput7(const Boolean))
IVBLogicalAndPart& IVBLogicalAndPart::setInput7 (Boolean aInput7)
{
  if (iInput7 != aInput7) {
    iInput7 = aInput7;
    compute ();
    notifyObservers(INotificationEvent(input7Id, *this,
                    true, (void*)iInput7));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setInput7                                                 |
|                                                                              |
| Set the input7 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setInput7(),, 3139)
IVBLogicalAndPart& IVBLogicalAndPart::setInput7 ()
{
  return setInput7 (defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::input8                                                    |
|                                                                              |
| Return the input8 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::input8() const,, 3140)
Boolean IVBLogicalAndPart::input8 () const
{
  return iInput8;
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setInput8                                                 |
|                                                                              |
| Set the input8 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setInput8(const Boolean))
IVBLogicalAndPart& IVBLogicalAndPart::setInput8 (Boolean aInput8)
{
  if (iInput8 != aInput8) {
    iInput8 = aInput8;
    compute ();
    notifyObservers(INotificationEvent(input8Id, *this,
                    true, (void*)iInput8));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setInput8                                                 |
|                                                                              |
| Set the input8 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setInput8(),, 3142)
IVBLogicalAndPart& IVBLogicalAndPart::setInput8 ()
{
  return setInput8 (defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::input9                                                    |
|                                                                              |
| Return the input9 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::input9() const,, 3143)
Boolean IVBLogicalAndPart::input9 () const
{
  return iInput9;
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setInput9                                                 |
|                                                                              |
| Set the input9 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setInput9(const Boolean))
IVBLogicalAndPart& IVBLogicalAndPart::setInput9 (Boolean aInput9)
{
  if (iInput9 != aInput9) {
    iInput9 = aInput9;
    compute ();
    notifyObservers(INotificationEvent(input9Id, *this,
                    true, (void*)iInput9));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setInput9                                                 |
|                                                                              |
| Set the input9 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setInput9(),, 3145)
IVBLogicalAndPart& IVBLogicalAndPart::setInput9 ()
{
  return setInput9 (defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::input10                                                   |
|                                                                              |
| Return the input10 attribute.                                                |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::input10() const,, 3146)
Boolean IVBLogicalAndPart::input10 () const
{
  return iInput10;
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setInput10                                                |
|                                                                              |
| Set the input10 attribute.                                                   |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setInput10(const Boolean))
IVBLogicalAndPart& IVBLogicalAndPart::setInput10 (Boolean aInput10)
{
  if (iInput10 != aInput10) {
    iInput10 = aInput10;
    compute ();
    notifyObservers(INotificationEvent(input10Id, *this,
                    true, (void*)iInput10));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setInput10                                                |
|                                                                              |
| Set the input10 attribute.                                                   |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setInput10(),, 3148)
IVBLogicalAndPart& IVBLogicalAndPart::setInput10 ()
{
  return setInput10 (defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::notInput1                                                 |
|                                                                              |
| Return the notInput1 attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::notInput1() const,, 3149)
Boolean IVBLogicalAndPart::notInput1 () const
{
  return !input1();
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setNotInput1                                              |
|                                                                              |
| Set the notInput1 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setNotInput1(const Boolean),, 3150)
IVBLogicalAndPart& IVBLogicalAndPart::setNotInput1 (Boolean aNotInput1)
{
  return setInput1(!aNotInput1);
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setNotInput1                                              |
|                                                                              |
| Set the notInput1 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setNotInput1(),, 3151)
IVBLogicalAndPart& IVBLogicalAndPart::setNotInput1 ()
{
  return setNotInput1 (!defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::notInput2                                                 |
|                                                                              |
| Return the notInput2 attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::notInput2() const,, 3152)
Boolean IVBLogicalAndPart::notInput2 () const
{
  return !input2();
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setNotInput2                                              |
|                                                                              |
| Set the notInput2 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setNotInput2(const Boolean),, 3153)
IVBLogicalAndPart& IVBLogicalAndPart::setNotInput2 (Boolean aNotInput2)
{
  return setInput2(!aNotInput2);
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setNotInput2                                              |
|                                                                              |
| Set the notInput2 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setNotInput2(),, 3154)
IVBLogicalAndPart& IVBLogicalAndPart::setNotInput2 ()
{
  return setNotInput2 (!defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::notInput3                                                 |
|                                                                              |
| Return the notInput3 attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::notInput3() const,, 3155)
Boolean IVBLogicalAndPart::notInput3 () const
{
  return !input3();
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setNotInput3                                              |
|                                                                              |
| Set the notInput3 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setNotInput3(const Boolean),, 3156)
IVBLogicalAndPart& IVBLogicalAndPart::setNotInput3 (Boolean aNotInput3)
{
  return setInput3(!aNotInput3);
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setNotInput3                                              |
|                                                                              |
| Set the notInput3 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setNotInput3(),, 3157)
IVBLogicalAndPart& IVBLogicalAndPart::setNotInput3 ()
{
  return setNotInput3 (!defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::notInput4                                                 |
|                                                                              |
| Return the notInput4 attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::notInput4() const,, 3158)
Boolean IVBLogicalAndPart::notInput4 () const
{
  return !input4();
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setNotInput4                                              |
|                                                                              |
| Set the notInput4 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setNotInput4(const Boolean),, 3159)
IVBLogicalAndPart& IVBLogicalAndPart::setNotInput4 (Boolean aNotInput4)
{
  return setInput4(!aNotInput4);
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setNotInput4                                              |
|                                                                              |
| Set the notInput4 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setNotInput4(),, 3160)
IVBLogicalAndPart& IVBLogicalAndPart::setNotInput4 ()
{
  return setNotInput4 (!defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::notInput5                                                 |
|                                                                              |
| Return the notInput5 attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::notInput5() const,, 3161)
Boolean IVBLogicalAndPart::notInput5 () const
{
  return !input5();
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setNotInput5                                              |
|                                                                              |
| Set the notInput5 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setNotInput5(const Boolean),, 3162)
IVBLogicalAndPart& IVBLogicalAndPart::setNotInput5 (Boolean aNotInput5)
{
  return setInput5(!aNotInput5);
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setNotInput5                                              |
|                                                                              |
| Set the notInput5 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setNotInput5(),, 3163)
IVBLogicalAndPart& IVBLogicalAndPart::setNotInput5 ()
{
  return setNotInput5 (!defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::notInput6                                                 |
|                                                                              |
| Return the notInput6 attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::notInput6() const,, 3164)
Boolean IVBLogicalAndPart::notInput6 () const
{
  return !input6();
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setNotInput6                                              |
|                                                                              |
| Set the notInput6 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setNotInput6(const Boolean),, 3165)
IVBLogicalAndPart& IVBLogicalAndPart::setNotInput6 (Boolean aNotInput6)
{
  return setInput6(!aNotInput6);
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setNotInput6                                              |
|                                                                              |
| Set the notInput6 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setNotInput6(),, 3166)
IVBLogicalAndPart& IVBLogicalAndPart::setNotInput6 ()
{
  return setNotInput6 (!defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::notInput7                                                 |
|                                                                              |
| Return the notInput7 attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::notInput7() const,, 3167)
Boolean IVBLogicalAndPart::notInput7 () const
{
  return !input7();
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setNotInput7                                              |
|                                                                              |
| Set the notInput7 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setNotInput7(const Boolean),, 3168)
IVBLogicalAndPart& IVBLogicalAndPart::setNotInput7 (Boolean aNotInput7)
{
  return setInput7(!aNotInput7);
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setNotInput7                                              |
|                                                                              |
| Set the notInput7 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setNotInput7(),, 3169)
IVBLogicalAndPart& IVBLogicalAndPart::setNotInput7 ()
{
  return setNotInput7 (!defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::notInput8                                                 |
|                                                                              |
| Return the notInput8 attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::notInput8() const,, 3170)
Boolean IVBLogicalAndPart::notInput8 () const
{
  return !input8();
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setNotInput8                                              |
|                                                                              |
| Set the notInput8 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setNotInput8(const Boolean),, 3171)
IVBLogicalAndPart& IVBLogicalAndPart::setNotInput8 (Boolean aNotInput8)
{
  return setInput8(!aNotInput8);
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setNotInput8                                              |
|                                                                              |
| Set the notInput8 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setNotInput8(),, 3172)
IVBLogicalAndPart& IVBLogicalAndPart::setNotInput8 ()
{
  return setNotInput8 (!defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::notInput9                                                 |
|                                                                              |
| Return the notInput9 attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::notInput9() const,, 3173)
Boolean IVBLogicalAndPart::notInput9 () const
{
  return !input9();
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setNotInput9                                              |
|                                                                              |
| Set the notInput9 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setNotInput9(const Boolean),, 3174)
IVBLogicalAndPart& IVBLogicalAndPart::setNotInput9 (Boolean aNotInput9)
{
  return setInput9(!aNotInput9);
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setNotInput9                                              |
|                                                                              |
| Set the notInput9 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setNotInput9(),, 3175)
IVBLogicalAndPart& IVBLogicalAndPart::setNotInput9 ()
{
  return setNotInput9 (!defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::notInput10                                                |
|                                                                              |
| Return the notInput10 attribute.                                             |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::notInput10() const,, 3176)
Boolean IVBLogicalAndPart::notInput10 () const
{
  return !input10();
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setNotInput10                                             |
|                                                                              |
| Set the notInput10 attribute.                                                |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setNotInput10(const Boolean),, 3177)
IVBLogicalAndPart& IVBLogicalAndPart::setNotInput10 (Boolean aNotInput10)
{
  return setInput10(!aNotInput10);
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::setNotInput10                                             |
|                                                                              |
| Set the notInput10 attribute.                                                |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::setNotInput10(),, 3178)
IVBLogicalAndPart& IVBLogicalAndPart::setNotInput10 ()
{
  return setNotInput10 (!defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::defaultInput                                              |
|                                                                              |
| Return the defaultInput attribute.                                           |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::defaultInput() const,, 3179)
Boolean IVBLogicalAndPart::defaultInput () const
{
  return true;
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::compute                                                   |
|                                                                              |
| Perform the compute action.                                                  |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::compute(),, 3180)
IVBLogicalAndPart& IVBLogicalAndPart::compute ()
{
  Boolean aValue = (iInput1 &&
                    iInput2 &&
                    iInput3 &&
                    iInput4 &&
                    iInput5 &&
                    iInput6 &&
                    iInput7 &&
                    iInput9 &&
                    iInput10);
  if (iValue != aValue) {
    iValue = aValue;
    notifyObservers(INotificationEvent(valueId, *this,
                      true, (void*)iValue));
  } ; /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::operator == (const IVBLogicalAndPart & aValue)            |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::operator == (const IVBLogicalAndPart&) const,, 3181)
Boolean IVBLogicalAndPart::
  operator == (const IVBLogicalAndPart& aValue) const
{
  if (value() != aValue.value()) {
    return false;
  } /* endif */
  if (input1() != aValue.input1()) {
    return false;
  } /* endif */
  if (input2() != aValue.input2()) {
    return false;
  } /* endif */
  if (input3() != aValue.input3()) {
    return false;
  } /* endif */
  if (input4() != aValue.input4()) {
    return false;
  } /* endif */
  if (input5() != aValue.input5()) {
    return false;
  } /* endif */
  if (input6() != aValue.input6()) {
    return false;
  } /* endif */
  if (input7() != aValue.input7()) {
    return false;
  } /* endif */
  if (input8() != aValue.input8()) {
    return false;
  } /* endif */
  if (input9() != aValue.input9()) {
    return false;
  } /* endif */
  if (input10() != aValue.input10()) {
    return false;
  } /* endif */
  return true;
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::operator != (const IVBLogicalAndPart & aValue)            |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::operator != (const IVBLogicalAndPart&) const,, 3182)
Boolean IVBLogicalAndPart::
  operator != (const IVBLogicalAndPart& aValue) const
{
  if (value() != aValue.value()) {
    return true;
  } /* endif */
  if (input1() != aValue.input1()) {
    return true;
  } /* endif */
  if (input2() != aValue.input2()) {
    return true;
  } /* endif */
  if (input3() != aValue.input3()) {
    return true;
  } /* endif */
  if (input4() != aValue.input4()) {
    return true;
  } /* endif */
  if (input5() != aValue.input5()) {
    return true;
  } /* endif */
  if (input6() != aValue.input6()) {
    return true;
  } /* endif */
  if (input7() != aValue.input7()) {
    return true;
  } /* endif */
  if (input8() != aValue.input8()) {
    return true;
  } /* endif */
  if (input9() != aValue.input9()) {
    return true;
  } /* endif */
  if (input10() != aValue.input10()) {
    return true;
  } /* endif */
  return false;
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::operator == (const IVBLogicalAndPart * aValue)            |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::operator == (const IVBLogicalAndPart*) const,, 3183)
Boolean IVBLogicalAndPart::
  operator == (const IVBLogicalAndPart* aValue) const
{
  if (value() != aValue->value()) {
    return false;
  } /* endif */
  if (input1() != aValue->input1()) {
    return false;
  } /* endif */
  if (input2() != aValue->input2()) {
    return false;
  } /* endif */
  if (input3() != aValue->input3()) {
    return false;
  } /* endif */
  if (input4() != aValue->input4()) {
    return false;
  } /* endif */
  if (input5() != aValue->input5()) {
    return false;
  } /* endif */
  if (input6() != aValue->input6()) {
    return false;
  } /* endif */
  if (input7() != aValue->input7()) {
    return false;
  } /* endif */
  if (input8() != aValue->input8()) {
    return false;
  } /* endif */
  if (input9() != aValue->input9()) {
    return false;
  } /* endif */
  if (input10() != aValue->input10()) {
    return false;
  } /* endif */
  return true;
}

/*------------------------------------------------------------------------------
| IVBLogicalAndPart::operator != (const IVBLogicalAndPart * aValue)            |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalAndPart::operator != (const IVBLogicalAndPart*) const,, 3184)
Boolean IVBLogicalAndPart::
  operator != (const IVBLogicalAndPart* aValue) const
{
  if (value() != aValue->value()) {
    return true;
  } /* endif */
  if (input1() != aValue->input1()) {
    return true;
  } /* endif */
  if (input2() != aValue->input2()) {
    return true;
  } /* endif */
  if (input3() != aValue->input3()) {
    return true;
  } /* endif */
  if (input4() != aValue->input4()) {
    return true;
  } /* endif */
  if (input5() != aValue->input5()) {
    return true;
  } /* endif */
  if (input6() != aValue->input6()) {
    return true;
  } /* endif */
  if (input7() != aValue->input7()) {
    return true;
  } /* endif */
  if (input8() != aValue->input8()) {
    return true;
  } /* endif */
  if (input9() != aValue->input9()) {
    return true;
  } /* endif */
  if (input10() != aValue->input10()) {
    return true;
  } /* endif */
  return false;
}
