/*******************************************************************************
* FILE NAME: ivblong.cpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class(es):                                     *
*    IVBLongPart - IBM VB sample Long part.                                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
* DISCLAIMER OF WARRANTIES:                                                    *
*   The following [enclosed] code is sample code created by IBM                *
*   Corporation.  This sample code is not part of any standard IBM product     *
*   and is provided to you solely for the purpose of assisting you in the      *
*   development of your applications.  The code is provided "AS IS",           *
*   without warranty of any kind.  IBM shall not be liable for any damages     *
*   arising out of your use of the sample code, even if they have been         *
*   advised of the possibility of such damages.                                *
*******************************************************************************/

#ifndef _IVBLONG_
  #include <ivblong.hpp>
#endif

#ifndef _INOTIFEV_
  #include <inotifev.hpp>
#endif



/*------------------------------------------------------------------------------
| IVBLongPart::IVBLongPart                                                     |
|                                                                              |
| Standard constructor.                                                        |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::IVBLongPart(long aValue),, 2300)
IVBLongPart::IVBLongPart(long aValue) : IVBDataTypePart ()
    ,iValue (aValue)
    ,iDefaultValue (0)
    ,iLowLimit (LONG_MIN)
    ,iHighLimit (LONG_MAX)
{
  enableNotification ();
}

/*------------------------------------------------------------------------------
| IVBLongPart::IVBLongPart                                                     |
|                                                                              |
| Standard copy constructor.                                                   |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::IVBLongPart(const IVBLongPart&),, 2301)
IVBLongPart::IVBLongPart (const IVBLongPart& partCopy)
  : IVBDataTypePart (partCopy)
    ,iValue (partCopy.value ())
    ,iDefaultValue (partCopy.defaultValue ())
    ,iLowLimit (partCopy.lowLimit ())
    ,iHighLimit (partCopy.highLimit ())
{
  enableNotification ();
}

/*------------------------------------------------------------------------------
| IVBLongPart::IVBLongPart                                                     |
|                                                                              |
| Standard operator=                                                           |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::operator= (const IVBLongPart&),, 2302)
IVBLongPart& IVBLongPart::operator= (const IVBLongPart& aIVBLongPart)
{
  if (this == &aIVBLongPart) {
    return *this;
  } /* endif */
  Inherited::operator=(aIVBLongPart);
  setValue(aIVBLongPart.value());
  setDefaultValue(aIVBLongPart.defaultValue());
  setLowLimit(aIVBLongPart.lowLimit());
  setHighLimit(aIVBLongPart.highLimit());
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLongPart::~IVBLongPart                                                    |
|                                                                              |
| IVBLongPart destructor.                                                      |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::~IVBLongPart(),, 2303)
IVBLongPart::~IVBLongPart()
{
}

/*------------------------------------------------------------------------------
| IVBLongPart::asString                                                        |
|                                                                              |
| Perform asString.                                                            |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::asString() const,, 2304)
IString IVBLongPart::asString () const
{
  return valueAsText();
}

/*------------------------------------------------------------------------------
| IVBLongPart::value                                                           |
|                                                                              |
| Return the value attribute.                                                  |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::value() const,, 2305)
long IVBLongPart::value () const
{
  return iValue;
}

/*------------------------------------------------------------------------------
| IVBLongPart::setValue                                                        |
|                                                                              |
| Set the value attribute.                                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::setValue(const long),, 2306)
IVBLongPart& IVBLongPart::setValue (long aValue)
{
  if (iValue != aValue) {
    long oldValue = iValue;
    iValue = aValue;
    notifyObservers(INotificationEvent(valueId, *this,
                    true, (void*)iValue));
    if (iValue < 0) {
      if (!(oldValue < 0)) {
        notifyObservers(INotificationEvent(valueNegativeId, *this,
                        true, (void*)iValue));
      } ; /* endif */
    } ;
    if (iValue > 0) {
      if (!(oldValue > 0)) {
        notifyObservers(INotificationEvent(valuePositiveId, *this,
                        true, (void*)iValue));
      } ; /* endif */
    } ; /* endif */
    if (iValue == 0) {
      notifyObservers(INotificationEvent(valueZeroId, *this,
                      true, (void*)iValue));
    }
    else {
      if (oldValue == 0) {
        notifyObservers(INotificationEvent(valueNotZeroId, *this,
                        true, (void*)iValue));
      } ; /* endif */
    } ; /* endif */
    if (iDefaultValue == iValue) {
      notifyObservers(INotificationEvent(valueEqualDefaultId, *this,
                      true, (void*)iValue));
    }
    else {
      if (iDefaultValue == oldValue) {
        notifyObservers(INotificationEvent(valueNotEqualDefaultId, *this,
                        true, (void*)iValue));
      } /* endif */
    } /* endif */
    if (iValue == iLowLimit) {
      notifyObservers(INotificationEvent(valueEqualLowLimitId, *this,
                      true, (void*)iValue));
    } ; /* endif */
    if (iLowLimit != LONG_MIN) {
      if (iValue < iLowLimit) {
        if (!(oldValue < iLowLimit)) {
          notifyObservers(INotificationEvent(valueBelowLowLimitId, *this,
                          true, (void*)iValue));
        } ; /* endif */
      } ; /* endif */
    } ; /* endif */
    if (iValue == iHighLimit) {
      notifyObservers(INotificationEvent(valueEqualHighLimitId, *this,
                      true, (void*)iValue));
    } ; /* endif */
    if (iHighLimit != LONG_MAX) {
      if (iValue > iHighLimit) {
        if (!(oldValue > iHighLimit)) {
          notifyObservers(INotificationEvent(valueAboveHighLimitId, *this,
                          true, (void*)iValue));
        } ; /* endif */
      } ; /* endif */
    } ; /* endif */
    if ((iValue >= iLowLimit) && (iValue <= iHighLimit)) {
      if (!((oldValue >= iLowLimit) && (oldValue <= iHighLimit))) {
        notifyObservers(INotificationEvent(valueWithinLimitsId, *this,
                        true, (void*)iValue));
      } ; /* endif */
    }
    else {
      if (((oldValue >= iLowLimit) && (oldValue <= iHighLimit))) {
        notifyObservers(INotificationEvent(valueOutsideLimitsId, *this,
                        true, (void*)iValue));
      } ; /* endif */
    } ; /* endif */
  } ; /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLongPart::setValue                                                        |
|                                                                              |
| Set the value attribute.                                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::setValue(),, 2307)
IVBLongPart& IVBLongPart::setValue ()
{
  return setValue(defaultValue());
}

/*------------------------------------------------------------------------------
| IVBLongPart::valueAsText                                                     |
|                                                                              |
| Return the valueAsText attribute.                                            |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::valueAsText() const,, 2308)
IString IVBLongPart::valueAsText () const
{
  return IString (value());
}

/*------------------------------------------------------------------------------
| IVBLongPart::setValueAsText                                                  |
|                                                                              |
| Set the valueAsText attribute.                                               |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::setValueAsText(const IString&),, 2309)
IVBLongPart& IVBLongPart::setValueAsText (const IString& aValueAsText)
{
#ifdef IC_PM
  IString tempValueString(aValueAsText);
  setValue (aValueAsText.asInt());
  tempValueString = tempValueString.strip();

  IString firstCharOfString(tempValueString.subString(1,1));  //Gets 1st char of string
  Boolean testFirstChar=firstCharOfString.indexOfAnyOf("+-"); //Checks 2C if 1st char is + or -

  if (testFirstChar) {
     tempValueString=tempValueString.subString(2);            //Uses rest of string after sign
  } /* endif */

/*********************************************************************
  The use of the Following Statement allows you to have a string like

    "+    23"          be seen as an integer, which would be the same as
                "+23"  which is of course an integer
**********************************************************************/
  tempValueString = tempValueString.strip();

  Boolean iValid = tempValueString.indexOfAnyBut("0123456789");

  IString eventData(aValueAsText);
  if (!(iValid)) {
    notifyObservers(INotificationEvent(inputStringIsValidId, *this,
                      true, (void*)&eventData));
  } else {
    notifyObservers(INotificationEvent(inputStringNotValidId, *this,
                      true, (void*)&eventData));
  } /* endif */
#endif
#ifdef IC_WIN
  setValue (aValueAsText.asInt());
  Boolean iValid = aValueAsText.indexOfAnyBut("+-0123456789 ");
  if (iValid) {
    IString eventData(aValueAsText);
    notifyObservers(INotificationEvent(inputStringNotValidId, *this,
                      true, (void*)&eventData));
  } else {
    IString eventData(aValueAsText);
    notifyObservers(INotificationEvent(inputStringIsValidId, *this,
                      true, (void*)&eventData));
  } /* endif */
#endif
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLongPart::setValueAsText                                                  |
|                                                                              |
| Set the valueAsText attribute.                                               |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::setValueAsText(const IString*),, 2310)
IVBLongPart& IVBLongPart::setValueAsText (const IString* aValueAsText)
{
  return setValueAsText (*aValueAsText);
}

/*------------------------------------------------------------------------------
| IVBLongPart::valueAs1Based                                                   |
|                                                                              |
| Return the valueAs1Based attribute.                                          |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::valueAs1Based() const,, 2311)
long IVBLongPart::valueAs1Based () const
{
  return (value() + 1) ;
}

/*------------------------------------------------------------------------------
| IVBLongPart::setValueAs1Based                                                |
|                                                                              |
| Set the valueAs1Based attribute.                                             |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::setValueAs1Based(long),, 2312)
IVBLongPart& IVBLongPart::setValueAs1Based (long aValueAs1Based)
{
  return setValue (aValueAs1Based - 1);
}

/*------------------------------------------------------------------------------
| IVBLongPart::defaultValue                                                    |
|                                                                              |
| Return the defaultValue attribute.                                           |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::defaultValue() const,, 2313)
long IVBLongPart::defaultValue () const
{
  return iDefaultValue;
}

/*------------------------------------------------------------------------------
| IVBLongPart::setDefaultValue                                                 |
|                                                                              |
| Set the defaultValue attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::setDefaultValue(const long),, 2314)
IVBLongPart& IVBLongPart::setDefaultValue (long aDefaultValue)
{
  if (iDefaultValue != aDefaultValue) {
    long oldValue = iDefaultValue;
    iDefaultValue = aDefaultValue;
    notifyObservers(INotificationEvent(defaultValueId, *this,
                      true, (void*)iDefaultValue));
    if (iDefaultValue == iValue) {
      notifyObservers(INotificationEvent(valueEqualDefaultId, *this,
                      true, (void*)iValue));
    }
    else {
      if (oldValue == iValue) {
        notifyObservers(INotificationEvent(valueNotEqualDefaultId, *this,
                        true, (void*)iValue));
      } /* endif */
    } /* endif */
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLongPart::isValueEqualDefault                                             |
|                                                                              |
| Return the valueEqualDefault attribute.                                      |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::isValueEqualDefault() const,, 2315)
Boolean IVBLongPart::isValueEqualDefault () const
{
  return (value() == defaultValue ()) ;
}

/*------------------------------------------------------------------------------
| IVBLongPart::isValueNotEqualDefault                                          |
|                                                                              |
| Return the valueNotEqualDefault attribute.                                   |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::isValueNotEqualDefault() const,, 2316)
Boolean IVBLongPart::isValueNotEqualDefault () const
{
  return (value() != defaultValue ()) ;
}

/*------------------------------------------------------------------------------
| IVBLongPart::lowLimit                                                        |
|                                                                              |
| Return the lowLimit attribute.                                               |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::lowLimit() const,, 2317)
long IVBLongPart::lowLimit () const
{
  return iLowLimit;
}

/*------------------------------------------------------------------------------
| IVBLongPart::setLowLimit                                                     |
|                                                                              |
| Set the lowLimit attribute.                                                  |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::setLowLimit(const long),, 2318)
IVBLongPart& IVBLongPart::setLowLimit (long aLowLimit)
{
  if (iLowLimit != aLowLimit) {
    long oldValue = iLowLimit;
    iLowLimit = aLowLimit;
    notifyObservers(INotificationEvent(lowLimitId, *this,
                      true, (void*)iLowLimit));
    if (iValue == lowLimit()) {
      notifyObservers(INotificationEvent(valueEqualLowLimitId, *this,
                      true, (void*)iValue));
    } ; /* endif */
    if (lowLimit() != LONG_MIN) {
      if (iValue < iLowLimit) {
        if (!(iValue < oldValue)) {
          notifyObservers(INotificationEvent(valueBelowLowLimitId, *this,
                          true, (void*)iValue));
        } ; /* endif */
      } ; /* endif */
    } ; /* endif */
    if ((iValue >= lowLimit()) && (iValue <= highLimit())) {
      if (!((iValue >= oldValue) && (iValue <= highLimit()))) {
        notifyObservers(INotificationEvent(valueWithinLimitsId, *this,
                        true, (void*)iLowLimit));
      } ; /* endif */
    }
    else {
      if ((iValue >= oldValue) && (iValue <= highLimit())) {
        notifyObservers(INotificationEvent(valueOutsideLimitsId, *this,
                        true, (void*)iLowLimit));
      } ; /* endif */
    } ; /* endif */
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLongPart::highLimit                                                       |
|                                                                              |
| Return the highLimit attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::highLimit() const,, 2319)
long IVBLongPart::highLimit () const
{
  return iHighLimit;
}

/*------------------------------------------------------------------------------
| IVBLongPart::setHighLimit                                                    |
|                                                                              |
| Set the highLimit attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::setHighLimit(const long),, 2320)
IVBLongPart& IVBLongPart::setHighLimit (long aHighLimit)
{
  if (iHighLimit != aHighLimit) {
    long oldValue = iHighLimit;
    iHighLimit = aHighLimit;
    notifyObservers(INotificationEvent(highLimitId, *this,
                      true, (void*)iHighLimit));
    if (iValue == highLimit()) {
      notifyObservers(INotificationEvent(valueEqualHighLimitId, *this,
                      true, (void*)iValue));
    } ; /* endif */
    if (highLimit() != LONG_MAX) {
      if (iValue > iHighLimit) {
        if (!(iValue > oldValue)) {
          notifyObservers(INotificationEvent(valueAboveHighLimitId, *this,
                          true, (void*)iValue));
        } ; /* endif */
      } ; /* endif */
    } ; /* endif */
    if ((iValue >= lowLimit()) && (iValue <= highLimit())) {
      if (!((iValue >= lowLimit()) && (iValue <= oldValue))) {
        notifyObservers(INotificationEvent(valueWithinLimitsId, *this,
                        true, (void*)iHighLimit));
      } ; /* endif */
    }
    else {
      if ((iValue >= lowLimit()) && (iValue <= oldValue)) {
        notifyObservers(INotificationEvent(valueOutsideLimitsId, *this,
                        true, (void*)iHighLimit));
      } ; /* endif */
    } ; /* endif */
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLongPart::isValueEqualLowLimit                                            |
|                                                                              |
| Return the valueEqualLowLimit attribute.                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::isValueEqualLowLimit() const,, 2321)
Boolean IVBLongPart::isValueEqualLowLimit () const
{
  return (value() == lowLimit ()) ;
}

/*------------------------------------------------------------------------------
| IVBLongPart::isValueEqualHighLimit                                           |
|                                                                              |
| Return the valueEqualHighLimit attribute.                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::isValueEqualHighLimit() const,, 2322)
Boolean IVBLongPart::isValueEqualHighLimit () const
{
  return (value() == highLimit ()) ;
}

/*------------------------------------------------------------------------------
| IVBLongPart::isValueBelowLowLimit                                            |
|                                                                              |
| Return the valueBelowLowLimit attribute.                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::isValueBelowLowLimit() const,, 2323)
Boolean IVBLongPart::isValueBelowLowLimit () const
{
  return (value() < lowLimit ()) ;
}

/*------------------------------------------------------------------------------
| IVBLongPart::isValueAboveHighLimit                                           |
|                                                                              |
| Return the valueAboveHighLimit attribute.                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::isValueAboveHighLimit() const,, 2324)
Boolean IVBLongPart::isValueAboveHighLimit () const
{
  return (value() > highLimit ()) ;
}

/*------------------------------------------------------------------------------
| IVBLongPart::isValueOutsideLimits                                            |
|                                                                              |
| Return the valueOutsideLimits attribute.                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::isValueOutsideLimits() const,, 2325)
Boolean IVBLongPart::isValueOutsideLimits () const
{
  return ((value() < lowLimit()) || (value() > highLimit())) ;
}

/*------------------------------------------------------------------------------
| IVBLongPart::isValueWithinLimits                                             |
|                                                                              |
| Return the valueWithinLimits attribute.                                      |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::isValueWithinLimits() const,, 2326)
Boolean IVBLongPart::isValueWithinLimits () const
{
  return !isValueOutsideLimits ();
}

/*------------------------------------------------------------------------------
| IVBLongPart::isValueNotZero                                                  |
|                                                                              |
| Return the valueNotZero attribute.                                           |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::isValueNotZero() const,, 2327)
Boolean IVBLongPart::isValueNotZero () const
{
  return (value() != 0) ;
}

/*------------------------------------------------------------------------------
| IVBLongPart::isValueZero                                                     |
|                                                                              |
| Return the valueZero attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::isValueZero() const,, 2328)
Boolean IVBLongPart::isValueZero () const
{
  return (value() == 0) ;
}

/*------------------------------------------------------------------------------
| IVBLongPart::isValuePositive                                                 |
|                                                                              |
| Return the valuePositive attribute.                                          |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::isValuePositive() const,, 2329)
Boolean IVBLongPart::isValuePositive () const
{
  return (value() > 0) ;
}

/*------------------------------------------------------------------------------
| IVBLongPart::isValueNegative                                                 |
|                                                                              |
| Return the valueNegative attribute.                                          |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::isValueNegative() const,, 2330)
Boolean IVBLongPart::isValueNegative () const
{
  return (value() < 0) ;
}

/*------------------------------------------------------------------------------
| IVBLongPart::assignValueToZero                                               |
|                                                                              |
| Assign the value attribute to 0.                                             |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::assignValueToZero(),, 2331)
IVBLongPart& IVBLongPart::assignValueToZero ()
{
  return setValue (0) ;
}

/*------------------------------------------------------------------------------
| IVBLongPart::assignValueToOne                                                |
|                                                                              |
| Assign the value attribute to 1.                                             |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::assignValueToOne(),, 2332)
IVBLongPart& IVBLongPart::assignValueToOne ()
{
  return setValue (1) ;
}

/*------------------------------------------------------------------------------
| IVBLongPart::assignValueToLowLimit                                           |
|                                                                              |
| Assign the value attribute to low limit attribute.                           |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::assignValueToLowLimit(),, 2333)
IVBLongPart& IVBLongPart::assignValueToLowLimit ()
{
  return setValue (lowLimit()) ;
}

/*------------------------------------------------------------------------------
| IVBLongPart::assignValueToHighLimit                                          |
|                                                                              |
| Assign the value attribute to high limit attribute.                          |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::assignValueToHighLimit(),, 2334)
IVBLongPart& IVBLongPart::assignValueToHighLimit ()
{
  return setValue (highLimit()) ;
}

/*------------------------------------------------------------------------------
| IVBLongPart::assignValueToDefault                                            |
|                                                                              |
| Assign the value attribute to default.                                       |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::assignValueToDefault(),, 2335)
IVBLongPart& IVBLongPart::assignValueToDefault ()
{
  return setValue (defaultValue ()) ;
}

/*------------------------------------------------------------------------------
| IVBLongPart::assignValueToRandom                                             |
|                                                                              |
| Assign the value attribute to a pseudo-random number.                        |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::assignValueToRandom(),, 2336)
IVBLongPart& IVBLongPart::assignValueToRandom ()
{
  return setValue (rand ()) ;
}

/*------------------------------------------------------------------------------
| IVBLongPart::copyValueToDefault                                              |
|                                                                              |
| Copy the value attribute to default.                                         |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::copyValueToDefault(),, 2337)
IVBLongPart& IVBLongPart::copyValueToDefault ()
{
  return setDefaultValue (value()) ;
}

/*------------------------------------------------------------------------------
| IVBLongPart::squareValue                                                     |
|                                                                              |
| Square the value attribute.                                                  |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::squareValue(),, 2338)
IVBLongPart& IVBLongPart::squareValue()
{
  return setValue (value() * value()) ;
}

/*------------------------------------------------------------------------------
| IVBLongPart::addValue                                                        |
|                                                                              |
| Perform the add operator to the value attribute.                             |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::addValue (long),, 2339)
IVBLongPart& IVBLongPart::addValue (long addValue)
{
  return setValue (value() + addValue) ;
}

/*------------------------------------------------------------------------------
| IVBLongPart::subtractValue                                                   |
|                                                                              |
| Perform the subtract operator to the value attribute.                        |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::subtractValue (long),, 2340)
IVBLongPart& IVBLongPart::subtractValue (long subtractValue)
{
  return setValue (value() - subtractValue) ;
}

/*------------------------------------------------------------------------------
| IVBLongPart::multiplyValue                                                   |
|                                                                              |
| Perform the multiply operator to the value attribute.                        |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::multiplyValue (long),, 2341)
IVBLongPart& IVBLongPart::multiplyValue (long multiplyValue)
{
  return setValue (value() * multiplyValue) ;
}

/*------------------------------------------------------------------------------
| IVBLongPart::divideValue                                                    |
|                                                                             |
| Perform the divide operator to the value attribute.                         |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::divideValue (long),, 2342)
IVBLongPart& IVBLongPart::divideValue (long divideValue)
{
  if (divideValue)
    return setValue (value() / divideValue) ;
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLongPart::andValue                                                        |
|                                                                              |
| Perform the and operator to the value attribute.                             |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::andValue (long),, 2343)
IVBLongPart& IVBLongPart::andValue (long andValue)
{
  return setValue (value() & andValue) ;
}

/*------------------------------------------------------------------------------
| IVBLongPart::orValue                                                         |
|                                                                              |
| Perform the or operator to the value attribute.                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::orValue (long),, 2344)
IVBLongPart& IVBLongPart::orValue (long orValue)
{
  return setValue (value() | orValue) ;
}

/*------------------------------------------------------------------------------
| IVBLongPart::operator == (const IVBLongPart & aValue)                        |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::operator == (const IVBLongPart&) const,, 2345)
Boolean IVBLongPart::
  operator == (const IVBLongPart& aValue) const
{
  if (value() != aValue.value()) {
    return false;
  } /* endif */
  if (defaultValue() != aValue.defaultValue()) {
    return false;
  } /* endif */
  if (lowLimit() != aValue.lowLimit()) {
    return false;
  } /* endif */
  if (highLimit() != aValue.highLimit()) {
    return false;
  } /* endif */
  return true;
}

/*------------------------------------------------------------------------------
| IVBLongPart::operator != (const IVBLongPart & aValue)                        |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::operator != (const IVBLongPart&) const,, 2346)
Boolean IVBLongPart::
  operator != (const IVBLongPart& aValue) const
{
  if (value() != aValue.value()) {
    return true;
  } /* endif */
  if (defaultValue() != aValue.defaultValue()) {
    return true;
  } /* endif */
  if (lowLimit() != aValue.lowLimit()) {
    return true;
  } /* endif */
  if (highLimit() != aValue.highLimit()) {
    return true;
  } /* endif */
  return false;
}

/*------------------------------------------------------------------------------
| IVBLongPart::operator == (const IVBLongPart * aValue)                        |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::operator == (const IVBLongPart*) const,, 2347)
Boolean IVBLongPart::
  operator == (const IVBLongPart* aValue) const
{
  if (value() != aValue->value()) {
    return false;
  } /* endif */
  if (defaultValue() != aValue->defaultValue()) {
    return false;
  } /* endif */
  if (lowLimit() != aValue->lowLimit()) {
    return false;
  } /* endif */
  if (highLimit() != aValue->highLimit()) {
    return false;
  } /* endif */
  return true;
}

/*------------------------------------------------------------------------------
| IVBLongPart::operator != (const IVBLongPart * aValue)                        |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLongPart::operator != (const IVBLongPart*) const,, 2348)
Boolean IVBLongPart::
  operator != (const IVBLongPart* aValue) const
{
  if (value() != aValue->value()) {
    return true;
  } /* endif */
  if (defaultValue() != aValue->defaultValue()) {
    return true;
  } /* endif */
  if (lowLimit() != aValue->lowLimit()) {
    return true;
  } /* endif */
  if (highLimit() != aValue->highLimit()) {
    return true;
  } /* endif */
  return false;
}
