/*******************************************************************************
* FILE NAME: ivblor.cpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class(es):                                     *
*    IVBLogicalOrPart - VB Logical Or Part.                                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
* DISCLAIMER OF WARRANTIES:                                                    *
*   The following [enclosed] code is sample code created by IBM                *
*   Corporation.  This sample code is not part of any standard IBM product     *
*   and is provided to you solely for the purpose of assisting you in the      *
*   development of your applications.  The code is provided "AS IS",           *
*   without warranty of any kind.  IBM shall not be liable for any damages     *
*   arising out of your use of the sample code, even if they have been         *
*   advised of the possibility of such damages.                                *
*******************************************************************************/

#ifndef _IVBLOR_
  #include <ivblor.hpp>
#endif

#ifndef _INOTIFEV_
  #include <inotifev.hpp>
#endif


#pragma export (IVBLogicalOrPart::valueId,, 3000)
const INotificationId IVBLogicalOrPart::valueId =
                     "IVBLogicalOrPart::value";
#pragma export (IVBLogicalOrPart::input1Id,, 3001)
const INotificationId IVBLogicalOrPart::input1Id =
                     "IVBLogicalOrPart::input1";
#pragma export (IVBLogicalOrPart::input2Id,, 3002)
const INotificationId IVBLogicalOrPart::input2Id =
                     "IVBLogicalOrPart::input2";
#pragma export (IVBLogicalOrPart::input3Id,, 3003)
const INotificationId IVBLogicalOrPart::input3Id =
                     "IVBLogicalOrPart::input3";
#pragma export (IVBLogicalOrPart::input4Id,, 3004)
const INotificationId IVBLogicalOrPart::input4Id =
                     "IVBLogicalOrPart::input4";
#pragma export (IVBLogicalOrPart::input5Id,, 3005)
const INotificationId IVBLogicalOrPart::input5Id =
                     "IVBLogicalOrPart::input5";
#pragma export (IVBLogicalOrPart::input6Id,, 3006)
const INotificationId IVBLogicalOrPart::input6Id =
                     "IVBLogicalOrPart::input6";
#pragma export (IVBLogicalOrPart::input7Id,, 3007)
const INotificationId IVBLogicalOrPart::input7Id =
                     "IVBLogicalOrPart::input7";
#pragma export (IVBLogicalOrPart::input8Id,, 3008)
const INotificationId IVBLogicalOrPart::input8Id =
                     "IVBLogicalOrPart::input8";
#pragma export (IVBLogicalOrPart::input9Id,, 3009)
const INotificationId IVBLogicalOrPart::input9Id =
                     "IVBLogicalOrPart::input9";
#pragma export (IVBLogicalOrPart::input10Id,, 3010)
const INotificationId IVBLogicalOrPart::input10Id =
                     "IVBLogicalOrPart::input10";

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::IVBLogicalOrPart                                           |
|                                                                              |
| Standard constructor.                                                        |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::IVBLogicalOrPart(),, 3011)
IVBLogicalOrPart::IVBLogicalOrPart() : IVBDataTypePart ()
    ,iValue (defaultInput())
    ,iInput1 (defaultInput())
    ,iInput2 (defaultInput())
    ,iInput3 (defaultInput())
    ,iInput4 (defaultInput())
    ,iInput5 (defaultInput())
    ,iInput6 (defaultInput())
    ,iInput7 (defaultInput())
    ,iInput8 (defaultInput())
    ,iInput9 (defaultInput())
    ,iInput10 (defaultInput())
{
  enableNotification ();
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::IVBLogicalOrPart                                           |
|                                                                              |
| Standard copy constructor.                                                   |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::IVBLogicalOrPart(const IVBLogicalOrPart&),, 3012)
IVBLogicalOrPart::IVBLogicalOrPart (const IVBLogicalOrPart& partCopy)
  : IVBDataTypePart (partCopy)
    ,iInput1 (partCopy.input1 ())
    ,iInput2 (partCopy.input2 ())
    ,iInput3 (partCopy.input3 ())
    ,iInput4 (partCopy.input4 ())
    ,iInput5 (partCopy.input5 ())
    ,iInput6 (partCopy.input6 ())
    ,iInput7 (partCopy.input7 ())
    ,iInput8 (partCopy.input8 ())
    ,iInput9 (partCopy.input9 ())
    ,iInput10 (partCopy.input10 ())
{
  enableNotification ();
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::IVBLogicalOrPart                                           |
|                                                                              |
| Standard operator=                                                           |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::operator= (const IVBLogicalOrPart&),, 3013)
IVBLogicalOrPart& IVBLogicalOrPart::operator= (const IVBLogicalOrPart& aIVBLogicalOrPart)
{
  if (this == &aIVBLogicalOrPart) {
    return *this;
  } /* endif */
  Inherited::operator=(aIVBLogicalOrPart);
  setInput1(aIVBLogicalOrPart.input1());
  setInput2(aIVBLogicalOrPart.input2());
  setInput3(aIVBLogicalOrPart.input3());
  setInput4(aIVBLogicalOrPart.input4());
  setInput5(aIVBLogicalOrPart.input5());
  setInput6(aIVBLogicalOrPart.input6());
  setInput7(aIVBLogicalOrPart.input7());
  setInput8(aIVBLogicalOrPart.input8());
  setInput9(aIVBLogicalOrPart.input9());
  setInput10(aIVBLogicalOrPart.input10());
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::~IVBLogicalOrPart                                          |
|                                                                              |
| IVBLogicalOrPart destructor.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::~IVBLogicalOrPart(),, 3014)
IVBLogicalOrPart::~IVBLogicalOrPart()
{
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::asString                                                   |
|                                                                              |
| Perform asString.                                                            |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::asString() const,, 3015)
IString IVBLogicalOrPart::asString () const
{
  return valueAsText();
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::value                                                      |
|                                                                              |
| Return the value attribute.                                                  |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::value() const,, 3016)
Boolean IVBLogicalOrPart::value () const
{
  return iValue;
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::notValue                                                   |
|                                                                              |
| Return the notValue attribute.                                               |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::notValue() const,, 3017)
Boolean IVBLogicalOrPart::notValue () const
{
  return !value();
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::valueAsText                                                |
|                                                                              |
| Return the valueAsText attribute.                                            |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::valueAsText() const,, 3018)
IString IVBLogicalOrPart::valueAsText () const
{
  if (value()) {
    return IString("1");
  } ; /* endif */
  return IString("0");
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::input1                                                     |
|                                                                              |
| Return the input1 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::input1() const,, 3019)
Boolean IVBLogicalOrPart::input1 () const
{
  return iInput1;
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setInput1                                                  |
|                                                                              |
| Set the input1 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setInput1(const Boolean))
IVBLogicalOrPart& IVBLogicalOrPart::setInput1 (Boolean aInput1)
{
  if (iInput1 != aInput1) {
    iInput1 = aInput1;
    compute ();
    notifyObservers(INotificationEvent(input1Id, *this,
                    true, (void*)iInput1));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setInput1                                                  |
|                                                                              |
| Set the input1 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setInput1(),, 3021)
IVBLogicalOrPart& IVBLogicalOrPart::setInput1 ()
{
  return setInput1 (defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::input2                                                     |
|                                                                              |
| Return the input2 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::input2() const,, 3022)
Boolean IVBLogicalOrPart::input2 () const
{
  return iInput2;
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setInput2                                                  |
|                                                                              |
| Set the input2 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setInput2(const Boolean))
IVBLogicalOrPart& IVBLogicalOrPart::setInput2 (Boolean aInput2)
{
  if (iInput2 != aInput2) {
    iInput2 = aInput2;
    compute ();
    notifyObservers(INotificationEvent(input2Id, *this,
                    true, (void*)iInput2));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setInput2                                                  |
|                                                                              |
| Set the input2 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setInput2(),, 3024)
IVBLogicalOrPart& IVBLogicalOrPart::setInput2 ()
{
  return setInput2 (defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::input3                                                     |
|                                                                              |
| Return the input3 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::input3() const,, 3025)
Boolean IVBLogicalOrPart::input3 () const
{
  return iInput3;
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setInput3                                                  |
|                                                                              |
| Set the input3 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setInput3(const Boolean))
IVBLogicalOrPart& IVBLogicalOrPart::setInput3 (Boolean aInput3)
{
  if (iInput3 != aInput3) {
    iInput3 = aInput3;
    compute ();
    notifyObservers(INotificationEvent(input3Id, *this,
                    true, (void*)iInput3));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setInput3                                                  |
|                                                                              |
| Set the input3 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setInput3(),, 3027)
IVBLogicalOrPart& IVBLogicalOrPart::setInput3 ()
{
  return setInput3 (defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::input4                                                     |
|                                                                              |
| Return the input4 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::input4() const,, 3028)
Boolean IVBLogicalOrPart::input4 () const
{
  return iInput4;
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setInput4                                                  |
|                                                                              |
| Set the input4 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setInput4(const Boolean))
IVBLogicalOrPart& IVBLogicalOrPart::setInput4 (Boolean aInput4)
{
  if (iInput4 != aInput4) {
    iInput4 = aInput4;
    compute ();
    notifyObservers(INotificationEvent(input4Id, *this,
                    true, (void*)iInput4));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setInput4                                                  |
|                                                                              |
| Set the input4 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setInput4(),, 3030)
IVBLogicalOrPart& IVBLogicalOrPart::setInput4 ()
{
  return setInput4 (defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::input5                                                     |
|                                                                              |
| Return the input5 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::input5() const,, 3031)
Boolean IVBLogicalOrPart::input5 () const
{
  return iInput5;
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setInput5                                                  |
|                                                                              |
| Set the input5 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setInput5(const Boolean))
IVBLogicalOrPart& IVBLogicalOrPart::setInput5 (Boolean aInput5)
{
  if (iInput5 != aInput5) {
    iInput5 = aInput5;
    compute ();
    notifyObservers(INotificationEvent(input5Id, *this,
                    true, (void*)iInput5));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setInput5                                                  |
|                                                                              |
| Set the input5 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setInput5(),, 3033)
IVBLogicalOrPart& IVBLogicalOrPart::setInput5 ()
{
  return setInput5 (defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::input6                                                     |
|                                                                              |
| Return the input6 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::input6() const,, 3034)
Boolean IVBLogicalOrPart::input6 () const
{
  return iInput6;
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setInput6                                                  |
|                                                                              |
| Set the input6 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setInput6(const Boolean))
IVBLogicalOrPart& IVBLogicalOrPart::setInput6 (Boolean aInput6)
{
  if (iInput6 != aInput6) {
    iInput6 = aInput6;
    compute ();
    notifyObservers(INotificationEvent(input6Id, *this,
                    true, (void*)iInput6));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setInput6                                                  |
|                                                                              |
| Set the input6 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setInput6(),, 3036)
IVBLogicalOrPart& IVBLogicalOrPart::setInput6 ()
{
  return setInput6 (defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::input7                                                     |
|                                                                              |
| Return the input7 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::input7() const,, 3037)
Boolean IVBLogicalOrPart::input7 () const
{
  return iInput7;
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setInput7                                                  |
|                                                                              |
| Set the input7 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setInput7(const Boolean))
IVBLogicalOrPart& IVBLogicalOrPart::setInput7 (Boolean aInput7)
{
  if (iInput7 != aInput7) {
    iInput7 = aInput7;
    compute ();
    notifyObservers(INotificationEvent(input7Id, *this,
                    true, (void*)iInput7));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setInput7                                                  |
|                                                                              |
| Set the input7 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setInput7(),, 3039)
IVBLogicalOrPart& IVBLogicalOrPart::setInput7 ()
{
  return setInput7 (defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::input8                                                     |
|                                                                              |
| Return the input8 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::input8() const,, 3040)
Boolean IVBLogicalOrPart::input8 () const
{
  return iInput8;
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setInput8                                                  |
|                                                                              |
| Set the input8 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setInput8(const Boolean))
IVBLogicalOrPart& IVBLogicalOrPart::setInput8 (Boolean aInput8)
{
  if (iInput8 != aInput8) {
    iInput8 = aInput8;
    compute ();
    notifyObservers(INotificationEvent(input8Id, *this,
                    true, (void*)iInput8));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setInput8                                                  |
|                                                                              |
| Set the input8 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setInput8(),, 3042)
IVBLogicalOrPart& IVBLogicalOrPart::setInput8 ()
{
  return setInput8 (defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::input9                                                     |
|                                                                              |
| Return the input9 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::input9() const,, 3043)
Boolean IVBLogicalOrPart::input9 () const
{
  return iInput9;
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setInput9                                                  |
|                                                                              |
| Set the input9 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setInput9(const Boolean))
IVBLogicalOrPart& IVBLogicalOrPart::setInput9 (Boolean aInput9)
{
  if (iInput9 != aInput9) {
    iInput9 = aInput9;
    compute ();
    notifyObservers(INotificationEvent(input9Id, *this,
                    true, (void*)iInput9));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setInput9                                                  |
|                                                                              |
| Set the input9 attribute.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setInput9(),, 3045)
IVBLogicalOrPart& IVBLogicalOrPart::setInput9 ()
{
  return setInput9 (defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::input10                                                    |
|                                                                              |
| Return the input10 attribute.                                                |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::input10() const,, 3046)
Boolean IVBLogicalOrPart::input10 () const
{
  return iInput10;
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setInput10                                                 |
|                                                                              |
| Set the input10 attribute.                                                   |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setInput10(const Boolean))
IVBLogicalOrPart& IVBLogicalOrPart::setInput10 (Boolean aInput10)
{
  if (iInput10 != aInput10) {
    iInput10 = aInput10;
    compute ();
    notifyObservers(INotificationEvent(input10Id, *this,
                    true, (void*)iInput10));
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setInput10                                                 |
|                                                                              |
| Set the input10 attribute.                                                   |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setInput10(),, 3048)
IVBLogicalOrPart& IVBLogicalOrPart::setInput10 ()
{
  return setInput10 (defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::notInput1                                                  |
|                                                                              |
| Return the notInput1 attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::notInput1() const,, 3049)
Boolean IVBLogicalOrPart::notInput1 () const
{
  return !input1();
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setNotInput1                                               |
|                                                                              |
| Set the notInput1 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setNotInput1(const Boolean),, 3050)
IVBLogicalOrPart& IVBLogicalOrPart::setNotInput1 (Boolean aNotInput1)
{
  return setInput1(!aNotInput1);
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setNotInput1                                               |
|                                                                              |
| Set the notInput1 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setNotInput1(),, 3051)
IVBLogicalOrPart& IVBLogicalOrPart::setNotInput1 ()
{
  return setNotInput1 (!defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::notInput2                                                  |
|                                                                              |
| Return the notInput2 attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::notInput2() const,, 3052)
Boolean IVBLogicalOrPart::notInput2 () const
{
  return !input2();
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setNotInput2                                               |
|                                                                              |
| Set the notInput2 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setNotInput2(const Boolean),, 3053)
IVBLogicalOrPart& IVBLogicalOrPart::setNotInput2 (Boolean aNotInput2)
{
  return setInput2(!aNotInput2);
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setNotInput2                                               |
|                                                                              |
| Set the notInput2 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setNotInput2(),, 3054)
IVBLogicalOrPart& IVBLogicalOrPart::setNotInput2 ()
{
  return setNotInput2 (!defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::notInput3                                                  |
|                                                                              |
| Return the notInput3 attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::notInput3() const,, 3055)
Boolean IVBLogicalOrPart::notInput3 () const
{
  return !input3();
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setNotInput3                                               |
|                                                                              |
| Set the notInput3 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setNotInput3(const Boolean),, 3056)
IVBLogicalOrPart& IVBLogicalOrPart::setNotInput3 (Boolean aNotInput3)
{
  return setInput3(!aNotInput3);
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setNotInput3                                               |
|                                                                              |
| Set the notInput3 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setNotInput3(),, 3057)
IVBLogicalOrPart& IVBLogicalOrPart::setNotInput3 ()
{
  return setNotInput3 (!defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::notInput4                                                  |
|                                                                              |
| Return the notInput4 attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::notInput4() const,, 3058)
Boolean IVBLogicalOrPart::notInput4 () const
{
  return !input4();
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setNotInput4                                               |
|                                                                              |
| Set the notInput4 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setNotInput4(const Boolean),, 3059)
IVBLogicalOrPart& IVBLogicalOrPart::setNotInput4 (Boolean aNotInput4)
{
  return setInput4(!aNotInput4);
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setNotInput4                                               |
|                                                                              |
| Set the notInput4 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setNotInput4(),, 3060)
IVBLogicalOrPart& IVBLogicalOrPart::setNotInput4 ()
{
  return setNotInput4 (!defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::notInput5                                                  |
|                                                                              |
| Return the notInput5 attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::notInput5() const,, 3061)
Boolean IVBLogicalOrPart::notInput5 () const
{
  return !input5();
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setNotInput5                                               |
|                                                                              |
| Set the notInput5 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setNotInput5(const Boolean),, 3062)
IVBLogicalOrPart& IVBLogicalOrPart::setNotInput5 (Boolean aNotInput5)
{
  return setInput5(!aNotInput5);
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setNotInput5                                               |
|                                                                              |
| Set the notInput5 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setNotInput5(),, 3063)
IVBLogicalOrPart& IVBLogicalOrPart::setNotInput5 ()
{
  return setNotInput5 (!defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::notInput6                                                  |
|                                                                              |
| Return the notInput6 attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::notInput6() const,, 3064)
Boolean IVBLogicalOrPart::notInput6 () const
{
  return !input6();
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setNotInput6                                               |
|                                                                              |
| Set the notInput6 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setNotInput6(const Boolean),, 3065)
IVBLogicalOrPart& IVBLogicalOrPart::setNotInput6 (Boolean aNotInput6)
{
  return setInput6(!aNotInput6);
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setNotInput6                                               |
|                                                                              |
| Set the notInput6 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setNotInput6(),, 3066)
IVBLogicalOrPart& IVBLogicalOrPart::setNotInput6 ()
{
  return setNotInput6 (!defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::notInput7                                                  |
|                                                                              |
| Return the notInput7 attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::notInput7() const,, 3067)
Boolean IVBLogicalOrPart::notInput7 () const
{
  return !input7();
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setNotInput7                                               |
|                                                                              |
| Set the notInput7 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setNotInput7(const Boolean),, 3068)
IVBLogicalOrPart& IVBLogicalOrPart::setNotInput7 (Boolean aNotInput7)
{
  return setInput7(!aNotInput7);
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setNotInput7                                               |
|                                                                              |
| Set the notInput7 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setNotInput7(),, 3069)
IVBLogicalOrPart& IVBLogicalOrPart::setNotInput7 ()
{
  return setNotInput7 (!defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::notInput8                                                  |
|                                                                              |
| Return the notInput8 attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::notInput8() const,, 3070)
Boolean IVBLogicalOrPart::notInput8 () const
{
  return !input8();
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setNotInput8                                               |
|                                                                              |
| Set the notInput8 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setNotInput8(const Boolean),, 3071)
IVBLogicalOrPart& IVBLogicalOrPart::setNotInput8 (Boolean aNotInput8)
{
  return setInput8(!aNotInput8);
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setNotInput8                                               |
|                                                                              |
| Set the notInput8 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setNotInput8(),, 3072)
IVBLogicalOrPart& IVBLogicalOrPart::setNotInput8 ()
{
  return setNotInput8 (!defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::notInput9                                                  |
|                                                                              |
| Return the notInput9 attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::notInput9() const,, 3073)
Boolean IVBLogicalOrPart::notInput9 () const
{
  return !input9();
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setNotInput9                                               |
|                                                                              |
| Set the notInput9 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setNotInput9(const Boolean),, 3074)
IVBLogicalOrPart& IVBLogicalOrPart::setNotInput9 (Boolean aNotInput9)
{
  return setInput9(!aNotInput9);
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setNotInput9                                               |
|                                                                              |
| Set the notInput9 attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setNotInput9(),, 3075)
IVBLogicalOrPart& IVBLogicalOrPart::setNotInput9 ()
{
  return setNotInput9 (!defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::notInput10                                                 |
|                                                                              |
| Return the notInput10 attribute.                                             |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::notInput10() const,, 3076)
Boolean IVBLogicalOrPart::notInput10 () const
{
  return !input10();
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setNotInput10                                              |
|                                                                              |
| Set the notInput10 attribute.                                                |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setNotInput10(const Boolean),, 3077)
IVBLogicalOrPart& IVBLogicalOrPart::setNotInput10 (Boolean aNotInput10)
{
  return setInput10(!aNotInput10);
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::setNotInput10                                              |
|                                                                              |
| Set the notInput10 attribute.                                                |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::setNotInput10(),, 3078)
IVBLogicalOrPart& IVBLogicalOrPart::setNotInput10 ()
{
  return setNotInput10 (!defaultInput());
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::defaultInput                                               |
|                                                                              |
| Return the defaultInput attribute.                                           |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::defaultInput() const,, 3079)
Boolean IVBLogicalOrPart::defaultInput () const
{
  return false;
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::compute                                                    |
|                                                                              |
| Perform the compute action.                                                  |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::compute(),, 3080)
IVBLogicalOrPart& IVBLogicalOrPart::compute ()
{
  Boolean aValue = (iInput1 ||
                    iInput2 ||
                    iInput3 ||
                    iInput4 ||
                    iInput5 ||
                    iInput6 ||
                    iInput7 ||
                    iInput9 ||
                    iInput10);
  if (iValue != aValue) {
    iValue = aValue;
    notifyObservers(INotificationEvent(valueId, *this,
                      true, (void*)iValue));
  } ; /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::operator == (const IVBLogicalOrPart & aValue)              |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::operator == (const IVBLogicalOrPart&) const,, 3081)
Boolean IVBLogicalOrPart::
  operator == (const IVBLogicalOrPart& aValue) const
{
  if (value() != aValue.value()) {
    return false;
  } /* endif */
  if (input1() != aValue.input1()) {
    return false;
  } /* endif */
  if (input2() != aValue.input2()) {
    return false;
  } /* endif */
  if (input3() != aValue.input3()) {
    return false;
  } /* endif */
  if (input4() != aValue.input4()) {
    return false;
  } /* endif */
  if (input5() != aValue.input5()) {
    return false;
  } /* endif */
  if (input6() != aValue.input6()) {
    return false;
  } /* endif */
  if (input7() != aValue.input7()) {
    return false;
  } /* endif */
  if (input8() != aValue.input8()) {
    return false;
  } /* endif */
  if (input9() != aValue.input9()) {
    return false;
  } /* endif */
  if (input10() != aValue.input10()) {
    return false;
  } /* endif */
  return true;
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::operator != (const IVBLogicalOrPart & aValue)              |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::operator != (const IVBLogicalOrPart&) const,, 3082)
Boolean IVBLogicalOrPart::
  operator != (const IVBLogicalOrPart& aValue) const
{
  if (value() != aValue.value()) {
    return true;
  } /* endif */
  if (input1() != aValue.input1()) {
    return true;
  } /* endif */
  if (input2() != aValue.input2()) {
    return true;
  } /* endif */
  if (input3() != aValue.input3()) {
    return true;
  } /* endif */
  if (input4() != aValue.input4()) {
    return true;
  } /* endif */
  if (input5() != aValue.input5()) {
    return true;
  } /* endif */
  if (input6() != aValue.input6()) {
    return true;
  } /* endif */
  if (input7() != aValue.input7()) {
    return true;
  } /* endif */
  if (input8() != aValue.input8()) {
    return true;
  } /* endif */
  if (input9() != aValue.input9()) {
    return true;
  } /* endif */
  if (input10() != aValue.input10()) {
    return true;
  } /* endif */
  return false;
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::operator == (const IVBLogicalOrPart * aValue)              |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::operator == (const IVBLogicalOrPart*) const,, 3083)
Boolean IVBLogicalOrPart::
  operator == (const IVBLogicalOrPart* aValue) const
{
  if (value() != aValue->value()) {
    return false;
  } /* endif */
  if (input1() != aValue->input1()) {
    return false;
  } /* endif */
  if (input2() != aValue->input2()) {
    return false;
  } /* endif */
  if (input3() != aValue->input3()) {
    return false;
  } /* endif */
  if (input4() != aValue->input4()) {
    return false;
  } /* endif */
  if (input5() != aValue->input5()) {
    return false;
  } /* endif */
  if (input6() != aValue->input6()) {
    return false;
  } /* endif */
  if (input7() != aValue->input7()) {
    return false;
  } /* endif */
  if (input8() != aValue->input8()) {
    return false;
  } /* endif */
  if (input9() != aValue->input9()) {
    return false;
  } /* endif */
  if (input10() != aValue->input10()) {
    return false;
  } /* endif */
  return true;
}

/*------------------------------------------------------------------------------
| IVBLogicalOrPart::operator != (const IVBLogicalOrPart * aValue)              |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBLogicalOrPart::operator != (const IVBLogicalOrPart*) const,, 3084)
Boolean IVBLogicalOrPart::
  operator != (const IVBLogicalOrPart* aValue) const
{
  if (value() != aValue->value()) {
    return true;
  } /* endif */
  if (input1() != aValue->input1()) {
    return true;
  } /* endif */
  if (input2() != aValue->input2()) {
    return true;
  } /* endif */
  if (input3() != aValue->input3()) {
    return true;
  } /* endif */
  if (input4() != aValue->input4()) {
    return true;
  } /* endif */
  if (input5() != aValue->input5()) {
    return true;
  } /* endif */
  if (input6() != aValue->input6()) {
    return true;
  } /* endif */
  if (input7() != aValue->input7()) {
    return true;
  } /* endif */
  if (input8() != aValue->input8()) {
    return true;
  } /* endif */
  if (input9() != aValue->input9()) {
    return true;
  } /* endif */
  if (input10() != aValue->input10()) {
    return true;
  } /* endif */
  return false;
}
