/*******************************************************************************
* FILE NAME: ivbshort.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class(es):                                     *
*    IVBShortPart - IBM VB sample Short part.                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
* DISCLAIMER OF WARRANTIES:                                                    *
*   The following [enclosed] code is sample code created by IBM                *
*   Corporation.  This sample code is not part of any standard IBM product     *
*   and is provided to you solely for the purpose of assisting you in the      *
*   development of your applications.  The code is provided "AS IS",           *
*   without warranty of any kind.  IBM shall not be liable for any damages     *
*   arising out of your use of the sample code, even if they have been         *
*   advised of the possibility of such damages.                                *
*******************************************************************************/

#ifndef _IVBSHORT_
  #include <ivbshort.hpp>
#endif

#ifndef _INOTIFEV_
  #include <inotifev.hpp>
#endif



/*------------------------------------------------------------------------------
| IVBShortPart::IVBShortPart                                                   |
|                                                                              |
| Standard constructor.                                                        |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::IVBShortPart(short aValue),, 2600)
IVBShortPart::IVBShortPart(short aValue) : IVBDataTypePart ()
    ,iValue (aValue)
    ,iDefaultValue (0)
    ,iLowLimit (SHRT_MIN)
    ,iHighLimit (SHRT_MAX)
{
  enableNotification ();
}

/*------------------------------------------------------------------------------
| IVBShortPart::IVBShortPart                                                   |
|                                                                              |
| Standard copy constructor.                                                   |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::IVBShortPart(const IVBShortPart&),, 2601)
IVBShortPart::IVBShortPart (const IVBShortPart& partCopy)
  : IVBDataTypePart (partCopy)
    ,iValue (partCopy.value ())
    ,iDefaultValue (partCopy.defaultValue ())
    ,iLowLimit (partCopy.lowLimit ())
    ,iHighLimit (partCopy.highLimit ())
{
  enableNotification ();
}

/*------------------------------------------------------------------------------
| IVBShortPart::IVBShortPart                                                   |
|                                                                              |
| Standard operator=                                                           |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::operator= (const IVBShortPart&),, 2602)
IVBShortPart& IVBShortPart::operator= (const IVBShortPart& aIVBShortPart)
{
  if (this == &aIVBShortPart) {
    return *this;
  } /* endif */
  Inherited::operator=(aIVBShortPart);
  setValue(aIVBShortPart.value());
  setDefaultValue(aIVBShortPart.defaultValue());
  setLowLimit(aIVBShortPart.lowLimit());
  setHighLimit(aIVBShortPart.highLimit());
  return *this;
}

/*------------------------------------------------------------------------------
| IVBShortPart::~IVBShortPart                                                  |
|                                                                              |
| IVBShortPart destructor.                                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::~IVBShortPart(),, 2603)
IVBShortPart::~IVBShortPart()
{
}

/*------------------------------------------------------------------------------
| IVBShortPart::asString                                                       |
|                                                                              |
| Perform asString.                                                            |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::asString() const,, 2604)
IString IVBShortPart::asString () const
{
  return valueAsText();
}

/*------------------------------------------------------------------------------
| IVBShortPart::value                                                          |
|                                                                              |
| Return the value attribute.                                                  |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::value() const,, 2605)
short IVBShortPart::value () const
{
  return iValue;
}

/*------------------------------------------------------------------------------
| IVBShortPart::setValue                                                       |
|                                                                              |
| Set the value attribute.                                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::setValue(const short),, 2606)
IVBShortPart& IVBShortPart::setValue (short aValue)
{
  if (iValue != aValue) {
    short oldValue = iValue;
    iValue = aValue;
    notifyObservers(INotificationEvent(valueId, *this,
                    true, (void*)iValue));
    if (iValue < 0) {
      if (!(oldValue < 0)) {
        notifyObservers(INotificationEvent(valueNegativeId, *this,
                        true, (void*)iValue));
      } ; /* endif */
    } ;
    if (iValue > 0) {
      if (!(oldValue > 0)) {
        notifyObservers(INotificationEvent(valuePositiveId, *this,
                        true, (void*)iValue));
      } ; /* endif */
    } ; /* endif */
    if (iValue == 0) {
      notifyObservers(INotificationEvent(valueZeroId, *this,
                      true, (void*)iValue));
    }
    else {
      if (oldValue == 0) {
        notifyObservers(INotificationEvent(valueNotZeroId, *this,
                        true, (void*)iValue));
      } ; /* endif */
    } ; /* endif */
    if (iDefaultValue == iValue) {
      notifyObservers(INotificationEvent(valueEqualDefaultId, *this,
                      true, (void*)iValue));
    }
    else {
      if (iDefaultValue == oldValue) {
        notifyObservers(INotificationEvent(valueNotEqualDefaultId, *this,
                        true, (void*)iValue));
      } /* endif */
    } /* endif */
    if (iValue == iLowLimit) {
      notifyObservers(INotificationEvent(valueEqualLowLimitId, *this,
                      true, (void*)iValue));
    } ; /* endif */
    if (iLowLimit != SHRT_MIN) {
      if (iValue < iLowLimit) {
        if (!(oldValue < iLowLimit)) {
          notifyObservers(INotificationEvent(valueBelowLowLimitId, *this,
                          true, (void*)iValue));
        } ; /* endif */
      } ; /* endif */
    } ; /* endif */
    if (iValue == iHighLimit) {
      notifyObservers(INotificationEvent(valueEqualHighLimitId, *this,
                      true, (void*)iValue));
    } ; /* endif */
    if (iHighLimit != SHRT_MAX) {
      if (iValue > iHighLimit) {
        if (!(oldValue > iHighLimit)) {
          notifyObservers(INotificationEvent(valueAboveHighLimitId, *this,
                          true, (void*)iValue));
        } ; /* endif */
      } ; /* endif */
    } ; /* endif */
    if ((iValue >= iLowLimit) && (iValue <= iHighLimit)) {
      if (!((oldValue >= iLowLimit) && (oldValue <= iHighLimit))) {
        notifyObservers(INotificationEvent(valueWithinLimitsId, *this,
                        true, (void*)iValue));
      } ; /* endif */
    }
    else {
      if (((oldValue >= iLowLimit) && (oldValue <= iHighLimit))) {
        notifyObservers(INotificationEvent(valueOutsideLimitsId, *this,
                        true, (void*)iValue));
      } ; /* endif */
    } ; /* endif */
  } ; /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBShortPart::setValue                                                       |
|                                                                              |
| Set the value attribute.                                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::setValue(),, 2607)
IVBShortPart& IVBShortPart::setValue ()
{
  return setValue(defaultValue());
}

/*------------------------------------------------------------------------------
| IVBShortPart::valueAsText                                                    |
|                                                                              |
| Return the valueAsText attribute.                                            |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::valueAsText() const,, 2608)
IString IVBShortPart::valueAsText () const
{
  return IString (value());
}

/*------------------------------------------------------------------------------
| IVBShortPart::setValueAsText                                                 |
|                                                                              |
| Set the valueAsText attribute.                                               |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::setValueAsText(const IString&),, 2609)
IVBShortPart& IVBShortPart::setValueAsText (const IString& aValueAsText)
{
#ifdef IC_PM
  Boolean isValid=1;
  IString tempValueString(aValueAsText);
  setValue (aValueAsText.asInt());

  tempValueString = tempValueString.strip();

  if ((tempValueString.asInt()>32767) || (tempValueString.asInt()<-32768))
    isValid=0;

  IString firstCharOfString(tempValueString.subString(1,1));  //Gets 1st char of string
  Boolean testFirstChar=firstCharOfString.indexOfAnyOf("+-"); //Checks 2C if 1st char is + or -

  if (testFirstChar) {
     tempValueString=tempValueString.subString(2);            //Uses rest of string after sign
  } /* endif */

  tempValueString = tempValueString.strip();

  if (isValid) isValid=tempValueString.isDigits();

  IString eventData(aValueAsText);
  if (isValid){
    notifyObservers(INotificationEvent(inputStringIsValidId, *this,
                      true, (void*)&eventData));
  } else {
    notifyObservers(INotificationEvent(inputStringNotValidId, *this,
                      true, (void*)&eventData));
  } /* endif */
#endif
#ifdef IC_WIN
  setValue (aValueAsText.asInt());
  Boolean iValid = aValueAsText.indexOfAnyBut("+-0123456789 ");
  if (iValid) {
    IString eventData(aValueAsText);
    notifyObservers(INotificationEvent(inputStringNotValidId, *this,
                      true, (void*)&eventData));
  } else {
    IString eventData(aValueAsText);
    notifyObservers(INotificationEvent(inputStringIsValidId, *this,
                      true, (void*)&eventData));
  } /* endif */
#endif
  return *this;
}

/*------------------------------------------------------------------------------
| IVBShortPart::setValueAsText                                                 |
|                                                                              |
| Set the valueAsText attribute.                                               |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::setValueAsText(const IString*),, 2610)
IVBShortPart& IVBShortPart::setValueAsText (const IString* aValueAsText)
{
  return setValueAsText (*aValueAsText);
}

/*------------------------------------------------------------------------------
| IVBShortPart::valueAs1Based                                                  |
|                                                                              |
| Return the valueAs1Based attribute.                                          |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::valueAs1Based() const,, 2611)
short IVBShortPart::valueAs1Based () const
{
  return (value() + 1) ;
}

/*------------------------------------------------------------------------------
| IVBShortPart::setValueAs1Based                                               |
|                                                                              |
| Set the valueAs1Based attribute.                                             |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::setValueAs1Based(short),, 2612)
IVBShortPart& IVBShortPart::setValueAs1Based (short aValueAs1Based)
{
  return setValue (aValueAs1Based - 1);
}

/*------------------------------------------------------------------------------
| IVBShortPart::defaultValue                                                   |
|                                                                              |
| Return the defaultValue attribute.                                           |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::defaultValue() const,, 2613)
short IVBShortPart::defaultValue () const
{
  return iDefaultValue;
}

/*------------------------------------------------------------------------------
| IVBShortPart::setDefaultValue                                                |
|                                                                              |
| Set the defaultValue attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::setDefaultValue(const short),, 2614)
IVBShortPart& IVBShortPart::setDefaultValue (short aDefaultValue)
{
  if (iDefaultValue != aDefaultValue) {
    short oldValue = iDefaultValue;
    iDefaultValue = aDefaultValue;
    notifyObservers(INotificationEvent(defaultValueId, *this,
                      true, (void*)iDefaultValue));
    if (iDefaultValue == iValue) {
      notifyObservers(INotificationEvent(valueEqualDefaultId, *this,
                      true, (void*)iValue));
    }
    else {
      if (oldValue == iValue) {
        notifyObservers(INotificationEvent(valueNotEqualDefaultId, *this,
                        true, (void*)iValue));
      } /* endif */
    } /* endif */
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBShortPart::isValueEqualDefault                                            |
|                                                                              |
| Return the valueEqualDefault attribute.                                      |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::isValueEqualDefault() const,, 2615)
Boolean IVBShortPart::isValueEqualDefault () const
{
  return (value() == defaultValue ()) ;
}

/*------------------------------------------------------------------------------
| IVBShortPart::isValueNotEqualDefault                                         |
|                                                                              |
| Return the valueNotEqualDefault attribute.                                   |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::isValueNotEqualDefault() const,, 2616)
Boolean IVBShortPart::isValueNotEqualDefault () const
{
  return (value() != defaultValue ()) ;
}

/*------------------------------------------------------------------------------
| IVBShortPart::lowLimit                                                       |
|                                                                              |
| Return the lowLimit attribute.                                               |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::lowLimit() const,, 2617)
short IVBShortPart::lowLimit () const
{
  return iLowLimit;
}

/*------------------------------------------------------------------------------
| IVBShortPart::setLowLimit                                                    |
|                                                                              |
| Set the lowLimit attribute.                                                  |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::setLowLimit(const short),, 2618)
IVBShortPart& IVBShortPart::setLowLimit (short aLowLimit)
{
  if (iLowLimit != aLowLimit) {
    short oldValue = iLowLimit;
    iLowLimit = aLowLimit;
    notifyObservers(INotificationEvent(lowLimitId, *this,
                      true, (void*)iLowLimit));
    if (iValue == lowLimit()) {
      notifyObservers(INotificationEvent(valueEqualLowLimitId, *this,
                      true, (void*)iValue));
    } ; /* endif */
    if (lowLimit() != SHRT_MIN) {
      if (iValue < iLowLimit) {
        if (!(iValue < oldValue)) {
          notifyObservers(INotificationEvent(valueBelowLowLimitId, *this,
                          true, (void*)iValue));
        } ; /* endif */
      } ; /* endif */
    } ; /* endif */
    if ((iValue >= lowLimit()) && (iValue <= highLimit())) {
      if (!((iValue >= oldValue) && (iValue <= highLimit()))) {
        notifyObservers(INotificationEvent(valueWithinLimitsId, *this,
                        true, (void*)iLowLimit));
      } ; /* endif */
    }
    else {
      if ((iValue >= oldValue) && (iValue <= highLimit())) {
        notifyObservers(INotificationEvent(valueOutsideLimitsId, *this,
                        true, (void*)iLowLimit));
      } ; /* endif */
    } ; /* endif */
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBShortPart::highLimit                                                      |
|                                                                              |
| Return the highLimit attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::highLimit() const,, 2619)
short IVBShortPart::highLimit () const
{
  return iHighLimit;
}

/*------------------------------------------------------------------------------
| IVBShortPart::setHighLimit                                                   |
|                                                                              |
| Set the highLimit attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::setHighLimit(const short),, 2620)
IVBShortPart& IVBShortPart::setHighLimit (short aHighLimit)
{
  if (iHighLimit != aHighLimit) {
    short oldValue = iHighLimit;
    iHighLimit = aHighLimit;
    notifyObservers(INotificationEvent(highLimitId, *this,
                      true, (void*)iHighLimit));
    if (iValue == highLimit()) {
      notifyObservers(INotificationEvent(valueEqualHighLimitId, *this,
                      true, (void*)iValue));
    } ; /* endif */
    if (highLimit() != SHRT_MAX) {
      if (iValue > iHighLimit) {
        if (!(iValue > oldValue)) {
          notifyObservers(INotificationEvent(valueAboveHighLimitId, *this,
                          true, (void*)iValue));
        } ; /* endif */
      } ; /* endif */
    } ; /* endif */
    if ((iValue >= lowLimit()) && (iValue <= highLimit())) {
      if (!((iValue >= lowLimit()) && (iValue <= oldValue))) {
        notifyObservers(INotificationEvent(valueWithinLimitsId, *this,
                        true, (void*)iHighLimit));
      } ; /* endif */
    }
    else {
      if ((iValue >= lowLimit()) && (iValue <= oldValue)) {
        notifyObservers(INotificationEvent(valueOutsideLimitsId, *this,
                        true, (void*)iHighLimit));
      } ; /* endif */
    } ; /* endif */
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBShortPart::isValueEqualLowLimit                                           |
|                                                                              |
| Return the valueEqualLowLimit attribute.                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::isValueEqualLowLimit() const,, 2621)
Boolean IVBShortPart::isValueEqualLowLimit () const
{
  return (value() == lowLimit ()) ;
}

/*------------------------------------------------------------------------------
| IVBShortPart::isValueEqualHighLimit                                          |
|                                                                              |
| Return the valueEqualHighLimit attribute.                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::isValueEqualHighLimit() const,, 2622)
Boolean IVBShortPart::isValueEqualHighLimit () const
{
  return (value() == highLimit ()) ;
}

/*------------------------------------------------------------------------------
| IVBShortPart::isValueBelowLowLimit                                           |
|                                                                              |
| Return the valueBelowLowLimit attribute.                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::isValueBelowLowLimit() const,, 2623)
Boolean IVBShortPart::isValueBelowLowLimit () const
{
  return (value() < lowLimit ()) ;
}

/*------------------------------------------------------------------------------
| IVBShortPart::isValueAboveHighLimit                                          |
|                                                                              |
| Return the valueAboveHighLimit attribute.                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::isValueAboveHighLimit() const,, 2624)
Boolean IVBShortPart::isValueAboveHighLimit () const
{
  return (value() > highLimit ()) ;
}

/*------------------------------------------------------------------------------
| IVBShortPart::isValueOutsideLimits                                           |
|                                                                              |
| Return the valueOutsideLimits attribute.                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::isValueOutsideLimits() const,, 2625)
Boolean IVBShortPart::isValueOutsideLimits () const
{
  return ((value() < lowLimit()) || (value() > highLimit())) ;
}

/*------------------------------------------------------------------------------
| IVBShortPart::isValueWithinLimits                                            |
|                                                                              |
| Return the valueWithinLimits attribute.                                      |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::isValueWithinLimits() const,, 2626)
Boolean IVBShortPart::isValueWithinLimits () const
{
  return !isValueOutsideLimits ();
}

/*------------------------------------------------------------------------------
| IVBShortPart::isValueNotZero                                                 |
|                                                                              |
| Return the valueNotZero attribute.                                           |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::isValueNotZero() const,, 2627)
Boolean IVBShortPart::isValueNotZero () const
{
  return (value() != 0) ;
}

/*------------------------------------------------------------------------------
| IVBShortPart::isValueZero                                                    |
|                                                                              |
| Return the valueZero attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::isValueZero() const,, 2628)
Boolean IVBShortPart::isValueZero () const
{
  return (value() == 0) ;
}

/*------------------------------------------------------------------------------
| IVBShortPart::isValuePositive                                                |
|                                                                              |
| Return the valuePositive attribute.                                          |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::isValuePositive() const,, 2629)
Boolean IVBShortPart::isValuePositive () const
{
  return (value() > 0) ;
}

/*------------------------------------------------------------------------------
| IVBShortPart::isValueNegative                                                |
|                                                                              |
| Return the valueNegative attribute.                                          |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::isValueNegative() const,, 2630)
Boolean IVBShortPart::isValueNegative () const
{
  return (value() < 0) ;
}

/*------------------------------------------------------------------------------
| IVBShortPart::assignValueToZero                                              |
|                                                                              |
| Assign the value attribute to 0.                                             |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::assignValueToZero(),, 2631)
IVBShortPart& IVBShortPart::assignValueToZero ()
{
  return setValue (0) ;
}

/*------------------------------------------------------------------------------
| IVBShortPart::assignValueToOne                                               |
|                                                                              |
| Assign the value attribute to 1.                                             |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::assignValueToOne(),, 2632)
IVBShortPart& IVBShortPart::assignValueToOne ()
{
  return setValue (1) ;
}

/*------------------------------------------------------------------------------
| IVBShortPart::assignValueToLowLimit                                          |
|                                                                              |
| Assign the value attribute to low limit attribute.                           |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::assignValueToLowLimit(),, 2633)
IVBShortPart& IVBShortPart::assignValueToLowLimit ()
{
  return setValue (lowLimit()) ;
}

/*------------------------------------------------------------------------------
| IVBShortPart::assignValueToHighLimit                                         |
|                                                                              |
| Assign the value attribute to high limit attribute.                          |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::assignValueToHighLimit(),, 2634)
IVBShortPart& IVBShortPart::assignValueToHighLimit ()
{
  return setValue (highLimit()) ;
}

/*------------------------------------------------------------------------------
| IVBShortPart::assignValueToDefault                                           |
|                                                                              |
| Assign the value attribute to default.                                       |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::assignValueToDefault(),, 2635)
IVBShortPart& IVBShortPart::assignValueToDefault ()
{
  return setValue (defaultValue ()) ;
}

/*------------------------------------------------------------------------------
| IVBShortPart::assignValueToRandom                                            |
|                                                                              |
| Assign the value attribute to a pseudo-random number.                        |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::assignValueToRandom(),, 2636)
IVBShortPart& IVBShortPart::assignValueToRandom ()
{
  return setValue (rand ()) ;
}

/*------------------------------------------------------------------------------
| IVBShortPart::copyValueToDefault                                             |
|                                                                              |
| Copy the value attribute to default.                                         |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::copyValueToDefault(),, 2637)
IVBShortPart& IVBShortPart::copyValueToDefault ()
{
  return setDefaultValue (value()) ;
}

/*------------------------------------------------------------------------------
| IVBShortPart::squareValue                                                    |
|                                                                              |
| Square the value attribute.                                                  |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::squareValue(),, 2638)
IVBShortPart& IVBShortPart::squareValue()
{
  return setValue (value() * value()) ;
}

/*------------------------------------------------------------------------------
| IVBShortPart::addValue                                                       |
|                                                                              |
| Perform the add operator to the value attribute.                             |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::addValue (short),, 2639)
IVBShortPart& IVBShortPart::addValue (short addValue)
{
  return setValue (value() + addValue) ;
}

/*------------------------------------------------------------------------------
| IVBShortPart::subtractValue                                                  |
|                                                                              |
| Perform the subtract operator to the value attribute.                        |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::subtractValue (short),, 2640)
IVBShortPart& IVBShortPart::subtractValue (short subtractValue)
{
  return setValue (value() - subtractValue) ;
}

/*------------------------------------------------------------------------------
| IVBShortPart::multiplyValue                                                  |
|                                                                              |
| Perform the multiply operator to the value attribute.                        |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::multiplyValue (short),, 2641)
IVBShortPart& IVBShortPart::multiplyValue (short multiplyValue)
{
  return setValue (value() * multiplyValue) ;
}

/*------------------------------------------------------------------------------
| IVBShortPart::divideValue                                                   |
|                                                                             |
| Perform the divide operator to the value attribute.                         |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::divideValue (short),, 2642)
IVBShortPart& IVBShortPart::divideValue (short divideValue)
{
  if (divideValue)
    return setValue (value() / divideValue) ;
  return *this;
}

/*------------------------------------------------------------------------------
| IVBShortPart::andValue                                                       |
|                                                                              |
| Perform the and operator to the value attribute.                             |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::andValue (short),, 2643)
IVBShortPart& IVBShortPart::andValue (short andValue)
{
  return setValue (value() & andValue) ;
}

/*------------------------------------------------------------------------------
| IVBShortPart::orValue                                                        |
|                                                                              |
| Perform the or operator to the value attribute.                              |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::orValue (short),, 2644)
IVBShortPart& IVBShortPart::orValue (short orValue)
{
  return setValue (value() | orValue) ;
}

/*------------------------------------------------------------------------------
| IVBShortPart::operator == (const IVBShortPart & aValue)                      |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::operator == (const IVBShortPart&) const,, 2645)
Boolean IVBShortPart::
  operator == (const IVBShortPart& aValue) const
{
  if (value() != aValue.value()) {
    return false;
  } /* endif */
  if (defaultValue() != aValue.defaultValue()) {
    return false;
  } /* endif */
  if (lowLimit() != aValue.lowLimit()) {
    return false;
  } /* endif */
  if (highLimit() != aValue.highLimit()) {
    return false;
  } /* endif */
  return true;
}

/*------------------------------------------------------------------------------
| IVBShortPart::operator != (const IVBShortPart & aValue)                      |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::operator != (const IVBShortPart&) const,, 2646)
Boolean IVBShortPart::
  operator != (const IVBShortPart& aValue) const
{
  if (value() != aValue.value()) {
    return true;
  } /* endif */
  if (defaultValue() != aValue.defaultValue()) {
    return true;
  } /* endif */
  if (lowLimit() != aValue.lowLimit()) {
    return true;
  } /* endif */
  if (highLimit() != aValue.highLimit()) {
    return true;
  } /* endif */
  return false;
}

/*------------------------------------------------------------------------------
| IVBShortPart::operator == (const IVBShortPart * aValue)                      |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::operator == (const IVBShortPart*) const,, 2647)
Boolean IVBShortPart::
  operator == (const IVBShortPart* aValue) const
{
  if (value() != aValue->value()) {
    return false;
  } /* endif */
  if (defaultValue() != aValue->defaultValue()) {
    return false;
  } /* endif */
  if (lowLimit() != aValue->lowLimit()) {
    return false;
  } /* endif */
  if (highLimit() != aValue->highLimit()) {
    return false;
  } /* endif */
  return true;
}

/*------------------------------------------------------------------------------
| IVBShortPart::operator != (const IVBShortPart * aValue)                      |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBShortPart::operator != (const IVBShortPart*) const,, 2648)
Boolean IVBShortPart::
  operator != (const IVBShortPart* aValue) const
{
  if (value() != aValue->value()) {
    return true;
  } /* endif */
  if (defaultValue() != aValue->defaultValue()) {
    return true;
  } /* endif */
  if (lowLimit() != aValue->lowLimit()) {
    return true;
  } /* endif */
  if (highLimit() != aValue->highLimit()) {
    return true;
  } /* endif */
  return false;
}
