/*******************************************************************************
* FILE NAME: ivbstrng.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class(es):                                     *
*    IVBStringPart - IBM VB sample string part.                                *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
* DISCLAIMER OF WARRANTIES:                                                    *
*   The following [enclosed] code is sample code created by IBM                *
*   Corporation.  This sample code is not part of any standard IBM product     *
*   and is provided to you solely for the purpose of assisting you in the      *
*   development of your applications.  The code is provided "AS IS",           *
*   without warranty of any kind.  IBM shall not be liable for any damages     *
*   arising out of your use of the sample code, even if they have been         *
*   advised of the possibility of such damages.                                *
*******************************************************************************/

#ifndef _IVBSTRNG_
  #include <ivbstrng.hpp>
#endif

#ifndef _INOTIFEV_
  #include <inotifev.hpp>
#endif

#ifndef _IDATE_
  #include <idate.hpp>
#endif

#ifndef _ITIME_
  #include <itime.hpp>
#endif

#ifndef _IAPP_
  #include <iapp.hpp>
#endif



/*------------------------------------------------------------------------------
| IVBStringPart::IVBStringPart                                                 |
|                                                                              |
| Standard constructor.                                                        |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::IVBStringPart(const IString& aText),, 2800)
IVBStringPart::IVBStringPart(const IString& aText) : IVBDataTypePart ()
    ,iText (aText)
    ,iDefaultText ("")
{
  enableNotification ();
}

/*------------------------------------------------------------------------------
| IVBStringPart::IVBStringPart                                                 |
|                                                                              |
| Standard copy constructor.                                                   |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::IVBStringPart(const IVBStringPart&),, 2801)
IVBStringPart::IVBStringPart (const IVBStringPart& partCopy)
  : IVBDataTypePart (partCopy)
    ,iText (partCopy.text ())
    ,iDefaultText (partCopy.defaultText ())
{
  enableNotification ();
}

/*------------------------------------------------------------------------------
| IVBStringPart::IVBStringPart                                                 |
|                                                                              |
| Standard operator=                                                           |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::operator= (const IVBStringPart&),, 2802)
IVBStringPart& IVBStringPart::operator= (const IVBStringPart& aIVBStringPart)
{
  if (this == &aIVBStringPart) {
    return *this;
  } /* endif */
  Inherited::operator=(aIVBStringPart);
  setText(aIVBStringPart.text());
  setDefaultText(aIVBStringPart.defaultText());
  return *this;
}

/*------------------------------------------------------------------------------
| IVBStringPart::~IVBStringPart                                                |
|                                                                              |
| IVBStringPart destructor.                                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::~IVBStringPart(),, 2803)
IVBStringPart::~IVBStringPart()
{
}

/*------------------------------------------------------------------------------
| IVBStringPart::text                                                          |
|                                                                              |
| Return the text attribute.                                                   |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::text() const,, 2804)
IString IVBStringPart::text () const
{
  return iText;
}

/*------------------------------------------------------------------------------
| IVBStringPart::setText                                                       |
|                                                                              |
| Set the text attribute.                                                      |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::setText(const IString&),, 2805)
IVBStringPart& IVBStringPart::setText (const IString& aText)
{
  if (iText != aText) {
    IString oldValue = iText;
    iText = aText;
    IString eventData(iText);
    notifyObservers(INotificationEvent(textId, *this,
                      true, (void*)&eventData));
    if (iText == defaultText()) {
      notifyObservers(INotificationEvent(textEqualDefaultId, *this,
                      true, (void*)&eventData));
    }
    else {
      if (iDefaultText == oldValue) {
        notifyObservers(INotificationEvent(textNotEqualDefaultId, *this,
                        true, (void*)&eventData));
      } ; /* endif */
    } ; /* endif */
    if (iText.isLowerCase()) {
      if (!(oldValue.isLowerCase())) {
        notifyObservers(INotificationEvent(lowerCaseId, *this,
                        true, (void*)&eventData));
      } ; /* endif */
    } ; /* endif */
    if (iText.isUpperCase()) {
      if (!(oldValue.isUpperCase())) {
        notifyObservers(INotificationEvent(upperCaseId, *this,
                        true, (void*)&eventData));
      } ; /* endif */
    } ; /* endif */
    if (iText.length() != oldValue.length()) {
      notifyObservers(INotificationEvent(textLengthId, *this,
                      true, (void*)&eventData));
    } ; /* endif */
  } ; /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBStringPart::setText                                                       |
|                                                                              |
| Set the text attribute.                                                      |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::setText(),, 2806)
IVBStringPart& IVBStringPart::setText ()
{
  return setText (defaultText());
}

/*------------------------------------------------------------------------------
| IVBStringPart::textAsLowerCase                                               |
|                                                                              |
| Return the textAsLowerCase attribute.                                        |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::textAsLowerCase() const,, 2807)
IString IVBStringPart::textAsLowerCase () const
{
  return IString::lowerCase(text());
}

/*------------------------------------------------------------------------------
| IVBStringPart::textAsUpperCase                                               |
|                                                                              |
| Return the textAsUpperCase attribute.                                        |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::textAsUpperCase() const,, 2808)
IString IVBStringPart::textAsUpperCase () const
{
  return IString::upperCase(text());
}

/*------------------------------------------------------------------------------
| IVBStringPart::defaultText                                                   |
|                                                                              |
| Return the defaultText attribute.                                            |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::defaultText() const,, 2809)
IString IVBStringPart::defaultText () const
{
  return iDefaultText;
}

/*------------------------------------------------------------------------------
| IVBStringPart::setDefaultText                                                |
|                                                                              |
| Set the defaultText attribute.                                               |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::setDefaultText(const IString&),, 2810)
IVBStringPart& IVBStringPart::setDefaultText (const IString& aDefaultText)
{
  if (iDefaultText != aDefaultText) {
    iDefaultText = aDefaultText;
    IString eventData(iDefaultText);
    notifyObservers(INotificationEvent(defaultTextId, *this,
                      true, (void*)&eventData));
    if (iDefaultText == text()) {
      notifyObservers(INotificationEvent(textEqualDefaultId, *this,
                      true, (void*)&eventData));
    }
    else {
      notifyObservers(INotificationEvent(textNotEqualDefaultId, *this,
                      true, (void*)&eventData));
    } /* endif */
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBStringPart::isTextEqualDefault                                            |
|                                                                              |
| Return the textEqualDefault attribute.                                       |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::isTextEqualDefault() const,, 2811)
Boolean IVBStringPart::isTextEqualDefault () const
{
  return (text() == defaultText ()) ;
}

/*------------------------------------------------------------------------------
| IVBStringPart::isTextNotEqualDefault                                         |
|                                                                              |
| Return the textNotEqualDefault attribute.                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::isTextNotEqualDefault() const,, 2812)
Boolean IVBStringPart::isTextNotEqualDefault () const
{
  return (text() != defaultText ()) ;
}

/*------------------------------------------------------------------------------
| IVBStringPart::textLength                                                    |
|                                                                              |
| Return the textLength attribute.                                             |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::textLength() const,, 2813)
unsigned long IVBStringPart::textLength () const
{
  return iText.length();
}

/*------------------------------------------------------------------------------
| IVBStringPart::isLowerCase                                                   |
|                                                                              |
| Return the lowerCase attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::isLowerCase() const,, 2814)
Boolean IVBStringPart::isLowerCase () const
{
  return iText.isLowerCase();
}

/*------------------------------------------------------------------------------
| IVBStringPart::isUpperCase                                                   |
|                                                                              |
| Return the upperCase attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::isUpperCase() const,, 2815)
Boolean IVBStringPart::isUpperCase () const
{
  return iText.isUpperCase();
}

/*------------------------------------------------------------------------------
| IVBStringPart::isDigits                                                      |
|                                                                              |
| Return the digits attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::isDigits() const,, 2816)
Boolean IVBStringPart::isDigits () const
{
  return iText.length();
}

/*------------------------------------------------------------------------------
| IVBStringPart::assignTextToEmpty                                             |
|                                                                              |
| Assign the text attribute to empty.                                          |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::assignTextToEmpty(),, 2817)
IVBStringPart& IVBStringPart::assignTextToEmpty ()
{
  return setText (IString("")) ;
}

/*------------------------------------------------------------------------------
| IVBStringPart::assignTextToDateToday                                         |
|                                                                              |
| Assign the text attribute to today's date.                                   |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::assignTextToDateToday(),, 2818)
IVBStringPart& IVBStringPart::assignTextToDateToday ()
{
  return setText (IDate::today().asString()) ;
}

/*------------------------------------------------------------------------------
| IVBStringPart::assignTextToTimeNow                                           |
|                                                                              |
| Assign the text attribute to time now.                                       |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::assignTextToTimeNow(),, 2819)
IVBStringPart& IVBStringPart::assignTextToTimeNow ()
{
  return setText (ITime::now().asString()) ;
}

/*------------------------------------------------------------------------------
| IVBStringPart::assignTextToCmdLineParm0                                      |
|                                                                              |
| Assign the text attribute to commad line parameter 0.                        |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::assignTextToCmdLineParm0(),, 2820)
IVBStringPart& IVBStringPart::assignTextToCmdLineParm0 ()
{
  return setText (IApplication::current().argv(0)) ;
}

/*------------------------------------------------------------------------------
| IVBStringPart::assignTextToCmdLineParm1                                      |
|                                                                              |
| Assign the text attribute to commad line parameter 1.                        |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::assignTextToCmdLineParm1(),, 2821)
IVBStringPart& IVBStringPart::assignTextToCmdLineParm1 ()
{
  return setText (IApplication::current().argv(1)) ;
}

/*------------------------------------------------------------------------------
| IVBStringPart::assignTextToDefault                                           |
|                                                                              |
| Assign the text attribute to default.                                        |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::assignTextToDefault(),, 2822)
IVBStringPart& IVBStringPart::assignTextToDefault ()
{
  return setText (defaultText ()) ;
}

/*------------------------------------------------------------------------------
| IVBStringPart::changeTextToLowerCase                                         |
|                                                                              |
| Change the text attribute to lower case.                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::changeTextToLowerCase(),, 2823)
IVBStringPart& IVBStringPart::changeTextToLowerCase ()
{
  return setText (IString::lowerCase(text())) ;
}

/*------------------------------------------------------------------------------
| IVBStringPart::changeTextToUpperCase                                         |
|                                                                              |
| Change the text attribute to upper case.                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::changeTextToUpperCase(),, 2824)
IVBStringPart& IVBStringPart::changeTextToUpperCase ()
{
  return setText (IString::upperCase(text())) ;
}

/*------------------------------------------------------------------------------
| IVBStringPart::reverseText                                                   |
|                                                                              |
| Reverse the text attribute.                                                  |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::reverseText(),, 2825)
IVBStringPart& IVBStringPart::reverseText()
{
  return setText (text().reverse ()) ;
}

/*------------------------------------------------------------------------------
| IVBStringPart::stripBlanksOnText                                             |
|                                                                              |
| Strip blanks on the text attribute.                                          |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::stripBlanksOnText(),, 2826)
IVBStringPart& IVBStringPart::stripBlanksOnText()
{
  return setText (IString::stripBlanks (text())) ;
}

/*------------------------------------------------------------------------------
| IVBStringPart::appendText                                                    |
|                                                                              |
| Append a string to the text attribute.                                       |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::appendText(const IString&),, 2827)
IVBStringPart& IVBStringPart::appendText(const IString& appendText)
{
  return setText (text() + appendText) ;
}

/*------------------------------------------------------------------------------
| IVBStringPart::preappendText                                                   |
|                                                                              |
| Preppend a string to the text attribute.                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::preappendText(const IString&),, 2828)
IVBStringPart& IVBStringPart::preappendText(const IString& preappendText)
{
  return setText (preappendText + text()) ;
}

/*------------------------------------------------------------------------------
| IVBStringPart::operator == (const IVBStringPart & aValue)                    |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::operator == (const IVBStringPart&) const,, 2829)
Boolean IVBStringPart::
  operator == (const IVBStringPart& aValue) const
{
  if (text() != aValue.text()) {
    return false;
  } /* endif */
  if (defaultText() != aValue.defaultText()) {
    return false;
  } /* endif */
  return true;
}

/*------------------------------------------------------------------------------
| IVBStringPart::operator != (const IVBStringPart & aValue)                    |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::operator != (const IVBStringPart&) const,, 2830)
Boolean IVBStringPart::
  operator != (const IVBStringPart& aValue) const
{
  if (text() != aValue.text()) {
    return true;
  } /* endif */
  if (defaultText() != aValue.defaultText()) {
    return true;
  } /* endif */
  return false;
}

/*------------------------------------------------------------------------------
| IVBStringPart::operator == (const IVBStringPart * aValue)                    |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::operator == (const IVBStringPart*) const,, 2831)
Boolean IVBStringPart::
  operator == (const IVBStringPart* aValue) const
{
  if (text() != aValue->text()) {
    return false;
  } /* endif */
  if (defaultText() != aValue->defaultText()) {
    return false;
  } /* endif */
  return true;
}

/*------------------------------------------------------------------------------
| IVBStringPart::operator != (const IVBStringPart * aValue)                    |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::operator != (const IVBStringPart*) const,, 2832)
Boolean IVBStringPart::
  operator != (const IVBStringPart* aValue) const
{
  if (text() != aValue->text()) {
    return true;
  } /* endif */
  if (defaultText() != aValue->defaultText()) {
    return true;
  } /* endif */
  return false;
}

#ifdef IC_PM
/*------------------------------------------------------------------------------
| IVBStringPart::asString                                                      |
|                                                                              |
| Perform asString.                                                            |
------------------------------------------------------------------------------*/
#pragma export (IVBStringPart::asString() const,, 2833)
IString IVBStringPart::asString () const
{
  return text();
}
#endif
