/*******************************************************************************
* FILE NAME: ivbulong.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class(es):                                     *
*    IVBUnsignedLongPart - IBM VB sample Unsigned Long part.                   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
* DISCLAIMER OF WARRANTIES:                                                    *
*   The following [enclosed] code is sample code created by IBM                *
*   Corporation.  This sample code is not part of any standard IBM product     *
*   and is provided to you solely for the purpose of assisting you in the      *
*   development of your applications.  The code is provided "AS IS",           *
*   without warranty of any kind.  IBM shall not be liable for any damages     *
*   arising out of your use of the sample code, even if they have been         *
*   advised of the possibility of such damages.                                *
*******************************************************************************/

#ifndef _IVBULONG_
  #include <ivbulong.hpp>
#endif

#ifndef _INOTIFEV_
  #include <inotifev.hpp>
#endif



/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::IVBUnsignedLongPart                                     |
|                                                                              |
| Standard constructor.                                                        |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::IVBUnsignedLongPart(unsigned long aValue),, 2400)
IVBUnsignedLongPart::IVBUnsignedLongPart(unsigned long aValue) : IVBDataTypePart ()
    ,iValue (aValue)
    ,iDefaultValue (0)
    ,iLowLimit (0)
    ,iHighLimit (ULONG_MAX)
{
  enableNotification ();
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::IVBUnsignedLongPart                                     |
|                                                                              |
| Standard copy constructor.                                                   |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::IVBUnsignedLongPart(const IVBUnsignedLongPart&),, 2401)
IVBUnsignedLongPart::IVBUnsignedLongPart (const IVBUnsignedLongPart& partCopy)
  : IVBDataTypePart (partCopy)
    ,iValue (partCopy.value ())
    ,iDefaultValue (partCopy.defaultValue ())
    ,iLowLimit (partCopy.lowLimit ())
    ,iHighLimit (partCopy.highLimit ())
{
  enableNotification ();
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::IVBUnsignedLongPart                                     |
|                                                                              |
| Standard operator=                                                           |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::operator= (const IVBUnsignedLongPart&),, 2402)
IVBUnsignedLongPart& IVBUnsignedLongPart::operator= (const IVBUnsignedLongPart& aIVBUnsignedLongPart)
{
  if (this == &aIVBUnsignedLongPart) {
    return *this;
  } /* endif */
  Inherited::operator=(aIVBUnsignedLongPart);
  setValue(aIVBUnsignedLongPart.value());
  setDefaultValue(aIVBUnsignedLongPart.defaultValue());
  setLowLimit(aIVBUnsignedLongPart.lowLimit());
  setHighLimit(aIVBUnsignedLongPart.highLimit());
  return *this;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::~IVBUnsignedLongPart                                    |
|                                                                              |
| IVBUnsignedLongPart destructor.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::~IVBUnsignedLongPart(),, 2403)
IVBUnsignedLongPart::~IVBUnsignedLongPart()
{
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::asString                                                |
|                                                                              |
| Perform asString.                                                            |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::asString() const,, 2404)
IString IVBUnsignedLongPart::asString () const
{
  return valueAsText();
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::value                                                   |
|                                                                              |
| Return the value attribute.                                                  |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::value() const,, 2405)
unsigned long IVBUnsignedLongPart::value () const
{
  return iValue;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::setValue                                                |
|                                                                              |
| Set the value attribute.                                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::setValue(const unsigned long),, 2406)
IVBUnsignedLongPart& IVBUnsignedLongPart::setValue (unsigned long aValue)
{
  if (iValue != aValue) {
    unsigned long oldValue = iValue;
    iValue = aValue;
    notifyObservers(INotificationEvent(valueId, *this,
                    true, (void*)iValue));
    if (iValue == 0) {
      notifyObservers(INotificationEvent(valueZeroId, *this,
                      true, (void*)iValue));
    }
    else {
      if (oldValue == 0) {
        notifyObservers(INotificationEvent(valueNotZeroId, *this,
                        true, (void*)iValue));
      } ; /* endif */
    } ; /* endif */
    if (iDefaultValue == iValue) {
      notifyObservers(INotificationEvent(valueEqualDefaultId, *this,
                      true, (void*)iValue));
    }
    else {
      if (iDefaultValue == oldValue) {
        notifyObservers(INotificationEvent(valueNotEqualDefaultId, *this,
                        true, (void*)iValue));
      } /* endif */
    } /* endif */
    if (iValue == iLowLimit) {
      notifyObservers(INotificationEvent(valueEqualLowLimitId, *this,
                      true, (void*)iValue));
    } ; /* endif */
    if (iLowLimit != 0) {
      if (iValue < iLowLimit) {
        if (!(oldValue < iLowLimit)) {
          notifyObservers(INotificationEvent(valueBelowLowLimitId, *this,
                          true, (void*)iValue));
        } ; /* endif */
      } ; /* endif */
    } ; /* endif */
    if (iValue == iHighLimit) {
      notifyObservers(INotificationEvent(valueEqualHighLimitId, *this,
                      true, (void*)iValue));
    } ; /* endif */
    if (iHighLimit != ULONG_MAX) {
      if (iValue > iHighLimit) {
        if (!(oldValue > iHighLimit)) {
          notifyObservers(INotificationEvent(valueAboveHighLimitId, *this,
                          true, (void*)iValue));
        } ; /* endif */
      } ; /* endif */
    } ; /* endif */
    if ((iValue >= iLowLimit) && (iValue <= iHighLimit)) {
      if (!((oldValue >= iLowLimit) && (oldValue <= iHighLimit))) {
        notifyObservers(INotificationEvent(valueWithinLimitsId, *this,
                        true, (void*)iValue));
      } ; /* endif */
    }
    else {
      if (((oldValue >= iLowLimit) && (oldValue <= iHighLimit))) {
        notifyObservers(INotificationEvent(valueOutsideLimitsId, *this,
                        true, (void*)iValue));
      } ; /* endif */
    } ; /* endif */
  } ; /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::setValue                                                |
|                                                                              |
| Set the value attribute.                                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::setValue(),, 2407)
IVBUnsignedLongPart& IVBUnsignedLongPart::setValue ()
{
  return setValue(defaultValue());
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::valueAsText                                             |
|                                                                              |
| Return the valueAsText attribute.                                            |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::valueAsText() const,, 2408)
IString IVBUnsignedLongPart::valueAsText () const
{
  return IString (value());
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::setValueAsText                                          |
|                                                                              |
| Set the valueAsText attribute.                                               |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::setValueAsText(const IString&),, 2409)
IVBUnsignedLongPart& IVBUnsignedLongPart::setValueAsText (const IString& aValueAsText)
{
#ifdef IC_PM
  IString tempValueString(aValueAsText);
  setValue (aValueAsText.asInt());
  tempValueString = tempValueString.strip();

  IString firstCharOfString(tempValueString.subString(1,1));  //Gets 1st char of string
  Boolean testFirstChar=firstCharOfString.indexOfAnyOf("+");  //Checks 2C if 1st char is +

  if (testFirstChar) {
     tempValueString=tempValueString.subString(2);            //Uses rest of string after sign
  } /* endif */

  tempValueString = tempValueString.strip();

  Boolean iValid = tempValueString.isDigits();

  IString eventData(aValueAsText);
  if (iValid) {
    notifyObservers(INotificationEvent(inputStringIsValidId, *this,
                      true, (void*)&eventData));
  } else {
    notifyObservers(INotificationEvent(inputStringNotValidId, *this,
                      true, (void*)&eventData));
  } /* endif */
#endif
#ifdef IC_WIN
  setValue (aValueAsText.asUnsigned());
  Boolean iValid = aValueAsText.indexOfAnyBut("+0123456789 ");
  if (iValid) {
    IString eventData(aValueAsText);
    notifyObservers(INotificationEvent(inputStringNotValidId, *this,
                      true, (void*)&eventData));
  } else {
    IString eventData(aValueAsText);
    notifyObservers(INotificationEvent(inputStringIsValidId, *this,
                      true, (void*)&eventData));
  } /* endif */
#endif
  return *this;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::setValueAsText                                          |
|                                                                              |
| Set the valueAsText attribute.                                               |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::setValueAsText(const IString*),, 2410)
IVBUnsignedLongPart& IVBUnsignedLongPart::setValueAsText (const IString* aValueAsText)
{
  return setValueAsText (*aValueAsText);
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::valueAs1Based                                           |
|                                                                              |
| Return the valueAs1Based attribute.                                          |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::valueAs1Based() const,, 2411)
unsigned long IVBUnsignedLongPart::valueAs1Based () const
{
  return (value() + 1) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::setValueAs1Based                                        |
|                                                                              |
| Set the valueAs1Based attribute.                                             |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::setValueAs1Based(unsigned long),, 2412)
IVBUnsignedLongPart& IVBUnsignedLongPart::setValueAs1Based (unsigned long aValueAs1Based)
{
  return setValue (aValueAs1Based - 1);
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::defaultValue                                            |
|                                                                              |
| Return the defaultValue attribute.                                           |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::defaultValue() const,, 2413)
unsigned long IVBUnsignedLongPart::defaultValue () const
{
  return iDefaultValue;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::setDefaultValue                                         |
|                                                                              |
| Set the defaultValue attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::setDefaultValue(const unsigned long),, 2414)
IVBUnsignedLongPart& IVBUnsignedLongPart::setDefaultValue (unsigned long aDefaultValue)
{
  if (iDefaultValue != aDefaultValue) {
    unsigned long oldValue = iDefaultValue;
    iDefaultValue = aDefaultValue;
    notifyObservers(INotificationEvent(defaultValueId, *this,
                      true, (void*)iDefaultValue));
    if (iDefaultValue == iValue) {
      notifyObservers(INotificationEvent(valueEqualDefaultId, *this,
                      true, (void*)iValue));
    }
    else {
      if (oldValue == iValue) {
        notifyObservers(INotificationEvent(valueNotEqualDefaultId, *this,
                        true, (void*)iValue));
      } /* endif */
    } /* endif */
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::isValueEqualDefault                                     |
|                                                                              |
| Return the valueEqualDefault attribute.                                      |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::isValueEqualDefault() const,, 2415)
Boolean IVBUnsignedLongPart::isValueEqualDefault () const
{
  return (value() == defaultValue ()) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::isValueNotEqualDefault                                  |
|                                                                              |
| Return the valueNotEqualDefault attribute.                                   |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::isValueNotEqualDefault() const,, 2416)
Boolean IVBUnsignedLongPart::isValueNotEqualDefault () const
{
  return (value() != defaultValue ()) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::lowLimit                                                |
|                                                                              |
| Return the lowLimit attribute.                                               |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::lowLimit() const,, 2417)
unsigned long IVBUnsignedLongPart::lowLimit () const
{
  return iLowLimit;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::setLowLimit                                             |
|                                                                              |
| Set the lowLimit attribute.                                                  |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::setLowLimit(const unsigned long),, 2418)
IVBUnsignedLongPart& IVBUnsignedLongPart::setLowLimit (unsigned long aLowLimit)
{
  if (iLowLimit != aLowLimit) {
    unsigned long oldValue = iLowLimit;
    iLowLimit = aLowLimit;
    notifyObservers(INotificationEvent(lowLimitId, *this,
                      true, (void*)iLowLimit));
    if (iValue == lowLimit()) {
      notifyObservers(INotificationEvent(valueEqualLowLimitId, *this,
                      true, (void*)iValue));
    } ; /* endif */
    if (lowLimit() != 0) {
      if (iValue < iLowLimit) {
        if (!(iValue < oldValue)) {
          notifyObservers(INotificationEvent(valueBelowLowLimitId, *this,
                          true, (void*)iValue));
        } ; /* endif */
      } ; /* endif */
    } ; /* endif */
    if ((iValue >= lowLimit()) && (iValue <= highLimit())) {
      if (!((iValue >= oldValue) && (iValue <= highLimit()))) {
        notifyObservers(INotificationEvent(valueWithinLimitsId, *this,
                        true, (void*)iLowLimit));
      } ; /* endif */
    }
    else {
      if ((iValue >= oldValue) && (iValue <= highLimit())) {
        notifyObservers(INotificationEvent(valueOutsideLimitsId, *this,
                        true, (void*)iLowLimit));
      } ; /* endif */
    } ; /* endif */
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::highLimit                                               |
|                                                                              |
| Return the highLimit attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::highLimit() const,, 2419)
unsigned long IVBUnsignedLongPart::highLimit () const
{
  return iHighLimit;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::setHighLimit                                            |
|                                                                              |
| Set the highLimit attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::setHighLimit(const unsigned long),, 2420)
IVBUnsignedLongPart& IVBUnsignedLongPart::setHighLimit (unsigned long aHighLimit)
{
  if (iHighLimit != aHighLimit) {
    unsigned long oldValue = iHighLimit;
    iHighLimit = aHighLimit;
    notifyObservers(INotificationEvent(highLimitId, *this,
                      true, (void*)iHighLimit));
    if (iValue == highLimit()) {
      notifyObservers(INotificationEvent(valueEqualHighLimitId, *this,
                      true, (void*)iValue));
    } ; /* endif */
    if (highLimit() != ULONG_MAX) {
      if (iValue > iHighLimit) {
        if (!(iValue > oldValue)) {
          notifyObservers(INotificationEvent(valueAboveHighLimitId, *this,
                          true, (void*)iValue));
        } ; /* endif */
      } ; /* endif */
    } ; /* endif */
    if ((iValue >= lowLimit()) && (iValue <= highLimit())) {
      if (!((iValue >= lowLimit()) && (iValue <= oldValue))) {
        notifyObservers(INotificationEvent(valueWithinLimitsId, *this,
                        true, (void*)iHighLimit));
      } ; /* endif */
    }
    else {
      if ((iValue >= lowLimit()) && (iValue <= oldValue)) {
        notifyObservers(INotificationEvent(valueOutsideLimitsId, *this,
                        true, (void*)iHighLimit));
      } ; /* endif */
    } ; /* endif */
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::isValueEqualLowLimit                                    |
|                                                                              |
| Return the valueEqualLowLimit attribute.                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::isValueEqualLowLimit() const,, 2421)
Boolean IVBUnsignedLongPart::isValueEqualLowLimit () const
{
  return (value() == lowLimit ()) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::isValueEqualHighLimit                                   |
|                                                                              |
| Return the valueEqualHighLimit attribute.                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::isValueEqualHighLimit() const,, 2422)
Boolean IVBUnsignedLongPart::isValueEqualHighLimit () const
{
  return (value() == highLimit ()) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::isValueBelowLowLimit                                    |
|                                                                              |
| Return the valueBelowLowLimit attribute.                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::isValueBelowLowLimit() const,, 2423)
Boolean IVBUnsignedLongPart::isValueBelowLowLimit () const
{
  return (value() < lowLimit ()) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::isValueAboveHighLimit                                   |
|                                                                              |
| Return the valueAboveHighLimit attribute.                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::isValueAboveHighLimit() const,, 2424)
Boolean IVBUnsignedLongPart::isValueAboveHighLimit () const
{
  return (value() > highLimit ()) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::isValueOutsideLimits                                    |
|                                                                              |
| Return the valueOutsideLimits attribute.                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::isValueOutsideLimits() const,, 2425)
Boolean IVBUnsignedLongPart::isValueOutsideLimits () const
{
  return ((value() < lowLimit()) || (value() > highLimit())) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::isValueWithinLimits                                     |
|                                                                              |
| Return the valueWithinLimits attribute.                                      |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::isValueWithinLimits() const,, 2426)
Boolean IVBUnsignedLongPart::isValueWithinLimits () const
{
  return !isValueOutsideLimits ();
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::isValueNotZero                                          |
|                                                                              |
| Return the valueNotZero attribute.                                           |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::isValueNotZero() const,, 2427)
Boolean IVBUnsignedLongPart::isValueNotZero () const
{
  return (value() != 0) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::isValueZero                                             |
|                                                                              |
| Return the valueZero attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::isValueZero() const,, 2428)
Boolean IVBUnsignedLongPart::isValueZero () const
{
  return (value() == 0) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::assignValueToZero                                       |
|                                                                              |
| Assign the value attribute to 0.                                             |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::assignValueToZero(),, 2429)
IVBUnsignedLongPart& IVBUnsignedLongPart::assignValueToZero ()
{
  return setValue (0) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::assignValueToOne                                        |
|                                                                              |
| Assign the value attribute to 1.                                             |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::assignValueToOne(),, 2430)
IVBUnsignedLongPart& IVBUnsignedLongPart::assignValueToOne ()
{
  return setValue (1) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::assignValueToLowLimit                                   |
|                                                                              |
| Assign the value attribute to low limit attribute.                           |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::assignValueToLowLimit(),, 2431)
IVBUnsignedLongPart& IVBUnsignedLongPart::assignValueToLowLimit ()
{
  return setValue (lowLimit()) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::assignValueToHighLimit                                  |
|                                                                              |
| Assign the value attribute to high limit attribute.                          |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::assignValueToHighLimit(),, 2432)
IVBUnsignedLongPart& IVBUnsignedLongPart::assignValueToHighLimit ()
{
  return setValue (highLimit()) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::assignValueToDefault                                    |
|                                                                              |
| Assign the value attribute to default.                                       |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::assignValueToDefault(),, 2433)
IVBUnsignedLongPart& IVBUnsignedLongPart::assignValueToDefault ()
{
  return setValue (defaultValue ()) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::assignValueToRandom                                     |
|                                                                              |
| Assign the value attribute to a pseudo-random number.                        |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::assignValueToRandom(),, 2434)
IVBUnsignedLongPart& IVBUnsignedLongPart::assignValueToRandom ()
{
  return setValue (rand ()) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::copyValueToDefault                                      |
|                                                                              |
| Copy the value attribute to default.                                         |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::copyValueToDefault(),, 2435)
IVBUnsignedLongPart& IVBUnsignedLongPart::copyValueToDefault ()
{
  return setDefaultValue (value()) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::squareValue                                             |
|                                                                              |
| Square the value attribute.                                                  |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::squareValue(),, 2436)
IVBUnsignedLongPart& IVBUnsignedLongPart::squareValue()
{
  return setValue (value() * value()) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::addValue                                                |
|                                                                              |
| Perform the add operator to the value attribute.                             |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::addValue (unsigned long),, 2437)
IVBUnsignedLongPart& IVBUnsignedLongPart::addValue (unsigned long addValue)
{
  return setValue (value() + addValue) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::subtractValue                                           |
|                                                                              |
| Perform the subtract operator to the value attribute.                        |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::subtractValue (unsigned long),, 2438)
IVBUnsignedLongPart& IVBUnsignedLongPart::subtractValue (unsigned long subtractValue)
{
  return setValue (value() - subtractValue) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::multiplyValue                                           |
|                                                                              |
| Perform the multiply operator to the value attribute.                        |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::multiplyValue (unsigned long),, 2439)
IVBUnsignedLongPart& IVBUnsignedLongPart::multiplyValue (unsigned long multiplyValue)
{
  return setValue (value() * multiplyValue) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::divideValue                                            |
|                                                                             |
| Perform the divide operator to the value attribute.                         |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::divideValue (unsigned long),, 2440)
IVBUnsignedLongPart& IVBUnsignedLongPart::divideValue (unsigned long divideValue)
{
  if (divideValue)
    return setValue (value() / divideValue) ;
  return *this;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::andValue                                                |
|                                                                              |
| Perform the and operator to the value attribute.                             |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::andValue (unsigned long),, 2441)
IVBUnsignedLongPart& IVBUnsignedLongPart::andValue (unsigned long andValue)
{
  return setValue (value() & andValue) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::orValue                                                 |
|                                                                              |
| Perform the or operator to the value attribute.                              |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::orValue (unsigned long),, 2442)
IVBUnsignedLongPart& IVBUnsignedLongPart::orValue (unsigned long orValue)
{
  return setValue (value() | orValue) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::operator == (const IVBUnsignedLongPart & aValue)        |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::operator == (const IVBUnsignedLongPart&) const,, 2443)
Boolean IVBUnsignedLongPart::
  operator == (const IVBUnsignedLongPart& aValue) const
{
  if (value() != aValue.value()) {
    return false;
  } /* endif */
  if (defaultValue() != aValue.defaultValue()) {
    return false;
  } /* endif */
  if (lowLimit() != aValue.lowLimit()) {
    return false;
  } /* endif */
  if (highLimit() != aValue.highLimit()) {
    return false;
  } /* endif */
  return true;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::operator != (const IVBUnsignedLongPart & aValue)        |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::operator != (const IVBUnsignedLongPart&) const,, 2444)
Boolean IVBUnsignedLongPart::
  operator != (const IVBUnsignedLongPart& aValue) const
{
  if (value() != aValue.value()) {
    return true;
  } /* endif */
  if (defaultValue() != aValue.defaultValue()) {
    return true;
  } /* endif */
  if (lowLimit() != aValue.lowLimit()) {
    return true;
  } /* endif */
  if (highLimit() != aValue.highLimit()) {
    return true;
  } /* endif */
  return false;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::operator == (const IVBUnsignedLongPart * aValue)        |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::operator == (const IVBUnsignedLongPart*) const,, 2445)
Boolean IVBUnsignedLongPart::
  operator == (const IVBUnsignedLongPart* aValue) const
{
  if (value() != aValue->value()) {
    return false;
  } /* endif */
  if (defaultValue() != aValue->defaultValue()) {
    return false;
  } /* endif */
  if (lowLimit() != aValue->lowLimit()) {
    return false;
  } /* endif */
  if (highLimit() != aValue->highLimit()) {
    return false;
  } /* endif */
  return true;
}

/*------------------------------------------------------------------------------
| IVBUnsignedLongPart::operator != (const IVBUnsignedLongPart * aValue)        |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedLongPart::operator != (const IVBUnsignedLongPart*) const,, 2446)
Boolean IVBUnsignedLongPart::
  operator != (const IVBUnsignedLongPart* aValue) const
{
  if (value() != aValue->value()) {
    return true;
  } /* endif */
  if (defaultValue() != aValue->defaultValue()) {
    return true;
  } /* endif */
  if (lowLimit() != aValue->lowLimit()) {
    return true;
  } /* endif */
  if (highLimit() != aValue->highLimit()) {
    return true;
  } /* endif */
  return false;
}
