/*******************************************************************************
* FILE NAME: ivbushrt.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class(es):                                     *
*    IVBUnsignedShortPart - IBM VB sample Unsigned Short part.                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
* DISCLAIMER OF WARRANTIES:                                                    *
*   The following [enclosed] code is sample code created by IBM                *
*   Corporation.  This sample code is not part of any standard IBM product     *
*   and is provided to you solely for the purpose of assisting you in the      *
*   development of your applications.  The code is provided "AS IS",           *
*   without warranty of any kind.  IBM shall not be liable for any damages     *
*   arising out of your use of the sample code, even if they have been         *
*   advised of the possibility of such damages.                                *
*******************************************************************************/

#ifndef _IVBUSHRT_
  #include <ivbushrt.hpp>
#endif

#ifndef _INOTIFEV_
  #include <inotifev.hpp>
#endif



/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::IVBUnsignedShortPart                                   |
|                                                                              |
| Standard constructor.                                                        |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::IVBUnsignedShortPart(unsigned short aValue),, 2500)
IVBUnsignedShortPart::IVBUnsignedShortPart(unsigned short aValue) : IVBDataTypePart ()
    ,iValue (aValue)
    ,iDefaultValue (0)
    ,iLowLimit (0)
    ,iHighLimit (USHRT_MAX)
{
  enableNotification ();
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::IVBUnsignedShortPart                                   |
|                                                                              |
| Standard copy constructor.                                                   |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::IVBUnsignedShortPart(const IVBUnsignedShortPart&),, 2501)
IVBUnsignedShortPart::IVBUnsignedShortPart (const IVBUnsignedShortPart& partCopy)
  : IVBDataTypePart (partCopy)
    ,iValue (partCopy.value ())
    ,iDefaultValue (partCopy.defaultValue ())
    ,iLowLimit (partCopy.lowLimit ())
    ,iHighLimit (partCopy.highLimit ())
{
  enableNotification ();
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::IVBUnsignedShortPart                                   |
|                                                                              |
| Standard operator=                                                           |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::operator= (const IVBUnsignedShortPart&),, 2502)
IVBUnsignedShortPart& IVBUnsignedShortPart::operator= (const IVBUnsignedShortPart& aIVBUnsignedShortPart)
{
  if (this == &aIVBUnsignedShortPart) {
    return *this;
  } /* endif */
  Inherited::operator=(aIVBUnsignedShortPart);
  setValue(aIVBUnsignedShortPart.value());
  setDefaultValue(aIVBUnsignedShortPart.defaultValue());
  setLowLimit(aIVBUnsignedShortPart.lowLimit());
  setHighLimit(aIVBUnsignedShortPart.highLimit());
  return *this;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::~IVBUnsignedShortPart                                  |
|                                                                              |
| IVBUnsignedShortPart destructor.                                             |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::~IVBUnsignedShortPart(),, 2503)
IVBUnsignedShortPart::~IVBUnsignedShortPart()
{
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::asString                                               |
|                                                                              |
| Perform asString.                                                            |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::asString() const,, 2504)
IString IVBUnsignedShortPart::asString () const
{
  return valueAsText();
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::value                                                  |
|                                                                              |
| Return the value attribute.                                                  |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::value() const,, 2505)
unsigned short IVBUnsignedShortPart::value () const
{
  return iValue;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::setValue                                               |
|                                                                              |
| Set the value attribute.                                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::setValue(const unsigned short),, 2506)
IVBUnsignedShortPart& IVBUnsignedShortPart::setValue (unsigned short aValue)
{
  if (iValue != aValue) {
    unsigned short oldValue = iValue;
    iValue = aValue;
    notifyObservers(INotificationEvent(valueId, *this,
                    true, (void*)iValue));
    if (iValue == 0) {
      notifyObservers(INotificationEvent(valueZeroId, *this,
                      true, (void*)iValue));
    }
    else {
      if (oldValue == 0) {
        notifyObservers(INotificationEvent(valueNotZeroId, *this,
                        true, (void*)iValue));
      } ; /* endif */
    } ; /* endif */
    if (iDefaultValue == iValue) {
      notifyObservers(INotificationEvent(valueEqualDefaultId, *this,
                      true, (void*)iValue));
    }
    else {
      if (iDefaultValue == oldValue) {
        notifyObservers(INotificationEvent(valueNotEqualDefaultId, *this,
                        true, (void*)iValue));
      } /* endif */
    } /* endif */
    if (iValue == iLowLimit) {
      notifyObservers(INotificationEvent(valueEqualLowLimitId, *this,
                      true, (void*)iValue));
    } ; /* endif */
    if (iLowLimit != 0) {
      if (iValue < iLowLimit) {
        if (!(oldValue < iLowLimit)) {
          notifyObservers(INotificationEvent(valueBelowLowLimitId, *this,
                          true, (void*)iValue));
        } ; /* endif */
      } ; /* endif */
    } ; /* endif */
    if (iValue == iHighLimit) {
      notifyObservers(INotificationEvent(valueEqualHighLimitId, *this,
                      true, (void*)iValue));
    } ; /* endif */
    if (iHighLimit != USHRT_MAX) {
      if (iValue > iHighLimit) {
        if (!(oldValue > iHighLimit)) {
          notifyObservers(INotificationEvent(valueAboveHighLimitId, *this,
                          true, (void*)iValue));
        } ; /* endif */
      } ; /* endif */
    } ; /* endif */
    if ((iValue >= iLowLimit) && (iValue <= iHighLimit)) {
      if (!((oldValue >= iLowLimit) && (oldValue <= iHighLimit))) {
        notifyObservers(INotificationEvent(valueWithinLimitsId, *this,
                        true, (void*)iValue));
      } ; /* endif */
    }
    else {
      if (((oldValue >= iLowLimit) && (oldValue <= iHighLimit))) {
        notifyObservers(INotificationEvent(valueOutsideLimitsId, *this,
                        true, (void*)iValue));
      } ; /* endif */
    } ; /* endif */
  } ; /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::setValue                                               |
|                                                                              |
| Set the value attribute.                                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::setValue(),, 2507)
IVBUnsignedShortPart& IVBUnsignedShortPart::setValue ()
{
  return setValue(defaultValue());
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::valueAsText                                            |
|                                                                              |
| Return the valueAsText attribute.                                            |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::valueAsText() const,, 2508)
IString IVBUnsignedShortPart::valueAsText () const
{
  return IString (value());
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::setValueAsText                                         |
|                                                                              |
| Set the valueAsText attribute.                                               |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::setValueAsText(const IString&),, 2509)
IVBUnsignedShortPart& IVBUnsignedShortPart::setValueAsText (const IString& aValueAsText)
{
#ifdef IC_PM
  Boolean iValid=1;
  IString tempValueString(aValueAsText);
  setValue (aValueAsText.asInt());
  tempValueString = tempValueString.strip();

  if ((tempValueString.asInt()>65535)) iValid=0;

  IString firstCharOfString(tempValueString.subString(1,1));  //Gets 1st char of string
  Boolean testFirstChar=firstCharOfString.indexOfAnyOf("+");  //Checks 2C if 1st char is +

  if (testFirstChar) {
     tempValueString=tempValueString.subString(2);            //Uses rest of string after sign
  } /* endif */

  tempValueString = tempValueString.strip();

  if (iValid) iValid = tempValueString.isDigits();

  IString eventData(aValueAsText);
  if (iValid) {
    notifyObservers(INotificationEvent(inputStringIsValidId, *this,
                      true, (void*)&eventData));
  } else {
    notifyObservers(INotificationEvent(inputStringNotValidId, *this,
                      true, (void*)&eventData));
  } /* endif */
#endif
#ifdef IC_WIN
  setValue (aValueAsText.asUnsigned());
  Boolean iValid = aValueAsText.indexOfAnyBut("+0123456789 ");
  if (iValid) {
    IString eventData(aValueAsText);
    notifyObservers(INotificationEvent(inputStringNotValidId, *this,
                      true, (void*)&eventData));
  } else {
    IString eventData(aValueAsText);
    notifyObservers(INotificationEvent(inputStringIsValidId, *this,
                      true, (void*)&eventData));
  } /* endif */
#endif
  return *this;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::setValueAsText                                         |
|                                                                              |
| Set the valueAsText attribute.                                               |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::setValueAsText(const IString*),, 2510)
IVBUnsignedShortPart& IVBUnsignedShortPart::setValueAsText (const IString* aValueAsText)
{
  return setValueAsText (*aValueAsText);
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::valueAs1Based                                          |
|                                                                              |
| Return the valueAs1Based attribute.                                          |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::valueAs1Based() const,, 2511)
unsigned short IVBUnsignedShortPart::valueAs1Based () const
{
  return (value() + 1) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::setValueAs1Based                                       |
|                                                                              |
| Set the valueAs1Based attribute.                                             |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::setValueAs1Based(unsigned short),, 2512)
IVBUnsignedShortPart& IVBUnsignedShortPart::setValueAs1Based (unsigned short aValueAs1Based)
{
  return setValue (aValueAs1Based - 1);
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::defaultValue                                           |
|                                                                              |
| Return the defaultValue attribute.                                           |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::defaultValue() const,, 2513)
unsigned short IVBUnsignedShortPart::defaultValue () const
{
  return iDefaultValue;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::setDefaultValue                                        |
|                                                                              |
| Set the defaultValue attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::setDefaultValue(const unsigned short),, 2514)
IVBUnsignedShortPart& IVBUnsignedShortPart::setDefaultValue (unsigned short aDefaultValue)
{
  if (iDefaultValue != aDefaultValue) {
    unsigned short oldValue = iDefaultValue;
    iDefaultValue = aDefaultValue;
    notifyObservers(INotificationEvent(defaultValueId, *this,
                      true, (void*)iDefaultValue));
    if (iDefaultValue == iValue) {
      notifyObservers(INotificationEvent(valueEqualDefaultId, *this,
                      true, (void*)iValue));
    }
    else {
      if (oldValue == iValue) {
        notifyObservers(INotificationEvent(valueNotEqualDefaultId, *this,
                        true, (void*)iValue));
      } /* endif */
    } /* endif */
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::isValueEqualDefault                                    |
|                                                                              |
| Return the valueEqualDefault attribute.                                      |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::isValueEqualDefault() const,, 2515)
Boolean IVBUnsignedShortPart::isValueEqualDefault () const
{
  return (value() == defaultValue ()) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::isValueNotEqualDefault                                 |
|                                                                              |
| Return the valueNotEqualDefault attribute.                                   |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::isValueNotEqualDefault() const,, 2516)
Boolean IVBUnsignedShortPart::isValueNotEqualDefault () const
{
  return (value() != defaultValue ()) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::lowLimit                                               |
|                                                                              |
| Return the lowLimit attribute.                                               |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::lowLimit() const,, 2517)
unsigned short IVBUnsignedShortPart::lowLimit () const
{
  return iLowLimit;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::setLowLimit                                            |
|                                                                              |
| Set the lowLimit attribute.                                                  |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::setLowLimit(const unsigned short),, 2518)
IVBUnsignedShortPart& IVBUnsignedShortPart::setLowLimit (unsigned short aLowLimit)
{
  if (iLowLimit != aLowLimit) {
    unsigned short oldValue = iLowLimit;
    iLowLimit = aLowLimit;
    notifyObservers(INotificationEvent(lowLimitId, *this,
                      true, (void*)iLowLimit));
    if (iValue == lowLimit()) {
      notifyObservers(INotificationEvent(valueEqualLowLimitId, *this,
                      true, (void*)iValue));
    } ; /* endif */
    if (lowLimit() != 0) {
      if (iValue < iLowLimit) {
        if (!(iValue < oldValue)) {
          notifyObservers(INotificationEvent(valueBelowLowLimitId, *this,
                          true, (void*)iValue));
        } ; /* endif */
      } ; /* endif */
    } ; /* endif */
    if ((iValue >= lowLimit()) && (iValue <= highLimit())) {
      if (!((iValue >= oldValue) && (iValue <= highLimit()))) {
        notifyObservers(INotificationEvent(valueWithinLimitsId, *this,
                        true, (void*)iLowLimit));
      } ; /* endif */
    }
    else {
      if ((iValue >= oldValue) && (iValue <= highLimit())) {
        notifyObservers(INotificationEvent(valueOutsideLimitsId, *this,
                        true, (void*)iLowLimit));
      } ; /* endif */
    } ; /* endif */
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::highLimit                                              |
|                                                                              |
| Return the highLimit attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::highLimit() const,, 2519)
unsigned short IVBUnsignedShortPart::highLimit () const
{
  return iHighLimit;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::setHighLimit                                           |
|                                                                              |
| Set the highLimit attribute.                                                 |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::setHighLimit(const unsigned short),, 2520)
IVBUnsignedShortPart& IVBUnsignedShortPart::setHighLimit (unsigned short aHighLimit)
{
  if (iHighLimit != aHighLimit) {
    unsigned short oldValue = iHighLimit;
    iHighLimit = aHighLimit;
    notifyObservers(INotificationEvent(highLimitId, *this,
                      true, (void*)iHighLimit));
    if (iValue == highLimit()) {
      notifyObservers(INotificationEvent(valueEqualHighLimitId, *this,
                      true, (void*)iValue));
    } ; /* endif */
    if (highLimit() != USHRT_MAX) {
      if (iValue > iHighLimit) {
        if (!(iValue > oldValue)) {
          notifyObservers(INotificationEvent(valueAboveHighLimitId, *this,
                          true, (void*)iValue));
        } ; /* endif */
      } ; /* endif */
    } ; /* endif */
    if ((iValue >= lowLimit()) && (iValue <= highLimit())) {
      if (!((iValue >= lowLimit()) && (iValue <= oldValue))) {
        notifyObservers(INotificationEvent(valueWithinLimitsId, *this,
                        true, (void*)iHighLimit));
      } ; /* endif */
    }
    else {
      if ((iValue >= lowLimit()) && (iValue <= oldValue)) {
        notifyObservers(INotificationEvent(valueOutsideLimitsId, *this,
                        true, (void*)iHighLimit));
      } ; /* endif */
    } ; /* endif */
  } /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::isValueEqualLowLimit                                   |
|                                                                              |
| Return the valueEqualLowLimit attribute.                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::isValueEqualLowLimit() const,, 2521)
Boolean IVBUnsignedShortPart::isValueEqualLowLimit () const
{
  return (value() == lowLimit ()) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::isValueEqualHighLimit                                  |
|                                                                              |
| Return the valueEqualHighLimit attribute.                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::isValueEqualHighLimit() const,, 2522)
Boolean IVBUnsignedShortPart::isValueEqualHighLimit () const
{
  return (value() == highLimit ()) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::isValueBelowLowLimit                                   |
|                                                                              |
| Return the valueBelowLowLimit attribute.                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::isValueBelowLowLimit() const,, 2523)
Boolean IVBUnsignedShortPart::isValueBelowLowLimit () const
{
  return (value() < lowLimit ()) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::isValueAboveHighLimit                                  |
|                                                                              |
| Return the valueAboveHighLimit attribute.                                    |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::isValueAboveHighLimit() const,, 2524)
Boolean IVBUnsignedShortPart::isValueAboveHighLimit () const
{
  return (value() > highLimit ()) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::isValueOutsideLimits                                   |
|                                                                              |
| Return the valueOutsideLimits attribute.                                     |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::isValueOutsideLimits() const,, 2525)
Boolean IVBUnsignedShortPart::isValueOutsideLimits () const
{
  return ((value() < lowLimit()) || (value() > highLimit())) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::isValueWithinLimits                                    |
|                                                                              |
| Return the valueWithinLimits attribute.                                      |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::isValueWithinLimits() const,, 2526)
Boolean IVBUnsignedShortPart::isValueWithinLimits () const
{
  return !isValueOutsideLimits ();
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::isValueNotZero                                         |
|                                                                              |
| Return the valueNotZero attribute.                                           |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::isValueNotZero() const,, 2527)
Boolean IVBUnsignedShortPart::isValueNotZero () const
{
  return (value() != 0) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::isValueZero                                            |
|                                                                              |
| Return the valueZero attribute.                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::isValueZero() const,, 2528)
Boolean IVBUnsignedShortPart::isValueZero () const
{
  return (value() == 0) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::assignValueToZero                                      |
|                                                                              |
| Assign the value attribute to 0.                                             |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::assignValueToZero(),, 2529)
IVBUnsignedShortPart& IVBUnsignedShortPart::assignValueToZero ()
{
  return setValue (0) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::assignValueToOne                                       |
|                                                                              |
| Assign the value attribute to 1.                                             |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::assignValueToOne(),, 2530)
IVBUnsignedShortPart& IVBUnsignedShortPart::assignValueToOne ()
{
  return setValue (1) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::assignValueToLowLimit                                  |
|                                                                              |
| Assign the value attribute to low limit attribute.                           |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::assignValueToLowLimit(),, 2531)
IVBUnsignedShortPart& IVBUnsignedShortPart::assignValueToLowLimit ()
{
  return setValue (lowLimit()) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::assignValueToHighLimit                                 |
|                                                                              |
| Assign the value attribute to high limit attribute.                          |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::assignValueToHighLimit(),, 2532)
IVBUnsignedShortPart& IVBUnsignedShortPart::assignValueToHighLimit ()
{
  return setValue (highLimit()) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::assignValueToDefault                                   |
|                                                                              |
| Assign the value attribute to default.                                       |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::assignValueToDefault(),, 2533)
IVBUnsignedShortPart& IVBUnsignedShortPart::assignValueToDefault ()
{
  return setValue (defaultValue ()) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::assignValueToRandom                                    |
|                                                                              |
| Assign the value attribute to a pseudo-random number.                        |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::assignValueToRandom(),, 2534)
IVBUnsignedShortPart& IVBUnsignedShortPart::assignValueToRandom ()
{
  return setValue (rand ()) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::copyValueToDefault                                     |
|                                                                              |
| Copy the value attribute to default.                                         |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::copyValueToDefault(),, 2535)
IVBUnsignedShortPart& IVBUnsignedShortPart::copyValueToDefault ()
{
  return setDefaultValue (value()) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::squareValue                                            |
|                                                                              |
| Square the value attribute.                                                  |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::squareValue(),, 2536)
IVBUnsignedShortPart& IVBUnsignedShortPart::squareValue()
{
  return setValue (value() * value()) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::addValue                                               |
|                                                                              |
| Perform the add operator to the value attribute.                             |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::addValue (unsigned short),, 2537)
IVBUnsignedShortPart& IVBUnsignedShortPart::addValue (unsigned short addValue)
{
  return setValue (value() + addValue) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::subtractValue                                          |
|                                                                              |
| Perform the subtract operator to the value attribute.                        |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::subtractValue (unsigned short),, 2538)
IVBUnsignedShortPart& IVBUnsignedShortPart::subtractValue (unsigned short subtractValue)
{
  return setValue (value() - subtractValue) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::multiplyValue                                          |
|                                                                              |
| Perform the multiply operator to the value attribute.                        |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::multiplyValue (unsigned short),, 2539)
IVBUnsignedShortPart& IVBUnsignedShortPart::multiplyValue (unsigned short multiplyValue)
{
  return setValue (value() * multiplyValue) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::divideValue                                           |
|                                                                             |
| Perform the divide operator to the value attribute.                         |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::divideValue (unsigned short),, 2540)
IVBUnsignedShortPart& IVBUnsignedShortPart::divideValue (unsigned short divideValue)
{
  if (divideValue)
    return setValue (value() / divideValue) ;
  return *this;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::andValue                                               |
|                                                                              |
| Perform the and operator to the value attribute.                             |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::andValue (unsigned short),, 2541)
IVBUnsignedShortPart& IVBUnsignedShortPart::andValue (unsigned short andValue)
{
  return setValue (value() & andValue) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::orValue                                                |
|                                                                              |
| Perform the or operator to the value attribute.                              |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::orValue (unsigned short),, 2542)
IVBUnsignedShortPart& IVBUnsignedShortPart::orValue (unsigned short orValue)
{
  return setValue (value() | orValue) ;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::operator == (const IVBUnsignedShortPart & aValue)      |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::operator == (const IVBUnsignedShortPart&) const,, 2543)
Boolean IVBUnsignedShortPart::
  operator == (const IVBUnsignedShortPart& aValue) const
{
  if (value() != aValue.value()) {
    return false;
  } /* endif */
  if (defaultValue() != aValue.defaultValue()) {
    return false;
  } /* endif */
  if (lowLimit() != aValue.lowLimit()) {
    return false;
  } /* endif */
  if (highLimit() != aValue.highLimit()) {
    return false;
  } /* endif */
  return true;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::operator != (const IVBUnsignedShortPart & aValue)      |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::operator != (const IVBUnsignedShortPart&) const,, 2544)
Boolean IVBUnsignedShortPart::
  operator != (const IVBUnsignedShortPart& aValue) const
{
  if (value() != aValue.value()) {
    return true;
  } /* endif */
  if (defaultValue() != aValue.defaultValue()) {
    return true;
  } /* endif */
  if (lowLimit() != aValue.lowLimit()) {
    return true;
  } /* endif */
  if (highLimit() != aValue.highLimit()) {
    return true;
  } /* endif */
  return false;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::operator == (const IVBUnsignedShortPart * aValue)      |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::operator == (const IVBUnsignedShortPart*) const,, 2545)
Boolean IVBUnsignedShortPart::
  operator == (const IVBUnsignedShortPart* aValue) const
{
  if (value() != aValue->value()) {
    return false;
  } /* endif */
  if (defaultValue() != aValue->defaultValue()) {
    return false;
  } /* endif */
  if (lowLimit() != aValue->lowLimit()) {
    return false;
  } /* endif */
  if (highLimit() != aValue->highLimit()) {
    return false;
  } /* endif */
  return true;
}

/*------------------------------------------------------------------------------
| IVBUnsignedShortPart::operator != (const IVBUnsignedShortPart * aValue)      |
|                                                                              |
------------------------------------------------------------------------------*/
#pragma export (IVBUnsignedShortPart::operator != (const IVBUnsignedShortPart*) const,, 2546)
Boolean IVBUnsignedShortPart::
  operator != (const IVBUnsignedShortPart* aValue) const
{
  if (value() != aValue->value()) {
    return true;
  } /* endif */
  if (defaultValue() != aValue->defaultValue()) {
    return true;
  } /* endif */
  if (lowLimit() != aValue->lowLimit()) {
    return true;
  } /* endif */
  if (highLimit() != aValue->highLimit()) {
    return true;
  } /* endif */
  return false;
}
