//=============================================================================
//  Microsoft (R) Network Monitor (tm). 
//  Copyright (C) 1991-1999. All rights reserved.
//
//  MODULE: NMErr.h
//
//  This is the top-level include file for all NETWORK MONITOR error codes
//=============================================================================

#ifndef _NMERR_
#define _NMERR_

#ifndef HRESULT
typedef LONG HRESULT;       // From wtypes.h
#endif

#ifndef INLINE
#define INLINE __inline
#endif

#include <winerror.h>       // For HRESULT macros

//=============================================================================
//  The operation succeeded.
//=============================================================================

#define NMERR_SUCCESS                        0

//=============================================================================
//  An error occured creating a memory-mapped file.
//=============================================================================

#define NMERR_MEMORY_MAPPED_FILE_ERROR       1

//=============================================================================
//  The handle to a filter is invalid.
//=============================================================================

#define NMERR_INVALID_HFILTER                2

//=============================================================================
//  Capturing has already been started.
//=============================================================================

#define NMERR_CAPTURING                      3

//=============================================================================
//  Capturing has not been started.
//=============================================================================

#define NMERR_NOT_CAPTURING                  4

//=============================================================================
//  The are no frames available.
//=============================================================================

#define NMERR_NO_MORE_FRAMES                 5

//=============================================================================
//  The buffer is too small to complete the operation.
//=============================================================================

#define NMERR_BUFFER_TOO_SMALL               6

//=============================================================================
//  No protocol was able to recognize the frame.
//=============================================================================

#define NMERR_FRAME_NOT_RECOGNIZED           7

//=============================================================================
//  The file already exists.
//=============================================================================

#define NMERR_FILE_ALREADY_EXISTS            8

//=============================================================================
//  A needed device driver was not found or is not loaded.
//=============================================================================

#define NMERR_DRIVER_NOT_FOUND               9

//=============================================================================
//  This address aready exists in the database.
//=============================================================================

#define NMERR_ADDRESS_ALREADY_EXISTS         10

//=============================================================================
//  The frame handle is invalid.
//=============================================================================

#define NMERR_INVALID_HFRAME                 11

//=============================================================================
//  The protocol handle is invalid.
//=============================================================================

#define NMERR_INVALID_HPROTOCOL              12

//=============================================================================
//  The property handle is invalid.
//=============================================================================

#define NMERR_INVALID_HPROPERTY              13

//=============================================================================
//  The the object has been locked.  
//=============================================================================

#define NMERR_LOCKED                         14

//=============================================================================
//  A pop operation was attempted on an empty stack.
//=============================================================================

#define NMERR_STACK_EMPTY                    15

//=============================================================================
//  A push operation was attempted on an full stack.
//=============================================================================

#define NMERR_STACK_OVERFLOW                 16

//=============================================================================
//  There are too many protocols active.
//=============================================================================

#define NMERR_TOO_MANY_PROTOCOLS             17

//=============================================================================
//  The file was not found.
//=============================================================================

#define NMERR_FILE_NOT_FOUND                 18

//=============================================================================
//  No memory was available.  Shut down windows to free up resources.
//=============================================================================

#define NMERR_OUT_OF_MEMORY                  19

//=============================================================================
//  The capture is already in the paused state.
//=============================================================================

#define NMERR_CAPTURE_PAUSED                 20

//=============================================================================
//  There are no buffers available or present.
//=============================================================================

#define NMERR_NO_BUFFERS                     21

//=============================================================================
//  There are already buffers present.
//=============================================================================

#define NMERR_BUFFERS_ALREADY_EXIST          22

//=============================================================================
//  The object is not locked.
//=============================================================================

#define NMERR_NOT_LOCKED                     23

//=============================================================================
//  A integer type was out of range.
//=============================================================================

#define NMERR_OUT_OF_RANGE                   24

//=============================================================================
//  An object was locked too many times.
//=============================================================================

#define NMERR_LOCK_NESTING_TOO_DEEP          25

//=============================================================================
//  A parser failed to load.
//=============================================================================

#define NMERR_LOAD_PARSER_FAILED             26

//=============================================================================
//  A parser failed to unload.
//=============================================================================

#define NMERR_UNLOAD_PARSER_FAILED          27

//=============================================================================
//  The address database handle is invalid.
//=============================================================================

#define NMERR_INVALID_HADDRESSDB             28

//=============================================================================
//  The MAC address was not found in the database.
//=============================================================================

#define NMERR_ADDRESS_NOT_FOUND              29

//=============================================================================
//  The network software was not found in the system.
//=============================================================================

#define NMERR_NETWORK_NOT_PRESENT            30

//=============================================================================
//  There is no property database for a protocol.
//=============================================================================

#define NMERR_NO_PROPERTY_DATABASE           31

//=============================================================================
//  A property was not found in the database.
//=============================================================================

#define NMERR_PROPERTY_NOT_FOUND             32

//=============================================================================
//  The property database handle is in valid.
//=============================================================================

#define NMERR_INVALID_HPROPERTYDB            33

//=============================================================================
//  The protocol has not been enabled.
//=============================================================================

#define NMERR_PROTOCOL_NOT_ENABLED          34

//=============================================================================
//  The protocol DLL could not be found.
//=============================================================================

#define NMERR_PROTOCOL_NOT_FOUND            35

//=============================================================================
//  The parser DLL is not valid.
//=============================================================================

#define NMERR_INVALID_PARSER_DLL            36

//=============================================================================
//  There are no properties attached.
//=============================================================================

#define NMERR_NO_ATTACHED_PROPERTIES         37

//=============================================================================
//  There are no frames in the buffer.
//=============================================================================

#define NMERR_NO_FRAMES                      38

//=============================================================================
//  The capture file format is not valid.
//=============================================================================

#define NMERR_INVALID_FILE_FORMAT            39

//=============================================================================
//  The OS could not create a temporary file.
//=============================================================================

#define NMERR_COULD_NOT_CREATE_TEMPFILE      40

//=============================================================================
//  There is not enough MS-DOS memory available.
//=============================================================================

#define NMERR_OUT_OF_DOS_MEMORY              41

//=============================================================================
//  There are no protocols enabled.
//=============================================================================

#define NMERR_NO_PROTOCOLS_ENABLED           42

//=============================================================================
//  The MAC type is invalid or unsupported.
//=============================================================================

#define NMERR_UNKNOWN_MACTYPE                46

//=============================================================================
//  There is no routing information present in the MAC frame.
//=============================================================================

#define NMERR_ROUTING_INFO_NOT_PRESENT       47

//=============================================================================
//  The network handle is invalid.
//=============================================================================

#define NMERR_INVALID_HNETWORK               48

//=============================================================================
//  The network is already open.
//=============================================================================

#define NMERR_NETWORK_ALREADY_OPENED         49

//=============================================================================
//  The network is not open.
//=============================================================================

#define NMERR_NETWORK_NOT_OPENED             50

//=============================================================================
//  The frame was not found in the buffer.
//=============================================================================

#define NMERR_FRAME_NOT_FOUND                51

//=============================================================================
//  There are no handles available.
//=============================================================================

#define NMERR_NO_HANDLES                     53

//=============================================================================
//  The network ID is invalid.
//=============================================================================

#define NMERR_INVALID_NETWORK_ID             54

//=============================================================================
//  The capture handle is invalid.
//=============================================================================

#define NMERR_INVALID_HCAPTURE               55

//=============================================================================
//  The protocol has already been enabled.
//=============================================================================

#define NMERR_PROTOCOL_ALREADY_ENABLED       56

//=============================================================================
//  The filter expression is invalid.
//=============================================================================

#define NMERR_FILTER_INVALID_EXPRESSION      57

//=============================================================================
//  A transmit error occured.
//=============================================================================

#define NMERR_TRANSMIT_ERROR                 58

//=============================================================================
//  The buffer handle is invalid.
//=============================================================================

#define NMERR_INVALID_HBUFFER                59

//=============================================================================
//  The specified data is unknown or invalid.
//=============================================================================

#define NMERR_INVALID_DATA                   60

//=============================================================================
//  The MS-DOS/NDIS 2.0 network driver is not loaded.
//=============================================================================

#define NMERR_MSDOS_DRIVER_NOT_LOADED        61

//=============================================================================
//  The Windows VxD/NDIS 3.0 network driver is not loaded.
//=============================================================================

#define NMERR_WINDOWS_DRIVER_NOT_LOADED      62

//=============================================================================
//  The MS-DOS/NDIS 2.0 driver had an init-time failure.
//=============================================================================

#define NMERR_MSDOS_DRIVER_INIT_FAILURE      63

//=============================================================================
//  The Windows/NDIS 3.0 driver had an init-time failure.
//=============================================================================

#define NMERR_WINDOWS_DRIVER_INIT_FAILURE    64

//=============================================================================
//  The network driver is busy and cannot handle requests.
//=============================================================================

#define NMERR_NETWORK_BUSY                   65

//=============================================================================
//  The capture is not paused.
//=============================================================================

#define NMERR_CAPTURE_NOT_PAUSED             66

//=============================================================================
//  The frame/packet length is not valid.
//=============================================================================

#define NMERR_INVALID_PACKET_LENGTH          67

//=============================================================================
//  An internal exception occured.
//=============================================================================

#define NMERR_INTERNAL_EXCEPTION             69

//=============================================================================
//  The MAC driver does not support promiscious mode.
//=============================================================================

#define NMERR_PROMISCUOUS_MODE_NOT_SUPPORTED 70

//=============================================================================
//  The MAC driver failed to open.
//=============================================================================

#define NMERR_MAC_DRIVER_OPEN_FAILURE        71

//=============================================================================
//  The protocol went off the end of the frame.
//=============================================================================

#define NMERR_RUNAWAY_PROTOCOL               72

//=============================================================================
//  An asynchronous operation is still pending.
//=============================================================================

#define NMERR_PENDING                        73

//=============================================================================
//  Access is denied.
//=============================================================================

#define NMERR_ACCESS_DENIED                  74

//=============================================================================
//  The password handle is invalid.
//=============================================================================

#define NMERR_INVALID_HPASSWORD              75

//=============================================================================
//  A bad parameter was detected.
//=============================================================================

#define NMERR_INVALID_PARAMETER              76

//=============================================================================
//  An error occured reading the file.
//=============================================================================

#define NMERR_FILE_READ_ERROR                77

//=============================================================================
//  An error occured writing to the file.
//=============================================================================

#define NMERR_FILE_WRITE_ERROR               78

//=============================================================================
//  The protocol has not been registered
//=============================================================================

#define NMERR_PROTOCOL_NOT_REGISTERED        79

//=============================================================================
//  The frame does not contain an IP address.
//=============================================================================

#define NMERR_IP_ADDRESS_NOT_FOUND           80

//=============================================================================
//  The transmit request was cancelled.
//=============================================================================

#define NMERR_TRANSMIT_CANCELLED             81

//=============================================================================
//  The operation cannot be performed on a capture with 1 or more locked frames.
//=============================================================================

#define NMERR_LOCKED_FRAMES                  82

//=============================================================================
//  A cancel transmit request was submitted but there were no transmits pending.
//=============================================================================

#define NMERR_NO_TRANSMITS_PENDING           83

//=============================================================================
//  Path not found.
//=============================================================================

#define NMERR_PATH_NOT_FOUND                 84

//=============================================================================
//  A windows error has occured.
//=============================================================================

#define NMERR_WINDOWS_ERROR                  85

//=============================================================================
//  The handle to the frame has no frame number.
//=============================================================================

#define NMERR_NO_FRAME_NUMBER                86

//=============================================================================
//  The frame is not associated with any capture.
//=============================================================================

#define NMERR_FRAME_HAS_NO_CAPTURE           87

//=============================================================================
//  The frame is already associated with a capture.
//=============================================================================

#define NMERR_FRAME_ALREADY_HAS_CAPTURE      88

//=============================================================================
//  The NAL is not remotable.
//=============================================================================

#define NMERR_NAL_IS_NOT_REMOTE              89

//=============================================================================
//  The API is not supported
//=============================================================================

#define NMERR_NOT_SUPPORTED                  90

//=============================================================================
//  Network Monitor should discard the current frame. 
//  This error code is only used during a filtered SaveCapture() API call.
//=============================================================================

#define NMERR_DISCARD_FRAME                  91

//=============================================================================
//  Network Monitor should cancel the current save. 
//  This error code is only used during a filtered SaveCapture() API call.
//=============================================================================

#define NMERR_CANCEL_SAVE_CAPTURE            92

//=============================================================================
//  The connection to the remote machine has been lost
//=============================================================================

#define NMERR_LOST_CONNECTION                93

//=============================================================================
//  The media/mac type is not valid.
//=============================================================================

#define NMERR_INVALID_MEDIA_TYPE             94

//=============================================================================
//  The Remote Agent is currently in use
//=============================================================================

#define NMERR_AGENT_IN_USE                   95

//=============================================================================
//  The request has timed out
//=============================================================================

#define NMERR_TIMEOUT                        96

//=============================================================================
//  The remote agent has been disconnected
//=============================================================================

#define NMERR_DISCONNECTED                   97

//=============================================================================
//  A timer required for operation failed creation
//=============================================================================

#define NMERR_SETTIMER_FAILED                98

//=============================================================================
//  A network error occured.
//=============================================================================

#define NMERR_NETWORK_ERROR                  99

//=============================================================================
//  Frame callback procedure is not valid
//=============================================================================
#define NMERR_INVALID_FRAMESPROC            100

//=============================================================================
//  Capture type specified is unknown
//=============================================================================
#define NMERR_UNKNOWN_CAPTURETYPE           101

//=============================================================================
// The NPP is not connected to a network.
//=============================================================================
#define NMERR_NOT_CONNECTED                 102

//=============================================================================
// The NPP is already connected to a network.
//=============================================================================
#define NMERR_ALREADY_CONNECTED             103

//=============================================================================
// The registry tag does not indicate a known configuration.
//=============================================================================
#define NMERR_INVALID_REGISTRY_CONFIGURATION 104

//=============================================================================
// The NPP is currently configured for delayed capturing.
//=============================================================================
#define NMERR_DELAYED                       105

//=============================================================================
// The NPP is not currently configured for delayed capturing.
//=============================================================================
#define NMERR_NOT_DELAYED                   106

//=============================================================================
// The NPP is currently configured for real time capturing.
//=============================================================================
#define NMERR_REALTIME                      107

//=============================================================================
// The NPP is not currently configured for real time capturing.
//=============================================================================
#define NMERR_NOT_REALTIME                  108

//=============================================================================
// The NPP is currently configured for stats only capturing.
//=============================================================================
#define NMERR_STATS_ONLY                    109

//=============================================================================
// The NPP is not currently configured for stats only capturing.
//=============================================================================
#define NMERR_NOT_STATS_ONLY                110

//=============================================================================
// The NPP is currently configured for transmitting.
//=============================================================================
#define NMERR_TRANSMIT                      111

//=============================================================================
// The NPP is not currently configured for transmitting.
//=============================================================================
#define NMERR_NOT_TRANSMIT                  112

//=============================================================================
// The NPP is currently transmitting
//=============================================================================
#define NMERR_TRANSMITTING                  113

//=============================================================================
// The specified capture file hard disk is not local
//=============================================================================
#define NMERR_DISK_NOT_LOCAL_FIXED          114

//=============================================================================
// Could not create the default capture directory on the given disk
//=============================================================================
#define NMERR_COULD_NOT_CREATE_DIRECTORY    115

//=============================================================================
// The default capture directory was not set in the registry:
// HKEY_LOCAL_MACHINE\System\CurrentControlSet\Services\nm\Parameters\CapturePath
//=============================================================================
#define NMERR_NO_DEFAULT_CAPTURE_DIRECTORY  116

//=============================================================================
//  The capture file is an uplevel version that this netmon does not understand
//=============================================================================

#define NMERR_UPLEVEL_CAPTURE_FILE           117


//=============================================================================
//  An expert failed to load.
//=============================================================================

#define NMERR_LOAD_EXPERT_FAILED             118

//=============================================================================
//  An expert failed to report its EXPERT_INFO structs.
//=============================================================================

#define	NMERR_EXPERT_REPORT_FAILED          119

//=============================================================================
//  Registry API call failed.
//=============================================================================

#define	NMERR_REG_OPERATION_FAILED          120


//=============================================================================
//  Registry API call failed.
//=============================================================================

#define	NMERR_NO_DLLS_FOUND                 121

//=============================================================================
//  There are no conversation stats, they were not asked for.
//=============================================================================

#define	NMERR_NO_CONVERSATION_STATS         122

//=============================================================================
//  We have received a security response packet from a security monitor.
//=============================================================================

#define	NMERR_SECURITY_BREACH_CAPTURE_DELETED  123

//=============================================================================
//  The given frame failed the display filter.
//=============================================================================

#define NMERR_FRAME_FAILED_FILTER           124


//=============================================================================
//  Netmon wants the Expert to stop running.
//=============================================================================

#define NMERR_EXPERT_TERMINATE              125

//=============================================================================
//  Netmon needs the remote machine to be a server.
//=============================================================================

#define NMERR_REMOTE_NOT_A_SERVER           126

//=============================================================================
//  Netmon needs the remote machine to be a server.
//=============================================================================

#define NMERR_REMOTE_VERSION_OUTOFSYNC      127

//=============================================================================
//  The supplied group is an invalid handle
//=============================================================================

#define NMERR_INVALID_EXPERT_GROUP      128

//=============================================================================
//  The supplied expert name cannot be found
//=============================================================================

#define NMERR_INVALID_EXPERT_NAME       129

//=============================================================================
//  The supplied expert name cannot be found
//=============================================================================

#define NMERR_INVALID_EXPERT_HANDLE 130

//=============================================================================
//  The supplied group name already exists
//=============================================================================

#define NMERR_GROUP_NAME_ALREADY_EXISTS  131

//=============================================================================
//  The supplied group name is invalid
//=============================================================================

#define NMERR_INVALID_GROUP_NAME    132

//=============================================================================
//  The supplied Expert is already in the group.  
//=============================================================================

#define NMERR_EXPERT_ALREADY_IN_GROUP    133

//=============================================================================
//  The Expert cannot be deleted from the group because it is not in the group
//=============================================================================

#define NMERR_EXPERT_NOT_IN_GROUP        134

//=============================================================================
//  The COM object has not been initialized
//=============================================================================

#define NMERR_NOT_INITIALIZED   135

//=============================================================================
//  Cannot perform function to Root group
//=============================================================================

#define NMERR_INVALID_GROUP_ROOT   136

//=============================================================================
//  Potential data structure mismatch between NdisNpp and Driver.
//=============================================================================

#define NMERR_BAD_VERSION   137

//=============================================================================
// The NPP is currently configured for ESP capturing.
//=============================================================================
#define NMERR_ESP                         138

//=============================================================================
// The NPP is not currently configured for ESP capturing.
//=============================================================================
#define NMERR_NOT_ESP                     139



///////////////////////////////////////////////////////////////////////////////
// MACROS
///////////////////////////////////////////////////////////////////////////////
// normal Network Monitor errors will be put into the code portion of an hresult
// for return from OLE objects:
// these two macros will help to create and crack the scode
INLINE HRESULT NMERR_TO_HRESULT( DWORD nmerror )
{
    HRESULT hResult;
    if (nmerror == NMERR_SUCCESS)
        hResult = NOERROR;
    else
        hResult = MAKE_HRESULT( SEVERITY_ERROR,FACILITY_ITF, (WORD)nmerror) ;

    return hResult;
}

//We use to decide whether the first bit was set to 1 or 0, not regarding 
//whether the result passed with a warning set in the low word.  Now we 
//disregard the first bit and pass back the warning.
INLINE DWORD HRESULT_TO_NMERR( HRESULT hResult )
{
    return HRESULT_CODE(hResult);
}

#endif // NMErr
