--------------------------------------------------------------------------------
--
-- COPYRIGHT:
--   IBM WorkFrame - Project Smarts
--   (C) Copyright International Business Machines Corporation 1996
--   Licensed Material - Program-Property of IBM - All Rights Reserved.
--   US Government Users Restricted Rights - Use, duplication, or disclosure
--   restricted by GSA ADP Schedule Contract with IBM Corp.
--
--------------------------------------------------------------------------------

<include prologc.tde>

/*----------------------------------------------
 * $FILE_NAME$.c - Source file for a C DLL
 *----------------------------------------------*/

#include "$FILE_NAME$.h"

#include <stdio.h>

/*----------------------------------------------------------------- */
/* This file defines 4 exported functions, and 2 internal functions.*/
<if ($CPPFILT$)>
/* No symbol or function is marked with the _Export keyword or      */
/* exported via the #pragma export directive.  Exporting is done    */
/* using a .DEF file created with the help of the CPPFILT utility   */
/* that creates an EXPORT entry for every public symbol.            */
</if>
<if ($EXPORT$)>
/* The functions to be exported contain an _Export qualifier        */
</if>
<if ($PRAGMA$)>
/* The functions to be exported are listed below.                   */
/* The format of #pragma export is:                                 */
/*     #pragma export (identifier,"exportName",ordinal)             */
/*        or                                                        */
/*     #pragma export (identifier,,ordinal)                         */
/* The exportName is optional, and only required when exporting the */
/* identifier as a different name than it is internally.            */
#pragma export( bubble    ,, 1 )
#pragma export( insertion ,, 2 )
#pragma export( selection ,, 3 )
#pragma export( list      ,, 4 )
</if>
/*----------------------------------------------------------------- */

size_t nSwaps;
size_t nCompares;


/*--------------------*/
/* Swap two integers. */
/*--------------------*/
static void swap(int *x, int *y)
{
   int temp;
   temp = *x;
   *x = *y;
   *y = temp;
   ++nSwaps;
   return ;
}


/*-----------------------*/
/* Compare two integers. */
/*-----------------------*/
static int compare(int x, int y)
{
   ++nCompares;
   return (x-y);
}


/*-------------------------------------------------------------------*/
/* Use Bubble Sort to sort an array of integers in increasing order. */
/*-------------------------------------------------------------------*/
<if ($EXPORT$)>
void _Export bubble(int array[], size_t nNumElements)
<else>
void bubble(int array[], size_t nNumElements)
</if>
{
   size_t i,j;                         /* array indices  */
   nSwaps = nCompares = 0;
   for (i = 0; i < nNumElements-1; ++i) {
      for (j = nNumElements-1; j > i; --j) {
         if (compare(array[j], array[j-1]) < 0)
            swap(&array[j], &array[j-1]);
      }
   }
   return ;
}
<if ($STATIC_LINK$)>
#pragma  handler( bubble )
</if>


/*--------------------------------------------------------------------------*/
/* Use Insertion Sort to sort an array of integers in increasing order.     */
/*--------------------------------------------------------------------------*/
<if ($EXPORT$)>
void _Export insertion(int array[], size_t nNumElements)
<else>
void insertion(int array[], size_t nNumElements)
</if>
{
   size_t i,j;                         /* array indices  */
   nSwaps = nCompares = 0;
   for (i = 1; i < nNumElements; ++i) {
      for (j = i; j && (compare(array[j], array[j-1]) < 0); --j)
         swap(&array[j], &array[j-1]);
   }
   return ;
}
<if ($STATIC_LINK$)>
#pragma  handler( insertion )
</if>


/*--------------------------------------------------------------------------*/
/* Use Selection Sort to sort an array of integers in increasing order.     */
/*--------------------------------------------------------------------------*/
<if ($EXPORT$)>
void _Export selection(int array[], size_t nNumElements)
<else>
void selection(int array[], size_t nNumElements)
</if>
{
   size_t i,j,lowindex;                /* array indices                     */
   int lowkey;                         /* temporary storage for lowest key  */
                                       /* value                             */
   nSwaps = nCompares = 0;
   for (i = 0; i < nNumElements-1; ++i) {
      lowindex = i;
      lowkey = array[i];
      for (j = i+1; j < nNumElements; ++j) {
         if (compare(array[j], lowkey) < 0) {
            lowkey = array[j];
            lowindex = j;
         }
      }
      if (lowindex != i)
         swap(&array[i], &array[lowindex]);
   }
   return ;
}
<if ($STATIC_LINK$)>
#pragma  handler( selection )
</if>


/*----------------------------------------*/
/* List the integers in an array.         */
/*----------------------------------------*/
<if ($EXPORT$)>
void _Export list(int array[], size_t nNumElements)
<else>
void list(int array[], size_t nNumElements)
</if>
{
   size_t i;
   for (i = 0; i < nNumElements; ++i)
      printf("%i ", array[i]);
   putchar('\n');
   return ;
}
<if ($STATIC_LINK$)>
#pragma  handler( list )
</if>
