--------------------------------------------------------------------------------
--
-- COPYRIGHT:
--   IBM WorkFrame - Project Smarts
--   (C) Copyright International Business Machines Corporation 1996
--   Licensed Material - Program-Property of IBM - All Rights Reserved.
--   US Government Users Restricted Rights - Use, duplication, or disclosure
--   restricted by GSA ADP Schedule Contract with IBM Corp.
--
--------------------------------------------------------------------------------
<include prologcp.tde>

//----------------------------------------------
// $FILE_NAME$.cpp - Source file for a C++ DLL
//----------------------------------------------

#include "$FILE_NAME$.hpp"

/***************************/
/* Defining Static Objects */
/***************************/

int area::objectCount = 0;
int rectangle::objectCount = 0;
int triangle::objectCount = 0;

<if ($CPPFILT$)>
/*-----------------------------------------------------------------*/
/* This file defines 3 classes, area, rectangle, and triangle.     */
/* No symbol or class is marked with the _Export keyword or        */
/* exported via the #pragma export directive.  Exporting is done   */
/* using a .DEF file created with the help of the CPPFILT utility  */
/* that creates an EXPORT entry for every public symbol.  The      */
/* symbols are thus exported by their mangled names.               */
/*-----------------------------------------------------------------*/
</if>
<if ($EXPORT$)>
/*--------------------------------------------------------------*/
/* This file defines 3 classes, area, rectangle, and triangle.  */
/* Identify the classes we wish to export                       */
/*--------------------------------------------------------------*/
class _Export area;
class _Export rectangle;
class _Export triangle;
</if>
<if ($PRAGMA$)>
/*--------------------------------------------------------------*/
/* This file defines 3 classes, area, rectangle, and triangle.  */
/* Identify the symbols we wish to export                       */
/*--------------------------------------------------------------*/
#pragma export(area::objectCount)
#pragma export(area::getDim)
#pragma export(area::getArea)
#pragma export(area::area(void))
#pragma export(area::setarea)

#pragma export(triangle::objectCount)
#pragma export(triangle::getArea)
#pragma export(triangle::triangle(void))

#pragma export(rectangle::objectCount)
#pragma export(rectangle::getArea)
#pragma export(rectangle::rectangle(void))

/*---------------------------------------------------------*/
/* Considerations: Ensure you export all the required      */
/* member functions.  If an inlined or exported function   */
/* uses private or protected members, you must also export */
/* those members.  In addition, you should also export     */
/* all static members otherwise clients of your class will */
/* not be able to debug their code because the reference   */
/* to the static data members cannot be resolved.          */
/*---------------------------------------------------------*/
</if>

/****************************/
/* Defining the Base Class  */
/****************************/

area::area(void)
   {
   ++area::objectCount;
   }

void area::setarea(double d1 , double d2)
         {
         dim1 = d1;
         dim2 = d2;
         }

void area::getDim(double &d1, double &d2)
         {
         d1 = dim1;
         d2 = dim2;
         }

double area::getArea()
         {
         return -1 ;    /* not override */
         }

/*******************************/
/* Defining a   Derived class  */
/*******************************/

double rectangle::getArea()
         {
         double d1,d2;
         getDim (d1,d2);
         return d1*d2;
         }

rectangle::rectangle(void)
   {
   ++rectangle::objectCount;
   }

/*******************************/
/* Defining a   Derived class  */
/*******************************/


triangle::triangle()
   {
   ++triangle::objectCount;
   }

double triangle::getArea()
   {
   double d1,d2;
   getDim (d1,d2);
   return .5*d1*d2;
   }

