--------------------------------------------------------------------------------
--
-- COPYRIGHT:
--   IBM WorkFrame - Project Smarts
--   (C) Copyright International Business Machines Corporation 1996
--   Licensed Material - Program-Property of IBM - All Rights Reserved.
--   US Government Users Restricted Rights - Use, duplication, or disclosure
--   restricted by GSA ADP Schedule Contract with IBM Corp.
--
--------------------------------------------------------------------------------
<include prologc.tde>

#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

/* _CRT_init is the C run-time environment initialization function.         */
/* It will return 0 to indicate success and -1 to indicate failure.         */
int _CRT_init(void);
void __ctordtorInit(void);

/* _CRT_term is the C run-time environment termination function.            */
void __ctordtorTerm(void);
void _CRT_term(void);

size_t nSize;
int *pArray;

/*--------------------------------------------------------------------------*/
/* _DLL_InitTerm is the function that gets called by the operating system   */
/* loader when it loads and frees this DLL for each process that accesses   */
/* this DLL.  However, it only gets called the first time the DLL is loaded */
/* and the last time it is freed for a particular process.  The system      */
/* linkage convention MUST be used because the operating system loader is   */
/* calling this function.                                                   */
/*--------------------------------------------------------------------------*/
unsigned long __stdcall _DLL_InitTerm( unsigned long hModule,
                                       unsigned long ulFlag,
                                       long* dummy )
{
   size_t i;
   int  rc;
   char namebuf[_MAX_PATH];
   unsigned long success=1;

   /* If ulFlag is one then the DLL is being loaded so initialization should*/
   /* be performed.  If ulFlag is zero then the DLL is being freed so       */
   /* termination should be performed.                                      */

   switch (ulFlag)
   {
      case DLL_PROCESS_ATTACH:                   /* The DLL is being loaded */

         /*******************************************************************/
         /* The C run-time environment initialization function must be      */
         /* called before any calls to C run-time functions that are not    */
         /* inlined.                                                        */
         /*******************************************************************/

         if (_CRT_init() == -1)
         {
            success=0;                                            /* ERROR! */
            break;
         }

         /**************************************/
         /* initialize any static C++ objects */
         /**************************************/
         __ctordtorInit();


         /*******************************************************************/
         /* For illustrative purposes only, print out the name of the DLL.  */
         /*******************************************************************/
         rc = GetModuleFileName((void *)hModule, namebuf, sizeof(namebuf));
         if (rc == 0)
            printf("GetModuleFileName returned %lu\n", GetLastError());
         else
            printf("The name of this DLL is %s\n", namebuf);

         /*******************************************************************/
         /* For illustrative purposes only, a randomly sized array will now */
         /* be created.  It will be freed upon DLL termination.             */
         /*******************************************************************/
         srand(17);
         nSize = (rand()%128)+32;
         printf("The array size for this process is %u\n", nSize);

         pArray = malloc(nSize *sizeof(int));
         if( !pArray )
         {
            printf("Could not allocate space for unsorted array.\n");
            success=0;                                            /* ERROR! */
            break;
         }

         for (i = 0; i < nSize; ++i )
         {
            pArray[i] = rand();
         }
         break;

      case DLL_PROCESS_DETACH:                    /* The DLL is being freed */
         /*******************************************************************/
         /* The array that was allocated during the DLL initialization will */
         /* now be freed.                                                   */
         /*******************************************************************/

         printf("The array will now be freed.\n");
         free(pArray);

         /**************************************/
         /* destruct any static C++ objects    */
         /**************************************/
         __ctordtorTerm();

         /**************************************/
         /* terminate our use of the C runtime */
         /**************************************/
         _CRT_term();

         break;

      default  :
         printf("ulFlag = %lu\n", ulFlag);
         success=0;                                               /* ERROR! */
         break;
   }

   /* A non-zero value must be returned to indicate success.                */

   return success;
}

