--------------------------------------------------------------------------------
--
-- COPYRIGHT:
--   IBM WorkFrame - Project Smarts
--   (C) Copyright International Business Machines Corporation 1996
--   Licensed Material - Program-Property of IBM - All Rights Reserved.
--   US Government Users Restricted Rights - Use, duplication, or disclosure
--   restricted by GSA ADP Schedule Contract with IBM Corp.
--
--------------------------------------------------------------------------------
<include prologcp.tde>

<if ($EXECUTABLE$==EXEandDLL)>
#pragma library( "$SOURCE_FILE:tolower$.lib" )
</if>

<if ($LANGUAGE$ == SOM)>

// $FILE_NAME:tolower$.CPP - main() for Data Access Builder application

#include <iostream.h>
#include "$SOURCE_FILE:tolower$.xh"

#define USERIDANDPASSWORD 3
#define USERID            1
#define PASSWORD          2

static int exceptionCheck(void);

Environment          *ev                = somGetGlobalEnvironment();
$CLASS_NAME$Factory           *DAXMgrObject      = $CLASS_NAME$NewClass(0,0);

// This program connects to a database, prints all its records,
// and then disconnects.  It will work for any database.

void main(int argc, char *argv[])
{
  cout << endl;

  $CLASS_NAME$Datastore *DSObject  = DAXMgrObject->create_datastore(ev);
  $CLASS_NAME$          *DAXObject = DAXMgrObject->create_object(ev);

  _IDL_SEQUENCE_PersistentObject DAXObjectList;

  int rc;

  // Establish connection to a datastore
  // If there are any arguments, assume that the connection is remote.
  // The arguments, if any, should be the userid and password.
  if (argc == USERIDANDPASSWORD)
     DSObject->connect_user(ev, argv[USERID], argv[PASSWORD]);
  else
     DSObject->connect_defaults(ev);

  rc = exceptionCheck();

  // Check if connection was successful.  If not, just exit.
  if (rc != 0) {
     cout << " Connection failed" << endl;
     exit(1);
  }

  // Retrieve all the rows from a table and store in the object list.
  DAXObjectList = DAXMgrObject->retrieveAll(ev);
  rc = exceptionCheck();
  if (rc == 0)
  {
    // Print all the rows
    for (int j=0; j < sequenceLength(DAXObjectList); j++)
    {
      DAXObject = ($CLASS_NAME$ *) sequenceElement(DAXObjectList,j);                       // Get the item from the sequence

      // The asString method prints all the table columns as strings.
      // Here, we just print the current row.
      cout <<  "\"" << DAXObject->asString(ev,"\", \"") << "\"" << endl;             // Output the item from the sequence
    }
  } /* endif */
  else
     cout << " Retrieval of all records failed" << endl;

  // disconnect from a datastore
  DSObject->commit(ev);
  DSObject->disconnect(ev);

}


int exceptionCheck(void )
{
   int rc = 0;
   char *exId;
   DA_DatastoreAccessError * er;

   switch (ev->_major)
   {
     case SYSTEM_EXCEPTION:
        cout << "system exception" << endl;
        rc ++;
        break;
     case USER_EXCEPTION:
        exId = somExceptionId(ev);
        cout << "Exception ID: " << somExceptionId(ev) << endl;
        rc ++;
        somExceptionFree(ev);
        break;
     case NO_EXCEPTION:
        break;
   }
   return rc;
}

<else>
<if ($LANGUAGE$ == C++)>

// $FILE_NAME$ - main() for C++ Data Access Builder application

#include "$SOURCE_FILE$.hpp"
#include <iostream.h>
#include <istring.hpp>


#define USERIDANDPASSWORD     3
#define USERID                1
#define PASSWORD              2


// This program connects to a database, prints all its records,
// and then disconnects.  It will work for any database.

main (int argc, char * argv[])
{
  try
     {
          $CLASS_NAME$Datastore aDatastore;

          cout << "Connecting..." << endl;

          // Establish connection to a datastore.
          // If there are any arguments, assume that the connection is remote.
          // The arguments, if any, should be the userid and password.
          if (argc==USERIDANDPASSWORD)
             aDatastore.connect(argv[USERID], argv[PASSWORD]);
          else
            aDatastore.connect();

          cout << "Connected." << endl;

          // Create the manager object
          $CLASS_NAME$Manager aManager;

          // Retrieve all the records from the database and
          // store the data in the aManager object.
          cout << "Retrieving database records..." << endl;
          aManager.refresh();
          cout << "Refresh complete." << endl << endl;

          // Create a cursor to the database items (rows).
          $CLASS_NAME$Manager::sequenceType::Cursor cursor(*aManager.items());

          // The forDisplay method concatenates the table columns
          // displayed as strings.  We use a cursor to iterate through
          // all the rows in the table to print them out.
          forCursor(cursor)
          {
            cout <<  cursor.element()->forDisplay(",") << endl;
          }

          cout << endl <<  "Disconnecting..." << endl;
          aDatastore.commit();
          aDatastore.disconnect();
          cout << "Disconnected." << endl;

     }

  catch ( IException exc )
     {
       cout << "IException thrown!" << endl;
       exit(1);
     }
  catch (...)
     {
       cout << "Unknown exception thrown!" << endl;
       exit(1);
     }

}

</if>
</if>
