--------------------------------------------------------------------------------
--
-- COPYRIGHT:
--   IBM WorkFrame - Project Smarts
--   (C) Copyright International Business Machines Corporation 1996
--   Licensed Material - Program-Property of IBM - All Rights Reserved.
--   US Government Users Restricted Rights - Use, duplication, or disclosure
--   restricted by GSA ADP Schedule Contract with IBM Corp.
--
--------------------------------------------------------------------------------

.SUFFIXES: .hh .idl

all: $SOM_IR_FILE$ somdimpl.dat

#
# $SOM_IR_FILE$ - local Interface Repository.
#
SOMIR=$(SOMIR);$SOM_IR_FILE$

#
# Generate IDL interfaces for each DTS C++ class.
#
.hh.idl:
        icc /c $*.hh

<repeat HEADER_NAME>
$HEADER_NAME$.idl: $HEADER_NAME$.hh
</repeat>


#
# Register the IDL class interface into the Interface Repository for
# every class that is to be accessed by a remote process.
#
$SOM_IR_FILE$: \
<repeat HEADER_NAME separate  \>
    $HEADER_NAME$.idl
</repeat>
<repeat HEADER_NAME>
        sc -sir -u $HEADER_NAME$.idl
</repeat>

#
# Register a new server's implementation and it's associated classes
# with the Implementation Repository.
#
somdimpl.dat:
        regimpl -A -i $SOM_SERVER$ -h $(HOSTNAME)
<repeat SOM_CLASS_NAME>
        regimpl -a -i $SOM_SERVER$ -c $SOM_CLASS_NAME$
</repeat>


#
# De-register all class implementations and delete $SOM_SERVER$.
#
clean:
<repeat SOM_CLASS_NAME>
        regimpl -d -c $SOM_CLASS_NAME$ -i $SOM_SERVER$
</repeat>
        regimpl -D -i $SOM_SERVER$


