--------------------------------------------------------------------------------
--
-- COPYRIGHT:
--   IBM WorkFrame - Project Smarts
--   (C) Copyright International Business Machines Corporation 1996
--   Licensed Material - Program-Property of IBM - All Rights Reserved.
--   US Government Users Restricted Rights - Use, duplication, or disclosure
--   restricted by GSA ADP Schedule Contract with IBM Corp.
--
--------------------------------------------------------------------------------

<include prologcp.tde>

#include <iframe.hpp>
#include <ititle.hpp>
#include <icmdhdr.hpp>
#include <istring.hpp>
#include <imenubar.hpp>
#include <iinfoa.hpp>
#include <imle.hpp>

class AppWindow;

/*************************************************/
/* Class: AppCommandHandler                      */
/*                                               */
/* Purpose: Handle command events for the main   */
/*          application window.  It subclasses   */
/*          ICommandHandler.                     */
/*************************************************/
class AppCommandHandler : public ICommandHandler
{
  public:
    AppCommandHandler( AppWindow* mainWindow );

  protected:
    virtual Boolean command( ICommandEvent& event );

  private:
    AppWindow* app;
};


/*************************************************/
/* Class: AppWindow                              */
/*                                               */
/* Purpose: Main window for an ICLUI application.*/
/*          It is a subclass of IFrameWindow.    */
/*************************************************/
class AppWindow : public IFrameWindow
{
  public:
    // Constructor and destructor
    //------
    AppWindow( unsigned long windowId );
    ~AppWindow();

    virtual Boolean
      isHelpAvailable() const;

    AppWindow
     &setStatus( const char * string ),
     &setStatus( IResourceId string ),
     &setFileName( const char * file ),
     &productInfo(),
     &enablePaste( Boolean which = true );

    IMultiLineEdit
     *editor();

    Boolean
      hasFileName();

    IString
      fileName();

    IHelpWindow
     *helpWin();

  private:
    ITitle          title;        // Title bar

    IMenuBar        menuBar;      // Window menu bar

    IMultiLineEdit  mle;          // MLE as the client area

    IInfoArea       infoarea;     // Information text

    IHelpWindow*    help;         // Help window

    AppCommandHandler cmdHdr;     // Command handler

    IString         openFileName; // Name of file opened

    Boolean         hasHelp;      // Help available flag

    Boolean         hasFile;      // File name available flag

 };
