--------------------------------------------------------------------------------
--
-- COPYRIGHT:
--   IBM WorkFrame - Project Smarts
--   (C) Copyright International Business Machines Corporation 1996
--   Licensed Material - Program-Property of IBM - All Rights Reserved.
--   US Government Users Restricted Rights - Use, duplication, or disclosure
--   restricted by GSA ADP Schedule Contract with IBM Corp.
--
--------------------------------------------------------------------------------

<include prologcp.tde>

/* UI Class Library headers */
#include <ibase.hpp>

/* Application headers */
#include "prodinfo.hpp"
#include "$FILE_NAME$.h"

/****************** ProdInfoDialog Implementation *******************/


/***********************************************************/
/* Constructor for the product information dialog class.   */
/***********************************************************/
ProdInfoDialog::ProdInfoDialog( IWindow *owner )
  :IFrameWindow( ID_PRODINFO, IWindow::desktopWindow(), owner,
                 IRectangle( 200, 200, 600, 470 ),
                 IFrameWindow::systemMenu
                 | IFrameWindow::dialogBackground
                 | IFrameWindow::dialogBorder )
  ,canvas( ID_PRODINFO_CANVAS, this, this )
  ,iconCtl( ID_PRODINFO_ICON, &canvas, &canvas )
  ,text1( ID_PRODINFO_TEXT1, &canvas, &canvas )
  ,text2( ID_PRODINFO_TEXT2, &canvas, &canvas )
  ,text3( ID_PRODINFO_TEXT3, &canvas, &canvas )
  ,text4( ID_PRODINFO_TEXT4, &canvas, &canvas )
  ,text5( ID_PRODINFO_TEXT5, &canvas, &canvas )
  ,button( ID_PRODINFO_OK, &canvas, &canvas )
{
   // Set self as command event handler
   handleEventsFor(this);

   // Set text for the controls
   iconCtl.setIcon( IDI_ICON );
   text1.setText( IResourceId( IDS_PRODINFO_TEXT1 ) );
   text1.setForegroundColor( IColor::red );
   text2.setText( IResourceId( IDS_PRODINFO_TEXT2 ) );
   text3.setText( IResourceId( IDS_PRODINFO_TEXT3 ) );
   text4.setText( IResourceId( IDS_PRODINFO_TEXT4 ) );
   text5.setText( IResourceId( IDS_PRODINFO_TEXT5 ) );
   button.setText( IResourceId( IDS_PRODINFO_OK ) );

   // Set the canvas orientation to veritical
   // Set the canvas alignment to center all the controls
   canvas.setDeckOrientation( ISetCanvas::vertical );
   canvas.setAlignment( ISetCanvas::centerCenter );

   // Set the client as the canvas
   setClient( &canvas );

   /******************************************************************************
   * Resize the window based on the minimum size of the canvas                   *
   ******************************************************************************/
#ifndef IC_MOTIF
   moveSizeToClient( IRectangle( IPoint(
                     IWindow::desktopWindow()->size().width()/2,
                     IWindow::desktopWindow()->size().height()/2 ),
                     canvas.minimumSize() ) );
#else
   moveSizeTo( IRectangle( IPoint(
               IWindow::desktopWindow()->size().width()/2,
               IWindow::desktopWindow()->size().height()/2 ),
               canvas.minimumSize() ) );
#endif

   /******************************************************************************
   * Center the frame window                                                     *
   ******************************************************************************/
   moveSizeTo( rect().centerAt( IWindow::desktopWindow()->rect().center() ) );

   /******************************************************************************
   * Show the dialog window                                                      *
   ******************************************************************************/
   setFocus();
   show();

}


/***********************************************************/
/* Destructor for the product information dialog class.    */
/***********************************************************/
ProdInfoDialog :: ~ProdInfoDialog()
{
   stopHandlingEventsFor(this);
}



/***********************************************************/
/* Command handler function for the product information    */
/* dialog. There is only one control to handle.            */
/***********************************************************/
Boolean ProdInfoDialog :: command( ICommandEvent& cmdevt)
{
  switch ( cmdevt.commandId() )
  {
     case ID_PRODINFO_OK:
        dismiss(ID_PRODINFO_OK);
        return true;
  }

  return false;
}
