
#ifndef _I0STRING_
#define _I0STRING_
/*******************************************************************************
* FILE NAME: i0string.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the declarations of the classes:                        *
*     I0String                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <istring.hpp>

#pragma pack(4)



class IStringTest;

class I0String : public IString {
public:
/*------------------------------- Constructors -------------------------------*/
  I0String          ( );
  I0String          ( const IString &aString );

  I0String          ( int  anInt );
  I0String          ( unsigned  anUnsigned );
  I0String          ( long  aLong );
  I0String          ( unsigned long  anUnsignedLong );
#ifdef _LONG_LONG
  I0String          ( long long  aLongLong );
  I0String          ( unsigned long long  anUnsignedLongLong );
#endif
  I0String          ( short  aShort );
  I0String          ( unsigned short  anUnsignedShort );

  I0String          ( double  aDouble );

  I0String          ( char aChar );
  I0String          ( unsigned char anUnsignedChar );
  I0String          ( signed char   aSignedChar );

  I0String          ( const char *pChar );
  I0String          ( const unsigned char *pUnsignedChar );
  I0String          ( const signed char *pSignedChar );

  I0String          ( const void *pBuffer1,
                      unsigned    lenBuffer1,
                      char        padCharacter = ' ' );
  I0String          ( const void *pBuffer1,
                      unsigned    lenBuffer1,
                      const void *pBuffer2,
                      unsigned    lenBuffer2,
                      char        padCharacter = ' ' );
  I0String          ( const void *pBuffer1,
                      unsigned    lenBuffer1,
                      const void *pBuffer2,
                      unsigned    lenBuffer2,
                      const void *pBuffer3,
                      unsigned    lenBuffer3,
                      char        padCharacter = ' ' );
virtual
  ~I0String         ( );

/*------------------------- Queries ------------------------------------------*/
I0String
  subString         ( unsigned startPos ) const,
  subString         ( unsigned startPos,
                      unsigned len,
                      char     padCharacter = ' ' ) const;

char
 &operator []       ( unsigned index );

const char
 &operator []       ( unsigned index ) const;

char
 &operator []       ( signed index );

const char
 &operator []       ( signed index ) const;

char
 &operator []       ( unsigned long index );

const char
 &operator []       ( unsigned long index ) const;

char
 &operator []       ( signed long index );

const char
 &operator []       ( signed long index ) const;

IStringEnum::CharType
  charType          ( unsigned index ) const;

/*------------------------- Searches -----------------------------------------*/
static const unsigned
  IC_IMPORTB notFound;

unsigned
  indexOf           ( const IString     &aString,
                      unsigned           startPos = 0 ) const,
  indexOf           ( const char        *pString,
                      unsigned           startPos = 0 ) const,
  indexOf           ( char               aCharacter,
                      unsigned           startPos = 0 ) const,
  indexOf           ( const IStringTest &aTest,
                      unsigned           startPos = 0 ) const,

  indexOfAnyBut     ( const IString     &aString,
                      unsigned           startPos = 0 ) const,
  indexOfAnyBut     ( const char        *pValidChars,
                      unsigned           startPos = 0 ) const,
  indexOfAnyBut     ( char               validChar,
                      unsigned           startPos = 0 ) const,
  indexOfAnyBut     ( const IStringTest &aTest,
                      unsigned           startPos = 0 ) const,

  indexOfAnyOf      ( const IString     &searchChars,
                      unsigned           startPos = 0 ) const,
  indexOfAnyOf      ( const char        *pSearchChars,
                      unsigned           startPos = 0 ) const,
  indexOfAnyOf      ( char               searchChar,
                      unsigned           startPos = 0 ) const,
  indexOfAnyOf      ( const IStringTest &aTest,
                      unsigned           startPos = 0 ) const,

  lastIndexOf       ( const IString     &aString,
                      unsigned           endPos =
                                          (unsigned)(UINT_MAX-1) ) const,
  lastIndexOf       ( const char        *pString,
                      unsigned           endPos =
                                          (unsigned)(UINT_MAX-1) ) const,
  lastIndexOf       ( char               aCharacter,
                      unsigned           endPos =
                                          (unsigned)(UINT_MAX-1) ) const,
  lastIndexOf       ( const IStringTest &aTest,
                      unsigned           startPos =
                                          (unsigned)(UINT_MAX-1) ) const,

  lastIndexOfAnyBut ( const IString     &validChars,
                      unsigned           endPos =
                                          (unsigned)(UINT_MAX-1)) const,
  lastIndexOfAnyBut ( const char        *pValidChars,
                      unsigned           endPos =
                                          (unsigned)(UINT_MAX-1)) const,
  lastIndexOfAnyBut ( char               validChar,
                      unsigned           startPos =
                                          (unsigned)(UINT_MAX-1)) const,
  lastIndexOfAnyBut ( const IStringTest &aTest,
                      unsigned           endPos =
                                          (unsigned)(UINT_MAX-1)) const,

  lastIndexOfAnyOf  ( const IString     &searchChars,
                      unsigned           endPos =
                                          (unsigned)(UINT_MAX-1)) const,
  lastIndexOfAnyOf  ( const char        *pSearchChars,
                      unsigned           endPos =
                                          (unsigned)(UINT_MAX-1)) const,
  lastIndexOfAnyOf  ( char               searchChar,
                      unsigned           startPos =
                                          (unsigned)(UINT_MAX-1)) const,
  lastIndexOfAnyOf  ( const IStringTest &aTest,
                      unsigned           endPos =
                                          (unsigned)(UINT_MAX-1)) const,

  occurrencesOf     ( const IString     &aString,
                      unsigned           startPos = 0 ) const,
  occurrencesOf     ( const char        *pString,
                      unsigned           startPos = 0 ) const,
  occurrencesOf     ( char               aCharacter,
                      unsigned           startPos = 0 ) const,
  occurrencesOf     ( const IStringTest &aTest,
                      unsigned           startPos = 0 ) const;

/*------------------------- Editing ------------------------------------------*/
I0String
 &change            ( const IString &aPattern,
                      const IString &aReplacement,
                      unsigned       startPos = 0,
                      unsigned       numChanges = (unsigned)UINT_MAX ),
 &change            ( const IString &aPattern,
                      const char    *pReplacement,
                      unsigned       startPos = 0,
                      unsigned       numChanges = (unsigned)UINT_MAX ),
 &change            ( const char    *pPattern,
                      const IString &aReplacement,
                      unsigned       startPos = 0,
                      unsigned       numChanges = (unsigned)UINT_MAX ),
 &change            ( const char    *pPattern,
                      const char    *pReplacement,
                      unsigned       startPos = 0,
                      unsigned       numChanges = (unsigned)UINT_MAX ),

 &insert            ( const IString &aString,
                      unsigned       index = (unsigned)UINT_MAX,
                      char           padCharacter = ' ' ),
 &insert            ( const char    *pString,
                      unsigned       index = (unsigned)UINT_MAX,
                      char           padCharacter = ' ' ),

 &overlayWith       ( const IString &aString,
                      unsigned       index        = 0,
                      char           padCharacter = ' ' ),
 &overlayWith       ( const char    *pString,
                      unsigned       index        = 0,
                      char           padCharacter = ' ' ),

 &remove            ( unsigned startPos ),
 &remove            ( unsigned startPos,
                      unsigned numChars );

static I0String
  change            ( const IString &aString,
                      const IString &inputString,
                      const IString &outputString,
                      unsigned       startPos = 0,
                      unsigned       numChanges = (unsigned)UINT_MAX ),
  change            ( const IString &aString,
                      const IString &inputString,
                      const char    *pOutputString,
                      unsigned       startPos = 0,
                      unsigned       numChanges = (unsigned)UINT_MAX ),
  change            ( const IString &aString,
                      const char    *pInputString,
                      const IString &outputString,
                      unsigned       startPos = 0,
                      unsigned       numChanges = (unsigned)UINT_MAX ),
  change            ( const IString &aString,
                      const char    *pInputString,
                      const char    *pOutputString,
                      unsigned       startPos = 0,
                      unsigned       numChanges = (unsigned)UINT_MAX ),

  insert            ( const IString &aString,
                      const IString &anInsert,
                      unsigned       index = (unsigned)UINT_MAX,
                      char           padCharacter = ' ' ),
  insert            ( const IString &aString,
                      const char    *pInsert,
                      unsigned       index = (unsigned)UINT_MAX,
                      char           padCharacter = ' ' ),

  overlayWith       ( const IString &aString,
                      const IString &anOverlay,
                      unsigned       index        = 0,
                      char           padCharacter = ' ' ),
  overlayWith       ( const IString &aString,
                      const char    *pOverlay,
                      unsigned       index        = 0,
                      char           padCharacter = ' ' ),

  remove            ( const IString &aString,
                      unsigned       startPos ),
  remove            ( const IString &aString,
                      unsigned       startPos,
                      unsigned       numChars );

/*------------------------- Word Operations ----------------------------------*/
unsigned
  indexOfPhrase     ( const IString &wordString,
                      unsigned       startWord = 1 ) const,
  indexOfWord       ( unsigned wordNumber ) const;

protected:
/*------------------------- Index Mapping ------------------------------------*/
static unsigned
  adjustArg         ( unsigned index ),
  adjustResult      ( unsigned index );
static signed
  adjustArg         ( signed index ),
  adjustResult      ( signed index );

private:




}; // class I0String



#pragma pack()

  #include <i0string.inl>

#endif /* _I0STRING_ */


