#ifndef _I3STATBX_
#define _I3STATBX_
/*******************************************************************************
* FILE NAME: i3statbx.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     I3stateCheckBox                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <isetbut.hpp>
#include <irect.hpp>
#include <ibitflag.hpp>

class IRectangle;
class ISize;
class IWindowHandle;
class I3StateCheckBoxData;

#pragma pack(4)


class I3StateCheckBox : public ISettingButton {
typedef ISettingButton
  Inherited;
public:
class Style;
/*------------------------------- Constructors -------------------------------*/
  I3StateCheckBox (unsigned long id,
                   IWindow* parent,
                   IWindow* owner,
                   const IRectangle& initial= IRectangle(),
                   const Style& style = defaultStyle() );

  I3StateCheckBox (unsigned long id,
                   IWindow*      parent);

  I3StateCheckBox (const IWindowHandle& handle);

virtual
  ~I3StateCheckBox( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF3(Style, I3StateCheckBox,
                                 IWindow, IControl, IButton);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU autoSelect;

static Style
  defaultStyle      ( );
static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;


/*------------------------------- Auto Select --------------------------------*/
virtual I3StateCheckBox
  &enableAutoSelect  (Boolean enable=true),
  &disableAutoSelect ( );
virtual Boolean
  isAutoSelect       ( ) const;

/*-------------------------------- Selection ---------------------------------*/
I3StateCheckBox&
  selectHalftone  ( );
Boolean
  isHalftone      ( ) const;

protected:
/*---------------------------------- Layout ----------------------------------*/
virtual ISize
  calcMinimumSize ( ) const;

private:
/*---------------------------------- Private ---------------------------------*/
friend class I3StateHandler;

static Style
  currentDefaultStyle;

I3StateCheckBoxData
 *f3StateCheckBoxData;

/*----------------------------- Hidden Functions -----------------------------*/
  I3StateCheckBox  (const I3StateCheckBox&);
  I3StateCheckBox
    &operator=     (const I3StateCheckBox&);
};  // I3StateCheckBox

INESTEDBITFLAGCLASSFUNCS(Style, I3StateCheckBox);


#pragma pack()

#endif  /* _I3STATBX_ */
