/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IABag
// ---

template <class Element>
inline
IABag <Element>::
IABag (INotifier& notifier)
{ SetImpl ((Implementation*)&notifier);
}

template <class Element>
inline
IABag <Element>::
~IABag ()
{
}

template <class Element>
inline void
IABag <Element>::
addDifference (IABag <Element> const& collection1,
               IABag <Element> const& collection2)
{ ImplOf (*this).
    AddDifference (ImplOf (collection1), ImplOf (collection2));
}

template <class Element>
inline void
IABag <Element>::
addIntersection (IABag <Element> const& collection1,
                 IABag <Element> const& collection2)
{ ImplOf (*this).
    AddIntersection (ImplOf (collection1), ImplOf (collection2));
}

template <class Element>
inline void
IABag <Element>::
addUnion (IABag <Element> const& collection1,
          IABag <Element> const& collection2)
{ ImplOf (*this).
    AddUnion (ImplOf (collection1), ImplOf (collection2));
}

template <class Element>
inline void
IABag <Element>::
differenceWith (IABag <Element> const& collection)
{ ImplOf (*this).Difference (ImplOf (collection));
}

template <class Element>
inline void
IABag <Element>::
intersectionWith (IABag <Element> const& collection)
{ ImplOf (*this).Intersection (ImplOf (collection));
}

template <class Element>
inline INumber
IABag <Element>::
numberOfDifferentElements () const
{ return ImplOf (*this).NumberOfDifferentElements ();
}

template <class Element>
inline IBoolean
IABag <Element>::
setToNextDifferentElement (ICursor& cursor) const
{ return ImplOf (*this).SetToNextDifferentElement (CrsrImplOf (cursor));
}

template <class Element>
inline void
IABag <Element>::
unionWith (IABag <Element> const& collection)
{ ImplOf (*this).Union (ImplOf (collection));
}

template <class Element>
inline IBoolean
IABag <Element>::
operator== (IABag <Element> const& collection) const
{ return ImplOf (*this).operator== (ImplOf (collection));
}

template <class Element>
inline IBoolean
IABag <Element>::
operator!= (IABag <Element> const& collection) const
{ return ImplOf (*this).operator!= (ImplOf (collection));
}

// protected members

template <class Element>
inline
IABag <Element>::
IABag ()
{
}

template <class Element>
inline
IABag <Element>::
IABag (IABag <Element> const& collection)
: Inherited (collection)
{
}

// private members

template <class Element>
inline IABag <Element>::Implementation&
IABag <Element>::
ImplOf (IABag <Element> const& collection)
{ return *(Implementation*)collection.ivImpl;
}
