#ifndef _IACCEL_
#define _IACCEL_
/*******************************************************************************
* FILE NAME: iaccel.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class:                                                  *
*     IAccelerator                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <ihandle.hpp>

class IResourceId;
class IWindow;
class IAcceleratorData;

#pragma pack(4)

class IAccelerator : public IBase {
typedef IBase
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IAccelerator ( const IAccelTblHandle& haccel = 0,
                 IWindow*               owner = 0 );

  IAccelerator ( const IResourceId&     accelResId,
                 IWindow*               owner = 0 );

  IAccelerator ( unsigned long          accelResId,
                 IWindow*               owner = 0 );

 ~IAccelerator ( );


/*---------------------------- Accelerator Tables ----------------------------*/
IAccelerator
 &set    ( const IAccelTblHandle& haccel ),
 &set    ( const IResourceId&     accelResId ),
 &set    ( unsigned long          accelResId );

IAccelerator
 &remove ( ),
 &reset  ( );

Boolean
  isSet  ( ) const;

IAccelTblHandle
  handle ( ) const;


/*---------------------------------- Window ----------------------------------*/
IWindow
 *owner ( ) const;


private:
/*------------------------------ Hidden Members ------------------------------*/
IAccelerator ( const IAccelerator& accelerator );
IAccelerator
 &operator=  ( const IAccelerator& accelerator );

/*--------------------------------- Private ----------------------------------*/
void
  create      ( IWindow* pwndOwner );
IWindowHandle
  ownerHandle ( ) const;

IWindow
 *pwndClOwner;
IAccelTblHandle
  haccelCl;
IAccelTblHandle
  haccelClPrior,
  haccelClOriginal;
Boolean
  isSetCl;

IAcceleratorData
 *fAcceleratorData;

}; // IAccelerator

#pragma pack()

  #include <iaccel.inl>

#endif /* _IACCEL_ */
