/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IACLLCT_H
#define _IACLLCT_H

#include <ibcllct.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element>
class IElementCursor : public ICursor {

  typedef  ICursorImpl Implementation;

public:

  Element const&
           element          () const;

protected:

           IElementCursor   (Implementation*);


};

template <class Element>
class IACollection : protected IACollectionBase {

  typedef  IACollectionImpl Implementation;

public:

           IACollection     (INotifier&);

  virtual ~IACollection     ();

  IBoolean add              (Element const&);

  IBoolean add              (Element const&, ICursor&);

  void     addAllFrom       (IACollection <Element> const&);

  IBoolean allElementsDo    (IBoolean (*applicatorFunction)
                              (Element&, void*),
                             void* additionalArgument = 0);

  IBoolean allElementsDo    (IBoolean (*applicatorFunction)
                              (Element const&, void*),
                             void* additionalArgument = 0) const;

  IBoolean allElementsDo    (IApplicator <Element>&);

  IBoolean allElementsDo    (IConstantApplicator <Element>&) const;

  Element const&
           any              () const;

  void     copy             (IACollection <Element> const&);

  INotifier&
           disableNotification
                            ();

  Element& elementAt        (ICursor const&);

  Element const&
           elementAt        (ICursor const&) const;

  INotifier&
           enableNotification
                            (IBoolean = true);

  IBoolean isBounded        () const;

  IBoolean isConsistent     () const;

  IBoolean isEmpty          () const;

  IBoolean isEnabledForNotification
                            () const;

  IBoolean isFull           () const;

  INumber  maxNumberOfElements
                            () const;

  ICursor* newCursor        () const;

  INotifier&
           notifier         ();

  INotifier const&
           notifier         () const;

  INotifier&
           notifyObservers  (INotificationEvent const&);

  INumber  numberOfElements () const;

  INumber  removeAll        ();

  INumber  removeAll        (IBoolean (*predicateFunction)
                              (Element const&, void*),
                             void* additionalArgument = 0);

  void     removeAt         (ICursor&);

  void     replaceAt        (ICursor const&, Element const&);

  IBoolean setToFirst       (ICursor&) const;

  IBoolean setToNext        (ICursor&) const;

           operator INotifier&
                            () const;

  // for backward compatibility
  Element const&
           anyElement       () const;

protected:

           IACollection     ();

           IACollection     (IACollection <Element> const&);

  static
  Implementation&
           ImplOf           (IACollection <Element> const&);

private:


};

#pragma SOMAsDefault (pop)

#include <iacllct.inl>

#pragma info (restore)
#pragma pack ()

#endif
