/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// --------------
// IElementCursor
// --------------

// public members

template <class Element>
inline Element const&
IElementCursor <Element>::
element () const
{ return *(Element const*) ImplOf (*this).Element ();
}

// protected members

template <class Element>
inline
IElementCursor <Element>::
IElementCursor (Implementation* impl)
: ICursor (impl)
{
}

// ------------
// IACollection
// ------------

// public members

template <class Element>
inline
IACollection <Element>::
IACollection (INotifier& notifier)
{ SetImpl ((Implementation*)&notifier);
}

template <class Element>
inline
IACollection <Element>::
~IACollection ()
{  
}

template <class Element>
inline IBoolean
IACollection <Element>::
add (Element const& element)
{ return ImplOf (*this).Add (&element);
}

template <class Element>
inline IBoolean
IACollection <Element>::
add (Element const& element, ICursor& cursor)
{ return ImplOf (*this).Add (&element, CrsrImplOf (cursor));
}

template <class Element>
inline void
IACollection <Element>::
addAllFrom (IACollection <Element> const& collection)
{ ImplOf (*this).AddAllFrom (ImplOf (collection));
}

template <class Element>
inline IBoolean
IACollection <Element>::
allElementsDo (IBoolean (*applFunc) (Element&, void*), void* addArg)
{ return ImplOf (*this).AllElementsDo ((IApplFunc)applFunc, addArg);
}

template <class Element>
inline IBoolean
IACollection <Element>::
allElementsDo (IBoolean (*applFunc) (Element const&, void*),
               void* addArg) const
{ return ImplOf (*this).AllElementsDo ((IApplFunc)applFunc, addArg);
}

template <class Element>
inline IBoolean
IACollection <Element>::
allElementsDo (IApplicator <Element>& applicator)
{ return ImplOf (*this).AllElementsDo (__applFunc, &applicator);
}

template <class Element>
inline IBoolean
IACollection <Element>::
allElementsDo (IConstantApplicator <Element>& applicator) const
{ return ImplOf (*this).AllElementsDo (__applFunc, &applicator);
}

template <class Element>
inline Element const&
IACollection <Element>::
any () const
{ return *(Element const*) ImplOf (*this).Any ();
}

template <class Element>
inline Element const&
IACollection <Element>::
anyElement () const
{ return *(Element const*) ImplOf (*this).Any ();
}

template <class Element>
inline void
IACollection <Element>::
copy (IACollection <Element> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
}

template <class Element>
inline INotifier&
IACollection <Element>::
disableNotification ()
{ return ImplOf (*this).DisableNotification ();
}

template <class Element>
inline Element&
IACollection <Element>::
elementAt (ICursor const& cursor)
{ return *(Element*) ImplOf (*this).ElementAt (CrsrImplOf (cursor));
}

template <class Element>
inline Element const&
IACollection <Element>::
elementAt (ICursor const& cursor) const
{ return *(Element const*) ImplOf (*this).
    ElementAt (CrsrImplOf (cursor));
}

template <class Element>
inline INotifier&
IACollection <Element>::
enableNotification (IBoolean enable)
{ return ImplOf (*this).EnableNotification (enable);
}

template <class Element>
inline IBoolean
IACollection <Element>::
isBounded () const
{ return ImplOf (*this).IsBounded ();
}

template <class Element>
inline IBoolean
IACollection <Element>::
isConsistent () const
{ return ImplOf (*this).IsConsistent ();
}

template <class Element>
inline IBoolean
IACollection <Element>::
isEmpty () const
{ return ImplOf (*this).IsEmpty ();
}

template <class Element>
inline IBoolean
IACollection <Element>::
isEnabledForNotification () const
{ return ImplOf (*this).IsEnabledForNotification ();
}

template <class Element>
inline IBoolean
IACollection <Element>::
isFull () const
{ return ImplOf (*this).IsFull ();
}

template <class Element>
inline INumber
IACollection <Element>::
maxNumberOfElements () const
{ return ImplOf (*this).MaxNumberOfElements ();
}

template <class Element>
inline ICursor*
IACollection <Element>::
newCursor () const
{ return InterfaceFor (ImplOf (*this).CreateCursor ());
}

template <class Element>
inline INotifier&
IACollection <Element>::
notifier ()
{ return ImplOf (*this);
}

template <class Element>
inline INotifier const&
IACollection <Element>::
notifier () const
{ return ImplOf (*this);
}

template <class Element>
inline INotifier&
IACollection <Element>::
notifyObservers (INotificationEvent const& event)
{ return ImplOf (*this).notifyObservers (event);
}

template <class Element>
inline INumber
IACollection <Element>::
numberOfElements () const
{ return ImplOf (*this).NumberOfElements ();
}

template <class Element>
inline INumber
IACollection <Element>::
removeAll ()
{ return ImplOf (*this).RemoveAll ();
}

template <class Element>
inline INumber
IACollection <Element>::
removeAll (IBoolean (*predFunc) (Element const&, void*), void* addArg)
{ return ImplOf (*this).RemoveAll ((IPredFunc)predFunc, addArg);
}

template <class Element>
inline void
IACollection <Element>::
removeAt (ICursor& cursor)
{ ImplOf (*this).RemoveAt (CrsrImplOf (cursor));
}

template <class Element>
inline void
IACollection <Element>::
replaceAt (ICursor const& cursor, Element const& element)
{ ImplOf (*this).ReplaceAt (CrsrImplOf (cursor), &element);
}

template <class Element>
inline IBoolean
IACollection <Element>::
setToFirst (ICursor& cursor) const
{ return ImplOf (*this).SetToFirst (CrsrImplOf (cursor));
}

template <class Element>
inline IBoolean
IACollection <Element>::
setToNext (ICursor& cursor) const
{ return ImplOf (*this).SetToNext (CrsrImplOf (cursor));
}

template <class Element>
inline
IACollection <Element>::
operator INotifier& () const
{ return ImplOf (*this);
}

// protected members

template <class Element>
inline
IACollection <Element>::
IACollection ()
: IACollectionBase ()
{
}

template <class Element>
inline
IACollection <Element>::
IACollection (IACollection <Element> const& collection)
: IACollectionBase (collection)
{
}

template <class Element>
inline IACollection <Element>::Implementation&
IACollection <Element>::
ImplOf (IACollection <Element> const& collection)
{ return *(Implementation*)collection.ivImpl;
}
