/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IADQU_H
#define _IADQU_H

#include <iarstrct.h>
#include <iaorder.h>
#include <iiaseq.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element>
class IADeque :
  public IARestrictedAccessCollection <Element> {

  typedef  IARestrictedAccessCollection <Element> Inherited;

  typedef  IASequenceImpl Implementation;

public:

           IADeque
                            (INotifier&);

          ~IADeque
                            ();

  void     addAsFirst       (Element const&);

  void     addAsFirst       (Element const&, ICursor&);

  void     addAsLast        (Element const&);

  void     addAsLast        (Element const&, ICursor&);

  long     compare          (IADeque <Element> const&,
                             long (*comparisonFunction)
                              (Element const&, Element const&)) const;
 
  void     removeFirst      ();

  void     removeLast       ();

protected:

           IADeque
                            ();

           IADeque
                            (IADeque <Element> const&);

private:

  static
  Implementation&
           ImplOf           (IADeque <Element> const&);


};

#include <iadqu.inl>

#pragma SOMAsDefault (pop)

#pragma info (restore)
#pragma pack ()

#endif
