/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IAEQUAL_H
#define _IAEQUAL_H

#include <iacllct.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element>
class IAEqualityCollection : public virtual IACollection <Element> {

  typedef  IACollectionImpl Implementation;

public:

           IAEqualityCollection
                            (INotifier&);

          ~IAEqualityCollection
                            ();

  IBoolean contains         (Element const&) const;

  IBoolean containsAllFrom  (IACollection <Element> const&) const;

  IBoolean locate           (Element const&, ICursor&) const;

  IBoolean locateOrAdd      (Element const&);

  IBoolean locateOrAdd      (Element const&, ICursor&);

  IBoolean locateNext       (Element const&, ICursor&) const;

  INumber  numberOfOccurrences
                            (Element const&) const;

  IBoolean remove           (Element const&);

  INumber  removeAllOccurrences
                            (Element const&);

protected:

           IAEqualityCollection
                            ();

           IAEqualityCollection
                            (IAEqualityCollection <Element> const&);

private:

  static
  Implementation&
           ImplOf           (IAEqualityCollection <Element> const&);


};

#pragma SOMAsDefault (pop)

#include <iaequal.inl>

#pragma info (restore)
#pragma pack ()

#endif
