/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// --------------------
// IAEqualityCollection
// --------------------

// public members

template <class Element>
inline
IAEqualityCollection <Element>::
IAEqualityCollection (INotifier& notifier)
{ SetImpl ((Implementation*)&notifier);
}

template <class Element>
inline
IAEqualityCollection <Element>::
~IAEqualityCollection ()
{
}

template <class Element>
inline IBoolean
IAEqualityCollection <Element>::
contains (Element const& element) const
{ return ImplOf (*this).Contains (&element);
}

template <class Element>
inline IBoolean
IAEqualityCollection <Element>::
containsAllFrom (IACollection <Element> const& collection) const
{ return ImplOf (*this).
    ContainsAllFrom (IACollection <Element>::ImplOf (collection));
}

template <class Element>
inline IBoolean
IAEqualityCollection <Element>::
locate (Element const& element, ICursor& cursor) const
{ return ImplOf (*this).Locate (&element, CrsrImplOf (cursor));
}

template <class Element>
inline IBoolean
IAEqualityCollection <Element>::
locateNext (Element const& element, ICursor& cursor) const
{ return ImplOf (*this).LocateNext (&element, CrsrImplOf (cursor));
}

template <class Element>
inline IBoolean
IAEqualityCollection <Element>::
locateOrAdd (Element const& element)
{ return ImplOf (*this).LocateOrAdd (&element);
}

template <class Element>
inline IBoolean
IAEqualityCollection <Element>::
locateOrAdd (Element const& element, ICursor& cursor)
{ return ImplOf (*this).LocateOrAdd (&element, CrsrImplOf (cursor));
}

template <class Element>
inline INumber
IAEqualityCollection <Element>::
numberOfOccurrences (Element const& element) const
{ return ImplOf (*this).NumberOfOccurrences (&element);
}

template <class Element>
inline IBoolean
IAEqualityCollection <Element>::
remove (Element const& element)
{ return ImplOf (*this).Remove (&element);
}

template <class Element>
inline INumber
IAEqualityCollection <Element>::
removeAllOccurrences (Element const& element)
{ return ImplOf (*this).RemoveAllOccurrences (&element);
}

// protected members

template <class Element>
inline
IAEqualityCollection <Element>::
IAEqualityCollection ()
{
}

template <class Element>
inline
IAEqualityCollection <Element>::
IAEqualityCollection (IAEqualityCollection <Element> const&)
{
}

// private members

template <class Element>
inline IAEqualityCollection <Element>::Implementation&
IAEqualityCollection <Element>::
ImplOf (IAEqualityCollection <Element> const& collection)
{ return *(Implementation*)collection.ivImpl;
}
