/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---------------
// IAKeyCollection
// ---------------

// public members

template <class Element, class Key>
inline
IAKeyCollection <Element, Key>::
IAKeyCollection (INotifier& notifier)
{ SetImpl ((Implementation*)&notifier);
}

template <class Element, class Key>
inline
IAKeyCollection <Element, Key>::
~IAKeyCollection ()
{
}

template <class Element, class Key>
inline IBoolean
IAKeyCollection <Element, Key>::
addOrReplaceElementWithKey (Element const& element)
{ return ImplOf (*this).AddOrReplaceElementWithKey (&element);
}

template <class Element, class Key>
inline IBoolean
IAKeyCollection <Element, Key>::
addOrReplaceElementWithKey
  (Element const& element, ICursor& cursor)
{ return ImplOf (*this).
    AddOrReplaceElementWithKey (&element, CrsrImplOf (cursor));
}

template <class Element, class Key>
inline IBoolean
IAKeyCollection <Element, Key>::
containsAllKeysFrom (IACollection <Element> const& collection) const
{ return ImplOf (*this).
    ContainsAllKeysFrom (IACollection <Element>::ImplOf (collection));
}

template <class Element, class Key>
inline IBoolean
IAKeyCollection <Element, Key>::
containsElementWithKey (Key const& key) const
{ return ImplOf (*this).ContainsElementWithKey (&key);
}

template <class Element, class Key>
inline Element&
IAKeyCollection <Element, Key>::
elementWithKey (Key const& key)
{ return *(Element*) ImplOf (*this).ElementWithKey (&key);
}

template <class Element, class Key>
inline Element const&
IAKeyCollection <Element, Key>::
elementWithKey (Key const& key) const
{ return *(Element*) ImplOf (*this).ElementWithKey (&key);
}

template <class Element, class Key>
inline Key const&
IAKeyCollection <Element, Key>::
key (Element const& element) const
{ return *(Key*) ImplOf (*this).Key (&element);
}

template <class Element, class Key>
inline IBoolean
IAKeyCollection <Element, Key>::
locateElementWithKey (Key const& key, ICursor& cursor) const
{ return ImplOf (*this).
    LocateElementWithKey (&key, CrsrImplOf (cursor));
}

template <class Element, class Key>
inline IBoolean
IAKeyCollection <Element, Key>::
locateNextElementWithKey (Key const& key, ICursor& cursor) const
{ return ImplOf (*this).
    LocateNextElementWithKey (&key, CrsrImplOf (cursor));
}

template <class Element, class Key>
inline IBoolean
IAKeyCollection <Element, Key>::
locateOrAddElementWithKey (Element const& element)
{ return ImplOf (*this).LocateOrAddElementWithKey (&element); 
}

template <class Element, class Key>
inline IBoolean
IAKeyCollection <Element, Key>::
locateOrAddElementWithKey (Element const& element, ICursor& cursor)
{ return ImplOf (*this).
    LocateOrAddElementWithKey (&element, CrsrImplOf (cursor));
}

template <class Element, class Key>
inline INumber
IAKeyCollection <Element, Key>::
numberOfDifferentKeys () const
{ return ImplOf (*this).NumberOfDifferentKeys ();
}

template <class Element, class Key>
inline INumber
IAKeyCollection <Element, Key>::
numberOfElementsWithKey (Key const& key) const   
{ return ImplOf (*this).NumberOfElementsWithKey (&key);
}

template <class Element, class Key>
inline IBoolean
IAKeyCollection <Element, Key>::
removeElementWithKey (Key const& key)
{ return ImplOf (*this).RemoveElementWithKey (&key);
}

template <class Element, class Key>
inline INumber
IAKeyCollection <Element, Key>::
removeAllElementsWithKey (Key const& key)
{ return ImplOf (*this).RemoveAllElementsWithKey (&key);
}

template <class Element, class Key>
inline IBoolean
IAKeyCollection <Element, Key>::
replaceElementWithKey (Element const& element)
{ return ImplOf (*this).ReplaceElementWithKey (&element);
}

template <class Element, class Key>
inline IBoolean
IAKeyCollection <Element, Key>::
replaceElementWithKey (Element const& element, ICursor& cursor)
{ return ImplOf (*this).
    ReplaceElementWithKey (&element, CrsrImplOf (cursor));
}

template <class Element, class Key>
inline IBoolean
IAKeyCollection <Element, Key>::
setToNextWithDifferentKey (ICursor& cursor) const
{ return ImplOf (*this).
    SetToNextWithDifferentKey (CrsrImplOf (cursor));
}

// protected members

template <class Element, class Key>
inline
IAKeyCollection <Element, Key>::
IAKeyCollection ()
{
}

template <class Element, class Key>
inline
IAKeyCollection <Element, Key>::
IAKeyCollection (IAKeyCollection <Element, Key> const&)
{
}

// private members

template <class Element, class Key>
inline IAKeyCollection <Element, Key>::Implementation&
IAKeyCollection <Element, Key>::
ImplOf (IAKeyCollection <Element, Key> const& collection)
{ return *(Implementation*)collection.ivImpl;
}
