/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IAKS_H
#define _IAKS_H

#include <iakey.h>
#include <iiaks.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key>
class IAKeySet :
  public IAKeyCollection <Element, Key> {

  typedef  IAKeyCollection <Element, Key> Inherited;

  typedef  IAKeySetImpl Implementation;

public:

           IAKeySet
                            (INotifier&);

          ~IAKeySet
                            ();

protected:

           IAKeySet
                            ();

           IAKeySet
                            (IAKeySet <Element, Key> const&);

  IBoolean locateNextElementWithKey
                            (Key const&, ICursor&) const;

  INumber  numberOfDifferentKeys
                            () const;

  INumber  numberOfElementsWithKey
                            (Key const&) const;

  INumber  removeAllElementsWithKey
                            (Key const&);

  IBoolean setToNextWithDifferentKey
                            (ICursor&) const;

private:

  static
  Implementation&
           ImplOf           (IAKeySet <Element, Key> const&);


};

#include <iaks.inl>

#pragma SOMAsDefault (pop)

#pragma info (restore)
#pragma pack ()

#endif
