/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IAKeySet
// ---

template <class Element, class Key>
inline
IAKeySet <Element, Key>::
IAKeySet (INotifier& notifier)
{ SetImpl ((Implementation*)&notifier);
}

template <class Element, class Key>
inline
IAKeySet <Element, Key>::
~IAKeySet ()
{
}

// protected members

template <class Element, class Key>
inline
IAKeySet <Element, Key>::
IAKeySet ()
{
}

template <class Element, class Key>
inline
IAKeySet <Element, Key>::
IAKeySet (IAKeySet <Element, Key> const& collection)
: Inherited (collection)
{
}

template <class Element, class Key>
inline IBoolean
IAKeySet <Element, Key>::
locateNextElementWithKey (Key const& key, ICursor& cursor) const
{ return IAKeyCollection <Element, Key>::
    locateNextElementWithKey (key, cursor);
}

template <class Element, class Key>
inline INumber
IAKeySet <Element, Key>::
numberOfDifferentKeys () const
{ return IAKeyCollection <Element, Key>::numberOfDifferentKeys ();
}

template <class Element, class Key>
inline INumber
IAKeySet <Element, Key>::
numberOfElementsWithKey (Key const& key) const
{ return IAKeyCollection <Element, Key>::numberOfElementsWithKey (key);
}

template <class Element, class Key>
inline INumber
IAKeySet <Element, Key>::
removeAllElementsWithKey (Key const& key)
{ return IAKeyCollection <Element, Key>::removeAllElementsWithKey (key);
}

template <class Element, class Key>
inline IBoolean
IAKeySet <Element, Key>::
setToNextWithDifferentKey (ICursor& cursor) const
{ return
    IAKeyCollection <Element, Key>::setToNextWithDifferentKey (cursor);
}

// private members

template <class Element, class Key>
inline IAKeySet <Element, Key>::Implementation&
IAKeySet <Element, Key>::
ImplOf (IAKeySet <Element, Key> const& collection)
{ return *(Implementation*)collection.ivImpl;
}
