/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IAMAP_H
#define _IAMAP_H

#include <iaeqkey.h>
#include <iiamap.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key>
class IAMap :
  public IAEqualityKeyCollection <Element, Key> {

  typedef  IAEqualityKeyCollection <Element, Key> Inherited;

  typedef  IAMapImpl Implementation;

public:

           IAMap
                            (INotifier&);

          ~IAMap
                            ();

  void     addDifference    (IAMap <Element, Key> const&,
                             IAMap <Element, Key> const&); 

  void     addIntersection  (IAMap <Element, Key> const&,
                             IAMap <Element, Key> const&);

  void     addUnion         (IAMap <Element, Key> const&,
                             IAMap <Element, Key> const&);

  void     differenceWith   (IAMap <Element, Key> const&);

  void     intersectionWith (IAMap <Element, Key> const&);

  void     unionWith        (IAMap <Element, Key> const&);

  IBoolean operator==       (IAMap
                              <Element, Key> const&) const;

  IBoolean operator!=       (IAMap
                              <Element, Key> const&) const;

protected:

           IAMap
                            ();

           IAMap
                            (IAMap <Element, Key> const&);

  IBoolean locateNext       (Element const&, ICursor&) const;

  IBoolean locateNextElementWithKey
                            (Key const&, ICursor&) const;

  INumber  numberOfDifferentKeys
                            () const;

  INumber  numberOfElementsWithKey
                            (Key const&) const;

  INumber  numberOfOccurrences
                            (Element const&) const;

  INumber  removeAllOccurrences
                            (Element const&);

  INumber  removeAllElementsWithKey
                            (Key const&);

  IBoolean setToNextWithDifferentKey
                            (ICursor&) const;

private:

  static
  Implementation&
           ImplOf           (IAMap <Element, Key> const&);


};

#include <iamap.inl>

#pragma SOMAsDefault (pop)

#pragma info (restore)
#pragma pack ()

#endif
