/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IAMap
// ---

template <class Element, class Key>
inline
IAMap <Element, Key>::
IAMap (INotifier& notifier)
{ SetImpl ((Implementation*)&notifier);
}

template <class Element, class Key>
inline
IAMap <Element, Key>::
~IAMap ()
{
}

template <class Element, class Key>
inline void
IAMap <Element, Key>::
addDifference (IAMap <Element, Key> const& collection1,
               IAMap <Element, Key> const& collection2)
{ ImplOf (*this).
    AddDifference (ImplOf (collection1), ImplOf (collection2));
}

template <class Element, class Key>
inline void
IAMap <Element, Key>::
addIntersection (IAMap <Element, Key> const& collection1,
                 IAMap <Element, Key> const& collection2)
{ ImplOf (*this).
    AddIntersection (ImplOf (collection1), ImplOf (collection2));
}

template <class Element, class Key>
inline void
IAMap <Element, Key>::
addUnion (IAMap <Element, Key> const& collection1,
          IAMap <Element, Key> const& collection2)
{ ImplOf (*this).
    AddUnion (ImplOf (collection1), ImplOf (collection2));
}

template <class Element, class Key>
inline void
IAMap <Element, Key>::
differenceWith (IAMap <Element, Key> const& collection)
{ ImplOf (*this).Difference (ImplOf (collection));
}

template <class Element, class Key>
inline void
IAMap <Element, Key>::
intersectionWith (IAMap <Element, Key> const& collection)
{ ImplOf (*this).Intersection (ImplOf (collection));
}

template <class Element, class Key>
inline void
IAMap <Element, Key>::
unionWith (IAMap <Element, Key> const& collection)
{ ImplOf (*this).Union (ImplOf (collection));
}

template <class Element, class Key>
inline IBoolean
IAMap <Element, Key>::
operator== (IAMap <Element, Key> const& collection) const
{ return ImplOf (*this).operator== (ImplOf (collection));
}

template <class Element, class Key>
inline IBoolean
IAMap <Element, Key>::
operator!= (IAMap <Element, Key> const& collection) const
{ return ImplOf (*this).operator!= (ImplOf (collection));
}

// protected members

template <class Element, class Key>
inline
IAMap <Element, Key>::
IAMap ()
{
}

template <class Element, class Key>
inline
IAMap <Element, Key>::
IAMap (IAMap <Element, Key> const& collection)
: Inherited (collection)
{
}

template <class Element, class Key>
inline IBoolean
IAMap <Element, Key>::
locateNext (Element const& element, ICursor& cursor) const
{ return IAEqualityCollection <Element>::locateNext (element, cursor);
}

template <class Element, class Key>
inline IBoolean
IAMap <Element, Key>::
locateNextElementWithKey (Key const& key, ICursor& cursor) const
{ return IAKeyCollection <Element, Key>::
    locateNextElementWithKey (key, cursor);
}

template <class Element, class Key>
inline INumber
IAMap <Element, Key>::
numberOfDifferentKeys () const
{ return IAKeyCollection <Element, Key>::numberOfDifferentKeys ();
}

template <class Element, class Key>
inline INumber
IAMap <Element, Key>::
numberOfElementsWithKey (Key const& key) const
{ return IAKeyCollection <Element, Key>::numberOfElementsWithKey (key);
}

template <class Element, class Key>
inline INumber
IAMap <Element, Key>::
numberOfOccurrences (Element const& element) const
{ return IAEqualityCollection <Element>::numberOfOccurrences (element);
}

template <class Element, class Key>
inline INumber
IAMap <Element, Key>::
removeAllOccurrences (Element const& element)
{ return IAEqualityCollection <Element>::removeAllOccurrences (element);
}

template <class Element, class Key>
inline INumber
IAMap <Element, Key>::
removeAllElementsWithKey (Key const& key)
{ return IAKeyCollection <Element, Key>::removeAllElementsWithKey (key);
}

template <class Element, class Key>
inline IBoolean
IAMap <Element, Key>::
setToNextWithDifferentKey (ICursor& cursor) const
{ return
    IAKeyCollection <Element, Key>::setToNextWithDifferentKey (cursor);
}

// private members

template <class Element, class Key>
inline IAMap <Element, Key>::Implementation&
IAMap <Element, Key>::
ImplOf (IAMap <Element, Key> const& collection)
{ return *(Implementation*)collection.ivImpl;
}
